/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2_16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;

public final class UBiDiProps {
    private int[] indexes;
    private int[] mirrors;
    private byte[] jgArray;
    private byte[] jgArray2;
    private Trie2_16 trie;
    private static final String DATA_NAME = "ubidi";
    private static final String DATA_TYPE = "icu";
    private static final String DATA_FILE_NAME = "ubidi.icu";
    private static final int FMT = 1114195049;
    private static final int IX_TRIE_SIZE = 2;
    private static final int IX_MIRROR_LENGTH = 3;
    private static final int IX_JG_START = 4;
    private static final int IX_JG_LIMIT = 5;
    private static final int IX_JG_START2 = 6;
    private static final int IX_JG_LIMIT2 = 7;
    private static final int IX_MAX_VALUES = 15;
    private static final int IX_TOP = 16;
    private static final int JT_SHIFT = 5;
    private static final int BPT_SHIFT = 8;
    private static final int JOIN_CONTROL_SHIFT = 10;
    private static final int BIDI_CONTROL_SHIFT = 11;
    private static final int IS_MIRRORED_SHIFT = 12;
    private static final int MIRROR_DELTA_SHIFT = 13;
    private static final int MAX_JG_SHIFT = 16;
    private static final int CLASS_MASK = 31;
    private static final int JT_MASK = 224;
    private static final int BPT_MASK = 768;
    private static final int MAX_JG_MASK = 0xFF0000;
    private static final int ESC_MIRROR_DELTA = -4;
    private static final int MIRROR_INDEX_SHIFT = 21;
    public static final UBiDiProps INSTANCE;

    private UBiDiProps() throws IOException {
        ByteBuffer byteBuffer = ICUBinary.getData(DATA_FILE_NAME);
        this.readData(byteBuffer);
    }

    private void readData(ByteBuffer byteBuffer) throws IOException {
        ICUBinary.readHeader(byteBuffer, 1114195049, new IsAcceptable());
        int n2 = byteBuffer.getInt();
        if (n2 < 16) {
            throw new IOException("indexes[0] too small in ubidi.icu");
        }
        this.indexes = new int[n2];
        this.indexes[0] = n2;
        for (int i2 = 1; i2 < n2; ++i2) {
            this.indexes[i2] = byteBuffer.getInt();
        }
        this.trie = Trie2_16.createFromSerialized(byteBuffer);
        int n3 = this.indexes[2];
        int n4 = this.trie.getSerializedLength();
        if (n4 > n3) {
            throw new IOException("ubidi.icu: not enough bytes for the trie");
        }
        ICUBinary.skipBytes(byteBuffer, n3 - n4);
        n2 = this.indexes[3];
        if (n2 > 0) {
            this.mirrors = ICUBinary.getInts(byteBuffer, n2, 0);
        }
        n2 = this.indexes[5] - this.indexes[4];
        this.jgArray = new byte[n2];
        byteBuffer.get(this.jgArray);
        n2 = this.indexes[7] - this.indexes[6];
        this.jgArray2 = new byte[n2];
        byteBuffer.get(this.jgArray2);
    }

    public final void addPropertyStarts(UnicodeSet unicodeSet) {
        int n2;
        for (Trie2.Range range : this.trie) {
            if (range.leadSurrogate) break;
            unicodeSet.add(range.startCodePoint);
        }
        int n3 = this.indexes[3];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = UBiDiProps.getMirrorCodePoint(this.mirrors[n2]);
            unicodeSet.add(n4, n4 + 1);
        }
        int n5 = this.indexes[4];
        int n6 = this.indexes[5];
        byte[] byArray = this.jgArray;
        while (true) {
            n3 = n6 - n5;
            byte by2 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                byte by3 = byArray[n2];
                if (by3 != by2) {
                    unicodeSet.add(n5);
                    by2 = by3;
                }
                ++n5;
            }
            if (by2 != 0) {
                unicodeSet.add(n6);
            }
            if (n6 != this.indexes[5]) break;
            n5 = this.indexes[6];
            n6 = this.indexes[7];
            byArray = this.jgArray2;
        }
    }

    public final int getMaxValue(int n2) {
        int n3 = this.indexes[15];
        switch (n2) {
            case 4096: {
                return n3 & 0x1F;
            }
            case 4102: {
                return (n3 & 0xFF0000) >> 16;
            }
            case 4103: {
                return (n3 & 0xE0) >> 5;
            }
            case 4117: {
                return (n3 & 0x300) >> 8;
            }
        }
        return -1;
    }

    public final int getClass(int n2) {
        return UBiDiProps.getClassFromProps(this.trie.get(n2));
    }

    public final boolean isMirrored(int n2) {
        return UBiDiProps.getFlagFromProps(this.trie.get(n2), 12);
    }

    private final int getMirror(int n2, int n3) {
        int n4 = UBiDiProps.getMirrorDeltaFromProps(n3);
        if (n4 != -4) {
            return n2 + n4;
        }
        int n5 = this.indexes[3];
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6 = this.mirrors[i2];
            int n7 = UBiDiProps.getMirrorCodePoint(n6);
            if (n2 == n7) {
                return UBiDiProps.getMirrorCodePoint(this.mirrors[UBiDiProps.getMirrorIndex(n6)]);
            }
            if (n2 < n7) break;
        }
        return n2;
    }

    public final int getMirror(int n2) {
        int n3 = this.trie.get(n2);
        return this.getMirror(n2, n3);
    }

    public final boolean isBidiControl(int n2) {
        return UBiDiProps.getFlagFromProps(this.trie.get(n2), 11);
    }

    public final boolean isJoinControl(int n2) {
        return UBiDiProps.getFlagFromProps(this.trie.get(n2), 10);
    }

    public final int getJoiningType(int n2) {
        return (this.trie.get(n2) & 0xE0) >> 5;
    }

    public final int getJoiningGroup(int n2) {
        int n3 = this.indexes[4];
        int n4 = this.indexes[5];
        if (n3 <= n2 && n2 < n4) {
            return this.jgArray[n2 - n3] & 0xFF;
        }
        n3 = this.indexes[6];
        n4 = this.indexes[7];
        if (n3 <= n2 && n2 < n4) {
            return this.jgArray2[n2 - n3] & 0xFF;
        }
        return 0;
    }

    public final int getPairedBracketType(int n2) {
        return (this.trie.get(n2) & 0x300) >> 8;
    }

    public final int getPairedBracket(int n2) {
        int n3 = this.trie.get(n2);
        if ((n3 & 0x300) == 0) {
            return n2;
        }
        return this.getMirror(n2, n3);
    }

    private static final int getClassFromProps(int n2) {
        return n2 & 0x1F;
    }

    private static final boolean getFlagFromProps(int n2, int n3) {
        return (n2 >> n3 & 1) != 0;
    }

    private static final int getMirrorDeltaFromProps(int n2) {
        return (short)n2 >> 13;
    }

    private static final int getMirrorCodePoint(int n2) {
        return n2 & 0x1FFFFF;
    }

    private static final int getMirrorIndex(int n2) {
        return n2 >>> 21;
    }

    static {
        try {
            INSTANCE = new UBiDiProps();
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return byArray[0] == 2;
        }
    }
}

