/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2;

public class Trie2_32
extends Trie2 {
    Trie2_32() {
    }

    public static Trie2_32 createFromSerialized(ByteBuffer byteBuffer) throws IOException {
        return (Trie2_32)Trie2.createFromSerialized(byteBuffer);
    }

    @Override
    public final int get(int n2) {
        if (n2 >= 0) {
            if (n2 < 55296 || n2 > 56319 && n2 <= 65535) {
                int n3 = this.index[n2 >> 5];
                n3 = (n3 << 2) + (n2 & 0x1F);
                int n4 = this.data32[n3];
                return n4;
            }
            if (n2 <= 65535) {
                int n5 = this.index[2048 + (n2 - 55296 >> 5)];
                n5 = (n5 << 2) + (n2 & 0x1F);
                int n6 = this.data32[n5];
                return n6;
            }
            if (n2 < this.highStart) {
                int n7 = 2080 + (n2 >> 11);
                n7 = this.index[n7];
                n7 += n2 >> 5 & 0x3F;
                n7 = this.index[n7];
                n7 = (n7 << 2) + (n2 & 0x1F);
                int n8 = this.data32[n7];
                return n8;
            }
            if (n2 <= 0x10FFFF) {
                int n9 = this.data32[this.highValueIndex];
                return n9;
            }
        }
        return this.errorValue;
    }

    @Override
    public int getFromU16SingleLead(char c2) {
        int n2 = this.index[c2 >> 5];
        n2 = (n2 << 2) + (c2 & 0x1F);
        int n3 = this.data32[n2];
        return n3;
    }

    public int serialize(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        int n2 = 0;
        n2 += this.serializeHeader(dataOutputStream);
        for (int i2 = 0; i2 < this.dataLength; ++i2) {
            dataOutputStream.writeInt(this.data32[i2]);
        }
        return n2 += this.dataLength * 4;
    }

    public int getSerializedLength() {
        return 16 + this.header.indexLength * 2 + this.dataLength * 4;
    }

    @Override
    int rangeEnd(int n2, int n3, int n4) {
        int n5 = n2;
        int n6 = 0;
        int n7 = 0;
        block0: while (n5 < n3) {
            int n8;
            if (n5 < 55296 || n5 > 56319 && n5 <= 65535) {
                n7 = 0;
                n6 = this.index[n5 >> 5] << 2;
            } else if (n5 < 65535) {
                n7 = 2048;
                n6 = this.index[n7 + (n5 - 55296 >> 5)] << 2;
            } else if (n5 < this.highStart) {
                n8 = 2080 + (n5 >> 11);
                n7 = this.index[n8];
                n6 = this.index[n7 + (n5 >> 5 & 0x3F)] << 2;
            } else {
                if (n4 != this.data32[this.highValueIndex]) break;
                n5 = n3;
                break;
            }
            if (n7 == this.index2NullOffset) {
                if (n4 != this.initialValue) break;
                n5 += 2048;
                continue;
            }
            if (n6 == this.dataNullOffset) {
                if (n4 != this.initialValue) break;
                n5 += 32;
                continue;
            }
            n8 = n6 + (n5 & 0x1F);
            int n9 = n6 + 32;
            for (int i2 = n8; i2 < n9; ++i2) {
                if (this.data32[i2] == n4) continue;
                n5 += i2 - n8;
                break block0;
            }
            n5 += n9 - n8;
        }
        if (n5 > n3) {
            n5 = n3;
        }
        return n5 - 1;
    }
}

