/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2_16;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2_32;

public abstract class Trie2
implements Iterable<Range> {
    private static ValueMapper defaultValueMapper = new ValueMapper(){

        @Override
        public int map(int n2) {
            return n2;
        }
    };
    UTrie2Header header;
    char[] index;
    int data16;
    int[] data32;
    int indexLength;
    int dataLength;
    int index2NullOffset;
    int initialValue;
    int errorValue;
    int highStart;
    int highValueIndex;
    int dataNullOffset;
    int fHash;
    static final int UTRIE2_OPTIONS_VALUE_BITS_MASK = 15;
    static final int UTRIE2_SHIFT_1 = 11;
    static final int UTRIE2_SHIFT_2 = 5;
    static final int UTRIE2_SHIFT_1_2 = 6;
    static final int UTRIE2_OMITTED_BMP_INDEX_1_LENGTH = 32;
    static final int UTRIE2_CP_PER_INDEX_1_ENTRY = 2048;
    static final int UTRIE2_INDEX_2_BLOCK_LENGTH = 64;
    static final int UTRIE2_INDEX_2_MASK = 63;
    static final int UTRIE2_DATA_BLOCK_LENGTH = 32;
    static final int UTRIE2_DATA_MASK = 31;
    static final int UTRIE2_INDEX_SHIFT = 2;
    static final int UTRIE2_DATA_GRANULARITY = 4;
    static final int UTRIE2_INDEX_2_OFFSET = 0;
    static final int UTRIE2_LSCP_INDEX_2_OFFSET = 2048;
    static final int UTRIE2_LSCP_INDEX_2_LENGTH = 32;
    static final int UTRIE2_INDEX_2_BMP_LENGTH = 2080;
    static final int UTRIE2_UTF8_2B_INDEX_2_OFFSET = 2080;
    static final int UTRIE2_UTF8_2B_INDEX_2_LENGTH = 32;
    static final int UTRIE2_INDEX_1_OFFSET = 2112;
    static final int UTRIE2_MAX_INDEX_1_LENGTH = 512;
    static final int UTRIE2_BAD_UTF8_DATA_OFFSET = 128;
    static final int UTRIE2_DATA_START_OFFSET = 192;
    static final int UNEWTRIE2_INDEX_GAP_OFFSET = 2080;
    static final int UNEWTRIE2_INDEX_GAP_LENGTH = 576;
    static final int UNEWTRIE2_MAX_INDEX_2_LENGTH = 35488;
    static final int UNEWTRIE2_INDEX_1_LENGTH = 544;
    static final int UNEWTRIE2_MAX_DATA_LENGTH = 1115264;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Trie2 createFromSerialized(ByteBuffer byteBuffer) throws IOException {
        ByteOrder byteOrder = byteBuffer.order();
        try {
            Trie2 trie2;
            ValueWidth valueWidth;
            UTrie2Header uTrie2Header = new UTrie2Header();
            uTrie2Header.signature = byteBuffer.getInt();
            switch (uTrie2Header.signature) {
                case 1416784178: {
                    break;
                }
                case 845771348: {
                    boolean bl2 = byteOrder == ByteOrder.BIG_ENDIAN;
                    byteBuffer.order(bl2 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                    uTrie2Header.signature = 1416784178;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Buffer does not contain a serialized UTrie2");
                }
            }
            uTrie2Header.options = byteBuffer.getChar();
            uTrie2Header.indexLength = byteBuffer.getChar();
            uTrie2Header.shiftedDataLength = byteBuffer.getChar();
            uTrie2Header.index2NullOffset = byteBuffer.getChar();
            uTrie2Header.dataNullOffset = byteBuffer.getChar();
            uTrie2Header.shiftedHighStart = byteBuffer.getChar();
            if ((uTrie2Header.options & 0xF) > 1) {
                throw new IllegalArgumentException("UTrie2 serialized format error.");
            }
            if ((uTrie2Header.options & 0xF) == 0) {
                valueWidth = ValueWidth.BITS_16;
                trie2 = new Trie2_16();
            } else {
                valueWidth = ValueWidth.BITS_32;
                trie2 = new Trie2_32();
            }
            trie2.header = uTrie2Header;
            trie2.indexLength = uTrie2Header.indexLength;
            trie2.dataLength = uTrie2Header.shiftedDataLength << 2;
            trie2.index2NullOffset = uTrie2Header.index2NullOffset;
            trie2.dataNullOffset = uTrie2Header.dataNullOffset;
            trie2.highStart = uTrie2Header.shiftedHighStart << 11;
            trie2.highValueIndex = trie2.dataLength - 4;
            if (valueWidth == ValueWidth.BITS_16) {
                trie2.highValueIndex += trie2.indexLength;
            }
            int n2 = trie2.indexLength;
            if (valueWidth == ValueWidth.BITS_16) {
                n2 += trie2.dataLength;
            }
            trie2.index = ICUBinary.getChars(byteBuffer, n2, 0);
            if (valueWidth == ValueWidth.BITS_16) {
                trie2.data16 = trie2.indexLength;
            } else {
                trie2.data32 = ICUBinary.getInts(byteBuffer, trie2.dataLength, 0);
            }
            switch (valueWidth) {
                case BITS_16: {
                    trie2.data32 = null;
                    trie2.initialValue = trie2.index[trie2.dataNullOffset];
                    trie2.errorValue = trie2.index[trie2.data16 + 128];
                    break;
                }
                case BITS_32: {
                    trie2.data16 = 0;
                    trie2.initialValue = trie2.data32[trie2.dataNullOffset];
                    trie2.errorValue = trie2.data32[128];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("UTrie2 serialized format error.");
                }
            }
            Trie2 trie22 = trie2;
            return trie22;
        }
        finally {
            byteBuffer.order(byteOrder);
        }
    }

    public static int getVersion(InputStream inputStream, boolean bl2) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("Input stream must support mark().");
        }
        inputStream.mark(4);
        byte[] byArray = new byte[4];
        int n2 = inputStream.read(byArray);
        inputStream.reset();
        if (n2 != byArray.length) {
            return 0;
        }
        if (byArray[0] == 84 && byArray[1] == 114 && byArray[2] == 105 && byArray[3] == 101) {
            return 1;
        }
        if (byArray[0] == 84 && byArray[1] == 114 && byArray[2] == 105 && byArray[3] == 50) {
            return 2;
        }
        if (bl2) {
            if (byArray[0] == 101 && byArray[1] == 105 && byArray[2] == 114 && byArray[3] == 84) {
                return 1;
            }
            if (byArray[0] == 50 && byArray[1] == 105 && byArray[2] == 114 && byArray[3] == 84) {
                return 2;
            }
        }
        return 0;
    }

    public abstract int get(int var1);

    public abstract int getFromU16SingleLead(char var1);

    public final boolean equals(Object object) {
        if (!(object instanceof Trie2)) {
            return false;
        }
        Trie2 trie2 = (Trie2)object;
        Iterator<Range> iterator = trie2.iterator();
        for (Range range : this) {
            if (!iterator.hasNext()) {
                return false;
            }
            Range range2 = iterator.next();
            if (range.equals(range2)) continue;
            return false;
        }
        if (iterator.hasNext()) {
            return false;
        }
        return this.errorValue == trie2.errorValue && this.initialValue == trie2.initialValue;
    }

    public int hashCode() {
        if (this.fHash == 0) {
            int n2 = Trie2.initHash();
            for (Range range : this) {
                n2 = Trie2.hashInt(n2, range.hashCode());
            }
            if (n2 == 0) {
                n2 = 1;
            }
            this.fHash = n2;
        }
        return this.fHash;
    }

    @Override
    public Iterator<Range> iterator() {
        return this.iterator(defaultValueMapper);
    }

    public Iterator<Range> iterator(ValueMapper valueMapper) {
        return new Trie2Iterator(valueMapper);
    }

    public Iterator<Range> iteratorForLeadSurrogate(char c2, ValueMapper valueMapper) {
        return new Trie2Iterator(c2, valueMapper);
    }

    public Iterator<Range> iteratorForLeadSurrogate(char c2) {
        return new Trie2Iterator(c2, defaultValueMapper);
    }

    protected int serializeHeader(DataOutputStream dataOutputStream) throws IOException {
        int n2 = 0;
        dataOutputStream.writeInt(this.header.signature);
        dataOutputStream.writeShort(this.header.options);
        dataOutputStream.writeShort(this.header.indexLength);
        dataOutputStream.writeShort(this.header.shiftedDataLength);
        dataOutputStream.writeShort(this.header.index2NullOffset);
        dataOutputStream.writeShort(this.header.dataNullOffset);
        dataOutputStream.writeShort(this.header.shiftedHighStart);
        n2 += 16;
        for (int i2 = 0; i2 < this.header.indexLength; ++i2) {
            dataOutputStream.writeChar(this.index[i2]);
        }
        return n2 += this.header.indexLength;
    }

    public CharSequenceIterator charSequenceIterator(CharSequence charSequence, int n2) {
        return new CharSequenceIterator(charSequence, n2);
    }

    int rangeEnd(int n2, int n3, int n4) {
        int n5;
        int n6 = Math.min(this.highStart, n3);
        for (n5 = n2 + 1; n5 < n6 && this.get(n5) == n4; ++n5) {
        }
        if (n5 >= this.highStart) {
            n5 = n3;
        }
        return n5 - 1;
    }

    private static int initHash() {
        return -2128831035;
    }

    private static int hashByte(int n2, int n3) {
        n2 *= 16777619;
        return n2 ^= n3;
    }

    private static int hashUChar32(int n2, int n3) {
        n2 = Trie2.hashByte(n2, n3 & 0xFF);
        n2 = Trie2.hashByte(n2, n3 >> 8 & 0xFF);
        n2 = Trie2.hashByte(n2, n3 >> 16);
        return n2;
    }

    private static int hashInt(int n2, int n3) {
        n2 = Trie2.hashByte(n2, n3 & 0xFF);
        n2 = Trie2.hashByte(n2, n3 >> 8 & 0xFF);
        n2 = Trie2.hashByte(n2, n3 >> 16 & 0xFF);
        n2 = Trie2.hashByte(n2, n3 >> 24 & 0xFF);
        return n2;
    }

    class Trie2Iterator
    implements Iterator<Range> {
        private ValueMapper mapper;
        private Range returnValue = new Range();
        private int nextStart;
        private int limitCP;
        private boolean doingCodePoints = true;
        private boolean doLeadSurrogates = true;

        Trie2Iterator(ValueMapper valueMapper) {
            this.mapper = valueMapper;
            this.nextStart = 0;
            this.limitCP = 0x110000;
            this.doLeadSurrogates = true;
        }

        Trie2Iterator(char c2, ValueMapper valueMapper) {
            if (c2 < '\ud800' || c2 > '\udbff') {
                throw new IllegalArgumentException("Bad lead surrogate value.");
            }
            this.mapper = valueMapper;
            this.nextStart = c2 - 55232 << 10;
            this.limitCP = this.nextStart + 1024;
            this.doLeadSurrogates = false;
        }

        @Override
        public Range next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.nextStart >= this.limitCP) {
                this.doingCodePoints = false;
                this.nextStart = 55296;
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (this.doingCodePoints) {
                n3 = Trie2.this.get(this.nextStart);
                n4 = this.mapper.map(n3);
                n2 = Trie2.this.rangeEnd(this.nextStart, this.limitCP, n3);
                while (n2 < this.limitCP - 1 && this.mapper.map(n3 = Trie2.this.get(n2 + 1)) == n4) {
                    n2 = Trie2.this.rangeEnd(n2 + 1, this.limitCP, n3);
                }
            } else {
                n3 = Trie2.this.getFromU16SingleLead((char)this.nextStart);
                n4 = this.mapper.map(n3);
                n2 = this.rangeEndLS((char)this.nextStart);
                while (n2 < 56319 && this.mapper.map(n3 = Trie2.this.getFromU16SingleLead((char)(n2 + 1))) == n4) {
                    n2 = this.rangeEndLS((char)(n2 + 1));
                }
            }
            this.returnValue.startCodePoint = this.nextStart;
            this.returnValue.endCodePoint = n2;
            this.returnValue.value = n4;
            this.returnValue.leadSurrogate = !this.doingCodePoints;
            this.nextStart = n2 + 1;
            return this.returnValue;
        }

        @Override
        public boolean hasNext() {
            return this.doingCodePoints && (this.doLeadSurrogates || this.nextStart < this.limitCP) || this.nextStart < 56320;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private int rangeEndLS(char c2) {
            int n2;
            if (c2 >= '\udbff') {
                return 56319;
            }
            int n3 = Trie2.this.getFromU16SingleLead(c2);
            for (n2 = c2 + '\u0001'; n2 <= 56319 && Trie2.this.getFromU16SingleLead((char)n2) == n3; ++n2) {
            }
            return n2 - 1;
        }
    }

    static class UTrie2Header {
        int signature;
        int options;
        int indexLength;
        int shiftedDataLength;
        int index2NullOffset;
        int dataNullOffset;
        int shiftedHighStart;

        UTrie2Header() {
        }
    }

    static enum ValueWidth {
        BITS_16,
        BITS_32;

    }

    public class CharSequenceIterator
    implements Iterator<CharSequenceValues> {
        private CharSequence text;
        private int textLength;
        private int index;
        private CharSequenceValues fResults = new CharSequenceValues();

        CharSequenceIterator(CharSequence charSequence, int n2) {
            this.text = charSequence;
            this.textLength = this.text.length();
            this.set(n2);
        }

        public void set(int n2) {
            if (n2 < 0 || n2 > this.textLength) {
                throw new IndexOutOfBoundsException();
            }
            this.index = n2;
        }

        @Override
        public final boolean hasNext() {
            return this.index < this.textLength;
        }

        public final boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public CharSequenceValues next() {
            int n2 = Character.codePointAt(this.text, this.index);
            int n3 = Trie2.this.get(n2);
            this.fResults.index = this.index++;
            this.fResults.codePoint = n2;
            this.fResults.value = n3;
            if (n2 >= 65536) {
                ++this.index;
            }
            return this.fResults;
        }

        public CharSequenceValues previous() {
            int n2 = Character.codePointBefore(this.text, this.index);
            int n3 = Trie2.this.get(n2);
            --this.index;
            if (n2 >= 65536) {
                --this.index;
            }
            this.fResults.index = this.index;
            this.fResults.codePoint = n2;
            this.fResults.value = n3;
            return this.fResults;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Trie2.CharSequenceIterator does not support remove().");
        }
    }

    public static class CharSequenceValues {
        public int index;
        public int codePoint;
        public int value;
    }

    public static interface ValueMapper {
        public int map(int var1);
    }

    public static class Range {
        public int startCodePoint;
        public int endCodePoint;
        public int value;
        public boolean leadSurrogate;

        public boolean equals(Object object) {
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            Range range = (Range)object;
            return this.startCodePoint == range.startCodePoint && this.endCodePoint == range.endCodePoint && this.value == range.value && this.leadSurrogate == range.leadSurrogate;
        }

        public int hashCode() {
            int n2 = Trie2.initHash();
            n2 = Trie2.hashUChar32(n2, this.startCodePoint);
            n2 = Trie2.hashUChar32(n2, this.endCodePoint);
            n2 = Trie2.hashInt(n2, this.value);
            n2 = Trie2.hashByte(n2, this.leadSurrogate ? 1 : 0);
            return n2;
        }
    }
}

