/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

public class TextTrieMap<V> {
    private Node _root = new Node();
    boolean _ignoreCase;

    public TextTrieMap(boolean bl2) {
        this._ignoreCase = bl2;
    }

    public TextTrieMap<V> put(CharSequence charSequence, V v2) {
        CharIterator charIterator = new CharIterator(charSequence, 0, this._ignoreCase);
        this._root.add(charIterator, v2);
        return this;
    }

    public Iterator<V> get(String string) {
        return this.get(string, 0);
    }

    public Iterator<V> get(CharSequence charSequence, int n2) {
        return this.get(charSequence, n2, null);
    }

    public Iterator<V> get(CharSequence charSequence, int n2, Output output) {
        LongestMatchHandler longestMatchHandler = new LongestMatchHandler();
        this.find(charSequence, n2, longestMatchHandler, output);
        if (output != null) {
            output.matchLength = longestMatchHandler.getMatchLength();
        }
        return longestMatchHandler.getMatches();
    }

    public void find(CharSequence charSequence, ResultHandler<V> resultHandler) {
        this.find(charSequence, 0, resultHandler, null);
    }

    public void find(CharSequence charSequence, int n2, ResultHandler<V> resultHandler) {
        this.find(charSequence, n2, resultHandler, null);
    }

    private void find(CharSequence charSequence, int n2, ResultHandler<V> resultHandler, Output output) {
        CharIterator charIterator = new CharIterator(charSequence, n2, this._ignoreCase);
        this.find(this._root, charIterator, resultHandler, output);
    }

    private synchronized void find(Node node, CharIterator charIterator, ResultHandler<V> resultHandler, Output output) {
        Iterator iterator = node.values();
        if (iterator != null && !resultHandler.handlePrefixMatch(charIterator.processedLength(), iterator)) {
            return;
        }
        Node node2 = node.findMatch(charIterator, output);
        if (node2 != null) {
            this.find(node2, charIterator, resultHandler, output);
        }
    }

    public void putLeadCodePoints(UnicodeSet unicodeSet) {
        this._root.putLeadCodePoints(unicodeSet);
    }

    private static char[] toCharArray(CharSequence charSequence) {
        char[] cArray = new char[charSequence.length()];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = charSequence.charAt(i2);
        }
        return cArray;
    }

    private static char[] subArray(char[] cArray, int n2) {
        if (n2 == 0) {
            return cArray;
        }
        char[] cArray2 = new char[cArray.length - n2];
        System.arraycopy(cArray, n2, cArray2, 0, cArray2.length);
        return cArray2;
    }

    private static char[] subArray(char[] cArray, int n2, int n3) {
        if (n2 == 0 && n3 == cArray.length) {
            return cArray;
        }
        char[] cArray2 = new char[n3 - n2];
        System.arraycopy(cArray, n2, cArray2, 0, n3 - n2);
        return cArray2;
    }

    private class Node {
        private char[] _text;
        private List<V> _values;
        private List<Node> _children;

        private Node() {
        }

        private Node(char[] cArray, List<V> list, List<Node> list2) {
            this._text = cArray;
            this._values = list;
            this._children = list2;
        }

        public int charCount() {
            return this._text == null ? 0 : this._text.length;
        }

        public Iterator<V> values() {
            if (this._values == null) {
                return null;
            }
            return this._values.iterator();
        }

        public void add(CharIterator charIterator, V v2) {
            StringBuilder stringBuilder = new StringBuilder();
            while (charIterator.hasNext()) {
                stringBuilder.append(charIterator.next());
            }
            this.add(TextTrieMap.toCharArray(stringBuilder), 0, v2);
        }

        public Node findMatch(CharIterator charIterator, Output output) {
            if (this._children == null) {
                return null;
            }
            if (!charIterator.hasNext()) {
                if (output != null) {
                    output.partialMatch = true;
                }
                return null;
            }
            Node node = null;
            Character c2 = charIterator.next();
            for (Node node2 : this._children) {
                if (c2.charValue() < node2._text[0]) break;
                if (c2.charValue() != node2._text[0]) continue;
                if (!node2.matchFollowing(charIterator, output)) break;
                node = node2;
                break;
            }
            return node;
        }

        public void putLeadCodePoints(UnicodeSet unicodeSet) {
            if (this._children == null) {
                return;
            }
            for (Node node : this._children) {
                char c2 = node._text[0];
                if (!UCharacter.isHighSurrogate(c2)) {
                    unicodeSet.add(c2);
                    continue;
                }
                if (node.charCount() >= 2) {
                    unicodeSet.add(Character.codePointAt(node._text, 0));
                    continue;
                }
                if (node._children == null) continue;
                for (Node node2 : node._children) {
                    char c3 = node2._text[0];
                    int n2 = Character.toCodePoint(c2, c3);
                    unicodeSet.add(n2);
                }
            }
        }

        private void add(char[] cArray, int n2, V v2) {
            if (cArray.length == n2) {
                this._values = this.addValue(this._values, v2);
                return;
            }
            if (this._children == null) {
                this._children = new LinkedList<Node>();
                Node node = new Node(TextTrieMap.subArray(cArray, n2), this.addValue(null, v2), null);
                this._children.add(node);
                return;
            }
            ListIterator<Node> listIterator = this._children.listIterator();
            while (listIterator.hasNext()) {
                Node node = listIterator.next();
                if (cArray[n2] < node._text[0]) {
                    listIterator.previous();
                    break;
                }
                if (cArray[n2] != node._text[0]) continue;
                int n3 = node.lenMatches(cArray, n2);
                if (n3 == node._text.length) {
                    node.add(cArray, n2 + n3, v2);
                } else {
                    node.split(n3);
                    node.add(cArray, n2 + n3, v2);
                }
                return;
            }
            listIterator.add(new Node(TextTrieMap.subArray(cArray, n2), this.addValue(null, v2), null));
        }

        private boolean matchFollowing(CharIterator charIterator, Output output) {
            boolean bl2 = true;
            for (int i2 = 1; i2 < this._text.length; ++i2) {
                if (!charIterator.hasNext()) {
                    if (output != null) {
                        output.partialMatch = true;
                    }
                    bl2 = false;
                    break;
                }
                Character c2 = charIterator.next();
                if (c2.charValue() == this._text[i2]) continue;
                bl2 = false;
                break;
            }
            return bl2;
        }

        private int lenMatches(char[] cArray, int n2) {
            int n3;
            int n4 = cArray.length - n2;
            int n5 = this._text.length < n4 ? this._text.length : n4;
            for (n3 = 0; n3 < n5 && this._text[n3] == cArray[n2 + n3]; ++n3) {
            }
            return n3;
        }

        private void split(int n2) {
            char[] cArray = TextTrieMap.subArray(this._text, n2);
            this._text = TextTrieMap.subArray(this._text, 0, n2);
            Node node = new Node(cArray, this._values, this._children);
            this._values = null;
            this._children = new LinkedList<Node>();
            this._children.add(node);
        }

        private List<V> addValue(List<V> list, V v2) {
            if (list == null) {
                list = new LinkedList();
            }
            list.add(v2);
            return list;
        }
    }

    private static class LongestMatchHandler<V>
    implements ResultHandler<V> {
        private Iterator<V> matches = null;
        private int length = 0;

        private LongestMatchHandler() {
        }

        @Override
        public boolean handlePrefixMatch(int n2, Iterator<V> iterator) {
            if (n2 > this.length) {
                this.length = n2;
                this.matches = iterator;
            }
            return true;
        }

        public Iterator<V> getMatches() {
            return this.matches;
        }

        public int getMatchLength() {
            return this.length;
        }
    }

    public static interface ResultHandler<V> {
        public boolean handlePrefixMatch(int var1, Iterator<V> var2);
    }

    public static class CharIterator
    implements Iterator<Character> {
        private boolean _ignoreCase;
        private CharSequence _text;
        private int _nextIdx;
        private int _startIdx;
        private Character _remainingChar;

        CharIterator(CharSequence charSequence, int n2, boolean bl2) {
            this._text = charSequence;
            this._nextIdx = this._startIdx = n2;
            this._ignoreCase = bl2;
        }

        @Override
        public boolean hasNext() {
            return this._nextIdx != this._text.length() || this._remainingChar != null;
        }

        @Override
        public Character next() {
            Character c2;
            if (this._nextIdx == this._text.length() && this._remainingChar == null) {
                return null;
            }
            if (this._remainingChar != null) {
                c2 = this._remainingChar;
                this._remainingChar = null;
            } else if (this._ignoreCase) {
                int n2 = UCharacter.foldCase(Character.codePointAt(this._text, this._nextIdx), true);
                this._nextIdx += Character.charCount(n2);
                char[] cArray = Character.toChars(n2);
                c2 = Character.valueOf(cArray[0]);
                if (cArray.length == 2) {
                    this._remainingChar = Character.valueOf(cArray[1]);
                }
            } else {
                c2 = Character.valueOf(this._text.charAt(this._nextIdx));
                ++this._nextIdx;
            }
            return c2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }

        public int nextIndex() {
            return this._nextIdx;
        }

        public int processedLength() {
            if (this._remainingChar != null) {
                throw new IllegalStateException("In the middle of surrogate pair");
            }
            return this._nextIdx - this._startIdx;
        }
    }

    public static class Output {
        public int matchLength;
        public boolean partialMatch;
    }
}

