/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

public class StringSegment
implements CharSequence {
    private final String str;
    private int start;
    private int end;
    private boolean foldCase;

    public StringSegment(String string, boolean bl2) {
        this.str = string;
        this.start = 0;
        this.end = string.length();
        this.foldCase = bl2;
    }

    public int getOffset() {
        return this.start;
    }

    public void setOffset(int n2) {
        assert (n2 <= this.end);
        this.start = n2;
    }

    public void adjustOffset(int n2) {
        assert (this.start + n2 >= 0);
        assert (this.start + n2 <= this.end);
        this.start += n2;
    }

    public void adjustOffsetByCodePoint() {
        this.start += Character.charCount(this.getCodePoint());
    }

    public void setLength(int n2) {
        assert (n2 >= 0);
        assert (this.start + n2 <= this.str.length());
        this.end = this.start + n2;
    }

    public void resetLength() {
        this.end = this.str.length();
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int n2) {
        return this.str.charAt(n2 + this.start);
    }

    @Override
    public CharSequence subSequence(int n2, int n3) {
        return this.str.subSequence(n2 + this.start, n3 + this.start);
    }

    public int getCodePoint() {
        char c2;
        assert (this.start < this.end);
        char c3 = this.str.charAt(this.start);
        if (Character.isHighSurrogate(c3) && this.start + 1 < this.end && Character.isLowSurrogate(c2 = this.str.charAt(this.start + 1))) {
            return Character.toCodePoint(c3, c2);
        }
        return c3;
    }

    public int codePointAt(int n2) {
        return this.str.codePointAt(this.start + n2);
    }

    public boolean startsWith(int n2) {
        return StringSegment.codePointsEqual(this.getCodePoint(), n2, this.foldCase);
    }

    public boolean startsWith(UnicodeSet unicodeSet) {
        int n2 = this.getCodePoint();
        if (n2 == -1) {
            return false;
        }
        return unicodeSet.contains(n2);
    }

    public boolean startsWith(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0 || this.length() == 0) {
            return false;
        }
        int n2 = Character.codePointAt(this, 0);
        int n3 = Character.codePointAt(charSequence, 0);
        return StringSegment.codePointsEqual(n2, n3, this.foldCase);
    }

    public int getCommonPrefixLength(CharSequence charSequence) {
        return this.getPrefixLengthInternal(charSequence, this.foldCase);
    }

    public int getCaseSensitivePrefixLength(CharSequence charSequence) {
        return this.getPrefixLengthInternal(charSequence, false);
    }

    private int getPrefixLengthInternal(CharSequence charSequence, boolean bl2) {
        int n2;
        int n3;
        int n4;
        assert (charSequence.length() != 0);
        for (n3 = 0; n3 < Math.min(this.length(), charSequence.length()) && StringSegment.codePointsEqual(n4 = Character.codePointAt(this, n3), n2 = Character.codePointAt(charSequence, n3), bl2); n3 += Character.charCount(n4)) {
        }
        return n3;
    }

    private static final boolean codePointsEqual(int n2, int n3, boolean bl2) {
        if (n2 == n3) {
            return true;
        }
        if (!bl2) {
            return false;
        }
        return (n2 = UCharacter.foldCase(n2, true)) == (n3 = UCharacter.foldCase(n3, true));
    }

    public boolean contentEquals(CharSequence charSequence) {
        return Utility.charSequenceEquals(this, charSequence);
    }

    @Override
    public String toString() {
        return this.str.substring(0, this.start) + "[" + this.str.substring(this.start, this.end) + "]" + this.str.substring(this.end);
    }

    public String asString() {
        return this.str.substring(this.start, this.end);
    }
}

