/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Relation;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.CharSequences;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;

public class StringRange {
    private static final boolean DEBUG = false;
    public static final Comparator<int[]> COMPARE_INT_ARRAYS = new Comparator<int[]>(){

        @Override
        public int compare(int[] nArray, int[] nArray2) {
            int n2 = Math.min(nArray.length, nArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2] - nArray2[i2];
                if (n3 == 0) continue;
                return n3;
            }
            return nArray.length - nArray2.length;
        }
    };

    public static void compact(Set<String> set, Adder adder, boolean bl2, boolean bl3) {
        if (!bl3) {
            String string = null;
            String string2 = null;
            boolean n2 = false;
            int n3 = 0;
            for (String string3 : set) {
                int object2;
                if (string != null) {
                    int n4;
                    if (string3.regionMatches(0, string, 0, n3) && (n4 = string3.codePointAt(n3)) == 1 + object2 && string3.length() == n3 + Character.charCount(n4)) {
                        string2 = string3;
                        object2 = n4;
                        continue;
                    }
                    adder.add(string, string2 == null ? null : (!bl2 ? string2 : string2.substring(n3, string2.length())));
                }
                string = string3;
                string2 = null;
                object2 = string3.codePointBefore(string3.length());
                n3 = string3.length() - Character.charCount(object2);
            }
            adder.add(string, string2 == null ? null : (!bl2 ? string2 : string2.substring(n3, string2.length())));
        } else {
            Object object;
            Relation<Integer, Ranges> relation = Relation.of(new TreeMap(), TreeSet.class);
            for (String string : set) {
                object = new Ranges(string);
                relation.put(((Ranges)object).size(), (Ranges)object);
            }
            for (Map.Entry entry : relation.keyValuesSet()) {
                object = StringRange.compact((Integer)entry.getKey(), (Set)entry.getValue());
                Iterator iterator = ((AbstractSequentialList)object).iterator();
                while (iterator.hasNext()) {
                    Ranges ranges = (Ranges)iterator.next();
                    adder.add(ranges.start(), ranges.end(bl2));
                }
            }
        }
    }

    public static void compact(Set<String> set, Adder adder, boolean bl2) {
        StringRange.compact(set, adder, bl2, false);
    }

    private static LinkedList<Ranges> compact(int n2, Set<Ranges> set) {
        LinkedList<Ranges> linkedList = new LinkedList<Ranges>(set);
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            Ranges ranges = null;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Ranges ranges2 = (Ranges)iterator.next();
                if (ranges == null) {
                    ranges = ranges2;
                    continue;
                }
                if (ranges.merge(i2, ranges2)) {
                    iterator.remove();
                    continue;
                }
                ranges = ranges2;
            }
        }
        return linkedList;
    }

    public static Collection<String> expand(String string, String string2, boolean bl2, Collection<String> collection) {
        if (string == null || string2 == null) {
            throw new ICUException("Range must have 2 valid strings");
        }
        int[] nArray = CharSequences.codePoints(string);
        int[] nArray2 = CharSequences.codePoints(string2);
        int n2 = nArray.length - nArray2.length;
        if (bl2 && n2 != 0) {
            throw new ICUException("Range must have equal-length strings");
        }
        if (n2 < 0) {
            throw new ICUException("Range must have start-length \u2265 end-length");
        }
        if (nArray2.length == 0) {
            throw new ICUException("Range must have end-length > 0");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.appendCodePoint(nArray[i2]);
        }
        StringRange.add(0, n2, nArray, nArray2, stringBuilder, collection);
        return collection;
    }

    private static void add(int n2, int n3, int[] nArray, int[] nArray2, StringBuilder stringBuilder, Collection<String> collection) {
        int n4 = nArray[n2 + n3];
        int n5 = nArray2[n2];
        if (n4 > n5) {
            throw new ICUException("Range must have x\u1d62 \u2264 y\u1d62 for each index i");
        }
        boolean bl2 = n2 == nArray2.length - 1;
        int n6 = stringBuilder.length();
        for (int i2 = n4; i2 <= n5; ++i2) {
            stringBuilder.appendCodePoint(i2);
            if (bl2) {
                collection.add(stringBuilder.toString());
            } else {
                StringRange.add(n2 + 1, n3, nArray, nArray2, stringBuilder, collection);
            }
            stringBuilder.setLength(n6);
        }
    }

    static final class Ranges
    implements Comparable<Ranges> {
        private final Range[] ranges;

        public Ranges(String string) {
            int[] nArray = CharSequences.codePoints(string);
            this.ranges = new Range[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.ranges[i2] = new Range(nArray[i2], nArray[i2]);
            }
        }

        public boolean merge(int n2, Ranges ranges) {
            for (int i2 = this.ranges.length - 1; i2 >= 0; --i2) {
                if (!(i2 == n2 ? this.ranges[i2].max != ranges.ranges[i2].min - 1 : !this.ranges[i2].equals(ranges.ranges[i2]))) continue;
                return false;
            }
            this.ranges[n2].max = ranges.ranges[n2].max;
            return true;
        }

        public String start() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < this.ranges.length; ++i2) {
                stringBuilder.appendCodePoint(this.ranges[i2].min);
            }
            return stringBuilder.toString();
        }

        public String end(boolean bl2) {
            int n2;
            int n3 = this.firstDifference();
            if (n3 == this.ranges.length) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n4 = n2 = bl2 ? n3 : 0;
            while (n2 < this.ranges.length) {
                stringBuilder.appendCodePoint(this.ranges[n2].max);
                ++n2;
            }
            return stringBuilder.toString();
        }

        public int firstDifference() {
            for (int i2 = 0; i2 < this.ranges.length; ++i2) {
                if (this.ranges[i2].min == this.ranges[i2].max) continue;
                return i2;
            }
            return this.ranges.length;
        }

        public Integer size() {
            return this.ranges.length;
        }

        @Override
        public int compareTo(Ranges ranges) {
            int n2 = this.ranges.length - ranges.ranges.length;
            if (n2 != 0) {
                return n2;
            }
            for (int i2 = 0; i2 < this.ranges.length; ++i2) {
                n2 = this.ranges[i2].compareTo(ranges.ranges[i2]);
                if (n2 == 0) continue;
                return n2;
            }
            return 0;
        }

        public String toString() {
            String string = this.start();
            String string2 = this.end(false);
            return string2 == null ? string : string + "~" + string2;
        }
    }

    static final class Range
    implements Comparable<Range> {
        int min;
        int max;

        public Range(int n2, int n3) {
            this.min = n2;
            this.max = n3;
        }

        public boolean equals(Object object) {
            return this == object || object != null && object instanceof Range && this.compareTo((Range)object) == 0;
        }

        @Override
        public int compareTo(Range range) {
            int n2 = this.min - range.min;
            if (n2 != 0) {
                return n2;
            }
            return this.max - range.max;
        }

        public int hashCode() {
            return this.min * 37 + this.max;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().appendCodePoint(this.min);
            return this.min == this.max ? stringBuilder.toString() : stringBuilder.append('~').appendCodePoint(this.max).toString();
        }
    }

    public static interface Adder {
        public void add(String var1, String var2);
    }
}

