/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.text.CharacterIterator;
import java.util.HashSet;
import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BreakIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.FilteredBreakIteratorBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UCharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BytesTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CharsTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CharsTrieBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUCloneNotSupportedException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.StringTrieBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class SimpleFilteredSentenceBreakIterator
extends BreakIterator {
    private BreakIterator delegate;
    private UCharacterIterator text;
    private CharsTrie backwardsTrie;
    private CharsTrie forwardsPartialTrie;

    public SimpleFilteredSentenceBreakIterator(BreakIterator breakIterator, CharsTrie charsTrie, CharsTrie charsTrie2) {
        this.delegate = breakIterator;
        this.forwardsPartialTrie = charsTrie;
        this.backwardsTrie = charsTrie2;
    }

    private final void resetState() {
        this.text = UCharacterIterator.getInstance((CharacterIterator)this.delegate.getText().clone());
    }

    private final boolean breakExceptionAt(int n2) {
        BytesTrie.Result result;
        int n3 = -1;
        int n4 = -1;
        this.text.setIndex(n2);
        this.backwardsTrie.reset();
        int n5 = this.text.previousCodePoint();
        if (n5 != 32) {
            n5 = this.text.nextCodePoint();
        }
        while ((n5 = this.text.previousCodePoint()) >= 0) {
            result = this.backwardsTrie.nextForCodePoint(n5);
            if (result.hasValue()) {
                n3 = this.text.getIndex();
                n4 = this.backwardsTrie.getValue();
            }
            if (result.hasNext()) continue;
            break;
        }
        this.backwardsTrie.reset();
        if (n3 >= 0) {
            if (n4 == 2) {
                return true;
            }
            if (n4 == 1 && this.forwardsPartialTrie != null) {
                this.forwardsPartialTrie.reset();
                result = BytesTrie.Result.INTERMEDIATE_VALUE;
                this.text.setIndex(n3);
                while ((n5 = this.text.nextCodePoint()) != -1 && (result = this.forwardsPartialTrie.nextForCodePoint(n5)).hasNext()) {
                }
                this.forwardsPartialTrie.reset();
                if (result.matches()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final int internalNext(int n2) {
        if (n2 == -1 || this.backwardsTrie == null) {
            return n2;
        }
        this.resetState();
        int n3 = this.text.getLength();
        while (n2 != -1 && n2 != n3) {
            if (this.breakExceptionAt(n2)) {
                n2 = this.delegate.next();
                continue;
            }
            return n2;
        }
        return n2;
    }

    private final int internalPrev(int n2) {
        if (n2 == 0 || n2 == -1 || this.backwardsTrie == null) {
            return n2;
        }
        this.resetState();
        while (n2 != -1 && n2 != 0) {
            if (this.breakExceptionAt(n2)) {
                n2 = this.delegate.previous();
                continue;
            }
            return n2;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SimpleFilteredSentenceBreakIterator simpleFilteredSentenceBreakIterator = (SimpleFilteredSentenceBreakIterator)object;
        return this.delegate.equals(simpleFilteredSentenceBreakIterator.delegate) && this.text.equals(simpleFilteredSentenceBreakIterator.text) && this.backwardsTrie.equals(simpleFilteredSentenceBreakIterator.backwardsTrie) && this.forwardsPartialTrie.equals(simpleFilteredSentenceBreakIterator.forwardsPartialTrie);
    }

    public int hashCode() {
        return this.forwardsPartialTrie.hashCode() * 39 + this.backwardsTrie.hashCode() * 11 + this.delegate.hashCode();
    }

    @Override
    public Object clone() {
        SimpleFilteredSentenceBreakIterator simpleFilteredSentenceBreakIterator = (SimpleFilteredSentenceBreakIterator)super.clone();
        try {
            if (this.delegate != null) {
                simpleFilteredSentenceBreakIterator.delegate = (BreakIterator)this.delegate.clone();
            }
            if (this.text != null) {
                simpleFilteredSentenceBreakIterator.text = (UCharacterIterator)this.text.clone();
            }
            if (this.backwardsTrie != null) {
                simpleFilteredSentenceBreakIterator.backwardsTrie = this.backwardsTrie.clone();
            }
            if (this.forwardsPartialTrie != null) {
                simpleFilteredSentenceBreakIterator.forwardsPartialTrie = this.forwardsPartialTrie.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ICUCloneNotSupportedException(cloneNotSupportedException);
        }
        return simpleFilteredSentenceBreakIterator;
    }

    @Override
    public int first() {
        return this.delegate.first();
    }

    @Override
    public int preceding(int n2) {
        return this.internalPrev(this.delegate.preceding(n2));
    }

    @Override
    public int previous() {
        return this.internalPrev(this.delegate.previous());
    }

    @Override
    public int current() {
        return this.delegate.current();
    }

    @Override
    public boolean isBoundary(int n2) {
        if (!this.delegate.isBoundary(n2)) {
            return false;
        }
        if (this.backwardsTrie == null) {
            return true;
        }
        this.resetState();
        return !this.breakExceptionAt(n2);
    }

    @Override
    public int next() {
        return this.internalNext(this.delegate.next());
    }

    @Override
    public int next(int n2) {
        return this.internalNext(this.delegate.next(n2));
    }

    @Override
    public int following(int n2) {
        return this.internalNext(this.delegate.following(n2));
    }

    @Override
    public int last() {
        return this.delegate.last();
    }

    @Override
    public CharacterIterator getText() {
        return this.delegate.getText();
    }

    @Override
    public void setText(CharacterIterator characterIterator) {
        this.delegate.setText(characterIterator);
    }

    public static class Builder
    extends FilteredBreakIteratorBuilder {
        private HashSet<CharSequence> filterSet = new HashSet();
        static final int PARTIAL = 1;
        static final int MATCH = 2;
        static final int SuppressInReverse = 1;
        static final int AddToForward = 2;

        public Builder(Locale locale) {
            this(ULocale.forLocale(locale));
        }

        public Builder(ULocale uLocale) {
            ICUResourceBundle iCUResourceBundle = ICUResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/brkitr", uLocale, ICUResourceBundle.OpenType.LOCALE_ROOT);
            ICUResourceBundle iCUResourceBundle2 = iCUResourceBundle.findWithFallback("exceptions/SentenceBreak");
            if (iCUResourceBundle2 != null) {
                int n2 = iCUResourceBundle2.getSize();
                for (int i2 = 0; i2 < n2; ++i2) {
                    ICUResourceBundle iCUResourceBundle3 = (ICUResourceBundle)iCUResourceBundle2.get(i2);
                    String string = iCUResourceBundle3.getString();
                    this.filterSet.add(string);
                }
            }
        }

        public Builder() {
        }

        @Override
        public boolean suppressBreakAfter(CharSequence charSequence) {
            return this.filterSet.add(charSequence);
        }

        @Override
        public boolean unsuppressBreakAfter(CharSequence charSequence) {
            return this.filterSet.remove(charSequence);
        }

        @Override
        public BreakIterator wrapIteratorWithFilter(BreakIterator breakIterator) {
            if (this.filterSet.isEmpty()) {
                return breakIterator;
            }
            CharsTrieBuilder charsTrieBuilder = new CharsTrieBuilder();
            CharsTrieBuilder charsTrieBuilder2 = new CharsTrieBuilder();
            int n2 = 0;
            int n3 = 0;
            int n4 = this.filterSet.size();
            CharSequence[] charSequenceArray = new CharSequence[n4];
            int[] nArray = new int[n4];
            CharsTrie charsTrie = null;
            CharsTrie charsTrie2 = null;
            int n5 = 0;
            Object object = this.filterSet.iterator();
            while (object.hasNext()) {
                CharSequence charSequence;
                charSequenceArray[n5] = charSequence = object.next();
                nArray[n5] = 0;
                ++n5;
            }
            for (n5 = 0; n5 < n4; ++n5) {
                object = charSequenceArray[n5].toString();
                int n6 = ((String)object).indexOf(46);
                if (n6 <= -1 || n6 + 1 == ((String)object).length()) continue;
                int n7 = -1;
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (i2 == n5 || !((String)object).regionMatches(0, charSequenceArray[i2].toString(), 0, n6 + 1)) continue;
                    if (nArray[i2] == 0) {
                        nArray[i2] = 3;
                        continue;
                    }
                    if ((nArray[i2] & 1) == 0) continue;
                    n7 = i2;
                }
                if (n7 != -1 || nArray[n5] != 0) continue;
                StringBuilder stringBuilder = new StringBuilder(((String)object).substring(0, n6 + 1));
                stringBuilder.reverse();
                charsTrieBuilder.add(stringBuilder, 1);
                ++n2;
                nArray[n5] = 3;
            }
            for (n5 = 0; n5 < n4; ++n5) {
                object = charSequenceArray[n5].toString();
                if (nArray[n5] == 0) {
                    StringBuilder stringBuilder = new StringBuilder((String)object).reverse();
                    charsTrieBuilder.add(stringBuilder, 2);
                    ++n2;
                    continue;
                }
                charsTrieBuilder2.add((CharSequence)object, 2);
                ++n3;
            }
            if (n2 > 0) {
                charsTrie = charsTrieBuilder.build(StringTrieBuilder.Option.FAST);
            }
            if (n3 > 0) {
                charsTrie2 = charsTrieBuilder2.build(StringTrieBuilder.Option.FAST);
            }
            return new SimpleFilteredSentenceBreakIterator(breakIterator, charsTrie2, charsTrie);
        }
    }
}

