/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUCache;

public class SimpleCache<K, V>
implements ICUCache<K, V> {
    private static final int DEFAULT_CAPACITY = 16;
    private volatile Reference<Map<K, V>> cacheRef = null;
    private int type = 0;
    private int capacity = 16;

    public SimpleCache() {
    }

    public SimpleCache(int n2) {
        this(n2, 16);
    }

    public SimpleCache(int n2, int n3) {
        if (n2 == 1) {
            this.type = n2;
        }
        if (n3 > 0) {
            this.capacity = n3;
        }
    }

    @Override
    public V get(Object object) {
        Map<K, V> map;
        Reference<Map<K, V>> reference = this.cacheRef;
        if (reference != null && (map = reference.get()) != null) {
            return map.get(object);
        }
        return null;
    }

    @Override
    public void put(K k2, V v2) {
        Reference reference = this.cacheRef;
        Map<K, V> map = null;
        if (reference != null) {
            map = reference.get();
        }
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap(this.capacity));
            reference = this.type == 1 ? new WeakReference<Map<K, V>>(map) : new SoftReference<Map<K, V>>(map);
            this.cacheRef = reference;
        }
        map.put(k2, v2);
    }

    @Override
    public void clear() {
        this.cacheRef = null;
    }
}

