/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Freezable;

public class Relation<K, V>
implements Freezable<Relation<K, V>> {
    private Map<K, Set<V>> data;
    Constructor<? extends Set<V>> setCreator;
    Object[] setComparatorParam;
    volatile boolean frozen = false;

    public static <K, V> Relation<K, V> of(Map<K, Set<V>> map, Class<?> clazz) {
        return new Relation<K, V>(map, clazz);
    }

    public static <K, V> Relation<K, V> of(Map<K, Set<V>> map, Class<?> clazz, Comparator<V> comparator) {
        return new Relation<K, V>(map, clazz, comparator);
    }

    public Relation(Map<K, Set<V>> map, Class<?> clazz) {
        this(map, clazz, null);
    }

    public Relation(Map<K, Set<V>> hashMap, Class<?> clazz, Comparator<V> comparator) {
        try {
            Object[] objectArray;
            if (comparator == null) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = comparator;
            }
            this.setComparatorParam = objectArray;
            if (comparator == null) {
                this.setCreator = clazz.getConstructor(new Class[0]);
                this.setCreator.newInstance(this.setComparatorParam);
            } else {
                this.setCreator = clazz.getConstructor(Comparator.class);
                this.setCreator.newInstance(this.setComparatorParam);
            }
            this.data = hashMap == null ? new HashMap() : hashMap;
        }
        catch (Exception exception) {
            throw (RuntimeException)new IllegalArgumentException("Can't create new set").initCause(exception);
        }
    }

    public void clear() {
        this.data.clear();
    }

    public boolean containsKey(Object object) {
        return this.data.containsKey(object);
    }

    public boolean containsValue(Object object) {
        for (Set<V> set : this.data.values()) {
            if (!set.contains(object)) continue;
            return true;
        }
        return false;
    }

    public final Set<Map.Entry<K, V>> entrySet() {
        return this.keyValueSet();
    }

    public Set<Map.Entry<K, Set<V>>> keyValuesSet() {
        return this.data.entrySet();
    }

    public Set<Map.Entry<K, V>> keyValueSet() {
        LinkedHashSet<Map.Entry<K, V>> linkedHashSet = new LinkedHashSet<Map.Entry<K, V>>();
        for (K k2 : this.data.keySet()) {
            for (V v2 : this.data.get(k2)) {
                linkedHashSet.add(new SimpleEntry<K, V>(k2, v2));
            }
        }
        return linkedHashSet;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return this.data.equals(((Relation)object).data);
    }

    public Set<V> getAll(Object object) {
        return this.data.get(object);
    }

    public Set<V> get(Object object) {
        return this.data.get(object);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Set<K> keySet() {
        return this.data.keySet();
    }

    public V put(K k2, V v2) {
        Set<V> set = this.data.get(k2);
        if (set == null) {
            set = this.newSet();
            this.data.put(k2, set);
        }
        set.add(v2);
        return v2;
    }

    public V putAll(K k2, Collection<? extends V> collection) {
        Set<V> set = this.data.get(k2);
        if (set == null) {
            set = this.newSet();
            this.data.put(k2, set);
        }
        set.addAll(collection);
        return collection.size() == 0 ? null : (V)collection.iterator().next();
    }

    public V putAll(Collection<K> collection, V v2) {
        V v3 = null;
        for (K k2 : collection) {
            v3 = this.put(k2, v2);
        }
        return v3;
    }

    private Set<V> newSet() {
        try {
            return this.setCreator.newInstance(this.setComparatorParam);
        }
        catch (Exception exception) {
            throw (RuntimeException)new IllegalArgumentException("Can't create new set").initCause(exception);
        }
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Relation<? extends K, ? extends V> relation) {
        for (K k2 : relation.keySet()) {
            for (V v2 : relation.getAll(k2)) {
                this.put(k2, v2);
            }
        }
    }

    public Set<V> removeAll(K k2) {
        try {
            return this.data.remove(k2);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public boolean remove(K k2, V v2) {
        try {
            Set<V> set = this.data.get(k2);
            if (set == null) {
                return false;
            }
            boolean bl2 = set.remove(v2);
            if (set.size() == 0) {
                this.data.remove(k2);
            }
            return bl2;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public int size() {
        return this.data.size();
    }

    public Set<V> values() {
        return this.values(new LinkedHashSet());
    }

    public <C extends Collection<V>> C values(C c2) {
        for (Map.Entry<K, Set<V>> entry : this.data.entrySet()) {
            c2.addAll((Collection)entry.getValue());
        }
        return c2;
    }

    public String toString() {
        return this.data.toString();
    }

    public Relation<K, V> addAllInverted(Relation<V, K> relation) {
        for (K k2 : relation.data.keySet()) {
            for (V v2 : relation.data.get(k2)) {
                this.put(v2, k2);
            }
        }
        return this;
    }

    public Relation<K, V> addAllInverted(Map<V, K> map) {
        for (Map.Entry<V, K> entry : map.entrySet()) {
            this.put(entry.getValue(), entry.getKey());
        }
        return this;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public Relation<K, V> freeze() {
        if (!this.frozen) {
            for (K k2 : this.data.keySet()) {
                this.data.put(k2, Collections.unmodifiableSet(this.data.get(k2)));
            }
            this.data = Collections.unmodifiableMap(this.data);
            this.frozen = true;
        }
        return this;
    }

    @Override
    public Relation<K, V> cloneAsThawed() {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Relation<K, V> relation) {
        boolean bl2 = false;
        for (K k2 : relation.keySet()) {
            try {
                Set<V> set = relation.getAll(k2);
                if (set == null) continue;
                bl2 |= this.removeAll(k2, (Iterable<V>)set);
            }
            catch (NullPointerException nullPointerException) {}
        }
        return bl2;
    }

    @SafeVarargs
    public final Set<V> removeAll(K ... KArray) {
        return this.removeAll((Collection<K>)Arrays.asList(KArray));
    }

    public boolean removeAll(K k2, Iterable<V> iterable) {
        boolean bl2 = false;
        for (V v2 : iterable) {
            bl2 |= this.remove(k2, v2);
        }
        return bl2;
    }

    public Set<V> removeAll(Collection<K> collection) {
        LinkedHashSet<V> linkedHashSet = new LinkedHashSet<V>();
        for (K k2 : collection) {
            try {
                Set<V> set = this.data.remove(k2);
                if (set == null) continue;
                linkedHashSet.addAll(set);
            }
            catch (NullPointerException nullPointerException) {}
        }
        return linkedHashSet;
    }

    static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        public SimpleEntry(K k2, V v2) {
            this.key = k2;
            this.value = v2;
        }

        public SimpleEntry(Map.Entry<K, V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }
    }
}

