/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.StringPrepParseException;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUInputTooLongException;

public final class Punycode {
    private static final int BASE = 36;
    private static final int TMIN = 1;
    private static final int TMAX = 26;
    private static final int SKEW = 38;
    private static final int DAMP = 700;
    private static final int INITIAL_BIAS = 72;
    private static final int INITIAL_N = 128;
    private static final char HYPHEN = '-';
    private static final char DELIMITER = '-';
    private static final int ZERO = 48;
    private static final int SMALL_A = 97;
    private static final int SMALL_Z = 122;
    private static final int CAPITAL_A = 65;
    private static final int CAPITAL_Z = 90;
    private static final int ENCODE_MAX_CODE_UNITS = 1000;
    private static final int DECODE_MAX_CHARS = 2000;

    private static int adaptBias(int n2, int n3, boolean bl2) {
        n2 = bl2 ? (n2 /= 700) : (n2 /= 2);
        n2 += n2 / n3;
        int n4 = 0;
        while (n2 > 455) {
            n2 /= 35;
            n4 += 36;
        }
        return n4 + 36 * n2 / (n2 + 38);
    }

    private static final int decodeDigit(int n2) {
        if (n2 <= 90) {
            if (n2 <= 57) {
                if (n2 < 48) {
                    return -1;
                }
                return n2 - 48 + 26;
            }
            return n2 - 65;
        }
        if (n2 <= 122) {
            return n2 - 97;
        }
        return -1;
    }

    private static char asciiCaseMap(char c2, boolean bl2) {
        if (bl2) {
            if ('a' <= c2 && c2 <= 'z') {
                c2 = (char)(c2 - 32);
            }
        } else if ('A' <= c2 && c2 <= 'Z') {
            c2 = (char)(c2 + 32);
        }
        return c2;
    }

    private static char digitToBasic(int n2, boolean bl2) {
        if (n2 < 26) {
            if (bl2) {
                return (char)(65 + n2);
            }
            return (char)(97 + n2);
        }
        return (char)(22 + n2);
    }

    public static StringBuilder encode(CharSequence charSequence, boolean[] blArray) throws StringPrepParseException {
        int n2;
        int n3;
        int n4 = charSequence.length();
        if (n4 > 1000) {
            throw new ICUInputTooLongException("input too long: " + n4 + " UTF-16 code units");
        }
        int[] nArray = new int[n4];
        StringBuilder stringBuilder = new StringBuilder(n4);
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            char c2;
            char c3 = charSequence.charAt(n3);
            if (Punycode.isBasic(c3)) {
                nArray[n5++] = 0;
                stringBuilder.append(blArray != null ? Punycode.asciiCaseMap(c3, blArray[n3]) : c3);
                continue;
            }
            n2 = (blArray != null && blArray[n3] ? 1 : 0) << 31;
            if (!UTF16.isSurrogate(c3)) {
                n2 |= c3;
            } else if (UTF16.isLeadSurrogate(c3) && n3 + 1 < n4 && UTF16.isTrailSurrogate(c2 = charSequence.charAt(n3 + 1))) {
                ++n3;
                n2 |= UCharacter.getCodePoint(c3, c2);
            } else {
                throw new StringPrepParseException("Illegal char found", 1);
            }
            nArray[n5++] = n2;
        }
        int n6 = stringBuilder.length();
        if (n6 > 0) {
            stringBuilder.append('-');
        }
        n2 = 128;
        int n7 = 0;
        int n8 = 72;
        int n9 = n6;
        while (n9 < n5) {
            int n10;
            int n11 = Integer.MAX_VALUE;
            for (n3 = 0; n3 < n5; ++n3) {
                n10 = nArray[n3] & Integer.MAX_VALUE;
                if (n2 > n10 || n10 >= n11) continue;
                n11 = n10;
            }
            if (n11 - n2 > (Integer.MAX_VALUE - n9 - n7) / (n9 + 1)) {
                throw new IllegalStateException("Internal program error");
            }
            n7 += (n11 - n2) * (n9 + 1);
            n2 = n11;
            for (n3 = 0; n3 < n5; ++n3) {
                n10 = nArray[n3] & Integer.MAX_VALUE;
                if (n10 < n2) {
                    ++n7;
                    continue;
                }
                if (n10 != n2) continue;
                n10 = n7;
                int n12 = 36;
                while (true) {
                    int n13;
                    if ((n13 = n12 - n8) < 1) {
                        n13 = 1;
                    } else if (n12 >= n8 + 26) {
                        n13 = 26;
                    }
                    if (n10 < n13) break;
                    stringBuilder.append(Punycode.digitToBasic(n13 + (n10 - n13) % (36 - n13), false));
                    n10 = (n10 - n13) / (36 - n13);
                    n12 += 36;
                }
                stringBuilder.append(Punycode.digitToBasic(n10, nArray[n3] < 0));
                n8 = Punycode.adaptBias(n7, n9 + 1, n9 == n6);
                n7 = 0;
                ++n9;
            }
            ++n7;
            ++n2;
        }
        return stringBuilder;
    }

    private static boolean isBasic(int n2) {
        return n2 < 128;
    }

    private static boolean isBasicUpperCase(int n2) {
        return 65 <= n2 && n2 >= 90;
    }

    private static boolean isSurrogate(int n2) {
        return (n2 & 0xFFFFF800) == 55296;
    }

    public static StringBuilder decode(CharSequence charSequence, boolean[] blArray) throws StringPrepParseException {
        int n2;
        int n3;
        int n4 = charSequence.length();
        if (n4 > 2000) {
            throw new ICUInputTooLongException("input too long: " + n4 + " characters");
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        int n5 = n4;
        while (n5 > 0 && charSequence.charAt(--n5) != '-') {
        }
        int n6 = n3 = n5;
        for (n5 = 0; n5 < n6; ++n5) {
            char c2 = charSequence.charAt(n5);
            if (!Punycode.isBasic(c2)) {
                throw new StringPrepParseException("Illegal char found", 0);
            }
            stringBuilder.append(c2);
            if (blArray == null || n5 >= blArray.length) continue;
            blArray[n5] = Punycode.isBasicUpperCase(c2);
        }
        int n7 = 128;
        int n8 = 0;
        int n9 = 72;
        int n10 = 1000000000;
        int n11 = n2 = n6 > 0 ? n6 + 1 : 0;
        while (n2 < n4) {
            int n12;
            int n13 = n8;
            int n14 = 1;
            int n15 = 36;
            while (true) {
                int n16;
                if (n2 >= n4) {
                    throw new StringPrepParseException("Illegal char found", 1);
                }
                if ((n16 = Punycode.decodeDigit(charSequence.charAt(n2++))) < 0) {
                    throw new StringPrepParseException("Invalid char found", 0);
                }
                if (n16 > (Integer.MAX_VALUE - n8) / n14) {
                    throw new StringPrepParseException("Illegal char found", 1);
                }
                n8 += n16 * n14;
                int n17 = n15 - n9;
                if (n17 < 1) {
                    n17 = 1;
                } else if (n15 >= n9 + 26) {
                    n17 = 26;
                }
                if (n16 < n17) break;
                if (n14 > Integer.MAX_VALUE / (36 - n17)) {
                    throw new StringPrepParseException("Illegal char found", 1);
                }
                n14 *= 36 - n17;
                n15 += 36;
            }
            n9 = Punycode.adaptBias(n8 - n13, ++n3, n13 == 0);
            if (n8 / n3 > Integer.MAX_VALUE - n7) {
                throw new StringPrepParseException("Illegal char found", 1);
            }
            n7 += n8 / n3;
            n8 %= n3;
            if (n7 > 0x10FFFF || Punycode.isSurrogate(n7)) {
                throw new StringPrepParseException("Illegal char found", 1);
            }
            int n18 = Character.charCount(n7);
            if (n8 <= n10) {
                n12 = n8;
                n10 = n18 > 1 ? n12 : ++n10;
            } else {
                n12 = stringBuilder.offsetByCodePoints(n10, n8 - n10);
            }
            if (blArray != null && stringBuilder.length() + n18 <= blArray.length) {
                if (n12 < stringBuilder.length()) {
                    System.arraycopy(blArray, n12, blArray, n12 + n18, stringBuilder.length() - n12);
                }
                blArray[n12] = Punycode.isBasicUpperCase(charSequence.charAt(n2 - 1));
                if (n18 == 2) {
                    blArray[n12 + 1] = false;
                }
            }
            if (n18 == 1) {
                stringBuilder.insert(n12, (char)n7);
            } else {
                stringBuilder.insert(n12, UTF16.getLeadSurrogate(n7));
                stringBuilder.insert(n12 + 1, UTF16.getTrailSurrogate(n7));
            }
            ++n8;
        }
        return stringBuilder;
    }
}

