/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

public class PatternTokenizer {
    private UnicodeSet ignorableCharacters = new UnicodeSet();
    private UnicodeSet syntaxCharacters = new UnicodeSet();
    private UnicodeSet extraQuotingCharacters = new UnicodeSet();
    private UnicodeSet escapeCharacters = new UnicodeSet();
    private boolean usingSlash = false;
    private boolean usingQuote = false;
    private transient UnicodeSet needingQuoteCharacters = null;
    private int start;
    private int limit;
    private String pattern;
    public static final char SINGLE_QUOTE = '\'';
    public static final char BACK_SLASH = '\\';
    private static int NO_QUOTE = -1;
    private static int IN_QUOTE = -2;
    public static final int DONE = 0;
    public static final int SYNTAX = 1;
    public static final int LITERAL = 2;
    public static final int BROKEN_QUOTE = 3;
    public static final int BROKEN_ESCAPE = 4;
    public static final int UNKNOWN = 5;
    private static final int AFTER_QUOTE = -1;
    private static final int NONE = 0;
    private static final int START_QUOTE = 1;
    private static final int NORMAL_QUOTE = 2;
    private static final int SLASH_START = 3;
    private static final int HEX = 4;

    public UnicodeSet getIgnorableCharacters() {
        return (UnicodeSet)this.ignorableCharacters.clone();
    }

    public PatternTokenizer setIgnorableCharacters(UnicodeSet unicodeSet) {
        this.ignorableCharacters = (UnicodeSet)unicodeSet.clone();
        this.needingQuoteCharacters = null;
        return this;
    }

    public UnicodeSet getSyntaxCharacters() {
        return (UnicodeSet)this.syntaxCharacters.clone();
    }

    public UnicodeSet getExtraQuotingCharacters() {
        return (UnicodeSet)this.extraQuotingCharacters.clone();
    }

    public PatternTokenizer setSyntaxCharacters(UnicodeSet unicodeSet) {
        this.syntaxCharacters = (UnicodeSet)unicodeSet.clone();
        this.needingQuoteCharacters = null;
        return this;
    }

    public PatternTokenizer setExtraQuotingCharacters(UnicodeSet unicodeSet) {
        this.extraQuotingCharacters = (UnicodeSet)unicodeSet.clone();
        this.needingQuoteCharacters = null;
        return this;
    }

    public UnicodeSet getEscapeCharacters() {
        return (UnicodeSet)this.escapeCharacters.clone();
    }

    public PatternTokenizer setEscapeCharacters(UnicodeSet unicodeSet) {
        this.escapeCharacters = (UnicodeSet)unicodeSet.clone();
        return this;
    }

    public boolean isUsingQuote() {
        return this.usingQuote;
    }

    public PatternTokenizer setUsingQuote(boolean bl2) {
        this.usingQuote = bl2;
        this.needingQuoteCharacters = null;
        return this;
    }

    public boolean isUsingSlash() {
        return this.usingSlash;
    }

    public PatternTokenizer setUsingSlash(boolean bl2) {
        this.usingSlash = bl2;
        this.needingQuoteCharacters = null;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public PatternTokenizer setLimit(int n2) {
        this.limit = n2;
        return this;
    }

    public int getStart() {
        return this.start;
    }

    public PatternTokenizer setStart(int n2) {
        this.start = n2;
        return this;
    }

    public PatternTokenizer setPattern(CharSequence charSequence) {
        return this.setPattern(charSequence.toString());
    }

    public PatternTokenizer setPattern(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Inconsistent arguments");
        }
        this.start = 0;
        this.limit = string.length();
        this.pattern = string;
        return this;
    }

    public String quoteLiteral(CharSequence charSequence) {
        return this.quoteLiteral(charSequence.toString());
    }

    public String quoteLiteral(String string) {
        int n2;
        if (this.needingQuoteCharacters == null) {
            this.needingQuoteCharacters = new UnicodeSet().addAll(this.syntaxCharacters).addAll(this.ignorableCharacters).addAll(this.extraQuotingCharacters);
            if (this.usingSlash) {
                this.needingQuoteCharacters.add(92);
            }
            if (this.usingQuote) {
                this.needingQuoteCharacters.add(39);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = NO_QUOTE;
        for (int i2 = 0; i2 < string.length(); i2 += UTF16.getCharCount(n2)) {
            n2 = UTF16.charAt(string, i2);
            if (this.escapeCharacters.contains(n2)) {
                if (n3 == IN_QUOTE) {
                    stringBuffer.append('\'');
                    n3 = NO_QUOTE;
                }
                this.appendEscaped(stringBuffer, n2);
                continue;
            }
            if (this.needingQuoteCharacters.contains(n2)) {
                if (n3 == IN_QUOTE) {
                    UTF16.append(stringBuffer, n2);
                    if (!this.usingQuote || n2 != 39) continue;
                    stringBuffer.append('\'');
                    continue;
                }
                if (this.usingSlash) {
                    stringBuffer.append('\\');
                    UTF16.append(stringBuffer, n2);
                    continue;
                }
                if (this.usingQuote) {
                    if (n2 == 39) {
                        stringBuffer.append('\'');
                        stringBuffer.append('\'');
                        continue;
                    }
                    stringBuffer.append('\'');
                    UTF16.append(stringBuffer, n2);
                    n3 = IN_QUOTE;
                    continue;
                }
                this.appendEscaped(stringBuffer, n2);
                continue;
            }
            if (n3 == IN_QUOTE) {
                stringBuffer.append('\'');
                n3 = NO_QUOTE;
            }
            UTF16.append(stringBuffer, n2);
        }
        if (n3 == IN_QUOTE) {
            stringBuffer.append('\'');
        }
        return stringBuffer.toString();
    }

    private void appendEscaped(StringBuffer stringBuffer, int n2) {
        if (n2 <= 65535) {
            stringBuffer.append("\\u").append(Utility.hex(n2, 4));
        } else {
            stringBuffer.append("\\U").append(Utility.hex(n2, 8));
        }
    }

    public String normalize() {
        int n2 = this.start;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (true) {
            stringBuffer2.setLength(0);
            int n3 = this.next(stringBuffer2);
            if (n3 == 0) {
                this.start = n2;
                return stringBuffer.toString();
            }
            if (n3 != 1) {
                stringBuffer.append(this.quoteLiteral(stringBuffer2));
                continue;
            }
            stringBuffer.append(stringBuffer2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int next(StringBuffer stringBuffer) {
        int n2;
        if (this.start >= this.limit) {
            return 0;
        }
        int n3 = 5;
        int n4 = 5;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        block21: for (int i2 = this.start; i2 < this.limit; i2 += UTF16.getCharCount(n2)) {
            n2 = UTF16.charAt(this.pattern, i2);
            switch (n5) {
                case 3: {
                    switch (n2) {
                        case 117: {
                            n5 = 4;
                            n6 = 4;
                            n7 = 0;
                            continue block21;
                        }
                        case 85: {
                            n5 = 4;
                            n6 = 8;
                            n7 = 0;
                            continue block21;
                        }
                        default: {
                            if (this.usingSlash) {
                                UTF16.append(stringBuffer, n2);
                                n5 = 0;
                                continue block21;
                            }
                            stringBuffer.append('\\');
                            n5 = 0;
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    n7 <<= 4;
                    n7 += n2;
                    switch (n2) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            n7 -= 48;
                            break;
                        }
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: {
                            n7 -= 87;
                            break;
                        }
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: {
                            n7 -= 55;
                            break;
                        }
                        default: {
                            this.start = i2;
                            return 4;
                        }
                    }
                    if (--n6 != 0) continue block21;
                    n5 = 0;
                    UTF16.append(stringBuffer, n7);
                    continue block21;
                }
                case -1: {
                    if (n2 == n4) {
                        UTF16.append(stringBuffer, n2);
                        n5 = 2;
                        continue block21;
                    }
                    n5 = 0;
                    break;
                }
                case 1: {
                    if (n2 == n4) {
                        UTF16.append(stringBuffer, n2);
                        n5 = 0;
                        continue block21;
                    }
                    UTF16.append(stringBuffer, n2);
                    n5 = 2;
                    continue block21;
                }
                case 2: {
                    if (n2 == n4) {
                        n5 = -1;
                        continue block21;
                    }
                    UTF16.append(stringBuffer, n2);
                    continue block21;
                }
            }
            if (this.ignorableCharacters.contains(n2)) continue;
            if (this.syntaxCharacters.contains(n2)) {
                if (n3 == 5) {
                    UTF16.append(stringBuffer, n2);
                    this.start = i2 + UTF16.getCharCount(n2);
                    return 1;
                }
                this.start = i2;
                return n3;
            }
            n3 = 2;
            if (n2 == 92) {
                n5 = 3;
                continue;
            }
            if (this.usingQuote && n2 == 39) {
                n4 = n2;
                n5 = 1;
                continue;
            }
            UTF16.append(stringBuffer, n2);
        }
        this.start = this.limit;
        switch (n5) {
            case 4: {
                return 4;
            }
            case 3: {
                if (this.usingSlash) {
                    return 4;
                }
                stringBuffer.append('\\');
                return n3;
            }
            case 1: 
            case 2: {
                return 3;
            }
        }
        return n3;
    }
}

