/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.util.Comparator;
import java.util.Iterator;

public class IterableComparator<T>
implements Comparator<Iterable<T>> {
    private final Comparator<T> comparator;
    private final int shorterFirst;
    private static final IterableComparator NOCOMPARATOR = new IterableComparator();

    public IterableComparator() {
        this(null, true);
    }

    public IterableComparator(Comparator<T> comparator) {
        this(comparator, true);
    }

    public IterableComparator(Comparator<T> comparator, boolean bl2) {
        this.comparator = comparator;
        this.shorterFirst = bl2 ? 1 : -1;
    }

    @Override
    public int compare(Iterable<T> iterable, Iterable<T> iterable2) {
        T t2;
        T t3;
        int n2;
        if (iterable == null) {
            return iterable2 == null ? 0 : -this.shorterFirst;
        }
        if (iterable2 == null) {
            return this.shorterFirst;
        }
        Iterator<T> iterator = iterable.iterator();
        Iterator<T> iterator2 = iterable2.iterator();
        do {
            if (!iterator.hasNext()) {
                return iterator2.hasNext() ? -this.shorterFirst : 0;
            }
            if (!iterator2.hasNext()) {
                return this.shorterFirst;
            }
            t3 = iterator.next();
            t2 = iterator2.next();
        } while ((n2 = this.comparator != null ? this.comparator.compare(t3, t2) : ((Comparable)t3).compareTo(t2)) == 0);
        return n2;
    }

    public static <T> int compareIterables(Iterable<T> iterable, Iterable<T> iterable2) {
        return NOCOMPARATOR.compare(iterable, iterable2);
    }
}

