/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.IntTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.TrieBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;

public class IntTrieBuilder
extends TrieBuilder {
    protected int[] m_data_;
    protected int m_initialValue_;
    private int m_leadUnitValue_;

    public IntTrieBuilder(IntTrieBuilder intTrieBuilder) {
        super(intTrieBuilder);
        this.m_data_ = new int[this.m_dataCapacity_];
        System.arraycopy(intTrieBuilder.m_data_, 0, this.m_data_, 0, this.m_dataLength_);
        this.m_initialValue_ = intTrieBuilder.m_initialValue_;
        this.m_leadUnitValue_ = intTrieBuilder.m_leadUnitValue_;
    }

    public IntTrieBuilder(int[] nArray, int n2, int n3, int n4, boolean bl2) {
        if (n2 < 32 || bl2 && n2 < 1024) {
            throw new IllegalArgumentException("Argument maxdatalength is too small");
        }
        this.m_data_ = nArray != null ? nArray : new int[n2];
        int n5 = 32;
        if (bl2) {
            int n6 = 0;
            do {
                this.m_index_[n6++] = n5;
                n5 += 32;
            } while (n6 < 8);
        }
        this.m_dataLength_ = n5;
        Arrays.fill(this.m_data_, 0, this.m_dataLength_, n3);
        this.m_initialValue_ = n3;
        this.m_leadUnitValue_ = n4;
        this.m_dataCapacity_ = n2;
        this.m_isLatin1Linear_ = bl2;
        this.m_isCompacted_ = false;
    }

    public int getValue(int n2) {
        if (this.m_isCompacted_ || n2 > 0x10FFFF || n2 < 0) {
            return 0;
        }
        int n3 = this.m_index_[n2 >> 5];
        return this.m_data_[Math.abs(n3) + (n2 & 0x1F)];
    }

    public int getValue(int n2, boolean[] blArray) {
        if (this.m_isCompacted_ || n2 > 0x10FFFF || n2 < 0) {
            if (blArray != null) {
                blArray[0] = true;
            }
            return 0;
        }
        int n3 = this.m_index_[n2 >> 5];
        if (blArray != null) {
            blArray[0] = n3 == 0;
        }
        return this.m_data_[Math.abs(n3) + (n2 & 0x1F)];
    }

    public boolean setValue(int n2, int n3) {
        if (this.m_isCompacted_ || n2 > 0x10FFFF || n2 < 0) {
            return false;
        }
        int n4 = this.getDataBlock(n2);
        if (n4 < 0) {
            return false;
        }
        this.m_data_[n4 + (n2 & 0x1F)] = n3;
        return true;
    }

    public IntTrie serialize(TrieBuilder.DataManipulate dataManipulate, Trie.DataManipulate dataManipulate2) {
        int n2;
        if (dataManipulate == null) {
            throw new IllegalArgumentException("Parameters can not be null");
        }
        if (!this.m_isCompacted_) {
            this.compact(false);
            this.fold(dataManipulate);
            this.compact(true);
            this.m_isCompacted_ = true;
        }
        if (this.m_dataLength_ >= 262144) {
            throw new ArrayIndexOutOfBoundsException("Data length too small");
        }
        char[] cArray = new char[this.m_indexLength_];
        int[] nArray = new int[this.m_dataLength_];
        for (n2 = 0; n2 < this.m_indexLength_; ++n2) {
            cArray[n2] = (char)(this.m_index_[n2] >>> 2);
        }
        System.arraycopy(this.m_data_, 0, nArray, 0, this.m_dataLength_);
        n2 = 37;
        n2 |= 0x100;
        if (this.m_isLatin1Linear_) {
            n2 |= 0x200;
        }
        return new IntTrie(cArray, nArray, this.m_initialValue_, n2, dataManipulate2);
    }

    public int serialize(OutputStream outputStream, boolean bl2, TrieBuilder.DataManipulate dataManipulate) throws IOException {
        int n2;
        if (dataManipulate == null) {
            throw new IllegalArgumentException("Parameters can not be null");
        }
        if (!this.m_isCompacted_) {
            this.compact(false);
            this.fold(dataManipulate);
            this.compact(true);
            this.m_isCompacted_ = true;
        }
        if ((n2 = bl2 ? this.m_dataLength_ + this.m_indexLength_ : this.m_dataLength_) >= 262144) {
            throw new ArrayIndexOutOfBoundsException("Data length too small");
        }
        n2 = 16 + 2 * this.m_indexLength_;
        n2 = bl2 ? (n2 += 2 * this.m_dataLength_) : (n2 += 4 * this.m_dataLength_);
        if (outputStream == null) {
            return n2;
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(1416784229);
        int n3 = 37;
        if (!bl2) {
            n3 |= 0x100;
        }
        if (this.m_isLatin1Linear_) {
            n3 |= 0x200;
        }
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeInt(this.m_indexLength_);
        dataOutputStream.writeInt(this.m_dataLength_);
        if (bl2) {
            int n4;
            int n5;
            for (n5 = 0; n5 < this.m_indexLength_; ++n5) {
                n4 = this.m_index_[n5] + this.m_indexLength_ >>> 2;
                dataOutputStream.writeChar(n4);
            }
            for (n5 = 0; n5 < this.m_dataLength_; ++n5) {
                n4 = this.m_data_[n5] & 0xFFFF;
                dataOutputStream.writeChar(n4);
            }
        } else {
            int n6;
            for (n6 = 0; n6 < this.m_indexLength_; ++n6) {
                int n7 = this.m_index_[n6] >>> 2;
                dataOutputStream.writeChar(n7);
            }
            for (n6 = 0; n6 < this.m_dataLength_; ++n6) {
                dataOutputStream.writeInt(this.m_data_[n6]);
            }
        }
        return n2;
    }

    public boolean setRange(int n2, int n3, int n4, boolean bl2) {
        int n5;
        int n6;
        int n7;
        if (this.m_isCompacted_ || n2 < 0 || n2 > 0x10FFFF || n3 < 0 || n3 > 0x110000 || n2 > n3) {
            return false;
        }
        if (n2 == n3) {
            return true;
        }
        if ((n2 & 0x1F) != 0) {
            n7 = this.getDataBlock(n2);
            if (n7 < 0) {
                return false;
            }
            n6 = n2 + 32 & 0xFFFFFFE0;
            if (n6 <= n3) {
                this.fillBlock(n7, n2 & 0x1F, 32, n4, bl2);
                n2 = n6;
            } else {
                this.fillBlock(n7, n2 & 0x1F, n3 & 0x1F, n4, bl2);
                return true;
            }
        }
        n7 = n3 & 0x1F;
        n3 &= 0xFFFFFFE0;
        n6 = 0;
        if (n4 != this.m_initialValue_) {
            n6 = -1;
        }
        while (n2 < n3) {
            n5 = this.m_index_[n2 >> 5];
            if (n5 > 0) {
                this.fillBlock(n5, 0, 32, n4, bl2);
            } else if (this.m_data_[-n5] != n4 && (n5 == 0 || bl2)) {
                if (n6 >= 0) {
                    this.m_index_[n2 >> 5] = -n6;
                } else {
                    n6 = this.getDataBlock(n2);
                    if (n6 < 0) {
                        return false;
                    }
                    this.m_index_[n2 >> 5] = -n6;
                    this.fillBlock(n6, 0, 32, n4, true);
                }
            }
            n2 += 32;
        }
        if (n7 > 0) {
            n5 = this.getDataBlock(n2);
            if (n5 < 0) {
                return false;
            }
            this.fillBlock(n5, 0, n7, n4, bl2);
        }
        return true;
    }

    private int allocDataBlock() {
        int n2 = this.m_dataLength_;
        int n3 = n2 + 32;
        if (n3 > this.m_dataCapacity_) {
            return -1;
        }
        this.m_dataLength_ = n3;
        return n2;
    }

    private int getDataBlock(int n2) {
        int n3 = this.m_index_[n2 >>= 5];
        if (n3 > 0) {
            return n3;
        }
        int n4 = this.allocDataBlock();
        if (n4 < 0) {
            return -1;
        }
        this.m_index_[n2] = n4;
        System.arraycopy(this.m_data_, Math.abs(n3), this.m_data_, n4, 128);
        return n4;
    }

    private void compact(boolean bl2) {
        int n2;
        int n3;
        if (this.m_isCompacted_) {
            return;
        }
        this.findUnusedBlocks();
        int n4 = 32;
        if (this.m_isLatin1Linear_) {
            n4 += 256;
        }
        int n5 = n3 = 32;
        while (n5 < this.m_dataLength_) {
            if (this.m_map_[n5 >>> 5] < 0) {
                n5 += 32;
                continue;
            }
            if (n5 >= n4 && (n2 = IntTrieBuilder.findSameDataBlock(this.m_data_, n3, n5, bl2 ? 4 : 32)) >= 0) {
                this.m_map_[n5 >>> 5] = n2;
                n5 += 32;
                continue;
            }
            if (bl2 && n5 >= n4) {
                for (n2 = 28; n2 > 0 && !IntTrieBuilder.equal_int(this.m_data_, n3 - n2, n5, n2); n2 -= 4) {
                }
            } else {
                n2 = 0;
            }
            if (n2 > 0) {
                this.m_map_[n5 >>> 5] = n3 - n2;
                n5 += n2;
                for (n2 = 32 - n2; n2 > 0; --n2) {
                    this.m_data_[n3++] = this.m_data_[n5++];
                }
                continue;
            }
            if (n3 < n5) {
                this.m_map_[n5 >>> 5] = n3;
                for (n2 = 32; n2 > 0; --n2) {
                    this.m_data_[n3++] = this.m_data_[n5++];
                }
                continue;
            }
            this.m_map_[n5 >>> 5] = n5;
            n5 = n3 += 32;
        }
        for (n2 = 0; n2 < this.m_indexLength_; ++n2) {
            this.m_index_[n2] = this.m_map_[Math.abs(this.m_index_[n2]) >>> 5];
        }
        this.m_dataLength_ = n3;
    }

    private static final int findSameDataBlock(int[] nArray, int n2, int n3, int n4) {
        n2 -= 32;
        for (int i2 = 0; i2 <= n2; i2 += n4) {
            if (!IntTrieBuilder.equal_int(nArray, i2, n3, 32)) continue;
            return i2;
        }
        return -1;
    }

    private final void fold(TrieBuilder.DataManipulate dataManipulate) {
        int n2;
        int[] nArray = new int[32];
        int[] nArray2 = this.m_index_;
        System.arraycopy(nArray2, 1728, nArray, 0, 32);
        int n3 = 0;
        if (this.m_leadUnitValue_ != this.m_initialValue_) {
            n3 = this.allocDataBlock();
            if (n3 < 0) {
                throw new IllegalStateException("Internal error: Out of memory space");
            }
            this.fillBlock(n3, 0, 32, this.m_leadUnitValue_, true);
            n3 = -n3;
        }
        for (n2 = 1728; n2 < 1760; ++n2) {
            this.m_index_[n2] = n3;
        }
        n2 = 2048;
        int n4 = 65536;
        while (n4 < 0x110000) {
            if (nArray2[n4 >> 5] != 0) {
                int n5;
                if ((n5 = dataManipulate.getFoldedValue(n4 &= 0xFFFFFC00, (n3 = IntTrieBuilder.findSameIndexBlock(nArray2, n2, n4 >> 5)) + 32)) != this.getValue(UTF16.getLeadSurrogate(n4))) {
                    if (!this.setValue(UTF16.getLeadSurrogate(n4), n5)) {
                        throw new ArrayIndexOutOfBoundsException("Data table overflow");
                    }
                    if (n3 == n2) {
                        System.arraycopy(nArray2, n4 >> 5, nArray2, n2, 32);
                        n2 += 32;
                    }
                }
                n4 += 1024;
                continue;
            }
            n4 += 32;
        }
        if (n2 >= 34816) {
            throw new ArrayIndexOutOfBoundsException("Index table overflow");
        }
        System.arraycopy(nArray2, 2048, nArray2, 2080, n2 - 2048);
        System.arraycopy(nArray, 0, nArray2, 2048, 32);
        this.m_indexLength_ = n2 += 32;
    }

    private void fillBlock(int n2, int n3, int n4, int n5, boolean bl2) {
        n4 += n2;
        n2 += n3;
        if (bl2) {
            while (n2 < n4) {
                this.m_data_[n2++] = n5;
            }
        } else {
            while (n2 < n4) {
                if (this.m_data_[n2] == this.m_initialValue_) {
                    this.m_data_[n2] = n5;
                }
                ++n2;
            }
        }
    }
}

