/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;

public class IntTrie
extends Trie {
    private int m_initialValue_;
    private int[] m_data_;

    public IntTrie(ByteBuffer byteBuffer, Trie.DataManipulate dataManipulate) throws IOException {
        super(byteBuffer, dataManipulate);
        if (!this.isIntTrie()) {
            throw new IllegalArgumentException("Data given does not belong to a int trie.");
        }
    }

    public IntTrie(int n2, int n3, Trie.DataManipulate dataManipulate) {
        super(new char[2080], 512, dataManipulate);
        int n4;
        int n5 = 256;
        int n6 = 256;
        if (n3 != n2) {
            n6 += 32;
        }
        this.m_data_ = new int[n6];
        this.m_dataLength_ = n6;
        this.m_initialValue_ = n2;
        for (n4 = 0; n4 < n5; ++n4) {
            this.m_data_[n4] = n2;
        }
        if (n3 != n2) {
            char c2 = (char)(n5 >> 2);
            int n7 = 1760;
            for (n4 = 1728; n4 < n7; ++n4) {
                this.m_index_[n4] = c2;
            }
            n7 = n5 + 32;
            for (n4 = n5; n4 < n7; ++n4) {
                this.m_data_[n4] = n3;
            }
        }
    }

    public final int getCodePointValue(int n2) {
        if (0 <= n2 && n2 < 55296) {
            int n3 = (this.m_index_[n2 >> 5] << 2) + (n2 & 0x1F);
            return this.m_data_[n3];
        }
        int n4 = this.getCodePointOffset(n2);
        return n4 >= 0 ? this.m_data_[n4] : this.m_initialValue_;
    }

    public final int getLeadValue(char c2) {
        return this.m_data_[this.getLeadOffset(c2)];
    }

    public final int getBMPValue(char c2) {
        return this.m_data_[this.getBMPOffset(c2)];
    }

    public final int getSurrogateValue(char c2, char c3) {
        if (!UTF16.isLeadSurrogate(c2) || !UTF16.isTrailSurrogate(c3)) {
            throw new IllegalArgumentException("Argument characters do not form a supplementary character");
        }
        int n2 = this.getSurrogateOffset(c2, c3);
        if (n2 > 0) {
            return this.m_data_[n2];
        }
        return this.m_initialValue_;
    }

    public final int getTrailValue(int n2, char c2) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int n3 = this.m_dataManipulate_.getFoldingOffset(n2);
        if (n3 > 0) {
            return this.m_data_[this.getRawOffset(n3, (char)(c2 & 0x3FF))];
        }
        return this.m_initialValue_;
    }

    public final int getLatin1LinearValue(char c2) {
        return this.m_data_[32 + c2];
    }

    @Override
    public boolean equals(Object object) {
        boolean bl2 = super.equals(object);
        if (bl2 && object instanceof IntTrie) {
            IntTrie intTrie = (IntTrie)object;
            return this.m_initialValue_ == intTrie.m_initialValue_ && Arrays.equals(this.m_data_, intTrie.m_data_);
        }
        return false;
    }

    @Override
    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    protected final void unserialize(ByteBuffer byteBuffer) {
        super.unserialize(byteBuffer);
        this.m_data_ = ICUBinary.getInts(byteBuffer, this.m_dataLength_, 0);
        this.m_initialValue_ = this.m_data_[0];
    }

    @Override
    protected final int getSurrogateOffset(char c2, char c3) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int n2 = this.m_dataManipulate_.getFoldingOffset(this.getLeadValue(c2));
        if (n2 > 0) {
            return this.getRawOffset(n2, (char)(c3 & 0x3FF));
        }
        return -1;
    }

    @Override
    protected final int getValue(int n2) {
        return this.m_data_[n2];
    }

    @Override
    protected final int getInitialValue() {
        return this.m_initialValue_;
    }

    IntTrie(char[] cArray, int[] nArray, int n2, int n3, Trie.DataManipulate dataManipulate) {
        super(cArray, n3, dataManipulate);
        this.m_data_ = nArray;
        this.m_dataLength_ = this.m_data_.length;
        this.m_initialValue_ = n2;
    }
}

