/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.util.Locale;

public class Grego {
    public static final long MIN_MILLIS = -184303902528000000L;
    public static final long MAX_MILLIS = 183882168921600000L;
    public static final int MILLIS_PER_SECOND = 1000;
    public static final int MILLIS_PER_MINUTE = 60000;
    public static final int MILLIS_PER_HOUR = 3600000;
    public static final int MILLIS_PER_DAY = 86400000;
    private static final int JULIAN_1_CE = 1721426;
    private static final int JULIAN_1970_CE = 2440588;
    private static final int[] MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] DAYS_BEFORE = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};

    public static final boolean isLeapYear(int n2) {
        return (n2 & 3) == 0 && (n2 % 100 != 0 || n2 % 400 == 0);
    }

    public static final int monthLength(int n2, int n3) {
        return MONTH_LENGTH[n3 + (Grego.isLeapYear(n2) ? 12 : 0)];
    }

    public static final int previousMonthLength(int n2, int n3) {
        return n3 > 0 ? Grego.monthLength(n2, n3 - 1) : 31;
    }

    public static long fieldsToDay(int n2, int n3, int n4) {
        int n5 = n2 - 1;
        long l2 = (long)(365 * n5) + Grego.floorDivide(n5, 4L) + 1721423L + Grego.floorDivide(n5, 400L) - Grego.floorDivide(n5, 100L) + 2L + (long)DAYS_BEFORE[n3 + (Grego.isLeapYear(n2) ? 12 : 0)] + (long)n4;
        return l2 - 2440588L;
    }

    public static int dayOfWeek(long l2) {
        long[] lArray = new long[1];
        Grego.floorDivide(l2 + 5L, 7L, lArray);
        int n2 = (int)lArray[0];
        n2 = n2 == 0 ? 7 : n2;
        return n2;
    }

    public static int[] dayToFields(long l2, int[] nArray) {
        int n2;
        if (nArray == null || nArray.length < 5) {
            nArray = new int[5];
        }
        long[] lArray = new long[1];
        long l3 = Grego.floorDivide(l2 += 719162L, 146097L, lArray);
        long l4 = Grego.floorDivide(lArray[0], 36524L, lArray);
        long l5 = Grego.floorDivide(lArray[0], 1461L, lArray);
        long l6 = Grego.floorDivide(lArray[0], 365L, lArray);
        int n3 = (int)(400L * l3 + 100L * l4 + 4L * l5 + l6);
        int n4 = (int)lArray[0];
        if (l4 == 4L || l6 == 4L) {
            n4 = 365;
        } else {
            ++n3;
        }
        boolean bl2 = Grego.isLeapYear(n3);
        int n5 = 0;
        int n6 = n2 = bl2 ? 60 : 59;
        if (n4 >= n2) {
            n5 = bl2 ? 1 : 2;
        }
        int n7 = (12 * (n4 + n5) + 6) / 367;
        int n8 = n4 - DAYS_BEFORE[bl2 ? n7 + 12 : n7] + 1;
        int n9 = (int)((l2 + 2L) % 7L);
        if (n9 < 1) {
            n9 += 7;
        }
        nArray[0] = n3;
        nArray[1] = n7;
        nArray[2] = n8;
        nArray[3] = n9;
        nArray[4] = ++n4;
        return nArray;
    }

    public static int[] timeToFields(long l2, int[] nArray) {
        if (nArray == null || nArray.length < 6) {
            nArray = new int[6];
        }
        long[] lArray = new long[1];
        long l3 = Grego.floorDivide(l2, 86400000L, lArray);
        Grego.dayToFields(l3, nArray);
        nArray[5] = (int)lArray[0];
        return nArray;
    }

    public static long floorDivide(long l2, long l3) {
        return l2 >= 0L ? l2 / l3 : (l2 + 1L) / l3 - 1L;
    }

    private static long floorDivide(long l2, long l3, long[] lArray) {
        if (l2 >= 0L) {
            lArray[0] = l2 % l3;
            return l2 / l3;
        }
        long l4 = (l2 + 1L) / l3 - 1L;
        lArray[0] = l2 - l4 * l3;
        return l4;
    }

    public static int getDayOfWeekInMonth(int n2, int n3, int n4) {
        int n5 = (n4 + 6) / 7;
        if (n5 == 4) {
            if (n4 + 7 > Grego.monthLength(n2, n3)) {
                n5 = -1;
            }
        } else if (n5 == 5) {
            n5 = -1;
        }
        return n5;
    }

    public static String timeToString(long l2) {
        int[] nArray = Grego.timeToFields(l2, null);
        int n2 = nArray[5];
        int n3 = n2 / 3600000;
        int n4 = (n2 %= 3600000) / 60000;
        int n5 = (n2 %= 60000) / 1000;
        return String.format((Locale)null, "%04d-%02d-%02dT%02d:%02d:%02d.%03dZ", nArray[0], nArray[1] + 1, nArray[2], n3, n4, n5, n2 %= 1000);
    }
}

