/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BytesTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CharsTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CodePointMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CodePointTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;

public final class EmojiProps {
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();
    private static final int DATA_FORMAT = 1164799850;
    private static final int IX_CPTRIE_OFFSET = 0;
    private static final int IX_BASIC_EMOJI_TRIE_OFFSET = 4;
    private static final int IX_RGI_EMOJI_ZWJ_SEQUENCE_TRIE_OFFSET = 9;
    private static final int BIT_EMOJI = 0;
    private static final int BIT_EMOJI_PRESENTATION = 1;
    private static final int BIT_EMOJI_MODIFIER = 2;
    private static final int BIT_EMOJI_MODIFIER_BASE = 3;
    private static final int BIT_EMOJI_COMPONENT = 4;
    private static final int BIT_EXTENDED_PICTOGRAPHIC = 5;
    private static final int BIT_BASIC_EMOJI = 6;
    public static final EmojiProps INSTANCE = new EmojiProps();
    private CodePointTrie.Fast8 cpTrie = null;
    private String[] stringTries = new String[6];
    private static final byte[] bitFlags = new byte[]{0, 1, 2, 3, 4, -1, -1, 5, 6, -1, -1, -1, -1, -1, 6};

    private static int getStringTrieIndex(int n2) {
        return n2 - 4;
    }

    private EmojiProps() {
        ByteBuffer byteBuffer = ICUBinary.getRequiredData("uemoji.icu");
        try {
            int n2;
            ICUBinary.readHeaderAndDataVersion(byteBuffer, 1164799850, IS_ACCEPTABLE);
            int n3 = byteBuffer.position();
            int n4 = byteBuffer.getInt();
            int n5 = n4 / 4;
            if (n5 <= 9) {
                throw new ICUUncheckedIOException("Emoji properties data: not enough indexes");
            }
            int[] nArray = new int[n5];
            nArray[0] = n4;
            for (n2 = 1; n2 < n5; ++n2) {
                nArray[n2] = byteBuffer.getInt();
            }
            n2 = 0;
            int n6 = nArray[n2++];
            int n7 = nArray[n2];
            this.cpTrie = CodePointTrie.Fast8.fromBinary(byteBuffer);
            int n8 = byteBuffer.position() - n3;
            assert (n7 >= n8);
            ICUBinary.skipBytes(byteBuffer, n7 - n8);
            n6 = n7;
            n7 = nArray[4];
            ICUBinary.skipBytes(byteBuffer, n7 - n6);
            for (n2 = 4; n2 <= 9; ++n2) {
                n7 = nArray[n2 + 1];
                n6 = nArray[n2];
                if (n7 <= n6) continue;
                this.stringTries[EmojiProps.getStringTrieIndex((int)n2)] = ICUBinary.getString(byteBuffer, (n7 - n6) / 2, 0);
            }
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    public UnicodeSet addPropertyStarts(UnicodeSet unicodeSet) {
        CodePointMap.Range range = new CodePointMap.Range();
        int n2 = 0;
        while (this.cpTrie.getRange(n2, null, range)) {
            unicodeSet.add(n2);
            n2 = range.getEnd() + 1;
        }
        return unicodeSet;
    }

    public boolean hasBinaryProperty(int n2, int n3) {
        if (n3 < 57 || 71 < n3) {
            return false;
        }
        byte by2 = bitFlags[n3 - 57];
        if (by2 < 0) {
            return false;
        }
        int n4 = this.cpTrie.get(n2);
        return (n4 >> by2 & 1) != 0;
    }

    public boolean hasBinaryProperty(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        if (n3 == 0) {
            return false;
        }
        if (n2 < 65 || 71 < n2) {
            return false;
        }
        int n4 = n2;
        int n5 = n2;
        if (n2 == 71) {
            n4 = 65;
            n5 = 70;
        }
        for (int i2 = n4; i2 <= n5; ++i2) {
            CharsTrie charsTrie;
            BytesTrie.Result result;
            String string = this.stringTries[i2 - 65];
            if (string == null || !(result = (charsTrie = new CharsTrie(string, 0)).next(charSequence, 0, n3)).hasValue()) continue;
            return true;
        }
        return false;
    }

    public void addStrings(int n2, UnicodeSet unicodeSet) {
        if (n2 < 65 || 71 < n2) {
            return;
        }
        int n3 = n2;
        int n4 = n2;
        if (n2 == 71) {
            n3 = 65;
            n4 = 70;
        }
        for (int i2 = n3; i2 <= n4; ++i2) {
            String string = this.stringTries[i2 - 65];
            if (string == null) continue;
            CharsTrie charsTrie = new CharsTrie(string, 0);
            for (CharsTrie.Entry entry : charsTrie) {
                unicodeSet.add(entry.chars);
            }
        }
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return byArray[0] == 1;
        }
    }
}

