/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.OutputInt;

public final class BMPSet {
    public static int U16_SURROGATE_OFFSET = 56613888;
    private boolean[] latin1Contains;
    private int[] table7FF;
    private int[] bmpBlockBits;
    private int[] list4kStarts;
    private final int[] list;
    private final int listLength;

    public BMPSet(int[] nArray, int n2) {
        this.list = nArray;
        this.listLength = n2;
        this.latin1Contains = new boolean[256];
        this.table7FF = new int[64];
        this.bmpBlockBits = new int[64];
        this.list4kStarts = new int[18];
        this.list4kStarts[0] = this.findCodePoint(2048, 0, this.listLength - 1);
        for (int i2 = 1; i2 <= 16; ++i2) {
            this.list4kStarts[i2] = this.findCodePoint(i2 << 12, this.list4kStarts[i2 - 1], this.listLength - 1);
        }
        this.list4kStarts[17] = this.listLength - 1;
        this.initBits();
    }

    public BMPSet(BMPSet bMPSet, int[] nArray, int n2) {
        this.list = nArray;
        this.listLength = n2;
        this.latin1Contains = (boolean[])bMPSet.latin1Contains.clone();
        this.table7FF = (int[])bMPSet.table7FF.clone();
        this.bmpBlockBits = (int[])bMPSet.bmpBlockBits.clone();
        this.list4kStarts = (int[])bMPSet.list4kStarts.clone();
    }

    public boolean contains(int n2) {
        if (n2 <= 255) {
            return this.latin1Contains[n2];
        }
        if (n2 <= 2047) {
            return (this.table7FF[n2 & 0x3F] & 1 << (n2 >> 6)) != 0;
        }
        if (n2 < 55296 || n2 >= 57344 && n2 <= 65535) {
            int n3 = n2 >> 12;
            int n4 = this.bmpBlockBits[n2 >> 6 & 0x3F] >> n3 & 0x10001;
            if (n4 <= 1) {
                return 0 != n4;
            }
            return this.containsSlow(n2, this.list4kStarts[n3], this.list4kStarts[n3 + 1]);
        }
        if (n2 <= 0x10FFFF) {
            return this.containsSlow(n2, this.list4kStarts[13], this.list4kStarts[17]);
        }
        return false;
    }

    public final int span(CharSequence charSequence, int n2, UnicodeSet.SpanCondition spanCondition, OutputInt outputInt) {
        int n3;
        int n4;
        int n5 = charSequence.length();
        int n6 = 0;
        if (UnicodeSet.SpanCondition.NOT_CONTAINED != spanCondition) {
            for (n4 = n2; n4 < n5; ++n4) {
                char c2;
                char c3 = charSequence.charAt(n4);
                if (c3 <= '\u00ff') {
                    if (this.latin1Contains[c3]) continue;
                } else if (c3 <= '\u07ff') {
                    if ((this.table7FF[c3 & 0x3F] & 1 << (c3 >> 6)) != 0) continue;
                } else if (c3 < '\ud800' || c3 >= '\udc00' || n4 + 1 == n5 || (c2 = charSequence.charAt(n4 + 1)) < '\udc00' || c2 >= '\ue000') {
                    n3 = c3 >> 12;
                    int n7 = this.bmpBlockBits[c3 >> 6 & 0x3F] >> n3 & 0x10001;
                    if (!(n7 <= 1 ? n7 == 0 : !this.containsSlow(c3, this.list4kStarts[n3], this.list4kStarts[n3 + 1]))) continue;
                } else {
                    n3 = Character.toCodePoint(c3, c2);
                    if (this.containsSlow(n3, this.list4kStarts[16], this.list4kStarts[17])) {
                        ++n6;
                        ++n4;
                        continue;
                    }
                }
                break;
            }
        } else {
            while (n4 < n5) {
                char c4;
                char c5 = charSequence.charAt(n4);
                if (c5 <= '\u00ff') {
                    if (this.latin1Contains[c5]) {
                        break;
                    }
                } else if (c5 <= '\u07ff') {
                    if ((this.table7FF[c5 & 0x3F] & 1 << (c5 >> 6)) != 0) {
                        break;
                    }
                } else if (c5 < '\ud800' || c5 >= '\udc00' || n4 + 1 == n5 || (c4 = charSequence.charAt(n4 + 1)) < '\udc00' || c4 >= '\ue000') {
                    n3 = c5 >> 12;
                    int n8 = this.bmpBlockBits[c5 >> 6 & 0x3F] >> n3 & 0x10001;
                    if (n8 <= 1 ? n8 != 0 : this.containsSlow(c5, this.list4kStarts[n3], this.list4kStarts[n3 + 1])) {
                        break;
                    }
                } else {
                    n3 = Character.toCodePoint(c5, c4);
                    if (this.containsSlow(n3, this.list4kStarts[16], this.list4kStarts[17])) break;
                    ++n6;
                    ++n4;
                }
                ++n4;
            }
        }
        if (outputInt != null) {
            n3 = n4 - n2;
            outputInt.value = n3 - n6;
        }
        return n4;
    }

    public final int spanBack(CharSequence charSequence, int n2, UnicodeSet.SpanCondition spanCondition) {
        block10: {
            if (UnicodeSet.SpanCondition.NOT_CONTAINED != spanCondition) {
                do {
                    int n3;
                    char c2;
                    char c3;
                    if ((c3 = charSequence.charAt(--n2)) <= '\u00ff') {
                        if (this.latin1Contains[c3]) continue;
                        break block10;
                    }
                    if (c3 <= '\u07ff') {
                        if ((this.table7FF[c3 & 0x3F] & 1 << (c3 >> 6)) != 0) continue;
                        break block10;
                    }
                    if (c3 < '\ud800' || c3 < '\udc00' || 0 == n2 || (c2 = charSequence.charAt(n2 - 1)) < '\ud800' || c2 >= '\udc00') {
                        n3 = c3 >> 12;
                        int n4 = this.bmpBlockBits[c3 >> 6 & 0x3F] >> n3 & 0x10001;
                        if (!(n4 <= 1 ? n4 == 0 : !this.containsSlow(c3, this.list4kStarts[n3], this.list4kStarts[n3 + 1]))) continue;
                        break block10;
                    }
                    n3 = Character.toCodePoint(c2, c3);
                    if (!this.containsSlow(n3, this.list4kStarts[16], this.list4kStarts[17])) break block10;
                    --n2;
                } while (0 != n2);
                return 0;
            }
            do {
                int n5;
                char c4;
                char c5;
                if ((c5 = charSequence.charAt(--n2)) <= '\u00ff') {
                    if (!this.latin1Contains[c5]) continue;
                    break block10;
                }
                if (c5 <= '\u07ff') {
                    if ((this.table7FF[c5 & 0x3F] & 1 << (c5 >> 6)) == 0) continue;
                    break block10;
                }
                if (c5 < '\ud800' || c5 < '\udc00' || 0 == n2 || (c4 = charSequence.charAt(n2 - 1)) < '\ud800' || c4 >= '\udc00') {
                    n5 = c5 >> 12;
                    int n6 = this.bmpBlockBits[c5 >> 6 & 0x3F] >> n5 & 0x10001;
                    if (!(n6 <= 1 ? n6 != 0 : this.containsSlow(c5, this.list4kStarts[n5], this.list4kStarts[n5 + 1]))) continue;
                    break block10;
                }
                n5 = Character.toCodePoint(c4, c5);
                if (this.containsSlow(n5, this.list4kStarts[16], this.list4kStarts[17])) break block10;
                --n2;
            } while (0 != n2);
            return 0;
        }
        return n2 + 1;
    }

    private static void set32x64Bits(int[] nArray, int n2, int n3) {
        assert (64 == nArray.length);
        int n4 = n2 >> 6;
        int n5 = n2 & 0x3F;
        int n6 = 1 << n4;
        if (n2 + 1 == n3) {
            int n7 = n5;
            nArray[n7] = nArray[n7] | n6;
            return;
        }
        int n8 = n3 >> 6;
        int n9 = n3 & 0x3F;
        if (n4 == n8) {
            while (n5 < n9) {
                int n10 = n5++;
                nArray[n10] = nArray[n10] | n6;
            }
        } else {
            if (n5 > 0) {
                do {
                    int n11 = n5++;
                    nArray[n11] = nArray[n11] | n6;
                } while (n5 < 64);
                ++n4;
            }
            if (n4 < n8) {
                n6 = ~((1 << n4) - 1);
                if (n8 < 32) {
                    n6 &= (1 << n8) - 1;
                }
                n5 = 0;
                while (n5 < 64) {
                    int n12 = n5++;
                    nArray[n12] = nArray[n12] | n6;
                }
            }
            n6 = 1 << n8;
            n5 = 0;
            while (n5 < n9) {
                int n13 = n5++;
                nArray[n13] = nArray[n13] | n6;
            }
        }
    }

    private void initBits() {
        int n2;
        int n3;
        int n4 = 0;
        do {
            n2 = this.list[n4++];
            n3 = n4 < this.listLength ? this.list[n4++] : 0x110000;
            if (n2 >= 256) break;
            do {
                this.latin1Contains[n2++] = true;
            } while (n2 < n3 && n2 < 256);
        } while (n3 <= 256);
        while (n2 < 2048) {
            BMPSet.set32x64Bits(this.table7FF, n2, n3 <= 2048 ? n3 : 2048);
            if (n3 > 2048) {
                n2 = 2048;
                break;
            }
            n2 = this.list[n4++];
            if (n4 < this.listLength) {
                n3 = this.list[n4++];
                continue;
            }
            n3 = 0x110000;
        }
        int n5 = 2048;
        while (n2 < 65536) {
            if (n3 > 65536) {
                n3 = 65536;
            }
            if (n2 < n5) {
                n2 = n5;
            }
            if (n2 < n3) {
                if (0 != (n2 & 0x3F)) {
                    int n6 = (n2 >>= 6) & 0x3F;
                    this.bmpBlockBits[n6] = this.bmpBlockBits[n6] | 65537 << (n2 >> 6);
                    n5 = n2 = n2 + 1 << 6;
                }
                if (n2 < n3) {
                    if (n2 < (n3 & 0xFFFFFFC0)) {
                        BMPSet.set32x64Bits(this.bmpBlockBits, n2 >> 6, n3 >> 6);
                    }
                    if (0 != (n3 & 0x3F)) {
                        int n7 = (n3 >>= 6) & 0x3F;
                        this.bmpBlockBits[n7] = this.bmpBlockBits[n7] | 65537 << (n3 >> 6);
                        n5 = n3 = n3 + 1 << 6;
                    }
                }
            }
            if (n3 == 65536) break;
            n2 = this.list[n4++];
            if (n4 < this.listLength) {
                n3 = this.list[n4++];
                continue;
            }
            n3 = 0x110000;
        }
    }

    private int findCodePoint(int n2, int n3, int n4) {
        int n5;
        if (n2 < this.list[n3]) {
            return n3;
        }
        if (n3 >= n4 || n2 >= this.list[n4 - 1]) {
            return n4;
        }
        while ((n5 = n3 + n4 >>> 1) != n3) {
            if (n2 < this.list[n5]) {
                n4 = n5;
                continue;
            }
            n3 = n5;
        }
        return n4;
    }

    private final boolean containsSlow(int n2, int n3, int n4) {
        return 0 != (this.findCodePoint(n2, n3, n4) & 1);
    }
}

