/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.io.IOException;
import java.nio.ByteBuffer;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.UConverterAliasDataReader;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;

final class UConverterAlias {
    static final int UNNORMALIZED = 0;
    static final int STD_NORMALIZED = 1;
    static final int AMBIGUOUS_ALIAS_MAP_BIT = 32768;
    static final int CONTAINS_OPTION_BIT = 16384;
    static final int CONVERTER_INDEX_MASK = 4095;
    static final int NUM_RESERVED_TAGS = 2;
    static final int NUM_HIDDEN_TAGS = 1;
    static char[] gConverterList = null;
    static char[] gTagList = null;
    static char[] gAliasList = null;
    static char[] gUntaggedConvArray = null;
    static char[] gTaggedAliasArray = null;
    static char[] gTaggedAliasLists = null;
    static char[] gOptionTable = null;
    static byte[] gStringTable = null;
    static byte[] gNormalizedStringTable = null;
    static final int tocLengthIndex = 0;
    private static final int converterListIndex = 1;
    private static final int tagListIndex = 2;
    private static final int aliasListIndex = 3;
    private static final int untaggedConvArrayIndex = 4;
    private static final int taggedAliasArrayIndex = 5;
    private static final int taggedAliasListsIndex = 6;
    private static final int optionTableIndex = 7;
    private static final int stringTableIndex = 8;
    private static final int normalizedStringTableIndex = 9;
    private static final int minTocLength = 9;
    private static final int offsetsCount = 10;
    static ByteBuffer gAliasData = null;
    private static final String CNVALIAS_DATA_FILE_NAME = "cnvalias.icu";
    private static final byte IGNORE = 0;
    private static final byte ZERO = 1;
    private static final byte NONZERO = 2;
    static final byte MINLETTER = 3;
    static final byte[] asciiTypes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 0, 0, 0, 0, 0, 0, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 0, 0, 0, 0, 0};
    static String[] gAvailableConverters = null;
    static int gAvailableConverterCount = 0;
    static String gDefaultConverterName = null;

    UConverterAlias() {
    }

    private static final String GET_STRING(int n2) {
        return UConverterAlias.extractString(gStringTable, 2 * n2);
    }

    private static final String GET_NORMALIZED_STRING(int n2) {
        return UConverterAlias.extractString(gNormalizedStringTable, 2 * n2);
    }

    private static final String extractString(byte[] byArray, int n2) {
        char[] cArray = new char[UConverterAlias.strlen(byArray, n2)];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = (char)(byArray[n2 + i2] & 0xFF);
        }
        return new String(cArray);
    }

    private static final int strlen(byte[] byArray, int n2) {
        int n3 = n2;
        while (n3 < byArray.length && byArray[n3++] != 0) {
        }
        return n3 - n2 - 1;
    }

    private static final boolean isAlias(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Alias param is null!");
        }
        return string.length() != 0;
    }

    private static final synchronized boolean haveAliasData() throws IOException {
        boolean bl2;
        boolean bl3 = bl2 = gAliasData == null;
        if (bl2) {
            ByteBuffer byteBuffer = null;
            int[] nArray = null;
            ByteBuffer byteBuffer2 = ICUBinary.getRequiredData(CNVALIAS_DATA_FILE_NAME);
            UConverterAliasDataReader uConverterAliasDataReader = new UConverterAliasDataReader(byteBuffer2);
            nArray = uConverterAliasDataReader.readToc(10);
            int n2 = nArray[0];
            if (n2 < 9) {
                throw new IOException("Invalid data format.");
            }
            gConverterList = ICUBinary.getChars(byteBuffer2, nArray[1], 0);
            gTagList = ICUBinary.getChars(byteBuffer2, nArray[2], 0);
            gAliasList = ICUBinary.getChars(byteBuffer2, nArray[3], 0);
            gUntaggedConvArray = ICUBinary.getChars(byteBuffer2, nArray[4], 0);
            gTaggedAliasArray = ICUBinary.getChars(byteBuffer2, nArray[5], 0);
            gTaggedAliasLists = ICUBinary.getChars(byteBuffer2, nArray[6], 0);
            gOptionTable = ICUBinary.getChars(byteBuffer2, nArray[7], 0);
            gStringTable = new byte[nArray[8] * 2];
            byteBuffer2.get(gStringTable);
            gNormalizedStringTable = new byte[nArray[9] * 2];
            byteBuffer2.get(gNormalizedStringTable);
            byteBuffer = ByteBuffer.allocate(0);
            if (gOptionTable[0] != '\u0001') {
                throw new IOException("Unsupported alias normalization");
            }
            if (gAliasData == null) {
                gAliasData = byteBuffer;
                byteBuffer = null;
            }
        }
        return true;
    }

    private static final int findConverter(String string, boolean[] blArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        UConverterAlias.stripForCompare(stringBuilder, string);
        string = stringBuilder.toString();
        int n3 = 0;
        int n4 = n2 = gUntaggedConvArray.length;
        int n5 = Integer.MAX_VALUE;
        while (n5 != (n4 = (n3 + n2) / 2)) {
            n5 = n4;
            String string2 = UConverterAlias.GET_NORMALIZED_STRING(gAliasList[n4]);
            int n6 = string.compareTo(string2);
            if (n6 < 0) {
                n2 = n4;
                continue;
            }
            if (n6 > 0) {
                n3 = n4;
                continue;
            }
            if ((gUntaggedConvArray[n4] & 0x8000) != 0) {
                blArray[0] = true;
            }
            return gUntaggedConvArray[n4] & 0xFFF;
        }
        return Integer.MAX_VALUE;
    }

    public static final StringBuilder stripForCompare(StringBuilder stringBuilder, String string) {
        return UConverterAlias.io_stripASCIIForCompare(stringBuilder, string);
    }

    private static final char GET_CHAR_TYPE(char c2) {
        return (char)(c2 < asciiTypes.length ? asciiTypes[c2] : (byte)0);
    }

    private static final StringBuilder io_stripASCIIForCompare(StringBuilder stringBuilder, String string) {
        int n2 = 0;
        boolean bl2 = false;
        block5: while (n2 < string.length()) {
            char c2 = string.charAt(n2++);
            char c3 = UConverterAlias.GET_CHAR_TYPE(c2);
            switch (c3) {
                case '\u0000': {
                    bl2 = false;
                    continue block5;
                }
                case '\u0001': {
                    char c4;
                    if (bl2 || n2 >= string.length() || (c4 = UConverterAlias.GET_CHAR_TYPE(string.charAt(n2))) != '\u0001' && c4 != '\u0002') break;
                    continue block5;
                }
                case '\u0002': {
                    bl2 = true;
                    break;
                }
                default: {
                    c2 = c3;
                    bl2 = false;
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder;
    }

    static int compareNames(String string, String string2) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        char c2 = '\u0000';
        char c3 = '\u0000';
        boolean bl2 = false;
        boolean bl3 = false;
        block10: while (true) {
            char c4;
            char c5;
            if (n3 < string.length()) {
                c2 = string.charAt(n3++);
                c5 = UConverterAlias.GET_CHAR_TYPE(c2);
                switch (c5) {
                    case '\u0000': {
                        bl2 = false;
                        continue block10;
                    }
                    case '\u0001': {
                        if (bl2 || n3 >= string.length() || (c4 = UConverterAlias.GET_CHAR_TYPE(string.charAt(n3))) != '\u0001' && c4 != '\u0002') break;
                        continue block10;
                    }
                    case '\u0002': {
                        bl2 = true;
                        break;
                    }
                    default: {
                        c2 = c5;
                        bl2 = false;
                        break;
                    }
                }
            }
            block11: while (n4 < string2.length()) {
                c3 = string2.charAt(n4++);
                c5 = UConverterAlias.GET_CHAR_TYPE(c3);
                switch (c5) {
                    case '\u0000': {
                        bl3 = false;
                        continue block11;
                    }
                    case '\u0001': {
                        if (bl3 || n3 >= string.length() || (c4 = UConverterAlias.GET_CHAR_TYPE(string2.charAt(n4))) != '\u0001' && c4 != '\u0002') break block11;
                        continue block11;
                    }
                    case '\u0002': {
                        bl3 = true;
                        break block11;
                    }
                    default: {
                        c3 = c5;
                        bl3 = false;
                        break block11;
                    }
                }
            }
            if (n3 >= string.length() && n4 >= string2.length()) {
                return 0;
            }
            n2 = c2 - c3;
            if (n2 != 0) break;
        }
        return n2;
    }

    static int io_countAliases(String string) throws IOException {
        char c2;
        boolean[] blArray;
        int n2;
        if (UConverterAlias.haveAliasData() && UConverterAlias.isAlias(string) && (n2 = UConverterAlias.findConverter(string, blArray = new boolean[1])) < gConverterList.length && (c2 = gTaggedAliasArray[(gTagList.length - 1) * gConverterList.length + n2]) != '\u0000') {
            return gTaggedAliasLists[c2];
        }
        return 0;
    }

    static String io_getAlias(String string, int n2) throws IOException {
        char c2;
        boolean[] blArray;
        int n3;
        if (UConverterAlias.haveAliasData() && UConverterAlias.isAlias(string) && (n3 = UConverterAlias.findConverter(string, blArray = new boolean[1])) < gConverterList.length && (c2 = gTaggedAliasArray[(gTagList.length - 1) * gConverterList.length + n3]) != '\u0000') {
            int n4 = c2 + '\u0001';
            return UConverterAlias.GET_STRING(gTaggedAliasLists[n4 + n2]);
        }
        return null;
    }

    static final String getStandardName(String string, String string2) throws IOException {
        int n2;
        if (UConverterAlias.haveAliasData() && UConverterAlias.isAlias(string) && 0 < (n2 = UConverterAlias.findTaggedAliasListsOffset(string, string2)) && n2 < gTaggedAliasLists.length) {
            int n3 = n2 + 1;
            if (gTaggedAliasLists[0] != '\u0000') {
                return UConverterAlias.GET_STRING(gTaggedAliasLists[n3]);
            }
        }
        return null;
    }

    static int countAliases(String string) throws IOException {
        return UConverterAlias.io_countAliases(string);
    }

    static String getAlias(String string, int n2) throws IOException {
        return UConverterAlias.io_getAlias(string, n2);
    }

    static String getAvailableName(int n2) {
        try {
            if (0 <= n2 && n2 <= 65535) {
                String string = UConverterAlias.bld_getAvailableConverter(n2);
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static String getCanonicalName(String string, String string2) throws IOException {
        int n2;
        if (UConverterAlias.haveAliasData() && UConverterAlias.isAlias(string) && (n2 = UConverterAlias.findTaggedConverterNum(string, string2)) < gConverterList.length) {
            return UConverterAlias.GET_STRING(gConverterList[n2]);
        }
        return null;
    }

    static int countAvailable() {
        try {
            return UConverterAlias.bld_countAvailableConverters();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    private static int getTagNumber(String string) {
        if (gTagList != null) {
            for (int i2 = 0; i2 < gTagList.length; ++i2) {
                if (!string.equals(UConverterAlias.GET_STRING(gTagList[i2]))) continue;
                return i2;
            }
        }
        return Integer.MAX_VALUE;
    }

    private static int findTaggedAliasListsOffset(String string, String string2) {
        int n2 = UConverterAlias.getTagNumber(string2);
        boolean[] blArray = new boolean[1];
        int n3 = UConverterAlias.findConverter(string, blArray);
        if (n2 < gTagList.length - 1 && n3 < gConverterList.length) {
            char c2 = gTaggedAliasArray[n2 * gConverterList.length + n3];
            if (c2 != '\u0000' && gTaggedAliasLists[c2 + '\u0001'] != '\u0000') {
                return c2;
            }
            if (blArray[0]) {
                for (int i2 = 0; i2 < gTaggedAliasArray.length; ++i2) {
                    int n4;
                    int n5;
                    char c3;
                    c2 = gTaggedAliasArray[i2];
                    if (c2 == '\u0000' || !UConverterAlias.isAliasInList(string, c2) || (c3 = gTaggedAliasArray[n2 * gConverterList.length + (n5 = i2 - (n4 = i2 / gConverterList.length) * gConverterList.length)]) == '\u0000' || gTaggedAliasLists[c3 + '\u0001'] == '\u0000') continue;
                    return c3;
                }
            }
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    private static int findTaggedConverterNum(String string, String string2) {
        int n2 = UConverterAlias.getTagNumber(string2);
        boolean[] blArray = new boolean[1];
        int n3 = UConverterAlias.findConverter(string, blArray);
        if (n2 < gTagList.length - 1 && n3 < gConverterList.length) {
            char c2 = gTaggedAliasArray[n2 * gConverterList.length + n3];
            if (c2 != '\u0000' && UConverterAlias.isAliasInList(string, c2)) {
                return n3;
            }
            if (blArray[0]) {
                int n4 = n2 * gConverterList.length;
                int n5 = (n2 + 1) * gConverterList.length;
                for (int i2 = n4; i2 < n5; ++i2) {
                    c2 = gTaggedAliasArray[i2];
                    if (c2 == '\u0000' || !UConverterAlias.isAliasInList(string, c2)) continue;
                    return i2 - n4;
                }
            }
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isAliasInList(String string, int n2) {
        if (n2 != 0) {
            int n3 = gTaggedAliasLists[n2];
            int n4 = n2 + 1;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (gTaggedAliasLists[i2 + n4] == '\u0000' || UConverterAlias.compareNames(string, UConverterAlias.GET_STRING(gTaggedAliasLists[i2 + n4])) != 0) continue;
                return true;
            }
        }
        return false;
    }

    static boolean haveAvailableConverterList() throws IOException {
        if (gAvailableConverters == null) {
            if (!UConverterAlias.haveAliasData()) {
                return false;
            }
            String[] stringArray = new String[gConverterList.length];
            int n2 = 0;
            for (int i2 = 0; i2 < gConverterList.length; ++i2) {
                String string = UConverterAlias.GET_STRING(gConverterList[i2]);
                stringArray[n2++] = string;
            }
            if (gAvailableConverters == null) {
                gAvailableConverters = stringArray;
                gAvailableConverterCount = n2;
            }
        }
        return true;
    }

    static int bld_countAvailableConverters() throws IOException {
        if (UConverterAlias.haveAvailableConverterList()) {
            return gAvailableConverterCount;
        }
        return 0;
    }

    static String bld_getAvailableConverter(int n2) throws IOException {
        if (UConverterAlias.haveAvailableConverterList() && n2 < gAvailableConverterCount) {
            return gAvailableConverters[n2];
        }
        return null;
    }
}

