/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetCESU8;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetDecoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetEncoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.UTF8;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class CharsetUTF8
extends CharsetICU {
    private static final byte[] fromUSubstitution = new byte[]{-17, -65, -67};
    private static final int[] BITMASK_FROM_UTF8 = new int[]{-1, 127, 31, 15, 7};
    private final boolean isCESU8 = this instanceof CharsetCESU8;

    public CharsetUTF8(String string, String string2, String[] stringArray) {
        super(string, string2, stringArray);
        this.maxBytesPerChar = 3;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
    }

    private static final byte encodeHeadOf1(int n2) {
        return (byte)n2;
    }

    private static final byte encodeHeadOf2(int n2) {
        return (byte)(0xC0 | n2 >>> 6);
    }

    private static final byte encodeHeadOf3(int n2) {
        return (byte)(0xE0 | n2 >>> 12);
    }

    private static final byte encodeHeadOf4(int n2) {
        return (byte)(0xF0 | n2 >>> 18);
    }

    private static final byte encodeThirdToLastTail(int n2) {
        return (byte)(0x80 | n2 >>> 12 & 0x3F);
    }

    private static final byte encodeSecondToLastTail(int n2) {
        return (byte)(0x80 | n2 >>> 6 & 0x3F);
    }

    private static final byte encodeLastTail(int n2) {
        return (byte)(0x80 | n2 & 0x3F);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderUTF8(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderUTF8(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet unicodeSet, int n2) {
        CharsetUTF8.getNonSurrogateUnicodeSet(unicodeSet);
    }

    class CharsetEncoderUTF8
    extends CharsetEncoderICU {
        private int sourceIndex;
        private int targetIndex;

        public CharsetEncoderUTF8(CharsetICU charsetICU) {
            super(charsetICU, fromUSubstitution);
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            CoderResult coderResult;
            if (!charBuffer.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!byteBuffer.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                CoderResult coderResult2;
                char[] cArray = charBuffer.array();
                int n2 = charBuffer.arrayOffset() + charBuffer.position();
                int n3 = charBuffer.arrayOffset() + charBuffer.limit();
                byte[] byArray = byteBuffer.array();
                int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                int n5 = byteBuffer.arrayOffset() + byteBuffer.limit();
                if (this.fromUChar32 != 0) {
                    this.sourceIndex = n2;
                    this.targetIndex = n4;
                    coderResult2 = this.encodeFourBytes(cArray, byArray, n3, n5, this.fromUChar32);
                    n2 = this.sourceIndex;
                    n4 = this.targetIndex;
                    if (coderResult2 != null) {
                        charBuffer.position(n2 - charBuffer.arrayOffset());
                        byteBuffer.position(n4 - byteBuffer.arrayOffset());
                        return coderResult2;
                    }
                }
                while (true) {
                    char c2;
                    if (n2 >= n3) {
                        coderResult2 = CoderResult.UNDERFLOW;
                        break;
                    }
                    if (n4 >= n5) {
                        coderResult2 = CoderResult.OVERFLOW;
                        break;
                    }
                    if ((c2 = cArray[n2++]) <= '\u007f') {
                        byArray[n4++] = CharsetUTF8.encodeHeadOf1(c2);
                        continue;
                    }
                    if (c2 <= '\u07ff') {
                        byArray[n4++] = CharsetUTF8.encodeHeadOf2(c2);
                        if (n4 >= n5) {
                            this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(c2);
                            coderResult2 = CoderResult.OVERFLOW;
                            break;
                        }
                        byArray[n4++] = CharsetUTF8.encodeLastTail(c2);
                        continue;
                    }
                    if (!UTF16.isSurrogate(c2) || CharsetUTF8.this.isCESU8) {
                        byArray[n4++] = CharsetUTF8.encodeHeadOf3(c2);
                        if (n4 >= n5) {
                            this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(c2);
                            this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(c2);
                            coderResult2 = CoderResult.OVERFLOW;
                            break;
                        }
                        byArray[n4++] = CharsetUTF8.encodeSecondToLastTail(c2);
                        if (n4 >= n5) {
                            this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(c2);
                            coderResult2 = CoderResult.OVERFLOW;
                            break;
                        }
                        byArray[n4++] = CharsetUTF8.encodeLastTail(c2);
                        continue;
                    }
                    this.sourceIndex = n2;
                    this.targetIndex = n4;
                    coderResult2 = this.encodeFourBytes(cArray, byArray, n3, n5, c2);
                    n2 = this.sourceIndex;
                    n4 = this.targetIndex;
                    if (coderResult2 != null) break;
                }
                charBuffer.position(n2 - charBuffer.arrayOffset());
                byteBuffer.position(n4 - byteBuffer.arrayOffset());
                return coderResult2;
            }
            if (this.fromUChar32 != 0 && (coderResult = this.encodeFourBytes(charBuffer, byteBuffer, this.fromUChar32)) != null) {
                return coderResult;
            }
            while (charBuffer.hasRemaining()) {
                if (!byteBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char c3 = charBuffer.get();
                if (c3 <= '\u007f') {
                    byteBuffer.put(CharsetUTF8.encodeHeadOf1(c3));
                    continue;
                }
                if (c3 <= '\u07ff') {
                    byteBuffer.put(CharsetUTF8.encodeHeadOf2(c3));
                    if (!byteBuffer.hasRemaining()) {
                        this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(c3);
                        return CoderResult.OVERFLOW;
                    }
                    byteBuffer.put(CharsetUTF8.encodeLastTail(c3));
                    continue;
                }
                if (!UTF16.isSurrogate(c3) || CharsetUTF8.this.isCESU8) {
                    byteBuffer.put(CharsetUTF8.encodeHeadOf3(c3));
                    if (!byteBuffer.hasRemaining()) {
                        this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(c3);
                        this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(c3);
                        return CoderResult.OVERFLOW;
                    }
                    byteBuffer.put(CharsetUTF8.encodeSecondToLastTail(c3));
                    if (!byteBuffer.hasRemaining()) {
                        this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(c3);
                        return CoderResult.OVERFLOW;
                    }
                    byteBuffer.put(CharsetUTF8.encodeLastTail(c3));
                    continue;
                }
                coderResult = this.encodeFourBytes(charBuffer, byteBuffer, c3);
                if (coderResult != null) return coderResult;
            }
            return CoderResult.UNDERFLOW;
        }

        private final CoderResult encodeFourBytes(char[] cArray, byte[] byArray, int n2, int n3, int n4) {
            CoderResult coderResult = this.handleSurrogates(cArray, this.sourceIndex, n2, (char)n4);
            if (coderResult != null) {
                return coderResult;
            }
            ++this.sourceIndex;
            n4 = this.fromUChar32;
            this.fromUChar32 = 0;
            byArray[this.targetIndex++] = CharsetUTF8.encodeHeadOf4(n4);
            if (this.targetIndex >= n3) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeThirdToLastTail(n4);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(n4);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(n4);
                return CoderResult.OVERFLOW;
            }
            byArray[this.targetIndex++] = CharsetUTF8.encodeThirdToLastTail(n4);
            if (this.targetIndex >= n3) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(n4);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(n4);
                return CoderResult.OVERFLOW;
            }
            byArray[this.targetIndex++] = CharsetUTF8.encodeSecondToLastTail(n4);
            if (this.targetIndex >= n3) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(n4);
                return CoderResult.OVERFLOW;
            }
            byArray[this.targetIndex++] = CharsetUTF8.encodeLastTail(n4);
            return null;
        }

        private final CoderResult encodeFourBytes(CharBuffer charBuffer, ByteBuffer byteBuffer, int n2) {
            CoderResult coderResult = this.handleSurrogates(charBuffer, (char)n2);
            if (coderResult != null) {
                return coderResult;
            }
            n2 = this.fromUChar32;
            this.fromUChar32 = 0;
            byteBuffer.put(CharsetUTF8.encodeHeadOf4(n2));
            if (!byteBuffer.hasRemaining()) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeThirdToLastTail(n2);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(n2);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(n2);
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put(CharsetUTF8.encodeThirdToLastTail(n2));
            if (!byteBuffer.hasRemaining()) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeSecondToLastTail(n2);
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(n2);
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put(CharsetUTF8.encodeSecondToLastTail(n2));
            if (!byteBuffer.hasRemaining()) {
                this.errorBuffer[this.errorBufferLength++] = CharsetUTF8.encodeLastTail(n2);
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put(CharsetUTF8.encodeLastTail(n2));
            return null;
        }
    }

    class CharsetDecoderUTF8
    extends CharsetDecoderICU {
        public CharsetDecoderUTF8(CharsetICU charsetICU) {
            super(charsetICU);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            CoderResult coderResult;
            int n2;
            int n3;
            block32: {
                int n4;
                int n5;
                int n6;
                byte by2;
                if (!byteBuffer.hasRemaining()) {
                    return CoderResult.UNDERFLOW;
                }
                if (!charBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                    CoderResult coderResult2;
                    int n7;
                    int n8;
                    block31: {
                        int n9;
                        int n10;
                        int n11;
                        byte by3;
                        byte[] byArray = byteBuffer.array();
                        n8 = byteBuffer.arrayOffset() + byteBuffer.position();
                        int n12 = byteBuffer.arrayOffset() + byteBuffer.limit();
                        char[] cArray = charBuffer.array();
                        n7 = charBuffer.arrayOffset() + charBuffer.position();
                        int n13 = charBuffer.arrayOffset() + charBuffer.limit();
                        if (this.mode == 0) {
                            this.toUBytesArray[0] = by3 = byArray[n8++];
                            n11 = UTF8.countBytes(by3);
                            n10 = by3 & BITMASK_FROM_UTF8[n11];
                            n9 = 1;
                        } else {
                            n10 = this.toUnicodeStatus;
                            n11 = this.mode;
                            n9 = this.toULength;
                            this.toUnicodeStatus = 0;
                            this.mode = 0;
                            this.toULength = 0;
                        }
                        while (true) {
                            if (n9 < n11) {
                                if (n8 >= n12) {
                                    this.toUnicodeStatus = n10;
                                    this.mode = n11;
                                    this.toULength = n9;
                                    coderResult2 = CoderResult.UNDERFLOW;
                                    break block31;
                                }
                                this.toUBytesArray[n9] = by3 = byArray[n8++];
                                if (!(UTF8.isValidTrail(n10, by3, n9, n11) || CharsetUTF8.this.isCESU8 && n9 == 1 && n10 == 13 && UTF8.isTrail(by3))) {
                                    --n8;
                                    this.toULength = n9;
                                    coderResult2 = CoderResult.malformedForLength(n9);
                                    break block31;
                                }
                                n10 = n10 << 6 | by3 & 0x3F;
                                ++n9;
                                continue;
                            }
                            if (n9 != n11 || CharsetUTF8.this.isCESU8 && n9 > 3) break;
                            if (n10 <= 65535) {
                                cArray[n7++] = (char)n10;
                            } else {
                                cArray[n7++] = (char)(((n10 -= 65536) >>> 10) + 55296);
                                if (n7 >= n13) {
                                    this.charErrorBufferArray[this.charErrorBufferLength++] = (char)((n10 & 0x3FF) + 56320);
                                    coderResult2 = CoderResult.OVERFLOW;
                                    break block31;
                                }
                                cArray[n7++] = (char)((n10 & 0x3FF) + 56320);
                            }
                            if (n8 >= n12) {
                                coderResult2 = CoderResult.UNDERFLOW;
                                break block31;
                            }
                            if (n7 >= n13) {
                                coderResult2 = CoderResult.OVERFLOW;
                                break block31;
                            }
                            while (UTF8.isSingle(by3 = byArray[n8++])) {
                                cArray[n7++] = (char)by3;
                                if (n8 >= n12) {
                                    coderResult2 = CoderResult.UNDERFLOW;
                                } else {
                                    if (n7 < n13) continue;
                                    coderResult2 = CoderResult.OVERFLOW;
                                }
                                break block31;
                            }
                            this.toUBytesArray[0] = by3;
                            n11 = UTF8.countBytes(by3);
                            n10 = by3 & BITMASK_FROM_UTF8[n11];
                            n9 = 1;
                        }
                        this.toULength = n9;
                        coderResult2 = CoderResult.malformedForLength(n9);
                    }
                    byteBuffer.position(n8 - byteBuffer.arrayOffset());
                    charBuffer.position(n7 - charBuffer.arrayOffset());
                    return coderResult2;
                }
                n3 = byteBuffer.position();
                int n14 = byteBuffer.limit();
                n2 = charBuffer.position();
                int n15 = charBuffer.limit();
                if (this.mode == 0) {
                    this.toUBytesArray[0] = by2 = byteBuffer.get(n3++);
                    n6 = UTF8.countBytes(by2);
                    n5 = by2 & BITMASK_FROM_UTF8[n6];
                    n4 = 1;
                } else {
                    n5 = this.toUnicodeStatus;
                    n6 = this.mode;
                    n4 = this.toULength;
                    this.toUnicodeStatus = 0;
                    this.mode = 0;
                    this.toULength = 0;
                }
                while (true) {
                    if (n4 < n6) {
                        if (n3 >= n14) {
                            this.toUnicodeStatus = n5;
                            this.mode = n6;
                            this.toULength = n4;
                            coderResult = CoderResult.UNDERFLOW;
                            break block32;
                        }
                        this.toUBytesArray[n4] = by2 = byteBuffer.get(n3++);
                        if (!(UTF8.isValidTrail(n5, by2, n4, n6) || CharsetUTF8.this.isCESU8 && n4 == 1 && n5 == 13 && UTF8.isTrail(by2))) {
                            --n3;
                            this.toULength = n4;
                            coderResult = CoderResult.malformedForLength(n4);
                            break block32;
                        }
                        n5 = n5 << 6 | by2 & 0x3F;
                        ++n4;
                        continue;
                    }
                    if (n4 != n6 || CharsetUTF8.this.isCESU8 && n4 > 3) break;
                    if (n5 <= 65535) {
                        charBuffer.put(n2++, (char)n5);
                    } else {
                        charBuffer.put(n2++, (char)(((n5 -= 65536) >>> 10) + 55296));
                        if (n2 >= n15) {
                            this.charErrorBufferArray[this.charErrorBufferLength++] = (char)((n5 & 0x3FF) + 56320);
                            coderResult = CoderResult.OVERFLOW;
                            break block32;
                        }
                        charBuffer.put(n2++, (char)((n5 & 0x3FF) + 56320));
                    }
                    if (n3 >= n14) {
                        coderResult = CoderResult.UNDERFLOW;
                        break block32;
                    }
                    if (n2 >= n15) {
                        coderResult = CoderResult.OVERFLOW;
                        break block32;
                    }
                    while (UTF8.isSingle(by2 = byteBuffer.get(n3++))) {
                        charBuffer.put(n2++, (char)by2);
                        if (n3 >= n14) {
                            coderResult = CoderResult.UNDERFLOW;
                        } else {
                            if (n2 < n15) continue;
                            coderResult = CoderResult.OVERFLOW;
                        }
                        break block32;
                    }
                    this.toUBytesArray[0] = by2;
                    n6 = UTF8.countBytes(by2);
                    n5 = by2 & BITMASK_FROM_UTF8[n6];
                    n4 = 1;
                }
                this.toULength = n4;
                coderResult = CoderResult.malformedForLength(n4);
            }
            byteBuffer.position(n3);
            charBuffer.position(n2);
            return coderResult;
        }
    }
}

