/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetDecoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetEncoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF16BE;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetUTF16LE;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class CharsetUTF16
extends CharsetICU {
    private static final int SIGNATURE_LENGTH = 2;
    private static final byte[] fromUSubstitution_BE = new byte[]{-1, -3};
    private static final byte[] fromUSubstitution_LE = new byte[]{-3, -1};
    private static final byte[] BOM_BE = new byte[]{-2, -1};
    private static final byte[] BOM_LE = new byte[]{-1, -2};
    private static final int ENDIAN_XOR_BE = 0;
    private static final int ENDIAN_XOR_LE = 1;
    private static final int NEED_TO_WRITE_BOM = 1;
    private boolean isEndianSpecified;
    private boolean isBigEndian;
    private int endianXOR;
    private byte[] bom;
    private byte[] fromUSubstitution;
    private int version;

    public CharsetUTF16(String string, String string2, String[] stringArray) {
        super(string, string2, stringArray);
        int n2 = string.indexOf("version=");
        this.version = n2 > 0 ? Integer.decode(string.substring(n2 + 8, n2 + 9)) : 0;
        this.isEndianSpecified = this instanceof CharsetUTF16BE || this instanceof CharsetUTF16LE;
        boolean bl2 = this.isBigEndian = !(this instanceof CharsetUTF16LE);
        if (this.isBigEndian) {
            this.bom = BOM_BE;
            this.fromUSubstitution = fromUSubstitution_BE;
            this.endianXOR = 0;
        } else {
            this.bom = BOM_LE;
            this.fromUSubstitution = fromUSubstitution_LE;
            this.endianXOR = 1;
        }
        this.maxBytesPerChar = 2;
        this.minBytesPerChar = 2;
        this.maxCharsPerByte = 1.0f;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderUTF16(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderUTF16(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet unicodeSet, int n2) {
        CharsetUTF16.getNonSurrogateUnicodeSet(unicodeSet);
    }

    class CharsetEncoderUTF16
    extends CharsetEncoderICU {
        private final byte[] temp;

        public CharsetEncoderUTF16(CharsetICU charsetICU) {
            super(charsetICU, CharsetUTF16.this.fromUSubstitution);
            this.temp = new byte[4];
            this.fromUnicodeStatus = CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.version != 1 ? 0 : 1;
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.fromUnicodeStatus = CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.version != 1 ? 0 : 1;
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            CoderResult coderResult;
            if (this.fromUnicodeStatus == 1) {
                if (!byteBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                this.fromUnicodeStatus = 0;
                coderResult = CharsetEncoderUTF16.fromUWriteBytes(this, CharsetUTF16.this.bom, 0, CharsetUTF16.this.bom.length, byteBuffer, intBuffer, -1);
                if (coderResult.isOverflow()) {
                    return coderResult;
                }
            }
            if (this.fromUChar32 != 0) {
                if (!byteBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                coderResult = this.encodeChar(charBuffer, byteBuffer, intBuffer, (char)this.fromUChar32);
                if (coderResult != null) {
                    return coderResult;
                }
            }
            do {
                if (!charBuffer.hasRemaining()) {
                    return CoderResult.UNDERFLOW;
                }
                if (byteBuffer.hasRemaining()) continue;
                return CoderResult.OVERFLOW;
            } while ((coderResult = this.encodeChar(charBuffer, byteBuffer, intBuffer, charBuffer.get())) == null);
            return coderResult;
        }

        private final CoderResult encodeChar(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, char c2) {
            CoderResult coderResult;
            int n2 = charBuffer.position() - 1;
            if (UTF16.isSurrogate(c2)) {
                coderResult = this.handleSurrogates(charBuffer, c2);
                if (coderResult != null) {
                    return coderResult;
                }
                char c3 = UTF16.getTrailSurrogate(this.fromUChar32);
                this.fromUChar32 = 0;
                this.temp[0 ^ ((CharsetUTF16)CharsetUTF16.this).endianXOR] = (byte)(c2 >>> 8);
                this.temp[1 ^ ((CharsetUTF16)CharsetUTF16.this).endianXOR] = (byte)c2;
                this.temp[2 ^ ((CharsetUTF16)CharsetUTF16.this).endianXOR] = (byte)(c3 >>> 8);
                this.temp[3 ^ ((CharsetUTF16)CharsetUTF16.this).endianXOR] = (byte)c3;
                coderResult = CharsetEncoderUTF16.fromUWriteBytes(this, this.temp, 0, 4, byteBuffer, intBuffer, n2);
            } else {
                this.temp[0 ^ ((CharsetUTF16)CharsetUTF16.this).endianXOR] = (byte)(c2 >>> 8);
                this.temp[1 ^ ((CharsetUTF16)CharsetUTF16.this).endianXOR] = (byte)c2;
                coderResult = CharsetEncoderUTF16.fromUWriteBytes(this, this.temp, 0, 2, byteBuffer, intBuffer, n2);
            }
            return coderResult.isUnderflow() ? null : coderResult;
        }
    }

    class CharsetDecoderUTF16
    extends CharsetDecoderICU {
        private boolean isBOMReadYet;
        private int actualEndianXOR;
        private byte[] actualBOM;

        public CharsetDecoderUTF16(CharsetICU charsetICU) {
            super(charsetICU);
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.isBOMReadYet = false;
            this.actualBOM = null;
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            CoderResult coderResult;
            CoderResult coderResult2;
            if (!this.isBOMReadYet) {
                block19: {
                    while (true) {
                        if (!byteBuffer.hasRemaining()) {
                            return CoderResult.UNDERFLOW;
                        }
                        this.toUBytesArray[this.toULength++] = byteBuffer.get();
                        if (this.toULength == 1) {
                            if ((!CharsetUTF16.this.isEndianSpecified || CharsetUTF16.this.isBigEndian) && this.toUBytesArray[this.toULength - 1] == BOM_BE[this.toULength - 1]) {
                                this.actualBOM = BOM_BE;
                                this.actualEndianXOR = 0;
                                continue;
                            }
                            if (!(CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.isBigEndian || this.toUBytesArray[this.toULength - 1] != BOM_LE[this.toULength - 1])) {
                                this.actualBOM = BOM_LE;
                                this.actualEndianXOR = 1;
                                continue;
                            }
                            if (CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.version == 1) {
                                this.actualBOM = CharsetUTF16.this.isBigEndian ? BOM_BE : BOM_LE;
                                this.actualEndianXOR = CharsetUTF16.this.isBigEndian ? 0 : 1;
                            } else {
                                this.actualBOM = null;
                                this.actualEndianXOR = CharsetUTF16.this.endianXOR;
                            }
                            break block19;
                        }
                        if (CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.version == 1 && this.toUBytesArray[this.toULength - 1] == this.actualBOM[this.toULength - 2] && this.toUBytesArray[this.toULength - 2] == this.actualBOM[this.toULength - 1]) {
                            return CoderResult.malformedForLength(2);
                        }
                        if (CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.version == 1 && this.toUBytesArray[this.toULength - 1] == this.actualBOM[this.toULength - 1] && this.toUBytesArray[this.toULength - 2] == this.actualBOM[this.toULength - 2]) {
                            this.toULength = 0;
                            break block19;
                        }
                        if (CharsetUTF16.this.isEndianSpecified || this.toUBytesArray[this.toULength - 1] != this.actualBOM[this.toULength - 1]) {
                            this.actualBOM = null;
                            this.actualEndianXOR = CharsetUTF16.this.endianXOR;
                            break block19;
                        }
                        if (this.toULength == 2) break;
                    }
                    this.toULength = 0;
                }
                this.isBOMReadYet = true;
            }
            if (this.toUnicodeStatus != 0 && (coderResult2 = this.decodeTrail(byteBuffer, charBuffer, intBuffer, (char)this.toUnicodeStatus)) != null) {
                return coderResult2;
            }
            while (true) {
                if (this.toULength < 2) {
                    if (!byteBuffer.hasRemaining()) {
                        return CoderResult.UNDERFLOW;
                    }
                    this.toUBytesArray[this.toULength++] = byteBuffer.get();
                    continue;
                }
                if (CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.version == 1 && this.toUBytesArray[this.toULength - 1] == this.actualBOM[this.toULength - 2] && this.toUBytesArray[this.toULength - 2] == this.actualBOM[this.toULength - 1]) {
                    return CoderResult.malformedForLength(2);
                }
                if (CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.version == 1 && this.toUBytesArray[this.toULength - 1] == this.actualBOM[this.toULength - 1] && this.toUBytesArray[this.toULength - 2] == this.actualBOM[this.toULength - 2]) {
                    this.toULength = 0;
                    continue;
                }
                if (!charBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char c2 = (char)((this.toUBytesArray[0 ^ this.actualEndianXOR] & 0xFF) << 8 | this.toUBytesArray[1 ^ this.actualEndianXOR] & 0xFF);
                if (!UTF16.isSurrogate(c2)) {
                    this.toULength = 0;
                    charBuffer.put(c2);
                    continue;
                }
                coderResult = this.decodeTrail(byteBuffer, charBuffer, intBuffer, c2);
                if (coderResult != null) break;
            }
            return coderResult;
        }

        private final CoderResult decodeTrail(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, char c2) {
            if (!UTF16.isLeadSurrogate(c2)) {
                this.toUnicodeStatus = 0;
                return CoderResult.malformedForLength(2);
            }
            while (this.toULength < 4) {
                if (!byteBuffer.hasRemaining()) {
                    this.toUnicodeStatus = c2;
                    return CoderResult.UNDERFLOW;
                }
                this.toUBytesArray[this.toULength++] = byteBuffer.get();
            }
            char c3 = (char)((this.toUBytesArray[2 ^ this.actualEndianXOR] & 0xFF) << 8 | this.toUBytesArray[3 ^ this.actualEndianXOR] & 0xFF);
            if (!UTF16.isTrailSurrogate(c3)) {
                this.toULength = 2;
                byteBuffer.position(byteBuffer.position() - 2);
                this.toUnicodeStatus = 0;
                return CoderResult.malformedForLength(2);
            }
            this.toUnicodeStatus = 0;
            this.toULength = 0;
            charBuffer.put(c2);
            if (charBuffer.hasRemaining()) {
                charBuffer.put(c3);
                return null;
            }
            this.charErrorBufferArray[0] = c3;
            this.charErrorBufferLength = 1;
            return CoderResult.OVERFLOW;
        }
    }
}

