/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetProviderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.IntTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PropsVectors;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

public final class CharsetSelector {
    private IntTrie trie;
    private int[] pv;
    private String[] encodings;

    private void generateSelectorData(PropsVectors propsVectors, UnicodeSet unicodeSet, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = (this.encodings.length + 31) / 32;
        for (n5 = 0; n5 < n6; ++n5) {
            propsVectors.setValue(0x110001, 0x110001, n5, -1, -1);
        }
        for (n5 = 0; n5 < this.encodings.length; ++n5) {
            Charset charset = CharsetICU.forNameICU(this.encodings[n5]);
            UnicodeSet unicodeSet2 = new UnicodeSet();
            ((CharsetICU)charset).getUnicodeSet(unicodeSet2, n2);
            n4 = n5 / 32;
            n3 = 1 << n5 % 32;
            int n7 = unicodeSet2.getRangeCount();
            for (int i2 = 0; i2 < n7; ++i2) {
                int n8 = unicodeSet2.getRangeStart(i2);
                int n9 = unicodeSet2.getRangeEnd(i2);
                propsVectors.setValue(n8, n9, n4, -1, n3);
            }
        }
        if (!unicodeSet.isEmpty()) {
            n5 = unicodeSet.getRangeCount();
            for (int i3 = 0; i3 < n5; ++i3) {
                int n10 = unicodeSet.getRangeStart(i3);
                n4 = unicodeSet.getRangeEnd(i3);
                for (n3 = 0; n3 < n6; ++n3) {
                    propsVectors.setValue(n10, n4, n3, -1, -1);
                }
            }
        }
        this.trie = propsVectors.compactToTrieWithRowIndexes();
        this.pv = propsVectors.getCompactedArray();
    }

    private boolean intersectMasks(int[] nArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = i2;
            int n6 = nArray[n5] & this.pv[n2 + i2];
            nArray[n5] = n6;
            n4 |= n6;
        }
        return n4 == 0;
    }

    private List<String> selectForMask(int[] nArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = (this.encodings.length + 31) / 32;
        int n3 = this.countOnes(nArray, n2);
        if (n3 > 0) {
            int n4 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n5 = nArray[i2];
                for (int i3 = 0; i3 < 32 && n4 < this.encodings.length; ++i3, ++n4) {
                    if ((n5 & 1) != 0) {
                        arrayList.add(this.encodings[n4]);
                    }
                    n5 >>= 1;
                }
            }
        }
        return arrayList;
    }

    private int countOnes(int[] nArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = nArray[i2];
            while (n4 != 0) {
                n4 &= n4 - 1;
                ++n3;
            }
        }
        return n3;
    }

    public CharsetSelector(List<String> list, UnicodeSet unicodeSet, int n2) {
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("Unsupported mappingTypes");
        }
        int n3 = list.size();
        if (n3 > 0) {
            this.encodings = list.toArray(new String[0]);
        } else {
            this.encodings = CharsetProviderICU.getAvailableNames();
            n3 = this.encodings.length;
        }
        PropsVectors propsVectors = new PropsVectors((n3 + 31) / 32);
        this.generateSelectorData(propsVectors, unicodeSet, n2);
    }

    public List<String> selectForString(CharSequence charSequence) {
        int n2;
        int n3;
        int n4 = (this.encodings.length + 31) / 32;
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = -1;
        }
        for (n3 = 0; n3 < charSequence.length(); n3 += UTF16.getCharCount(n2)) {
            n2 = UTF16.charAt(charSequence, n3);
            int n5 = this.trie.getCodePointValue(n2);
            if (!this.intersectMasks(nArray, n5, n4)) continue;
            break;
        }
        return this.selectForMask(nArray);
    }
}

