/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetDecoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetEncoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class CharsetISCII
extends CharsetICU {
    private static final short UCNV_OPTIONS_VERSION_MASK = 15;
    private static final short ZWNJ = 8204;
    private static final short ZWJ = 8205;
    private static final short ATR = 239;
    private static final short EXT = 240;
    private static final short DANDA = 2404;
    private static final short DOUBLE_DANDA = 2405;
    private static final short ISCII_NUKTA = 233;
    private static final short ISCII_HALANT = 232;
    private static final short ISCII_DANDA = 234;
    private static final short ISCII_VOWEL_SIGN_E = 224;
    private static final short ISCII_INV = 217;
    private static final short INDIC_BLOCK_BEGIN = 2304;
    private static final short INDIC_BLOCK_END = 3455;
    private static final short INDIC_RANGE = 1151;
    private static final short VOCALLIC_RR = 2353;
    private static final short LF = 10;
    private static final short ASCII_END = 160;
    private static final short TELUGU_DELTA = 768;
    private static final short DEV_ABBR_SIGN = 2416;
    private static final short DEV_ANUDATTA = 2386;
    private static final short EXT_RANGE_BEGIN = 161;
    private static final short EXT_RANGE_END = 238;
    private static final short PNJ_DELTA = 256;
    private static final int NO_CHAR_MARKER = 65534;
    private static UnicodeSet PNJ_BINDI_TIPPI_SET;
    private static UnicodeSet PNJ_CONSONANT_SET;
    private static final short PNJ_BINDI = 2562;
    private static final short PNJ_TIPPI = 2672;
    private static final short PNJ_SIGN_VIRAMA = 2637;
    private static final short PNJ_ADHAK = 2673;
    private static final short PNJ_HA = 2617;
    private static final short PNJ_RRA = 2652;
    private static final LookupDataStruct[] lookupInitialData;
    private static final short[] validityTable;
    private static final char[] fromUnicodeTable;
    private static final char[] toUnicodeTable;
    private static final char[][] nuktaSpecialCases;
    private static final char[][] vowelSignESpecialCases;
    private static final short[][] lookupTable;
    private UConverterDataISCII extraInfo = null;
    protected byte[] fromUSubstitution = new byte[]{26};

    public CharsetISCII(String string, String string2, String[] stringArray) {
        super(string, string2, stringArray);
        this.maxBytesPerChar = 4;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        int n2 = Integer.parseInt(string.substring(14));
        this.extraInfo = new UConverterDataISCII(n2);
        this.initializePNJSets();
    }

    private void initializePNJSets() {
        if (PNJ_BINDI_TIPPI_SET != null && PNJ_CONSONANT_SET != null) {
            return;
        }
        PNJ_BINDI_TIPPI_SET = new UnicodeSet();
        PNJ_CONSONANT_SET = new UnicodeSet();
        PNJ_CONSONANT_SET.add(2581, 2600);
        PNJ_CONSONANT_SET.add(2602, 2608);
        PNJ_CONSONANT_SET.add(2613, 2614);
        PNJ_CONSONANT_SET.add(2616, 2617);
        PNJ_BINDI_TIPPI_SET.addAll(PNJ_CONSONANT_SET);
        PNJ_BINDI_TIPPI_SET.add(2565);
        PNJ_BINDI_TIPPI_SET.add(2567);
        PNJ_BINDI_TIPPI_SET.add(2625, 2626);
        PNJ_BINDI_TIPPI_SET.add(2623);
        PNJ_CONSONANT_SET.compact();
        PNJ_BINDI_TIPPI_SET.compact();
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderISCII(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderISCII(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet unicodeSet, int n2) {
        unicodeSet.add(0, 160);
        for (int i2 = 0; i2 <= 8; ++i2) {
            char c2 = (char)CharsetISCII.lookupInitialData[i2].maskEnum;
            for (int i3 = 0; i3 < 128; ++i3) {
                if ((validityTable[i3] & c2) == 0 && (i2 != 6 || i3 != 49)) continue;
                unicodeSet.add(i3 + i2 * 128 + 2304);
            }
        }
        unicodeSet.add(2404);
        unicodeSet.add(2405);
        unicodeSet.add(8204);
        unicodeSet.add(8205);
    }

    static {
        lookupInitialData = new LookupDataStruct[]{new LookupDataStruct(0, 128, 66), new LookupDataStruct(1, 8, 67), new LookupDataStruct(2, 64, 75), new LookupDataStruct(3, 32, 74), new LookupDataStruct(4, 16, 71), new LookupDataStruct(5, 1, 68), new LookupDataStruct(6, 4, 69), new LookupDataStruct(7, 4, 72), new LookupDataStruct(8, 2, 73)};
        validityTable = new short[]{0, 248, 255, 255, 128, 255, 255, 255, 255, 255, 255, 190, 158, 160, 135, 255, 255, 160, 135, 255, 255, 255, 254, 254, 254, 255, 255, 254, 255, 254, 255, 255, 254, 254, 254, 255, 255, 254, 254, 254, 255, 129, 255, 254, 254, 254, 255, 255, 255, 131, 255, 247, 131, 247, 254, 191, 255, 255, 0, 0, 216, 128, 255, 255, 255, 255, 255, 190, 172, 160, 135, 255, 255, 160, 135, 255, 255, 255, 0, 0, 160, 128, 128, 128, 128, 4, 20, 26, 128, 192, 192, 192, 200, 152, 192, 152, 190, 158, 136, 136, 128, 128, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        fromUnicodeTable = new char[]{'\u00a0', '\u00a1', '\u00a2', '\u00a3', '\ua4e0', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\ua6e9', '\u00ae', '\u00ab', '\u00ac', '\u00ad', '\u00b2', '\u00af', '\u00b0', '\u00b1', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\uffff', '\uffff', '\u00e9', '\ueae9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\udfe9', '\u00e3', '\u00e0', '\u00e1', '\u00e2', '\u00e7', '\u00e4', '\u00e5', '\u00e6', '\u00e8', '\u00ec', '\u00ed', '\ua1e9', '\uffff', '\uf0b8', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\ub3e9', '\ub4e9', '\ub5e9', '\ubae9', '\ubfe9', '\uc0e9', '\uc9e9', '\u00ce', '\uaae9', '\ua7e9', '\udbe9', '\udce9', '\u00ea', '\ueaea', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\uf0bf', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff'};
        toUnicodeTable = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u0901', '\u0902', '\u0903', '\u0905', '\u0906', '\u0907', '\u0908', '\u0909', '\u090a', '\u090b', '\u090e', '\u090f', '\u0910', '\u090d', '\u0912', '\u0913', '\u0914', '\u0911', '\u0915', '\u0916', '\u0917', '\u0918', '\u0919', '\u091a', '\u091b', '\u091c', '\u091d', '\u091e', '\u091f', '\u0920', '\u0921', '\u0922', '\u0923', '\u0924', '\u0925', '\u0926', '\u0927', '\u0928', '\u0929', '\u092a', '\u092b', '\u092c', '\u092d', '\u092e', '\u092f', '\u095f', '\u0930', '\u0931', '\u0932', '\u0933', '\u0934', '\u0935', '\u0936', '\u0937', '\u0938', '\u0939', '\u200d', '\u093e', '\u093f', '\u0940', '\u0941', '\u0942', '\u0943', '\u0946', '\u0947', '\u0948', '\u0945', '\u094a', '\u094b', '\u094c', '\u0949', '\u094d', '\u093c', '\u0964', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u0966', '\u0967', '\u0968', '\u0969', '\u096a', '\u096b', '\u096c', '\u096d', '\u096e', '\u096f', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff'};
        nuktaSpecialCases = new char[][]{{'\u0010', '\u0000'}, {'\u00a6', '\u090c'}, {'\u00ea', '\u093d'}, {'\u00df', '\u0944'}, {'\u00a1', '\u0950'}, {'\u00b3', '\u0958'}, {'\u00b4', '\u0959'}, {'\u00b5', '\u095a'}, {'\u00ba', '\u095b'}, {'\u00bf', '\u095c'}, {'\u00c0', '\u095d'}, {'\u00c9', '\u095e'}, {'\u00aa', '\u0960'}, {'\u00a7', '\u0961'}, {'\u00db', '\u0962'}, {'\u00dc', '\u0963'}};
        vowelSignESpecialCases = new char[][]{{'\u0002', '\u0000'}, {'\u00a4', '\u0904'}};
        lookupTable = new short[][]{{0, 0}, {0, 0}, {0, 128}, {1, 8}, {5, 1}, {6, 4}, {1, 8}, {4, 16}, {7, 4}, {8, 2}, {3, 32}, {2, 64}};
    }

    class CharsetEncoderISCII
    extends CharsetEncoderICU {
        public CharsetEncoderISCII(CharsetICU charsetICU) {
            super(charsetICU, CharsetISCII.this.fromUSubstitution);
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
            CharsetISCII.this.extraInfo.initialize();
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            int n2 = 0;
            int n3 = 0;
            short s2 = 0;
            short s3 = 0;
            boolean bl3 = false;
            int n4 = 0;
            CoderResult coderResult = CoderResult.UNDERFLOW;
            UConverterDataISCII uConverterDataISCII = CharsetISCII.this.extraInfo;
            s2 = uConverterDataISCII.currentDeltaFromUnicode;
            s3 = (short)(s2 / 128);
            n3 = this.fromUChar32;
            if (n3 != 0) {
                coderResult = this.handleSurrogates(charBuffer, (char)n3);
                return coderResult != null ? coderResult : CoderResult.unmappableForLength(2);
            }
            block4: while (charBuffer.hasRemaining()) {
                if (!byteBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                if (this.fromUnicodeStatus == 10) {
                    n2 = 61184;
                    this.fromUnicodeStatus = 0;
                    coderResult = this.WriteToTargetFromU(intBuffer, charBuffer, byteBuffer, n2 += 0xFF & (byte)lookupInitialData[s3].isciiLang);
                    if (coderResult.isOverflow()) break;
                }
                n3 = charBuffer.get();
                n4 = uConverterDataISCII.contextCharFromUnicode;
                n2 = 65535;
                if (n3 <= 160) {
                    this.fromUnicodeStatus = n3;
                    coderResult = this.WriteToTargetFromU(intBuffer, charBuffer, byteBuffer, n3);
                    if (!coderResult.isOverflow()) continue;
                    break;
                }
                switch (n3) {
                    case 8204: {
                        if (uConverterDataISCII.contextCharFromUnicode != 0) {
                            uConverterDataISCII.contextCharFromUnicode = 0;
                            n2 = 232;
                            break;
                        }
                        uConverterDataISCII.contextCharFromUnicode = 0;
                        continue block4;
                    }
                    case 8205: {
                        n2 = uConverterDataISCII.contextCharFromUnicode != 0 ? 233 : 217;
                        uConverterDataISCII.contextCharFromUnicode = 0;
                        break;
                    }
                    default: {
                        if ((char)(3455 - n3) <= '\u047f') {
                            if (n3 != 2404 && n3 != 2405) {
                                s3 = (short)((n3 - 2304) / 128);
                                s2 = (short)(s3 * 128);
                                if (s2 != uConverterDataISCII.currentDeltaFromUnicode || uConverterDataISCII.isFirstBuffer) {
                                    uConverterDataISCII.currentDeltaFromUnicode = s2;
                                    uConverterDataISCII.currentMaskFromUnicode = lookupInitialData[s3].maskEnum;
                                    bl3 = true;
                                    uConverterDataISCII.isFirstBuffer = false;
                                }
                                if (uConverterDataISCII.currentDeltaFromUnicode == 256) {
                                    if (n3 == 2672) {
                                        n3 = 2562;
                                    } else if (n3 == 2673) {
                                        uConverterDataISCII.contextCharFromUnicode = 2673;
                                    }
                                }
                                n3 -= uConverterDataISCII.currentDeltaFromUnicode;
                            }
                            n2 = fromUnicodeTable[(short)n3 & 0xFF];
                            if ((validityTable[(short)n3 & 0xFF] & uConverterDataISCII.currentMaskFromUnicode) == 0 && (uConverterDataISCII.currentDeltaFromUnicode != 768 || n3 != 2353)) {
                                n2 = 65535;
                            }
                            if (bl3) {
                                int n5 = 0;
                                n5 = 61184;
                                n5 = (char)(n5 + (char)(lookupInitialData[s3].isciiLang & 0xFF));
                                bl3 = false;
                                coderResult = this.WriteToTargetFromU(intBuffer, charBuffer, byteBuffer, n5);
                                if (coderResult.isOverflow()) break;
                            }
                            if (uConverterDataISCII.currentDeltaFromUnicode == 256 && n3 + 256 == 2673) continue block4;
                        }
                        uConverterDataISCII.contextCharFromUnicode = 0;
                    }
                }
                if (uConverterDataISCII.currentDeltaFromUnicode == 256 && n4 == 2673 && PNJ_CONSONANT_SET.contains(n3 + 256)) {
                    uConverterDataISCII.contextCharFromUnicode = 0;
                    coderResult = this.WriteToTargetFromU(intBuffer, charBuffer, byteBuffer, n2 = n2 << 16 | 0xE800 | n2);
                    if (!coderResult.isOverflow()) continue;
                    break;
                }
                if (n2 != 65535) {
                    if (n2 == 232) {
                        uConverterDataISCII.contextCharFromUnicode = (char)n2;
                    }
                    if (!(coderResult = this.WriteToTargetFromU(intBuffer, charBuffer, byteBuffer, n2)).isOverflow()) continue;
                    break;
                }
                if (UTF16.isSurrogate(n3)) {
                    coderResult = this.handleSurrogates(charBuffer, (char)n3);
                    return coderResult != null ? coderResult : CoderResult.unmappableForLength(2);
                }
                return CoderResult.unmappableForLength(1);
            }
            return coderResult;
        }

        private CoderResult WriteToTargetFromU(IntBuffer intBuffer, CharBuffer charBuffer, ByteBuffer byteBuffer, int n2) {
            CoderResult coderResult = CoderResult.UNDERFLOW;
            int n3 = charBuffer.position() - 1;
            if (byteBuffer.hasRemaining()) {
                if (n2 <= 255) {
                    byteBuffer.put((byte)n2);
                    if (intBuffer != null) {
                        intBuffer.put(n3);
                    }
                } else {
                    if (n2 > 65535) {
                        byteBuffer.put((byte)(n2 >> 16));
                        if (intBuffer != null) {
                            intBuffer.put(--n3);
                        }
                    }
                    if (!byteBuffer.hasRemaining()) {
                        this.errorBuffer[this.errorBufferLength++] = (byte)(n2 >> 8);
                        this.errorBuffer[this.errorBufferLength++] = (byte)n2;
                        coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byteBuffer.put((byte)(n2 >> 8));
                    if (intBuffer != null) {
                        intBuffer.put(n3);
                    }
                    if (byteBuffer.hasRemaining()) {
                        byteBuffer.put((byte)n2);
                        if (intBuffer != null) {
                            intBuffer.put(n3);
                        }
                    } else {
                        this.errorBuffer[this.errorBufferLength++] = (byte)n2;
                        coderResult = CoderResult.OVERFLOW;
                    }
                }
            } else {
                if (n2 > 65535) {
                    this.errorBuffer[this.errorBufferLength++] = (byte)(n2 >> 16);
                } else if ((n2 & 0xFF00) > 0) {
                    this.errorBuffer[this.errorBufferLength++] = (byte)(n2 >> 8);
                }
                this.errorBuffer[this.errorBufferLength++] = (byte)n2;
                coderResult = CoderResult.OVERFLOW;
            }
            return coderResult;
        }
    }

    class CharsetDecoderISCII
    extends CharsetDecoderICU {
        public CharsetDecoderISCII(CharsetICU charsetICU) {
            super(charsetICU);
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.toUnicodeStatus = 65535;
            CharsetISCII.this.extraInfo.initialize();
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            CoderResult coderResult = CoderResult.UNDERFLOW;
            int n2 = 0;
            short s2 = 0;
            boolean bl3 = false;
            int n3 = 0;
            UConverterDataISCII uConverterDataISCII = CharsetISCII.this.extraInfo;
            block8: while (byteBuffer.hasRemaining()) {
                n2 = 65535;
                if (charBuffer.hasRemaining()) {
                    s2 = (short)(byteBuffer.get() & 0xFF);
                    if (uConverterDataISCII.contextCharToUnicode == 239) {
                        if (((short)(75 - s2) & 0xFF) <= 9) {
                            uConverterDataISCII.currentDeltaToUnicode = (short)(lookupTable[s2 & 0xF][0] * 128);
                            uConverterDataISCII.currentMaskToUnicode = lookupTable[s2 & 0xF][1];
                        } else if (s2 == 64) {
                            uConverterDataISCII.currentDeltaToUnicode = uConverterDataISCII.defDeltaToUnicode;
                            uConverterDataISCII.currentMaskToUnicode = uConverterDataISCII.defMaskToUnicode;
                        } else if (s2 < 33 || s2 > 63) {
                            coderResult = CoderResult.malformedForLength(1);
                            uConverterDataISCII.contextCharToUnicode = 65534;
                            bl3 = true;
                        }
                        if (!bl3) {
                            uConverterDataISCII.contextCharToUnicode = 65534;
                            continue;
                        }
                    } else if (uConverterDataISCII.contextCharToUnicode == 240) {
                        if (((short)(238 - s2) & 0xFF) <= 77) {
                            if (s2 == 191 || s2 == 184) {
                                int n4 = n2 = s2 == 191 ? 2416 : 2386;
                                if ((validityTable[(short)n2 & 0xFF] & uConverterDataISCII.currentMaskToUnicode) > 0) {
                                    uConverterDataISCII.contextCharToUnicode = 65534;
                                    if (uConverterDataISCII.prevToUnicodeStatus != 0) {
                                        coderResult = this.WriteToTargetToU(intBuffer, byteBuffer.position() - 1, byteBuffer, charBuffer, uConverterDataISCII.prevToUnicodeStatus, (short)0);
                                        uConverterDataISCII.prevToUnicodeStatus = 0;
                                    }
                                    coderResult = this.WriteToTargetToU(intBuffer, byteBuffer.position() - 2, byteBuffer, charBuffer, n2, uConverterDataISCII.currentDeltaToUnicode);
                                    continue;
                                }
                            }
                            n2 = 65535;
                            coderResult = CoderResult.unmappableForLength(1);
                        } else {
                            uConverterDataISCII.contextCharToUnicode = 65534;
                            coderResult = CoderResult.malformedForLength(1);
                        }
                        bl3 = true;
                    } else if (uConverterDataISCII.contextCharToUnicode == 217) {
                        n2 = s2 == 232 ? 32 : 8205;
                        if (uConverterDataISCII.prevToUnicodeStatus != 0) {
                            coderResult = this.WriteToTargetToU(intBuffer, byteBuffer.position() - 1, byteBuffer, charBuffer, uConverterDataISCII.prevToUnicodeStatus, (short)0);
                            uConverterDataISCII.prevToUnicodeStatus = 0;
                        }
                        coderResult = this.WriteToTargetToU(intBuffer, byteBuffer.position() - 2, byteBuffer, charBuffer, n2, uConverterDataISCII.currentDeltaToUnicode);
                        uConverterDataISCII.contextCharToUnicode = 65534;
                    }
                    if (!bl3) {
                        switch (s2) {
                            case 217: 
                            case 239: 
                            case 240: {
                                uConverterDataISCII.contextCharToUnicode = (char)s2;
                                if (this.toUnicodeStatus == 65535) continue block8;
                                if (uConverterDataISCII.prevToUnicodeStatus != 0) {
                                    coderResult = this.WriteToTargetToU(intBuffer, byteBuffer.position() - 1, byteBuffer, charBuffer, uConverterDataISCII.prevToUnicodeStatus, (short)0);
                                    uConverterDataISCII.prevToUnicodeStatus = 0;
                                }
                                coderResult = this.WriteToTargetToU(intBuffer, byteBuffer.position() - 2, byteBuffer, charBuffer, this.toUnicodeStatus, uConverterDataISCII.currentDeltaToUnicode);
                                this.toUnicodeStatus = 65535;
                                continue block8;
                            }
                            case 234: {
                                if (uConverterDataISCII.contextCharToUnicode == 234) {
                                    n2 = 2405;
                                    uConverterDataISCII.contextCharToUnicode = 65534;
                                    this.toUnicodeStatus = 65535;
                                    break;
                                }
                                n2 = this.GetMapping(s2, n2, uConverterDataISCII);
                                uConverterDataISCII.contextCharToUnicode = (char)s2;
                                break;
                            }
                            case 232: {
                                if (uConverterDataISCII.contextCharToUnicode == 232) {
                                    n2 = 8204;
                                    uConverterDataISCII.contextCharToUnicode = 65534;
                                    break;
                                }
                                n2 = this.GetMapping(s2, n2, uConverterDataISCII);
                                uConverterDataISCII.contextCharToUnicode = (char)s2;
                                break;
                            }
                            case 10: 
                            case 13: {
                                uConverterDataISCII.resetToDefaultToUnicode = true;
                                n2 = this.GetMapping(s2, n2, uConverterDataISCII);
                                uConverterDataISCII.contextCharToUnicode = (char)s2;
                                break;
                            }
                            case 224: {
                                boolean bl4 = false;
                                for (int i2 = 1; i2 < vowelSignESpecialCases[0][0]; ++i2) {
                                    if (vowelSignESpecialCases[i2][0] != ((short)uConverterDataISCII.contextCharToUnicode & 0xFF)) continue;
                                    n2 = vowelSignESpecialCases[i2][1];
                                    bl4 = true;
                                    break;
                                }
                                if (bl4 && (validityTable[(byte)n2] & uConverterDataISCII.currentMaskFromUnicode) > 0) {
                                    uConverterDataISCII.contextCharToUnicode = 65534;
                                    this.toUnicodeStatus = 65535;
                                    break;
                                }
                                n2 = this.GetMapping(s2, n2, uConverterDataISCII);
                                uConverterDataISCII.contextCharToUnicode = (char)s2;
                                break;
                            }
                            case 233: {
                                if (uConverterDataISCII.contextCharToUnicode == 232) {
                                    n2 = 8205;
                                    uConverterDataISCII.contextCharToUnicode = 65534;
                                    break;
                                }
                                if (uConverterDataISCII.currentDeltaToUnicode == 256 && uConverterDataISCII.contextCharToUnicode == 192) {
                                    coderResult = this.WriteToTargetToU(intBuffer, byteBuffer.position() - 2, byteBuffer, charBuffer, 2652, (short)0);
                                    if (!coderResult.isOverflow()) {
                                        coderResult = this.WriteToTargetToU(intBuffer, byteBuffer.position() - 2, byteBuffer, charBuffer, 2637, (short)0);
                                        if (!coderResult.isOverflow()) {
                                            coderResult = this.WriteToTargetToU(intBuffer, byteBuffer.position() - 2, byteBuffer, charBuffer, 2617, (short)0);
                                        } else {
                                            this.charErrorBufferArray[this.charErrorBufferLength++] = 2617;
                                        }
                                    } else {
                                        this.charErrorBufferArray[this.charErrorBufferLength++] = 2637;
                                        this.charErrorBufferArray[this.charErrorBufferLength++] = 2617;
                                    }
                                    this.toUnicodeStatus = 65535;
                                    uConverterDataISCII.contextCharToUnicode = 65534;
                                    if (coderResult.isError()) break;
                                    continue block8;
                                }
                                boolean bl5 = false;
                                for (int i3 = 1; i3 < nuktaSpecialCases[0][0]; ++i3) {
                                    if (nuktaSpecialCases[i3][0] != ((short)uConverterDataISCII.contextCharToUnicode & 0xFF)) continue;
                                    n2 = nuktaSpecialCases[i3][1];
                                    bl5 = true;
                                    break;
                                }
                                if (bl5 && (validityTable[(byte)n2] & uConverterDataISCII.currentMaskToUnicode) > 0) {
                                    uConverterDataISCII.contextCharToUnicode = 65534;
                                    this.toUnicodeStatus = 65535;
                                    if (uConverterDataISCII.currentDeltaToUnicode != 256) break;
                                    if (uConverterDataISCII.prevToUnicodeStatus != 0) {
                                        coderResult = this.WriteToTargetToU(intBuffer, byteBuffer.position() - 1, byteBuffer, charBuffer, uConverterDataISCII.prevToUnicodeStatus, (short)0);
                                        uConverterDataISCII.prevToUnicodeStatus = 0;
                                    }
                                    coderResult = this.WriteToTargetToU(intBuffer, byteBuffer.position() - 2, byteBuffer, charBuffer, n2, uConverterDataISCII.currentDeltaToUnicode);
                                    continue block8;
                                }
                            }
                            default: {
                                n2 = this.GetMapping(s2, n2, uConverterDataISCII);
                                uConverterDataISCII.contextCharToUnicode = (char)s2;
                            }
                        }
                    }
                    if (!bl3 && this.toUnicodeStatus != 65535) {
                        if (uConverterDataISCII.currentDeltaToUnicode == 256 && uConverterDataISCII.prevToUnicodeStatus != 0 && PNJ_CONSONANT_SET.contains(uConverterDataISCII.prevToUnicodeStatus) && this.toUnicodeStatus + 256 == 2637 && n2 + 256 == uConverterDataISCII.prevToUnicodeStatus) {
                            if (intBuffer != null) {
                                n3 = byteBuffer.position() - 3;
                            }
                            coderResult = this.WriteToTargetToU(intBuffer, n3, byteBuffer, charBuffer, 2673, (short)0);
                            coderResult = this.WriteToTargetToU(intBuffer, n3, byteBuffer, charBuffer, uConverterDataISCII.prevToUnicodeStatus, (short)0);
                            uConverterDataISCII.prevToUnicodeStatus = 0;
                            this.toUnicodeStatus = 65535;
                            continue;
                        }
                        if (uConverterDataISCII.prevToUnicodeStatus != 0) {
                            coderResult = this.WriteToTargetToU(intBuffer, byteBuffer.position() - 1, byteBuffer, charBuffer, uConverterDataISCII.prevToUnicodeStatus, (short)0);
                            uConverterDataISCII.prevToUnicodeStatus = 0;
                        }
                        if (uConverterDataISCII.currentDeltaToUnicode == 256 && n2 + 256 == 2562 && PNJ_BINDI_TIPPI_SET.contains(this.toUnicodeStatus + 256)) {
                            n2 = 2416;
                            coderResult = this.WriteToTargetToU(intBuffer, byteBuffer.position() - 2, byteBuffer, charBuffer, this.toUnicodeStatus, (short)256);
                        } else if (uConverterDataISCII.currentDeltaToUnicode == 256 && n2 + 256 == 2637 && PNJ_CONSONANT_SET.contains(this.toUnicodeStatus + 256)) {
                            uConverterDataISCII.prevToUnicodeStatus = this.toUnicodeStatus + 256;
                        } else {
                            coderResult = this.WriteToTargetToU(intBuffer, byteBuffer.position() - 2, byteBuffer, charBuffer, this.toUnicodeStatus, uConverterDataISCII.currentDeltaToUnicode);
                        }
                        this.toUnicodeStatus = 65535;
                    }
                    if (!bl3 && n2 != 65535) {
                        this.toUnicodeStatus = (char)n2;
                        if (!uConverterDataISCII.resetToDefaultToUnicode) continue;
                        uConverterDataISCII.currentDeltaToUnicode = uConverterDataISCII.defDeltaToUnicode;
                        uConverterDataISCII.currentMaskToUnicode = uConverterDataISCII.defMaskToUnicode;
                        uConverterDataISCII.resetToDefaultToUnicode = false;
                        continue;
                    }
                    if (!bl3) {
                        coderResult = CoderResult.unmappableForLength(1);
                    }
                    this.toUBytesArray[0] = (byte)s2;
                    this.toULength = 1;
                    bl3 = false;
                    break;
                }
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            if (coderResult.isUnderflow() && bl2 && !byteBuffer.hasRemaining()) {
                if (uConverterDataISCII.contextCharToUnicode == 239 || uConverterDataISCII.contextCharToUnicode == 240 || uConverterDataISCII.contextCharToUnicode == 217) {
                    this.toUBytesArray[0] = (byte)uConverterDataISCII.contextCharToUnicode;
                    this.toULength = 1;
                    uConverterDataISCII.contextCharToUnicode = 65534;
                } else {
                    this.toULength = 0;
                }
                if (this.toUnicodeStatus != 65535) {
                    this.WriteToTargetToU(intBuffer, byteBuffer.position() - 2, byteBuffer, charBuffer, this.toUnicodeStatus, uConverterDataISCII.currentDeltaToUnicode);
                    this.toUnicodeStatus = 65535;
                }
            }
            return coderResult;
        }

        private CoderResult WriteToTargetToU(IntBuffer intBuffer, int n2, ByteBuffer byteBuffer, CharBuffer charBuffer, int n3, short s2) {
            CoderResult coderResult = CoderResult.UNDERFLOW;
            if (n3 > 160 && n3 != 8205 && n3 != 8204 && n3 != 2404 && n3 != 2405) {
                n3 += s2;
            }
            if (charBuffer.hasRemaining()) {
                charBuffer.put((char)n3);
                if (intBuffer != null) {
                    intBuffer.put(n2);
                }
            } else {
                this.charErrorBufferArray[this.charErrorBufferLength++] = (char)n3;
                coderResult = CoderResult.OVERFLOW;
            }
            return coderResult;
        }

        private int GetMapping(short s2, int n2, UConverterDataISCII uConverterDataISCII) {
            n2 = toUnicodeTable[s2];
            if (s2 > 160 && (validityTable[n2 & 0x7F] & uConverterDataISCII.currentMaskToUnicode) == 0 && (uConverterDataISCII.currentDeltaToUnicode != 768 || n2 != 2353)) {
                n2 = 65535;
            }
            return n2;
        }
    }

    private static final class LookupDataStruct {
        short uniLang;
        short maskEnum;
        short isciiLang;

        LookupDataStruct(short s2, short s3, short s4) {
            this.uniLang = s2;
            this.maskEnum = s3;
            this.isciiLang = s4;
        }
    }

    private static final class UConverterDataISCII {
        int option;
        int contextCharToUnicode;
        int contextCharFromUnicode;
        short defDeltaToUnicode;
        short currentDeltaFromUnicode;
        short currentDeltaToUnicode;
        short currentMaskFromUnicode;
        short currentMaskToUnicode;
        short defMaskToUnicode;
        boolean isFirstBuffer;
        boolean resetToDefaultToUnicode;
        int prevToUnicodeStatus;

        UConverterDataISCII(int n2) {
            this.option = n2;
            this.initialize();
        }

        void initialize() {
            this.contextCharToUnicode = 65534;
            this.currentDeltaFromUnicode = 0;
            this.defDeltaToUnicode = (short)(lookupInitialData[this.option & 0xF].uniLang * 128);
            this.currentDeltaFromUnicode = (short)(lookupInitialData[this.option & 0xF].uniLang * 128);
            this.currentDeltaToUnicode = (short)(lookupInitialData[this.option & 0xF].uniLang * 128);
            this.currentMaskToUnicode = lookupInitialData[this.option & 0xF].maskEnum;
            this.currentMaskFromUnicode = lookupInitialData[this.option & 0xF].maskEnum;
            this.defMaskToUnicode = lookupInitialData[this.option & 0xF].maskEnum;
            this.isFirstBuffer = true;
            this.resetToDefaultToUnicode = false;
            this.prevToUnicodeStatus = 0;
        }
    }

    private static final class MaskEnum {
        static final short DEV_MASK = 128;
        static final short PNJ_MASK = 64;
        static final short GJR_MASK = 32;
        static final short ORI_MASK = 16;
        static final short BNG_MASK = 8;
        static final short KND_MASK = 4;
        static final short MLM_MASK = 2;
        static final short TML_MASK = 1;
        static final short ZERO = 0;

        private MaskEnum() {
        }
    }

    private static final class ISCIILang {
        static final short DEF = 64;
        static final short RMN = 65;
        static final short DEV = 66;
        static final short BNG = 67;
        static final short TML = 68;
        static final short TLG = 69;
        static final short ASM = 70;
        static final short ORI = 71;
        static final short KND = 72;
        static final short MLM = 73;
        static final short GJR = 74;
        static final short PNJ = 75;
        static final short ARB = 113;
        static final short PES = 114;
        static final short URD = 115;
        static final short SND = 116;
        static final short KSM = 117;
        static final short PST = 118;

        private ISCIILang() {
        }
    }

    private static final class UniLang {
        static final short DEVALANGARI = 0;
        static final short BENGALI = 1;
        static final short GURMUKHI = 2;
        static final short GUJARATI = 3;
        static final short ORIYA = 4;
        static final short TAMIL = 5;
        static final short TELUGU = 6;
        static final short KANNADA = 7;
        static final short MALAYALAM = 8;
        static final short DELTA = 128;

        private UniLang() {
        }
    }
}

