/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetCallback;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Assert;

public abstract class CharsetDecoderICU
extends CharsetDecoder {
    int toUnicodeStatus;
    byte[] toUBytesArray = new byte[128];
    int toUBytesBegin = 0;
    int toULength;
    char[] charErrorBufferArray = new char[128];
    int charErrorBufferLength;
    int charErrorBufferBegin;
    char[] invalidCharBuffer = new char[128];
    int invalidCharLength;
    @Deprecated
    protected static final int EXT_MAX_BYTES = 31;
    byte[] preToUArray = new byte[31];
    int preToUBegin;
    int preToULength;
    int preToUFirstLength;
    int mode;
    Object toUContext = null;
    private CharsetCallback.Decoder onUnmappableCharacter = CharsetCallback.TO_U_CALLBACK_STOP;
    private CharsetCallback.Decoder onMalformedInput = CharsetCallback.TO_U_CALLBACK_STOP;
    CharsetCallback.Decoder toCharErrorBehaviour = new CharsetCallback.Decoder(){

        @Override
        public CoderResult call(CharsetDecoderICU charsetDecoderICU, Object object, ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, char[] cArray, int n2, CoderResult coderResult) {
            if (coderResult.isUnmappable()) {
                return CharsetDecoderICU.this.onUnmappableCharacter.call(charsetDecoderICU, object, byteBuffer, charBuffer, intBuffer, cArray, n2, coderResult);
            }
            return CharsetDecoderICU.this.onMalformedInput.call(charsetDecoderICU, object, byteBuffer, charBuffer, intBuffer, cArray, n2, coderResult);
        }
    };
    private boolean malformedInputCalled = false;
    private boolean unmappableCharacterCalled = false;
    private final ByteBuffer EMPTY = ByteBuffer.allocate(0);

    CharsetDecoderICU(CharsetICU charsetICU) {
        super(charsetICU, 1.0f / charsetICU.maxCharsPerByte, charsetICU.maxCharsPerByte);
    }

    final boolean isFallbackUsed() {
        return true;
    }

    static final boolean isToUUseFallback() {
        return CharsetDecoderICU.isToUUseFallback(true);
    }

    static final boolean isToUUseFallback(boolean bl2) {
        return true;
    }

    @Override
    protected final void implOnMalformedInput(CodingErrorAction codingErrorAction) {
        if (this.malformedInputCalled) {
            return;
        }
        if (codingErrorAction == CodingErrorAction.REPLACE) {
            this.malformedInputCalled = true;
            super.onMalformedInput(CodingErrorAction.IGNORE);
            this.malformedInputCalled = false;
        }
        this.onMalformedInput = CharsetDecoderICU.getCallback(codingErrorAction);
    }

    @Override
    protected final void implOnUnmappableCharacter(CodingErrorAction codingErrorAction) {
        if (this.unmappableCharacterCalled) {
            return;
        }
        if (codingErrorAction == CodingErrorAction.REPLACE) {
            this.unmappableCharacterCalled = true;
            super.onUnmappableCharacter(CodingErrorAction.IGNORE);
            this.unmappableCharacterCalled = false;
        }
        this.onUnmappableCharacter = CharsetDecoderICU.getCallback(codingErrorAction);
    }

    public final void setToUCallback(CoderResult coderResult, CharsetCallback.Decoder decoder, Object object) {
        if (coderResult.isMalformed()) {
            this.onMalformedInput = decoder;
        } else if (coderResult.isUnmappable()) {
            this.onUnmappableCharacter = decoder;
        }
        if (this.toUContext == null || !this.toUContext.equals(object)) {
            this.toUContext = object;
        }
    }

    private static CharsetCallback.Decoder getCallback(CodingErrorAction codingErrorAction) {
        if (codingErrorAction == CodingErrorAction.REPLACE) {
            return CharsetCallback.TO_U_CALLBACK_SUBSTITUTE;
        }
        if (codingErrorAction == CodingErrorAction.IGNORE) {
            return CharsetCallback.TO_U_CALLBACK_SKIP;
        }
        return CharsetCallback.TO_U_CALLBACK_STOP;
    }

    @Override
    protected final CoderResult implFlush(CharBuffer charBuffer) {
        return this.decode(this.EMPTY, charBuffer, null, true);
    }

    @Override
    protected void implReset() {
        this.toUnicodeStatus = 0;
        this.toULength = 0;
        this.charErrorBufferLength = 0;
        this.charErrorBufferBegin = 0;
        this.preToUBegin = 0;
        this.preToULength = 0;
        this.preToUFirstLength = 0;
        this.mode = 0;
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.remaining() < this.toUCountPending()) {
            return CoderResult.UNDERFLOW;
        }
        byteBuffer.position(byteBuffer.position() + this.toUCountPending());
        CoderResult coderResult = this.decode(byteBuffer, charBuffer, null, false);
        byteBuffer.position(byteBuffer.position() - this.toUCountPending());
        return coderResult;
    }

    abstract CoderResult decodeLoop(ByteBuffer var1, CharBuffer var2, IntBuffer var3, boolean var4);

    final CoderResult decode(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
        if (charBuffer == null || byteBuffer == null) {
            throw new IllegalArgumentException();
        }
        if (this.charErrorBufferLength > 0) {
            int n2 = 0;
            do {
                if (!charBuffer.hasRemaining()) {
                    int n3 = 0;
                    do {
                        this.charErrorBufferArray[n3++] = this.charErrorBufferArray[n2++];
                    } while (n2 < this.charErrorBufferLength);
                    this.charErrorBufferLength = (byte)n3;
                    return CoderResult.OVERFLOW;
                }
                charBuffer.put(this.charErrorBufferArray[n2++]);
                if (intBuffer == null) continue;
                intBuffer.put(-1);
            } while (n2 < this.charErrorBufferLength);
            this.charErrorBufferLength = 0;
        }
        if (!bl2 && !byteBuffer.hasRemaining() && this.toULength == 0 && this.preToULength >= 0) {
            return CoderResult.UNDERFLOW;
        }
        return this.toUnicodeWithCallback(byteBuffer, charBuffer, intBuffer, bl2);
    }

    /*
     * Unable to fully structure code
     */
    final CoderResult toUnicodeWithCallback(ByteBuffer var1_1, CharBuffer var2_2, IntBuffer var3_3, boolean var4_4) {
        var9_5 = var1_1.position();
        var10_6 = ByteBuffer.allocate(31);
        var11_7 = 0;
        var12_8 = null;
        var13_9 = false;
        var14_10 = 0;
        var15_11 = CoderResult.UNDERFLOW;
        var5_12 = 0;
        if (this.preToULength < 0) {
            var12_8 = var1_1;
            var13_9 = var4_4;
            var14_10 = var5_12;
            var10_6.put(this.preToUArray, 0, -this.preToULength);
            var1_1 = var10_6;
            var1_1.position(0);
            var1_1.limit(var11_7 - this.preToULength);
            var4_4 = false;
            var5_12 = -1;
            this.preToULength = 0;
        }
        block0: while (true) {
            var7_14 = (var15_11 = this.decodeLoop(var1_1, var2_2, var3_3, var4_4)).isUnderflow() != false && var4_4 != false && var1_1.remaining() == 0 && this.toULength == 0;
            var8_15 = false;
            var6_13 = 0;
            while (true) {
                if (this.preToULength < 0) {
                    if (var12_8 == null) {
                        var12_8 = var1_1;
                        var13_9 = var4_4;
                        var14_10 = var5_12;
                        var10_6.put(this.preToUArray, 0, -this.preToULength);
                        var10_6.position(0);
                        var1_1 = var10_6;
                        var1_1.limit(var11_7 - this.preToULength);
                        var4_4 = false;
                        if ((var5_12 += this.preToULength) < 0) {
                            var5_12 = -1;
                        }
                        this.preToULength = 0;
                    } else {
                        Assert.assrt(var12_8 == null);
                    }
                }
                var9_5 = var1_1.position();
                if (var15_11.isUnderflow()) {
                    if (var9_5 < var1_1.limit()) continue block0;
                    if (var12_8 != null) {
                        var1_1 = var12_8;
                        var4_4 = var13_9;
                        var5_12 = var14_10;
                        var12_8 = null;
                        continue block0;
                    }
                    if (var4_4 && this.toULength > 0) {
                        var15_11 = CoderResult.malformedForLength(this.toULength);
                        var8_15 = false;
                    } else {
                        if (var4_4) {
                            if (var7_14) ** break;
                            continue block0;
                            this.implReset();
                        }
                        return var15_11;
                    }
                }
                if (var8_15 || var15_11.isOverflow() || var15_11.isMalformed() && var15_11.isUnmappable()) {
                    if (var12_8 != null) {
                        Assert.assrt(this.preToULength == 0);
                        var16_16 = var1_1.limit() - var1_1.position();
                        if (var16_16 > 0) {
                            var1_1.get(this.preToUArray, this.preToUBegin, var16_16);
                            this.preToULength = (byte)(-var16_16);
                        }
                    }
                    return var15_11;
                }
                this.invalidCharLength = this.toULength;
                var6_13 = this.invalidCharLength;
                if (var6_13 > 0) {
                    this.copy(this.toUBytesArray, 0, this.invalidCharBuffer, 0, var6_13);
                }
                this.toULength = 0;
                var15_11 = this.toCharErrorBehaviour.call(this, this.toUContext, var1_1, var2_2, var3_3, this.invalidCharBuffer, var6_13, var15_11);
                var8_15 = true;
            }
            break;
        }
    }

    int toUCountPending() {
        if (this.preToULength > 0) {
            return this.preToULength;
        }
        if (this.preToULength < 0) {
            return -this.preToULength;
        }
        if (this.toULength > 0) {
            return this.toULength;
        }
        return 0;
    }

    private void copy(byte[] byArray, int n2, char[] cArray, int n3, int n4) {
        for (int i2 = n2; i2 < n4; ++i2) {
            cArray[n3++] = (char)(byArray[n2++] & 0xFF);
        }
    }

    static final CoderResult toUWriteUChars(CharsetDecoderICU charsetDecoderICU, char[] cArray, int n2, int n3, CharBuffer charBuffer, IntBuffer intBuffer, int n4) {
        CoderResult coderResult = CoderResult.UNDERFLOW;
        if (intBuffer == null) {
            while (n3 > 0 && charBuffer.hasRemaining()) {
                charBuffer.put(cArray[n2++]);
                --n3;
            }
        } else {
            while (n3 > 0 && charBuffer.hasRemaining()) {
                charBuffer.put(cArray[n2++]);
                intBuffer.put(n4);
                --n3;
            }
        }
        if (n3 > 0) {
            charsetDecoderICU.charErrorBufferLength = 0;
            coderResult = CoderResult.OVERFLOW;
            do {
                charsetDecoderICU.charErrorBufferArray[charsetDecoderICU.charErrorBufferLength++] = cArray[n2++];
            } while (--n3 > 0);
        }
        return coderResult;
    }

    public final float maxBytesPerChar() {
        return ((CharsetICU)this.charset()).maxBytesPerChar;
    }
}

