/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CoderResult;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetDecoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetEncoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;

public class CharsetCallback {
    private static final String SUB_STOP_ON_ILLEGAL = "i";
    private static final String ESCAPE_JAVA = "J";
    private static final String ESCAPE_C = "C";
    private static final String ESCAPE_XML_DEC = "D";
    private static final String ESCAPE_XML_HEX = "X";
    private static final String ESCAPE_UNICODE = "U";
    private static final String ESCAPE_CSS2 = "S";
    public static final Encoder FROM_U_CALLBACK_SKIP = new Encoder(){

        @Override
        public CoderResult call(CharsetEncoderICU charsetEncoderICU, Object object, CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, char[] cArray, int n2, int n3, CoderResult coderResult) {
            if (object == null) {
                return CoderResult.UNDERFLOW;
            }
            if (((String)object).equals(CharsetCallback.SUB_STOP_ON_ILLEGAL)) {
                if (!coderResult.isUnmappable()) {
                    return coderResult;
                }
                return CoderResult.UNDERFLOW;
            }
            return coderResult;
        }
    };
    public static final Decoder TO_U_CALLBACK_SKIP = new Decoder(){

        @Override
        public CoderResult call(CharsetDecoderICU charsetDecoderICU, Object object, ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, char[] cArray, int n2, CoderResult coderResult) {
            if (object == null) {
                return CoderResult.UNDERFLOW;
            }
            if (((String)object).equals(CharsetCallback.SUB_STOP_ON_ILLEGAL)) {
                if (!coderResult.isUnmappable()) {
                    return coderResult;
                }
                return CoderResult.UNDERFLOW;
            }
            return coderResult;
        }
    };
    public static final Encoder FROM_U_CALLBACK_SUBSTITUTE = new Encoder(){

        @Override
        public CoderResult call(CharsetEncoderICU charsetEncoderICU, Object object, CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, char[] cArray, int n2, int n3, CoderResult coderResult) {
            if (coderResult.isUnmappable() && CharsetCallback.IS_DEFAULT_IGNORABLE_CODE_POINT(n3)) {
                return CoderResult.UNDERFLOW;
            }
            if (object == null) {
                return charsetEncoderICU.cbFromUWriteSub(charsetEncoderICU, charBuffer, byteBuffer, intBuffer);
            }
            if (((String)object).equals(CharsetCallback.SUB_STOP_ON_ILLEGAL)) {
                if (!coderResult.isUnmappable()) {
                    return coderResult;
                }
                return charsetEncoderICU.cbFromUWriteSub(charsetEncoderICU, charBuffer, byteBuffer, intBuffer);
            }
            return coderResult;
        }
    };
    private static final char[] kSubstituteChar1 = new char[]{'\u001a'};
    private static final char[] kSubstituteChar = new char[]{'\ufffd'};
    public static final Decoder TO_U_CALLBACK_SUBSTITUTE = new Decoder(){

        @Override
        public CoderResult call(CharsetDecoderICU charsetDecoderICU, Object object, ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, char[] cArray, int n2, CoderResult coderResult) {
            CharsetICU charsetICU = (CharsetICU)charsetDecoderICU.charset();
            boolean bl2 = true;
            char[] cArray2 = charsetDecoderICU.replacement().toCharArray();
            if (cArray2.length == 1 && (cArray2[0] == kSubstituteChar1[0] || cArray2[0] == kSubstituteChar[0])) {
                bl2 = false;
            }
            if (charsetDecoderICU.invalidCharLength == 1 && charsetICU.subChar1 != 0) {
                return CharsetDecoderICU.toUWriteUChars(charsetDecoderICU, bl2 ? cArray2 : kSubstituteChar1, 0, bl2 ? cArray2.length : 1, charBuffer, intBuffer, byteBuffer.position());
            }
            return CharsetDecoderICU.toUWriteUChars(charsetDecoderICU, bl2 ? cArray2 : kSubstituteChar, 0, bl2 ? cArray2.length : 1, charBuffer, intBuffer, byteBuffer.position());
        }
    };
    public static final Encoder FROM_U_CALLBACK_STOP = new Encoder(){

        @Override
        public CoderResult call(CharsetEncoderICU charsetEncoderICU, Object object, CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, char[] cArray, int n2, int n3, CoderResult coderResult) {
            if (coderResult.isUnmappable() && CharsetCallback.IS_DEFAULT_IGNORABLE_CODE_POINT(n3)) {
                return CoderResult.UNDERFLOW;
            }
            return coderResult;
        }
    };
    public static final Decoder TO_U_CALLBACK_STOP = new Decoder(){

        @Override
        public CoderResult call(CharsetDecoderICU charsetDecoderICU, Object object, ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, char[] cArray, int n2, CoderResult coderResult) {
            return coderResult;
        }
    };
    private static final int VALUE_STRING_LENGTH = 32;
    private static final char UNICODE_PERCENT_SIGN_CODEPOINT = '%';
    private static final char UNICODE_U_CODEPOINT = 'U';
    private static final char UNICODE_X_CODEPOINT = 'X';
    private static final char UNICODE_RS_CODEPOINT = '\\';
    private static final char UNICODE_U_LOW_CODEPOINT = 'u';
    private static final char UNICODE_X_LOW_CODEPOINT = 'x';
    private static final char UNICODE_AMP_CODEPOINT = '&';
    private static final char UNICODE_HASH_CODEPOINT = '#';
    private static final char UNICODE_SEMICOLON_CODEPOINT = ';';
    private static final char UNICODE_PLUS_CODEPOINT = '+';
    private static final char UNICODE_LEFT_CURLY_CODEPOINT = '{';
    private static final char UNICODE_RIGHT_CURLY_CODEPOINT = '}';
    private static final char UNICODE_SPACE_CODEPOINT = ' ';
    public static final Encoder FROM_U_CALLBACK_ESCAPE = new Encoder(){

        @Override
        public CoderResult call(CharsetEncoderICU charsetEncoderICU, Object object, CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, char[] cArray, int n2, int n3, CoderResult coderResult) {
            char[] cArray2 = new char[32];
            int n4 = 0;
            int n5 = 0;
            if (coderResult.isUnmappable() && CharsetCallback.IS_DEFAULT_IGNORABLE_CODE_POINT(n3)) {
                return CoderResult.UNDERFLOW;
            }
            if (object == null || !(object instanceof String)) {
                while (n5 < n2) {
                    cArray2[n4++] = 37;
                    cArray2[n4++] = 85;
                    n4 += CharsetCallback.itou(cArray2, n4, cArray[n5++], 16, 4);
                }
            } else if (((String)object).equals(CharsetCallback.ESCAPE_JAVA)) {
                while (n5 < n2) {
                    cArray2[n4++] = 92;
                    cArray2[n4++] = 117;
                    n4 += CharsetCallback.itou(cArray2, n4, cArray[n5++], 16, 4);
                }
            } else if (((String)object).equals(CharsetCallback.ESCAPE_C)) {
                cArray2[n4++] = 92;
                if (n2 == 2) {
                    cArray2[n4++] = 85;
                    n4 = CharsetCallback.itou(cArray2, n4, n3, 16, 8);
                } else {
                    cArray2[n4++] = 117;
                    n4 += CharsetCallback.itou(cArray2, n4, cArray[0], 16, 4);
                }
            } else if (((String)object).equals(CharsetCallback.ESCAPE_XML_DEC)) {
                cArray2[n4++] = 38;
                cArray2[n4++] = 35;
                n4 = n2 == 2 ? (n4 += CharsetCallback.itou(cArray2, n4, n3, 10, 0)) : (n4 += CharsetCallback.itou(cArray2, n4, cArray[0], 10, 0));
                cArray2[n4++] = 59;
            } else if (((String)object).equals(CharsetCallback.ESCAPE_XML_HEX)) {
                cArray2[n4++] = 38;
                cArray2[n4++] = 35;
                cArray2[n4++] = 120;
                n4 = n2 == 2 ? (n4 += CharsetCallback.itou(cArray2, n4, n3, 16, 0)) : (n4 += CharsetCallback.itou(cArray2, n4, cArray[0], 16, 0));
                cArray2[n4++] = 59;
            } else if (((String)object).equals(CharsetCallback.ESCAPE_UNICODE)) {
                cArray2[n4++] = 123;
                cArray2[n4++] = 85;
                cArray2[n4++] = 43;
                n4 = n2 == 2 ? (n4 += CharsetCallback.itou(cArray2, n4, n3, 16, 4)) : (n4 += CharsetCallback.itou(cArray2, n4, cArray[0], 16, 4));
                cArray2[n4++] = 125;
            } else if (((String)object).equals(CharsetCallback.ESCAPE_CSS2)) {
                cArray2[n4++] = 92;
                n4 += CharsetCallback.itou(cArray2, n4, n3, 16, 0);
                cArray2[n4++] = 32;
            } else {
                while (n5 < n2) {
                    cArray2[n4++] = 37;
                    cArray2[n4++] = 85;
                    n4 += CharsetCallback.itou(cArray2, n4, cArray[n5++], 16, 4);
                }
            }
            return charsetEncoderICU.cbFromUWriteUChars(charsetEncoderICU, CharBuffer.wrap(cArray2, 0, n4), byteBuffer, intBuffer);
        }
    };
    public static final Decoder TO_U_CALLBACK_ESCAPE = new Decoder(){

        @Override
        public CoderResult call(CharsetDecoderICU charsetDecoderICU, Object object, ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, char[] cArray, int n2, CoderResult coderResult) {
            char[] cArray2 = new char[32];
            int n3 = 0;
            int n4 = 0;
            if (object == null || !(object instanceof String)) {
                while (n4 < n2) {
                    cArray2[n3++] = 37;
                    cArray2[n3++] = 88;
                    n3 += CharsetCallback.itou(cArray2, n3, cArray[n4++] & 0xFF, 16, 2);
                }
            } else if (((String)object).equals(CharsetCallback.ESCAPE_XML_DEC)) {
                while (n4 < n2) {
                    cArray2[n3++] = 38;
                    cArray2[n3++] = 35;
                    n3 += CharsetCallback.itou(cArray2, n3, cArray[n4++] & 0xFF, 10, 0);
                    cArray2[n3++] = 59;
                }
            } else if (((String)object).equals(CharsetCallback.ESCAPE_XML_HEX)) {
                while (n4 < n2) {
                    cArray2[n3++] = 38;
                    cArray2[n3++] = 35;
                    cArray2[n3++] = 120;
                    n3 += CharsetCallback.itou(cArray2, n3, cArray[n4++] & 0xFF, 16, 0);
                    cArray2[n3++] = 59;
                }
            } else if (((String)object).equals(CharsetCallback.ESCAPE_C)) {
                while (n4 < n2) {
                    cArray2[n3++] = 92;
                    cArray2[n3++] = 120;
                    n3 += CharsetCallback.itou(cArray2, n3, cArray[n4++] & 0xFF, 16, 2);
                }
            } else {
                while (n4 < n2) {
                    cArray2[n3++] = 37;
                    cArray2[n3++] = 88;
                    CharsetCallback.itou(cArray2, n3, cArray[n4++] & 0xFF, 16, 2);
                    n3 += 2;
                }
            }
            coderResult = CharsetDecoderICU.toUWriteUChars(charsetDecoderICU, cArray2, 0, n3, charBuffer, intBuffer, 0);
            return coderResult;
        }
    };

    private static boolean IS_DEFAULT_IGNORABLE_CODE_POINT(int n2) {
        return n2 == 173 || n2 == 847 || n2 == 1564 || n2 == 4447 || n2 == 4448 || 6068 <= n2 && n2 <= 6069 || 6155 <= n2 && n2 <= 6159 || 8203 <= n2 && n2 <= 8207 || 8234 <= n2 && n2 <= 8238 || 8288 <= n2 && n2 <= 8303 || n2 == 12644 || 65024 <= n2 && n2 <= 65039 || n2 == 65279 || n2 == 65440 || 65520 <= n2 && n2 <= 65528 || 113824 <= n2 && n2 <= 113827 || 119155 <= n2 && n2 <= 119162 || 917504 <= n2 && n2 <= 921599;
    }

    private static final int itou(char[] cArray, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        do {
            int n7 = n3 % n4;
            cArray[n2 + n6++] = (char)(n7 <= 9 ? 48 + n7 : 48 + n7 + 7);
        } while ((n3 /= n4) != 0 && n2 + n6 < cArray.length);
        while (n6 < n5) {
            cArray[n2 + n6++] = 48;
        }
        for (int i2 = 0; i2 < n6 / 2; ++i2) {
            char c2 = cArray[n2 + n6 - 1 - i2];
            cArray[n2 + n6 - 1 - i2] = cArray[n2 + i2];
            cArray[n2 + i2] = c2;
        }
        return n6;
    }

    private CharsetCallback() {
    }

    public static interface Encoder {
        public CoderResult call(CharsetEncoderICU var1, Object var2, CharBuffer var3, ByteBuffer var4, IntBuffer var5, char[] var6, int var7, int var8, CoderResult var9);
    }

    public static interface Decoder {
        public CoderResult call(CharsetDecoderICU var1, Object var2, ByteBuffer var3, CharBuffer var4, IntBuffer var5, char[] var6, int var7, CoderResult var8);
    }
}

