/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetDecoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetEncoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class CharsetASCII
extends CharsetICU {
    protected byte[] fromUSubstitution = new byte[]{26};

    public CharsetASCII(String string, String string2, String[] stringArray) {
        super(string, string2, stringArray);
        this.maxBytesPerChar = 1;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderASCII(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderASCII(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet unicodeSet, int n2) {
        unicodeSet.add(0, 127);
    }

    class CharsetEncoderASCII
    extends CharsetEncoderICU {
        private static final int NEED_TO_WRITE_BOM = 1;

        public CharsetEncoderASCII(CharsetICU charsetICU) {
            super(charsetICU, CharsetASCII.this.fromUSubstitution);
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.fromUnicodeStatus = 1;
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            int n2;
            CoderResult coderResult;
            if (!charBuffer.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!byteBuffer.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            int n3 = charBuffer.position();
            int n4 = byteBuffer.position();
            if (this.fromUChar32 != 0) {
                coderResult = this.encodeTrail(charBuffer, (char)this.fromUChar32, bl2);
            } else if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                char[] cArray = charBuffer.array();
                n2 = charBuffer.arrayOffset();
                int n10 = n3 + n2;
                int n11 = charBuffer.limit() - n3;
                byte[] byArray = byteBuffer.array();
                coderResult = this.encodeLoopCoreOptimized(charBuffer, byteBuffer, cArray, byArray, n10, n9 = (n8 = n4 + (n7 = byteBuffer.arrayOffset())) - n10, n6 = (n11 < (n5 = byteBuffer.limit() - n4) ? n11 : n5) + n10, bl2);
                if (coderResult == null) {
                    if (n11 <= n5) {
                        charBuffer.position(n3 + n11);
                        byteBuffer.position(n4 + n11);
                        coderResult = CoderResult.UNDERFLOW;
                    } else {
                        charBuffer.position(n3 + n5);
                        byteBuffer.position(n4 + n5);
                        coderResult = CoderResult.OVERFLOW;
                    }
                }
            } else {
                coderResult = this.encodeLoopCoreUnoptimized(charBuffer, byteBuffer, bl2);
                if (coderResult == CoderResult.OVERFLOW) {
                    charBuffer.position(charBuffer.position() - 1);
                }
            }
            if (intBuffer != null) {
                int n12 = byteBuffer.position() - n4;
                n2 = -1;
                while (--n12 >= 0) {
                    intBuffer.put(++n2);
                }
            }
            return coderResult;
        }

        protected CoderResult encodeLoopCoreOptimized(CharBuffer charBuffer, ByteBuffer byteBuffer, char[] cArray, byte[] byArray, int n2, int n3, int n4, boolean bl2) {
            int n5;
            int n6 = 0;
            for (n5 = n2; n5 < n4 && ((n6 = cArray[n5]) & 0xFF80) == 0; ++n5) {
                byArray[n5 + n3] = (byte)n6;
            }
            if ((n6 & 0xFF80) != 0) {
                charBuffer.position(n5 + 1 - charBuffer.arrayOffset());
                byteBuffer.position(n5 + n3);
                return this.encodeMalformedOrUnmappable(charBuffer, n6, bl2);
            }
            return null;
        }

        protected CoderResult encodeLoopCoreUnoptimized(CharBuffer charBuffer, ByteBuffer byteBuffer, boolean bl2) {
            while (charBuffer.hasRemaining()) {
                char c2 = charBuffer.get();
                if ((c2 & 0xFF80) == 0) {
                    if (byteBuffer.hasRemaining()) {
                        byteBuffer.put((byte)c2);
                        continue;
                    }
                    return CoderResult.OVERFLOW;
                }
                return this.encodeMalformedOrUnmappable(charBuffer, c2, bl2);
            }
            return CoderResult.UNDERFLOW;
        }

        protected final CoderResult encodeMalformedOrUnmappable(CharBuffer charBuffer, int n2, boolean bl2) {
            return UTF16.isSurrogate(n2) ? this.encodeTrail(charBuffer, (char)n2, bl2) : CoderResult.unmappableForLength(1);
        }

        private final CoderResult encodeTrail(CharBuffer charBuffer, char c2, boolean bl2) {
            CoderResult coderResult = this.handleSurrogates(charBuffer, c2);
            if (coderResult != null) {
                return coderResult;
            }
            return CoderResult.unmappableForLength(2);
        }
    }

    class CharsetDecoderASCII
    extends CharsetDecoderICU {
        public CharsetDecoderASCII(CharsetICU charsetICU) {
            super(charsetICU);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            CoderResult coderResult;
            int n2;
            if (!byteBuffer.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!charBuffer.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            int n3 = byteBuffer.position();
            int n4 = charBuffer.position();
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                byte[] byArray = byteBuffer.array();
                n2 = byteBuffer.arrayOffset();
                int n10 = n3 + n2;
                int n11 = byteBuffer.limit() - n3;
                char[] cArray = charBuffer.array();
                coderResult = this.decodeLoopCoreOptimized(byteBuffer, charBuffer, byArray, cArray, n10, n9 = (n8 = n4 + (n7 = charBuffer.arrayOffset())) - n10, n6 = (n11 < (n5 = charBuffer.limit() - n4) ? n11 : n5) + n10);
                if (coderResult == null) {
                    if (n11 <= n5) {
                        byteBuffer.position(n3 + n11);
                        charBuffer.position(n4 + n11);
                        coderResult = CoderResult.UNDERFLOW;
                    } else {
                        byteBuffer.position(n3 + n5);
                        charBuffer.position(n4 + n5);
                        coderResult = CoderResult.OVERFLOW;
                    }
                }
            } else {
                coderResult = this.decodeLoopCoreUnoptimized(byteBuffer, charBuffer);
                if (coderResult == CoderResult.OVERFLOW) {
                    byteBuffer.position(byteBuffer.position() - 1);
                }
            }
            if (intBuffer != null) {
                int n12 = charBuffer.position() - n4;
                n2 = -1;
                while (--n12 >= 0) {
                    intBuffer.put(++n2);
                }
            }
            return coderResult;
        }

        protected CoderResult decodeLoopCoreOptimized(ByteBuffer byteBuffer, CharBuffer charBuffer, byte[] byArray, char[] cArray, int n2, int n3, int n4) {
            int n5;
            int n6 = 0;
            for (n5 = n2; n5 < n4 && ((n6 = byArray[n5] & 0xFF) & 0x80) == 0; ++n5) {
                cArray[n5 + n3] = (char)n6;
            }
            if ((n6 & 0x80) != 0) {
                byteBuffer.position(n5 + 1);
                charBuffer.position(n5 + n3);
                return this.decodeMalformedOrUnmappable(n6);
            }
            return null;
        }

        protected CoderResult decodeLoopCoreUnoptimized(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n2 = 0;
            while (byteBuffer.hasRemaining()) {
                n2 = byteBuffer.get() & 0xFF;
                if ((n2 & 0x80) == 0) {
                    if (charBuffer.hasRemaining()) {
                        charBuffer.put((char)n2);
                        continue;
                    }
                    return CoderResult.OVERFLOW;
                }
                return this.decodeMalformedOrUnmappable(n2);
            }
            return CoderResult.UNDERFLOW;
        }

        protected CoderResult decodeMalformedOrUnmappable(int n2) {
            this.toUBytesArray[0] = (byte)n2;
            this.toULength = 1;
            return CoderResult.malformedForLength(1);
        }
    }
}

