/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.excel;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;

public class ExcelDataFormatter {
    private boolean isDate = false;
    private boolean malformed = false;
    private boolean niy = false;
    private String colorPOSSNG;
    private String colorNEG;
    private String colorZERO;
    private DateFormat df;
    private NumberFormat nfPOSSNG;
    private NumberFormat nfNEG;
    private NumberFormat nfZERO;

    public ExcelDataFormatter(String format) {
        if (format.equalsIgnoreCase("General") || format.equalsIgnoreCase("@")) {
            this.nfPOSSNG = new DecimalFormat();
        } else {
            this.setupFormat(format + ";");
        }
    }

    private void setupFormat(String format) {
        boolean POSSNG = true;
        int NEG = 2;
        int ZERO = 3;
        boolean TUNK = false;
        boolean TDATE = true;
        int TNUM = 2;
        boolean quot = false;
        boolean square = false;
        boolean hour = false;
        boolean ampm = this.isAmPm(format);
        boolean shield = false;
        boolean end = false;
        int section = 1;
        int type = 0;
        StringBuffer cut = new StringBuffer();
        StringBuffer formatString = new StringBuffer();
        String low = format.toLowerCase();
        for (int i = 0; i < format.length(); ++i) {
            char ch = format.charAt(i);
            if (shield) {
                if (ch == '\'') {
                    formatString.append('\'');
                    formatString.append('\'');
                } else if (formatString.charAt(formatString.length() - 1) == '\'') {
                    formatString.setCharAt(formatString.length() - 1, ch);
                } else {
                    formatString.append('\'');
                    formatString.append(ch);
                }
                formatString.append('\'');
                shield = false;
                continue;
            }
            if ((quot || square) && ch != '\"' && ch != ']') {
                cut.append(ch);
                continue;
            }
            ch = Character.toLowerCase(ch);
            switch (ch) {
                case '\"': {
                    if (quot) {
                        formatString.append("'" + cut + "'");
                    } else {
                        cut = new StringBuffer();
                    }
                    quot = !quot;
                    break;
                }
                case '[': {
                    cut = new StringBuffer();
                    square = true;
                    break;
                }
                case ']': {
                    if (!square) {
                        this.malformed = true;
                        break;
                    }
                    String squared = cut.toString();
                    if (squared.length() == 1) {
                        char tl = Character.toLowerCase(squared.charAt(0));
                        if (tl == 'h' || tl == 'm' || tl == 's') {
                            if (type == 2) {
                                this.malformed = true;
                                break;
                            }
                            type = 1;
                            if (tl == 'h') {
                                formatString.append('H');
                            } else {
                                formatString.append(tl);
                            }
                            this.niy = true;
                        }
                    } else if (section == 3) {
                        this.colorZERO = squared.toUpperCase();
                    } else if (section == 2) {
                        this.colorNEG = squared.toUpperCase();
                    } else {
                        this.colorPOSSNG = squared.toUpperCase();
                    }
                    square = false;
                    break;
                }
                case 'm': {
                    if (type == 2) {
                        this.malformed = true;
                        break;
                    }
                    type = 1;
                    if (low.charAt(i + 1) == 'm') {
                        if (low.charAt(i + 2) == 'm') {
                            if (low.charAt(i + 3) == 'm') {
                                formatString.append("MMMM");
                                ++i;
                            } else {
                                formatString.append("MMM");
                            }
                            ++i;
                        } else {
                            formatString.append(hour ? "mm" : "MM");
                        }
                        ++i;
                    } else {
                        formatString.append(hour ? "m" : "M");
                    }
                    hour = false;
                    break;
                }
                case 'h': {
                    if (type == 2) {
                        this.malformed = true;
                        break;
                    }
                    type = 1;
                    if (low.charAt(i + 1) == 'h') {
                        formatString.append(ampm ? "hh" : "HH");
                        ++i;
                    } else {
                        formatString.append(ampm ? "hh" : "HH");
                    }
                    hour = true;
                    break;
                }
                case 'd': {
                    if (type == 2) {
                        this.malformed = true;
                        break;
                    }
                    type = 1;
                    if (low.charAt(i + 1) == 'd') {
                        if (low.charAt(i + 2) == 'd') {
                            if (low.charAt(i + 3) == 'd') {
                                formatString.append("EEEE");
                                ++i;
                            } else {
                                formatString.append("EEE");
                            }
                            ++i;
                        } else {
                            formatString.append("dd");
                        }
                        ++i;
                    } else {
                        formatString.append("d");
                    }
                    hour = false;
                    break;
                }
                case 'y': {
                    if (type == 2) {
                        this.malformed = true;
                        break;
                    }
                    type = 1;
                    if (low.charAt(i + 1) == 'y') {
                        if (low.charAt(i + 2) == 'y') {
                            if (low.charAt(i + 3) == 'y') {
                                formatString.append("yyyy");
                                ++i;
                            } else {
                                this.malformed = true;
                                formatString.append("yy");
                            }
                            ++i;
                        } else {
                            formatString.append("yy");
                        }
                        ++i;
                    } else {
                        this.malformed = true;
                    }
                    hour = false;
                    break;
                }
                case 'a': {
                    if (type == 2) {
                        this.malformed = true;
                        break;
                    }
                    if (format.charAt(i + 1) == '/' && low.charAt(i + 2) == 'p') {
                        formatString.append("a");
                        i += 2;
                    } else if (low.charAt(i + 1) == 'm' && format.charAt(i + 2) == '/' && low.charAt(i + 3) == 'p' && low.charAt(i + 4) == 'm') {
                        formatString.append("a");
                        i += 4;
                    } else {
                        this.malformed = true;
                    }
                    hour = false;
                    break;
                }
                case '#': {
                    if (type == 1) {
                        this.malformed = true;
                        break;
                    }
                    type = 2;
                    formatString.append('#');
                    break;
                }
                case '0': 
                case '?': {
                    if (type == 1) {
                        this.malformed = true;
                        break;
                    }
                    type = 2;
                    formatString.append('0');
                    break;
                }
                case 'e': {
                    if (type == 1) {
                        this.malformed = true;
                        break;
                    }
                    type = 2;
                    if (format.charAt(i + 1) == '+' || format.charAt(i + 1) == '-') {
                        formatString.append('E');
                        ++i;
                        break;
                    }
                    this.malformed = true;
                    break;
                }
                case '%': 
                case ',': 
                case '-': 
                case '.': 
                case ':': {
                    formatString.append(ch);
                    break;
                }
                case '_': {
                    break;
                }
                case ';': {
                    if (type == 0) {
                        type = 2;
                    }
                    end = true;
                    break;
                }
                case '/': {
                    if (type == 2) {
                        this.niy = true;
                        int j = i;
                        while (format.charAt(--j) == '?') {
                            formatString.deleteCharAt(formatString.length() - 1);
                        }
                        while (format.charAt(i + 1) == '?' || Character.isDigit(format.charAt(i + 1))) {
                            ++i;
                        }
                        break;
                    }
                    formatString.append(ch);
                    break;
                }
                case '\\': {
                    shield = true;
                    break;
                }
                default: {
                    formatString.append(ch);
                }
            }
            if (!end) continue;
            if (type == 1) {
                try {
                    this.df = new SimpleDateFormat(formatString.toString());
                }
                catch (IllegalArgumentException iae) {
                    this.df = new SimpleDateFormat();
                }
                this.isDate = true;
                return;
            }
            if (type == 2) {
                DecimalFormat nf;
                try {
                    nf = new DecimalFormat(formatString.toString());
                }
                catch (IllegalArgumentException iae) {
                    nf = new DecimalFormat();
                }
                formatString = new StringBuffer();
                if (section == 1) {
                    this.nfPOSSNG = nf;
                    section = 2;
                } else if (section == 2) {
                    this.nfNEG = nf;
                    section = 3;
                } else {
                    this.nfZERO = nf;
                    return;
                }
            }
            end = false;
        }
    }

    private boolean isAmPm(String format) {
        String f = format.toLowerCase();
        return f.contains("am/pm") || f.contains("a/p");
    }

    public String format(Date date) {
        if (this.isDate) {
            return this.df.format(date);
        }
        return this.format(HSSFDateUtil.getExcelDate((Date)date));
    }

    public String format(double number) {
        return this.format(number, false);
    }

    public String format(double number, boolean windowing) {
        if (this.isDate) {
            return this.df.format(HSSFDateUtil.getJavaDate((double)number, (boolean)windowing));
        }
        if (number < 0.0 && this.nfNEG != null) {
            return this.nfNEG.format(number);
        }
        if (number == 0.0 && this.nfZERO != null) {
            return this.nfZERO.format(number);
        }
        return this.nfPOSSNG.format(number);
    }

    public boolean isDate() {
        return this.isDate;
    }

    public boolean isMalformed() {
        return this.malformed;
    }

    public boolean isNiy() {
        return this.niy;
    }
}

