/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import macromedia.sequelink.net.EndPoint;
import macromedia.sequelink.net.NetMessage;
import macromedia.sequelink.net.NetworkException;

class SocketEndPoint
implements EndPoint {
    private Socket socket;

    SocketEndPoint(String string, int n) throws NetworkException {
        try {
            this.socket = new Socket(string, n);
        }
        catch (UnknownHostException unknownHostException) {
            NetworkException networkException = SocketEndPoint.MakeException(unknownHostException.toString(), 7622);
            throw networkException;
        }
        catch (ConnectException connectException) {
            NetworkException networkException = SocketEndPoint.MakeException(connectException.toString(), 7627);
            throw networkException;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            NetworkException networkException = SocketEndPoint.MakeException(noRouteToHostException.toString(), 7628);
            throw networkException;
        }
        catch (IOException iOException) {
            NetworkException networkException = SocketEndPoint.MakeException(iOException.toString(), 7625);
            throw networkException;
        }
        try {
            this.socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            NetworkException networkException = SocketEndPoint.MakeException(socketException.toString(), 7631);
            throw networkException;
        }
    }

    SocketEndPoint(InetAddress inetAddress, int n) throws NetworkException {
        try {
            this.socket = new Socket(inetAddress, n);
        }
        catch (UnknownHostException unknownHostException) {
            NetworkException networkException = SocketEndPoint.MakeException(unknownHostException.toString(), 7623);
            throw networkException;
        }
        catch (ConnectException connectException) {
            NetworkException networkException = SocketEndPoint.MakeException(connectException.toString(), 7627);
            throw networkException;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            NetworkException networkException = SocketEndPoint.MakeException(noRouteToHostException.toString(), 7628);
            throw networkException;
        }
        catch (IOException iOException) {
            NetworkException networkException = SocketEndPoint.MakeException(iOException.toString(), 7625);
            throw networkException;
        }
    }

    SocketEndPoint(Socket socket) {
        this.socket = socket;
    }

    public InputStream getInputStream() throws NetworkException {
        try {
            return this.socket.getInputStream();
        }
        catch (IOException iOException) {
            NetworkException networkException = SocketEndPoint.MakeException(iOException.toString(), 7624);
            throw networkException;
        }
        catch (NullPointerException nullPointerException) {
            throw SocketEndPoint.MakeException(7621);
        }
    }

    public OutputStream getOutputStream() throws NetworkException {
        try {
            return this.socket.getOutputStream();
        }
        catch (IOException iOException) {
            NetworkException networkException = SocketEndPoint.MakeException(iOException.toString(), 7624);
            throw networkException;
        }
        catch (NullPointerException nullPointerException) {
            throw SocketEndPoint.MakeException(7621);
        }
    }

    public InetAddress getInetAddress() {
        try {
            return this.socket.getInetAddress();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public int getPort() {
        try {
            return this.socket.getPort();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public InetAddress getLocalAddress() {
        try {
            return this.socket.getLocalAddress();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public int getLocalPort() {
        try {
            return this.socket.getLocalPort();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public void setTimeout(int n) throws NetworkException {
        try {
            this.socket.setSoTimeout(n * 1000);
        }
        catch (SocketException socketException) {
            NetworkException networkException = SocketEndPoint.MakeException(socketException.toString(), 7632);
            throw networkException;
        }
    }

    public void close() throws NetworkException {
        if (this.socket == null) {
            throw SocketEndPoint.MakeException(7621);
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            NetworkException networkException = SocketEndPoint.MakeException(iOException.toString(), 7626);
            throw networkException;
        }
    }

    public void setDebugStream(OutputStream outputStream) throws NetworkException {
    }

    static NetworkException MakeException(String string, int n) {
        NetworkException networkException = NetMessage.Message.getNetworkException(n);
        NetworkException networkException2 = new NetworkException("[SOCKET]" + string);
        networkException.setNextException(networkException2);
        return networkException;
    }

    static NetworkException MakeException(int n) {
        return NetMessage.Message.getNetworkException(n);
    }
}

