/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import java.sql.SQLException;

public class NetworkException
extends Exception {
    static final String MESSAGE_PREFIX = "[Macromedia][SequeLink JDBC Driver]";
    static final String DEFAULT_STATE = "HY000";
    private int code;
    private String sqlState;
    private NetworkException next;
    private NetworkException last;

    public NetworkException(String string, String string2, int n) {
        super(string);
        this.sqlState = string2;
        this.code = n;
    }

    public NetworkException(String string) {
        this(string, DEFAULT_STATE, 0);
    }

    public int getErrorCode() {
        return this.code;
    }

    public String getSQLState() {
        return this.sqlState;
    }

    public NetworkException getNextException() {
        return this.next;
    }

    public synchronized void setNextException(NetworkException networkException) {
        if (this.last == null) {
            this.last = this;
        }
        this.last.next = networkException;
        this.last = networkException;
    }

    public String toString() {
        NetworkException networkException = this;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            String string = networkException.getClass().getName();
            String string2 = networkException.getMessage();
            stringBuffer.append(string2 != null ? string + ": " + string2 : string);
            networkException = networkException.getNextException();
            if (networkException == null) continue;
            stringBuffer.append(System.getProperty("line.separator"));
        } while (networkException != null);
        return stringBuffer.toString();
    }

    public SQLException toSqlException() {
        SQLException sQLException = new SQLException(MESSAGE_PREFIX + this.getMessage(), this.sqlState, this.code);
        for (NetworkException networkException = this.next; networkException != null; networkException = networkException.getNextException()) {
            SQLException sQLException2 = new SQLException(networkException.getMessage(), networkException.getSQLState(), networkException.getErrorCode());
            sQLException.setNextException(sQLException2);
        }
        return sQLException;
    }
}

