/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.report.CFExprEvaluator;
import coldfusion.runtime.report.CalcScope;
import coldfusion.runtime.report.ParamScope;
import coldfusion.runtime.report.QueryScope;
import coldfusion.runtime.report.Report;
import coldfusion.sql.DataSrcImpl;
import coldfusion.sql.QueryTable;
import jakarta.servlet.jsp.PageContext;
import java.io.File;
import java.sql.ResultSet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRSubreportRunResult;

public abstract class JRSubreportRunnable
implements Runnable {
    private final JRFillSubreport fillSubreport;
    private Throwable error;
    private boolean running;
    private final JRBaseFiller subreportFiller;

    protected JRSubreportRunnable(JRFillSubreport fillSubreport, JRBaseFiller subreportFiller) {
        this.fillSubreport = fillSubreport;
        this.subreportFiller = subreportFiller;
    }

    protected JRSubreportRunResult runResult() {
        return new JRSubreportRunResult(!this.running, this.error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        this.error = null;
        LocalScope reportScope = new LocalScope();
        ParamScope paramScope = new ParamScope();
        reportScope.bindInternal("PARAM", (Object)paramScope);
        CalcScope calcScope = new CalcScope();
        if (this.fillSubreport.getSubreportQueries() != null) {
            CFLogs.REPORT_LOG.debug((Object)"sub report queries exists!");
            paramScope.setChartQueries(this.fillSubreport.getSubreportQueries());
        }
        reportScope.bindInternal("CALC", (Object)calcScope);
        FusionContext context = this.fillSubreport.getCFFusionContext();
        FusionContext.setCurrent((FusionContext)context);
        FusionContext.FusionContextData data = null;
        try {
            data = context.createContextData(null, null, null);
            FusionContext.setCurrent((FusionContext)data.getContext());
            data.getContext().application = data.getOldContext().application;
            data.getContext().SymTab_initForRequest(false);
            data.getContext().hiddenScope = new LocalScope();
            data.getContext().hiddenScope.cloneScope(data.getOldContext().hiddenScope);
            Report report = this.fillSubreport.getCFReport();
            data.getContext().pageContext = report.setupScopesForSubReport(data.getContext().pageContext, data.getContext());
            TemplateProxy reportCFC = report.getReportCFC();
            if (reportCFC != null) {
                reportScope.bindInternal("REPORT", (Object)reportCFC);
            }
            NeoPageContext pageContext = data.getContext().pageContext;
            CFLogs.REPORT_LOG.debug((Object)("CFR_PATH is: " + reportCFC.page.getPagePath()));
            reportScope.bindInternal("CFR_PATH", (Object)new File(reportCFC.page.getPagePath()).getParent());
            ResultSet tempRS = this.fillSubreport.getQuery();
            try {
                if (this.subreportFiller.isDebugEnabled()) {
                    System.err.println("Push report Scopes");
                }
                pageContext.pushNewFunctionLocalScope(reportScope);
                if (tempRS == null) {
                    try {
                        tempRS = (ResultSet)reportCFC.invoke("GetQueryObject", new Object[]{this.fillSubreport.getCaseInsensitiveParameterValues()}, (PageContext)pageContext);
                    }
                    catch (TemplateProxy.InvalidMethodNameException ex) {
                        tempRS = null;
                    }
                    catch (Throwable t) {
                        CFLogs.REPORT_LOG.debug((Object)("Error caught!. Thread is " + Thread.currentThread().getId()));
                        t.printStackTrace();
                        throw new Report.ExecutingSubReportQueryException(reportCFC.page.getPagePath(), t);
                    }
                }
                QueryScope queryScope = new QueryScope(tempRS);
                reportScope.bindInternal("QUERY", (Object)queryScope);
                if (tempRS instanceof QueryTable) {
                    FusionContext.getCurrent().pageContext.pushQueryScope((QueryTable)tempRS);
                }
                try {
                    JRDataSource ds = tempRS == null ? new JREmptyDataSource() : new JRResultSetDataSource(tempRS);
                    if (this.subreportFiller.calculator.getEvaluator() instanceof CFExprEvaluator) {
                        CFExprEvaluator e = (CFExprEvaluator)this.subreportFiller.calculator.getEvaluator();
                        e.resetPageContext(pageContext);
                        calcScope.setCalc(e);
                        queryScope.setCalc(e);
                        paramScope.setCalc(e);
                    }
                    CFLogs.REPORT_LOG.debug((Object)("Sub Report Filler Thread from parent Thread " + Thread.currentThread().getId() + " will be called now."));
                    this.fillSubreport.fillSubreport(ds);
                }
                catch (JRFillInterruptedException e) {
                    CFLogs.REPORT_LOG.debug((Object)("Report Filler Thread " + Thread.currentThread().getId() + " is interrupted."));
                }
                finally {
                    if (tempRS instanceof QueryTable) {
                        FusionContext.getCurrent().pageContext.popQueryScope();
                    }
                }
            }
            finally {
                if (this.subreportFiller.isDebugEnabled()) {
                    System.err.println("Pop report scopes");
                }
                pageContext.popFunctionLocalScope();
            }
        }
        catch (Throwable t) {
            CFLogs.REPORT_LOG.error((Object)("Some error occurred at Thread " + Thread.currentThread().getId()), t);
            this.error = t;
        }
        finally {
            DataSrcImpl.clearSqlProxy();
            if (data != null) {
                FusionContext.setCurrent((FusionContext)data.getOldContext());
            }
        }
        this.running = false;
    }

    protected boolean isRunning() {
        return this.running;
    }
}

