/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.storage;

import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STAttribute;
import com.lotus.sametime.storage.StorageEvent;
import com.lotus.sametime.storage.StorageImpl;
import com.lotus.sametime.storage.StorageService;
import com.lotus.sametime.storage.StorageServiceListener;
import com.lotus.sametime.storage.TimeoutThread;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StorageComp
extends STComp
implements StorageService {
    private StorageImpl m_impl = null;
    private Vector m_storageListeners = new Vector();
    private int m_timeout = 60000;
    private TimeoutThread m_timeoutThread;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.storage");

    public StorageComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.storage.StorageComp", sTSession);
        this.m_impl = new StorageImpl(sTSession);
        sTSession.registerComponent(this.getName(), this);
    }

    protected void start() {
    }

    protected void stop() {
    }

    public Integer queryAttr(int n) {
        Vector<Integer> vector = new Vector<Integer>(1);
        vector.addElement(new Integer(n));
        return this.queryAttrList(vector);
    }

    public Integer queryAttrList(Vector vector) {
        Integer n = StorageComp.getUniqueId();
        StorageEvent storageEvent = new StorageEvent(this, vector, 2, n, null);
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "queryAttrList", "StorageComp.queryAttrList : Send Event");
        }
        this.sendEvent(storageEvent);
        return n;
    }

    public Integer storeAttr(STAttribute sTAttribute) {
        Vector<STAttribute> vector = new Vector<STAttribute>(1);
        vector.addElement(sTAttribute);
        return this.storeAttrList(vector);
    }

    public Integer storeAttrList(Vector vector) {
        Integer n = StorageComp.getUniqueId();
        StorageEvent storageEvent = new StorageEvent(this, vector, 1, n, null);
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.logp(Level.FINEST, this.getClass().getName(), "storeAttrList", "StorageComp.storeAttrList : Send Event");
        }
        this.sendEvent(storageEvent);
        return n;
    }

    void checkTimeout() {
        StorageEvent storageEvent = new StorageEvent(this, 3);
        storageEvent.m_timeout = this.m_timeout;
        this.sendEvent(storageEvent);
    }

    public synchronized void addStorageServiceListener(StorageServiceListener storageServiceListener) {
        Vector vector = (Vector)this.m_storageListeners.clone();
        vector.addElement(storageServiceListener);
        this.m_storageListeners = vector;
        if (this.m_impl.isServiceUp()) {
            StorageEvent storageEvent = new StorageEvent(this, 104);
            this.sendEvent(storageEvent);
        }
    }

    public synchronized void removeStorageServiceListener(StorageServiceListener storageServiceListener) {
        Vector vector = (Vector)this.m_storageListeners.clone();
        vector.removeElement(storageServiceListener);
        this.m_storageListeners = vector;
    }

    public void enableBuffering(boolean bl) {
        this.m_impl.m_enableBuffering = bl;
    }

    protected void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof StorageEvent) {
            this.dispatchEvent((StorageEvent)sTEvent);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    private void dispatchEvent(StorageEvent storageEvent) {
        Vector vector = this.m_storageListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            StorageServiceListener storageServiceListener = (StorageServiceListener)enumeration.nextElement();
            switch (storageEvent.getId()) {
                case 101: {
                    storageServiceListener.attrStored(storageEvent);
                    break;
                }
                case 102: {
                    storageServiceListener.attrQueried(storageEvent);
                    break;
                }
                case 103: {
                    storageServiceListener.serviceUnavailable(storageEvent);
                    break;
                }
                case 104: {
                    storageServiceListener.serviceAvailable(storageEvent);
                    break;
                }
                case 105: {
                    storageServiceListener.attrUpdated(storageEvent);
                }
            }
        }
    }
}

