/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.places;

import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.places.Activity;
import com.lotus.sametime.places.Place;
import com.lotus.sametime.places.PlacesEvent;
import com.lotus.sametime.places.Section;

public class PlaceEvent
extends PlacesEvent {
    static final int ENTER_PLACE = 1;
    static final int LEAVE_PLACE = 2;
    static final int ADD_ACTIVITY = 4;
    static final int INVITE_15_CLIENT = 5;
    static final int ADD_ALLOWED_USERS = 6;
    static final int REMOVE_ALLOWED_USERS = 7;
    static final int SET_ID_IN_ACTIVITY = 8;
    public static final int PLACE_ENTERED = -2147483647;
    public static final int ENTER_PLACE_FAILED = -2147483646;
    public static final int PLACE_LEFT = -2147483645;
    public static final int ACTIVITY_ADDED = -2147483642;
    public static final int ADD_ACTIVITY_FAILED = -2147483641;
    public static final int ACTIVITY_REMOVED = -2147483640;
    public static final int SECTION_ADDED = -2147483639;
    public static final int SECTION_REMOVED = -2147483638;
    public static final int INVITE_15_DECLINED = -2147483637;
    public static final int ADD_ALLOWED_USERS_FAILED = -2147483636;
    public static final int REMOVE_ALLOWED_USERS_FAILED = -2147483635;
    private Integer m_placeId;
    private Integer m_sectionId;
    private Integer m_activityId;
    private String m_displayName;
    private EncLevel m_encLevel;
    private int m_type;
    private int m_activitiesNum;
    private boolean m_addedByMe;
    private boolean m_hasWrapper;
    private int m_reason;
    private byte[] m_data;
    private String m_inviteText;
    private STUser m_invitee;
    private boolean m_autoInvite;
    private STUser[] m_allowedUsers;
    private Section m_section;
    private Activity m_activity;
    private String m_serverName;
    private short m_publishMode;
    private short m_creationMode;
    private String m_idInActivity;

    PlaceEvent(Place place, int n) {
        super(place, n);
        Debug.stAssert(n == 1);
        this.m_placeId = place.getPlaceId();
    }

    PlaceEvent(Object object, int n, Integer n2, int n3) {
        super(object, n);
        Debug.stAssert(n == 2);
        this.m_placeId = n2;
        this.m_reason = n3;
    }

    PlaceEvent(Object object, int n, int n2) {
        super(object, n);
        Debug.stAssert(n == -2147483646 || n == -2147483645 || n == -2147483636 || n == -2147483635);
        this.m_reason = n2;
    }

    PlaceEvent(Object object, int n, Section section) {
        super(object, n);
        Debug.stAssert(n == -2147483639 || n == -2147483638);
        this.m_section = section;
        this.m_sectionId = section.getMemberId();
    }

    PlaceEvent(Object object, int n, Integer n2, STUser sTUser, String string, boolean bl) {
        super(object, n);
        Debug.stAssert(n == 5);
        this.m_placeId = n2;
        this.m_invitee = sTUser;
        this.m_inviteText = string;
        this.m_autoInvite = bl;
    }

    PlaceEvent(Object object, int n, STUser sTUser, int n2) {
        super(object, n);
        Debug.stAssert(n == -2147483637);
        this.m_invitee = sTUser;
        this.m_reason = n2;
    }

    PlaceEvent(Object object, int n, Integer n2, int n3, byte[] byArray) {
        super(object, n);
        Debug.stAssert(n == 4);
        this.m_placeId = n2;
        this.m_type = n3;
        this.m_data = byArray;
    }

    PlaceEvent(Object object, int n, Integer n2, STUser[] sTUserArray) {
        super(object, n);
        Debug.stAssert(n == 6 || n == 7);
        this.m_placeId = n2;
        this.m_allowedUsers = sTUserArray;
    }

    PlaceEvent(Object object, int n, Integer n2, Integer n3, String string) {
        super(object, n);
        Debug.stAssert(n == 8);
        this.m_placeId = n2;
        this.m_activityId = n3;
        this.m_idInActivity = string;
    }

    PlaceEvent(Object object, int n, String string, Section section, EncLevel encLevel, boolean bl, boolean bl2, int n2, String string2) {
        super(object, n);
        Debug.stAssert(n == -2147483647);
        this.m_displayName = string;
        this.m_encLevel = encLevel;
        this.m_activitiesNum = n2;
        this.m_serverName = string2;
        this.m_section = section;
        this.m_publishMode = bl ? (short)0 : 1;
        this.m_creationMode = bl2 ? (short)1 : 0;
    }

    PlaceEvent(Object object, int n, Activity activity) {
        super(object, n);
        Debug.stAssert(n == -2147483642 || n == -2147483640);
        this.m_activity = activity;
        this.m_activityId = activity.getMemberId();
        this.m_type = activity.getActivityType();
        this.m_data = activity.getActivityData();
        this.m_addedByMe = activity.addedByMe();
        this.m_hasWrapper = activity.hasWrapper();
    }

    PlaceEvent(Object object, int n, int n2, int n3) {
        super(object, n);
        Debug.stAssert(n == -2147483641);
        this.m_type = n2;
        this.m_reason = n3;
    }

    public Place getPlace() {
        Object object = this.getSource();
        if (object instanceof Place) {
            return (Place)object;
        }
        return null;
    }

    public Section getSection() {
        return this.m_section;
    }

    public Activity getActivity() {
        return this.m_activity;
    }

    public int getReason() {
        return this.m_reason;
    }

    public STUser getUser() {
        return this.m_invitee;
    }

    public int getActivityType() {
        return this.m_type;
    }

    public boolean addedByMe() {
        return this.m_addedByMe;
    }

    public boolean hasWrapper() {
        return this.m_hasWrapper;
    }

    Integer getActivityId() {
        return this.m_activityId;
    }

    Integer getSectionId() {
        return this.m_sectionId;
    }

    Integer getPlaceId() {
        return this.m_placeId;
    }

    int getType() {
        return this.m_type;
    }

    String getServerName() {
        return this.m_serverName;
    }

    byte[] getData() {
        return this.m_data;
    }

    String getDisplayName() {
        return this.m_displayName;
    }

    int getActivitiesNum() {
        return this.m_activitiesNum;
    }

    String getIdInActivity() {
        return this.m_idInActivity;
    }

    EncLevel getEncLevel() {
        return this.m_encLevel;
    }

    STUser[] getAllowedUsers() {
        return this.m_allowedUsers;
    }

    short getPublishMode() {
        return this.m_publishMode;
    }

    short getCreationMode() {
        return this.m_creationMode;
    }

    boolean getAutoInvite() {
        return this.m_autoInvite;
    }

    String getInviteText() {
        return this.m_inviteText;
    }
}

