/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.tree;

import com.lotus.sametime.gdk.tooltip.STToolTip;
import com.lotus.sametime.guiutils.tree.ColumnAttributes;
import com.lotus.sametime.guiutils.tree.McTitleView;
import com.lotus.sametime.guiutils.tree.TreeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Enumeration;
import java.util.Vector;

public class McListView
extends Panel
implements ComponentListener,
STToolTip {
    private int m_nbOfLeftColumns = 0;
    private int m_nbOfRightColumns = 0;
    private McTitleView m_titleView;
    private TreeView m_treeView;
    private int m_borderSize;

    public McListView(boolean bl, Vector vector, Vector vector2) {
        this.m_borderSize = bl ? 2 : 0;
        this.setLayout(new BorderLayout());
        if (vector == null) {
            vector = new Vector();
        }
        this.m_nbOfLeftColumns = vector.size();
        if (vector2 == null) {
            vector2 = new Vector();
        }
        this.m_nbOfRightColumns = vector2.size();
        this.m_titleView = new McTitleView(this, vector, vector2);
        this.add((Component)this.m_titleView, "North");
        this.addComponentListener(this);
    }

    public McListView(boolean bl) {
        this(bl, null, null);
    }

    public void addColumn(int n, ColumnAttributes columnAttributes) {
        this.getTitleView().addColumn(n, columnAttributes);
        this.getTreeView().addColumn(n);
        if (n > 0) {
            ++this.m_nbOfRightColumns;
        } else {
            ++this.m_nbOfLeftColumns;
        }
    }

    public McTitleView getTitleView() {
        return this.m_titleView;
    }

    public TreeView getTreeView() {
        return this.m_treeView;
    }

    public void setTreeView(TreeView treeView) {
        this.m_treeView = treeView;
    }

    public int getNbOfLeftColumns() {
        return this.m_nbOfLeftColumns;
    }

    public int getNbOfRightColumns() {
        return this.m_nbOfRightColumns;
    }

    protected int getBorderSize() {
        return this.m_borderSize;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension();
        int n = 2 * this.m_borderSize + 6 * TreeView.ITEM_HEIGHT;
        int n2 = 2 * this.m_borderSize + 15 + this.m_treeView.m_minNameWidth + this.getAllColumnsWidth();
        dimension.setSize(n2, n);
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Insets getInsets() {
        Insets insets = (Insets)super.getInsets().clone();
        insets.top += this.m_borderSize;
        insets.left += this.m_borderSize;
        insets.bottom += this.m_borderSize;
        insets.right += this.m_borderSize;
        return insets;
    }

    public void paint(Graphics graphics) {
        if (this.m_borderSize > 0) {
            Insets insets = super.getInsets();
            int n = this.getSize().width - insets.left - insets.right;
            int n2 = this.getSize().height - insets.top - insets.bottom;
            graphics.setColor(Color.gray);
            for (int i = 0; i < this.m_borderSize; ++i) {
                graphics.draw3DRect(i + insets.left, i + insets.top, n - 2 * i - 1, n2 - 2 * i - 1, i < this.m_borderSize / 2);
            }
        }
    }

    protected int getAllColumnsWidth() {
        ColumnAttributes columnAttributes;
        Enumeration enumeration = this.m_titleView.getLeftTitles().elements();
        Enumeration enumeration2 = this.m_titleView.getRightTitles().elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            columnAttributes = (ColumnAttributes)enumeration.nextElement();
            n += columnAttributes.getWidth();
        }
        while (enumeration2.hasMoreElements()) {
            columnAttributes = (ColumnAttributes)enumeration2.nextElement();
            n += columnAttributes.getWidth();
        }
        return n;
    }

    protected int getNameWidth() {
        return this.m_treeView.m_nameWidth;
    }

    protected void setNameWidth(int n) {
        this.m_treeView.m_nameWidth = n;
    }

    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (dimension.width <= dimension2.width) {
            this.m_treeView.m_nameWidth = this.m_treeView.m_minNameWidth;
        } else {
            int n = dimension.width - 2 * this.m_borderSize - 15;
            this.m_treeView.m_nameWidth = n - this.getAllColumnsWidth();
        }
        this.repaint();
    }

    public Vector getToolTipComponents() {
        Vector vector = this.m_titleView.getToolTipComponents();
        if (this.m_treeView != null) {
            Vector vector2 = this.m_treeView.getToolTipComponents();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.addElement(vector2.elementAt(i));
            }
        }
        return vector;
    }

    public void setHoverBased(boolean bl) {
    }

    public boolean isHoverBased() {
        return true;
    }

    public void setToolTipText(Component component, String string) {
    }

    public String getToolTipText(Component component, Point point) {
        String string = null;
        if (component == this.m_titleView) {
            string = this.m_titleView.getToolTipText(component, point);
        } else if (component == this.m_treeView) {
            string = this.m_treeView.getToolTipText(component, point);
        }
        return string;
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }
}

