/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.tree;

import com.lotus.sametime.guiutils.tree.ContentProvider;
import com.lotus.sametime.guiutils.tree.DefaultSorter;
import com.lotus.sametime.guiutils.tree.Sorter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ColumnAttributes {
    private static int m_minColumnWidth = 30;
    private Hashtable m_attributes = new Hashtable();
    private int m_pseudoOrder;
    private ContentProvider m_provider;
    private Sorter m_sorter = new DefaultSorter();
    private String m_tooltip;
    private int m_width;

    public ColumnAttributes(int[] nArray, int n, ContentProvider contentProvider, int n2) {
        this.m_pseudoOrder = n;
        this.m_provider = contentProvider;
        this.setWidth(n2);
        for (int i = 0; null != nArray && i < nArray.length; ++i) {
            Integer n3 = new Integer(nArray[i]);
            this.m_attributes.put(n3, n3);
        }
    }

    public ColumnAttributes(int[] nArray, int n, ContentProvider contentProvider) {
        this(nArray, n, contentProvider, m_minColumnWidth);
    }

    public String getTooltipText() {
        return this.m_tooltip;
    }

    public void setTooltipText(String string) {
        this.m_tooltip = string;
    }

    public int getPseudoOrder() {
        return this.m_pseudoOrder;
    }

    public ContentProvider getProvider() {
        return this.m_provider;
    }

    public Sorter getSorter() {
        return this.m_sorter;
    }

    public void setSorter(Sorter sorter) {
        this.m_sorter = sorter;
    }

    protected int getWidth() {
        return this.m_width;
    }

    protected void setWidth(int n) {
        this.m_width = n;
        if (this.m_width < m_minColumnWidth) {
            this.m_width = m_minColumnWidth;
        }
    }

    public static int getMinColumnWidth() {
        return m_minColumnWidth;
    }

    public static void setMinColumnWidth(int n) {
        m_minColumnWidth = n;
    }

    public int getRealOrder(Vector vector) {
        int n;
        int n2 = 1;
        if (vector != null && (n = vector.indexOf(this)) == -1) {
            n = Math.abs(this.m_pseudoOrder);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ColumnAttributes columnAttributes = (ColumnAttributes)enumeration.nextElement();
                if (Math.abs(columnAttributes.m_pseudoOrder) > n) break;
                ++n2;
            }
        }
        if (this.m_pseudoOrder < 0) {
            n2 = -n2;
        }
        return n2;
    }

    public boolean containsAttribute(int n) {
        return this.m_attributes.containsKey(new Integer(n));
    }
}

