/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.sttable;

import com.lotus.sametime.guiutils.sttable.table.TableColumn;
import com.lotus.sametime.guiutils.sttable.table.TableHeader;
import com.lotus.sametime.guiutils.sttable.table.TableModel;
import com.lotus.sametime.guiutils.sttable.table.TableRenderer;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class StTable
extends Container
implements ItemSelectable {
    private TableModel tableModel;
    private TableColumn[] tableColumns = new TableColumn[0];
    private TableHeader tableHeader;
    private Container viewport;
    private int rowHeight = 18;
    private Color gridColor = Color.gray;
    private Color selectionBackground = new Color(0, 0, 128);
    private Color selectionForeground = Color.white;
    private boolean showVerticalLines = true;
    private boolean showHorizontalLines = true;
    private boolean continuousGrid = false;
    public static final int AUTO_RESIZE_OFF = 0;
    public static final int AUTO_RESIZE_NEXT_COLUMN = 1;
    public static final int AUTO_RESIZE_LAST_COLUMN = 2;
    private int autoResizeMode = 1;
    private boolean selectionAllowed = true;
    private int selectedRow = -1;
    private ItemListener itemListener;
    private ActionListener actionListener;
    private TableRenderer renderer = new TableRenderer();

    public StTable(TableModel tableModel) {
        this.tableModel = tableModel;
        this.tableHeader = new TableHeader(this);
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.setFont(new Font("Times-Roman", 0, 12));
        this.setLayout(new BorderLayout());
        this.add("North", this.tableHeader);
        final ScrollPane scrollPane = (ScrollPane)this.add("Center", new ScrollPane());
        Adjustable adjustable = scrollPane.getVAdjustable();
        if (adjustable != null) {
            adjustable.setUnitIncrement(this.rowHeight);
        }
        if ((adjustable = scrollPane.getHAdjustable()) != null) {
            adjustable.setUnitIncrement(32);
            adjustable.addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    if (StTable.this.tableHeader != null) {
                        StTable.this.tableHeader.setOffset(adjustmentEvent.getValue());
                    }
                }
            });
        }
        this.viewport = new Container(){

            public Dimension getPreferredSize() {
                int n = 0;
                if (StTable.this.autoResizeMode == 0) {
                    for (int i = 0; i < StTable.this.tableColumns.length; ++i) {
                        n += StTable.this.tableColumns[i].getWidth();
                    }
                }
                return new Dimension(n, StTable.this.rowHeight * StTable.this.tableModel.getRowCount());
            }

            public void addNotify() {
                super.addNotify();
                this.getParent().addComponentListener(new ComponentAdapter(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void componentResized(ComponentEvent componentEvent) {
                        StTable.access$600(2.access$500(this.this$1), componentEvent.getComponent().getSize().width);
                        2.access$700(this.this$1).repaint();
                    }
                });
            }

            public void paint(Graphics graphics) {
                Adjustable adjustable = scrollPane.getVAdjustable();
                int n = adjustable.getValue();
                int n2 = this.getSize().width;
                int n3 = adjustable.getVisibleAmount();
                Rectangle rectangle = graphics.getClipBounds();
                rectangle = rectangle.intersection(new Rectangle(0, n, n2, n3));
                graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                super.paint(graphics);
            }

            static /* synthetic */ StTable access$500(2 var0) {
                return var0.StTable.this;
            }

            static /* synthetic */ ScrollPane access$700(2 var0) {
                return var0.scrollPane;
            }
        };
        this.viewport.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                StTable.this.rowClicked(mouseEvent.getY() / StTable.this.rowHeight, mouseEvent.getClickCount());
            }
        });
        scrollPane.add(this.viewport);
        this.viewport.setLayout(null);
        this.initializeColumns(this.viewport);
    }

    private void rowClicked(int n, int n2) {
        if (!this.selectionAllowed || n >= this.tableModel.getRowCount()) {
            return;
        }
        int n3 = this.selectedRow;
        this.setSelectedRow(n);
        if (this.itemListener != null) {
            if (n3 != -1) {
                this.itemListener.itemStateChanged(new ItemEvent(this, 701, new Integer(n3), 2));
            }
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, new Integer(this.selectedRow), 1));
        }
        if (n2 > 1 && this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "" + this.selectedRow));
        }
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        int n = this.getTableModel().getColumnCount();
        Object[][] objectArray = new Object[1][n];
        for (int i = 0; i < n; ++i) {
            objectArray[0][i] = this.getTableModel().getValueAt(this.getSelectedRow(), i);
        }
        return objectArray;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        this.tableModel = tableModel;
        this.initializeColumns(this.viewport);
    }

    private void initializeColumns(Container container) {
        if (this.tableModel == null) {
            return;
        }
        int n = this.tableModel.getColumnCount();
        this.tableColumns = new TableColumn[n];
        for (int i = 0; i < n; ++i) {
            this.tableColumns[i] = new TableColumn(this, i);
            container.add(this.tableColumns[i]);
            this.tableColumns[i].setIdentifier(this.tableModel.getColumnName(i));
        }
        this.resizeAndRepaint();
    }

    public void resizeAndRepaint() {
        this.resizeColumns();
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(int n) {
        if (this.selectionAllowed) {
            int n2 = this.selectedRow;
            this.selectedRow = n;
            if (n2 != -1) {
                this.repaintRow(n2);
            }
            if (this.selectedRow != -1) {
                this.repaintRow(this.selectedRow);
            }
        }
    }

    public TableColumn getColumn(Object object) {
        for (int i = 0; i < this.tableColumns.length; ++i) {
            if (!this.tableColumns[i].getIdentifier().equals(object)) continue;
            return this.tableColumns[i];
        }
        return null;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setSelectionBackground(Color color) {
        this.selectionBackground = color;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionForeground(Color color) {
        this.selectionForeground = color;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setShowVerticalLines(boolean bl) {
        this.showVerticalLines = bl;
    }

    public boolean getShowVerticalLines() {
        return this.showVerticalLines;
    }

    public void setShowHorizontalLines(boolean bl) {
        this.showHorizontalLines = bl;
    }

    public boolean getShowHorizontalLines() {
        return this.showHorizontalLines;
    }

    public void setSelectionAllowed(boolean bl) {
        this.selectionAllowed = bl;
        this.selectedRow = -1;
    }

    public boolean getSelectionAllowed() {
        return this.selectionAllowed;
    }

    public void setAutoResizeMode(int n) {
        this.autoResizeMode = n;
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public TableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(TableHeader tableHeader) {
        if (this.tableHeader != null) {
            this.remove(this.tableHeader);
        }
        if (tableHeader != null) {
            this.tableHeader = tableHeader;
            this.add("North", this.tableHeader);
        }
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setTableRenderer(TableRenderer tableRenderer) {
        this.renderer = tableRenderer;
        this.resizeAndRepaint();
    }

    public TableRenderer getTableRenderer() {
        return this.renderer;
    }

    public void setContinuousGrid(boolean bl) {
        this.continuousGrid = bl;
    }

    public boolean getContinuousGrid() {
        return this.continuousGrid;
    }

    private void distributeColumnWidths(int n) {
        if (this.tableColumns.length == 0 || n < 50) {
            return;
        }
        if (this.autoResizeMode != 0) {
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < this.tableColumns.length; ++i) {
                n2 += this.tableColumns[i].getPreferredWidth();
                n3 += this.tableColumns[i].getMinimumWidth();
            }
            float f = (float)(n - n2) / (float)(n2 - n3);
            int n4 = 0;
            for (int i = 0; i < this.tableColumns.length - 1; ++i) {
                int n5 = this.tableColumns[i].getPreferredWidth();
                int n6 = this.tableColumns[i].getMinimumWidth();
                int n7 = n5 + (int)(f * (float)(n5 - n6));
                this.tableColumns[i].setWidth(n7);
                n4 += n7;
            }
            this.tableColumns[this.tableColumns.length - 1].setWidth(n - n4);
        }
        this.resizeColumns();
    }

    public void columnWidthChanged(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        switch (this.autoResizeMode) {
            case 0: {
                int n3 = n2 < 0 ? Math.max(n2, -this.tableColumns[n].getWidth()) : n2;
                this.tableColumns[n].setPreferredWidth(this.tableColumns[n].getWidth() + n3);
                break;
            }
            case 2: {
                int n4 = 0;
                n4 = n2 < 0 ? Math.max(n2, -this.tableColumns[n].getWidth()) : Math.min(n2, this.tableColumns[this.tableColumns.length - 1].getWidth());
                this.tableColumns[n].setPreferredWidth(this.tableColumns[n].getWidth() + n4);
                this.tableColumns[this.tableColumns.length - 1].setPreferredWidth(this.tableColumns[this.tableColumns.length - 1].getWidth() - n4);
                break;
            }
            default: {
                int n5 = 0;
                n5 = n2 < 0 ? Math.max(n2, -this.tableColumns[n].getWidth()) : Math.min(n2, this.tableColumns[n + 1].getWidth());
                this.tableColumns[n].setPreferredWidth(this.tableColumns[n].getWidth() + n5);
                this.tableColumns[n + 1].setPreferredWidth(this.tableColumns[n + 1].getWidth() - n5);
            }
        }
        this.resizeColumns();
    }

    private void resizeColumns() {
        if (this.tableModel == null) {
            System.out.println("resizeCols: null tableModel");
            return;
        }
        int n = this.tableModel.getRowCount();
        int n2 = this.rowHeight * n;
        if (this.continuousGrid) {
            n2 = Math.max(n2, this.viewport.getSize().height);
        }
        int n3 = 0;
        int[] nArray = new int[this.tableColumns.length];
        for (int i = 0; i < this.tableColumns.length; ++i) {
            nArray[i] = this.tableColumns[i].getWidth();
            this.tableColumns[i].setBounds(n3, 0, nArray[i], n2);
            n3 += nArray[i];
        }
        if (this.tableHeader != null) {
            this.tableHeader.adjustWidths(nArray);
        }
        this.validate();
        this.viewport.repaint();
    }

    protected void repaintRow(int n) {
        Graphics graphics = this.viewport.getGraphics();
        if (graphics != null) {
            graphics.setClip(0, n * this.rowHeight, this.getSize().width, this.rowHeight);
            this.viewport.paint(graphics);
        }
    }

    static /* synthetic */ void access$600(StTable stTable, int n) {
        stTable.distributeColumnWidths(n);
    }
}

