/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.chat;

import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.guiutils.chat.ChatAreaEvent;
import com.lotus.sametime.guiutils.chat.ChatAreaListener;
import com.lotus.sametime.guiutils.chat.ChatTranscript;
import com.lotus.sametime.guiutils.helpers.GraphicsHelpers;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ChatArea
extends ScrollPane {
    private ChatTranscript m_transcript;
    private Vector m_chatAreaListeners = new Vector();
    protected static Color m_urlColor = new Color(0, 128, 0);
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.guiutils.chat");

    public ChatArea(int n, Font font, int n2, ResourceBundle resourceBundle) {
        super(StaticProps.m_bAIXOS ? 1 : 0);
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "We are running on AIX = " + StaticProps.m_bAIXOS);
        }
        this.m_transcript = new ChatTranscript(this, n, font, n2, resourceBundle);
        this.add(this.m_transcript);
    }

    public ChatArea(int n, Font font, int n2, String string, String string2) {
        super(StaticProps.m_bAIXOS ? 1 : 0);
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "We are running on AIX = " + StaticProps.m_bAIXOS);
        }
        this.m_transcript = new ChatTranscript(this, n, font, n2, string, string2);
        this.add(this.m_transcript);
    }

    public ChatArea(int n, Font font, int n2) {
        super(StaticProps.m_bAIXOS ? 1 : 0);
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "<init>", "We are running on AIX = " + StaticProps.m_bAIXOS);
        }
        this.m_transcript = new ChatTranscript(this, n, font, n2, null);
        this.add(this.m_transcript);
    }

    public void addChatAreaListener(ChatAreaListener chatAreaListener) {
        this.m_chatAreaListeners.addElement(chatAreaListener);
    }

    public void removeChatAreaListener(ChatAreaListener chatAreaListener) {
        this.m_chatAreaListeners.removeElement(chatAreaListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.m_transcript.addFocusListener(focusListener);
    }

    public synchronized void write(String string, String string2, Color color) {
        boolean bl = this.isEmpty();
        this.m_transcript.addParagraph(color, string, string2);
        if (bl) {
            this.contentChanged(true);
        }
    }

    public synchronized void writeSeparator(String string, Color color) {
        boolean bl = this.isEmpty();
        this.m_transcript.addParagraph(color, "", string);
        if (bl) {
            this.contentChanged(true);
        }
    }

    public void copy() {
        this.m_transcript.copySelectionToClip();
    }

    public void selectAll() {
        this.m_transcript.requestFocus();
        this.m_transcript.selectAll();
    }

    protected void requestURL(String string) {
        ChatAreaEvent chatAreaEvent = new ChatAreaEvent(this, string);
        for (int i = 0; i < this.m_chatAreaListeners.size(); ++i) {
            ((ChatAreaListener)this.m_chatAreaListeners.elementAt(i)).chatURLClicked(chatAreaEvent);
        }
    }

    protected void statusChanged(boolean bl) {
        ChatAreaEvent chatAreaEvent = new ChatAreaEvent(this, bl, false);
        for (int i = 0; i < this.m_chatAreaListeners.size(); ++i) {
            ((ChatAreaListener)this.m_chatAreaListeners.elementAt(i)).chatAreaStatusChanged(chatAreaEvent);
        }
    }

    private void contentChanged(boolean bl) {
        ChatAreaEvent chatAreaEvent = new ChatAreaEvent(this, false, bl);
        for (int i = 0; i < this.m_chatAreaListeners.size(); ++i) {
            ((ChatAreaListener)this.m_chatAreaListeners.elementAt(i)).chatAreaContentChanged(chatAreaEvent);
        }
    }

    public String[] getAllText() {
        return this.m_transcript.getAllText();
    }

    public String getSelectedText() {
        return this.m_transcript.getSelectedText();
    }

    public void clear() {
        this.removeSelection();
        this.m_transcript.clear();
        this.contentChanged(false);
    }

    public void setURLColor(Color color) {
        m_urlColor = color;
    }

    public Insets getInsets() {
        return new Insets(2, 3, 2, 3);
    }

    public void paint(Graphics graphics) {
        GraphicsHelpers.draw3dRect(graphics, 1, 0, this.getSize().width - 1, this.getSize().height, false);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Object getEventSource() {
        return this.m_transcript;
    }

    public void removeSelection() {
        this.m_transcript.removeSelection();
    }

    public boolean isEmpty() {
        return this.m_transcript.empty();
    }

    public Dimension getPreferredSize() {
        return new Dimension(280, 90);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

