/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.filetransferui;

import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.filetransfer.FileTransfer;
import com.lotus.sametime.filetransfer.FileTransferService;
import com.lotus.sametime.filetransferui.FileTransferStatusDialog;
import com.lotus.sametime.filetransferui.FileTransferUIComp;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.STTextField;
import com.lotus.sametime.guiutils.misc.UbqDialog;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Vector;

public class SendFileDialog
extends Dialog {
    private static final short PADDING = 5;
    private static final int DEFAULT_WIDTH = 350;
    private static final int DEFAULT_HEIGHT = 300;
    private static String BUNDLE_FILE_NAME = "properties/filetransferui";
    private boolean m_isTabFromTA = false;
    private STSession m_session;
    private STUser m_receiver;
    private Frame m_parent;
    private FileTransferUIComp m_FTUIService;
    private STBundle m_resourceFile;
    private STTextField m_fileNameFld;
    private TextArea m_descrTxt;

    public SendFileDialog(Frame frame, STSession sTSession, STUser sTUser) {
        super(frame);
        this.m_parent = frame;
        this.m_session = sTSession;
        this.m_receiver = sTUser;
        this.addWindowListener(new WindowEventHandler());
        this.m_FTUIService = (FileTransferUIComp)this.m_session.getCompApi("com.lotus.sametime.filetransferui.FileTransferUIComp");
        ResourceLoaderService resourceLoaderService = (ResourceLoaderService)((Object)this.m_session.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_resourceFile = resourceLoaderService.getBundle(BUNDLE_FILE_NAME);
        this.showDialog();
    }

    private void showDialog() {
        Object[] objectArray = new String[]{this.m_receiver.getDisplayName()};
        this.setTitle(this.m_resourceFile.formatString("SEND_DLG_TITLE", objectArray));
        this.setSize(350, 300);
        this.setLayout(new BorderLayout(0, 10));
        this.setFont(Font.decode(Toolkit.getDefaultToolkit().getFontList()[0]));
        ButtonEventHandler buttonEventHandler = new ButtonEventHandler();
        Panel panel = new Panel(new BorderLayout());
        Label label = new Label(this.m_resourceFile.getString("SEND_DLG_LBL_FILE_TO_SEND"));
        panel.add((Component)label, "North");
        Panel panel2 = new Panel(new BorderLayout());
        this.m_fileNameFld = new STTextField(30);
        Button button = new Button(this.m_resourceFile.getString("SEND_DLG_BTN_BROWSE"));
        button.addActionListener(buttonEventHandler);
        panel2.add((Component)this.m_fileNameFld, "Center");
        panel2.add((Component)button, "East");
        panel.add((Component)panel2, "Center");
        Integer n = (Integer)this.m_session.getSessionProperty("fileTransferMaxFileSize");
        Object[] objectArray2 = n == -1 ? new String[]{this.m_resourceFile.getString("SEND_DLG_FILE_SIZE_UNLIMITED"), ""} : FileTransferUIComp.fileSizeToString(n, this.m_resourceFile);
        Label label2 = new Label(this.m_resourceFile.formatString("SEND_DLG_LBL_NOTE", objectArray2));
        panel.add((Component)label2, "South");
        Panel panel3 = new Panel(new BorderLayout());
        Label label3 = new Label(this.m_resourceFile.getString("SEND_DLG_LBL_DESCR"));
        this.m_descrTxt = new TextArea("", 3, 40, 1);
        this.m_descrTxt.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c == '\t') {
                    String string = SendFileDialog.this.m_descrTxt.getText();
                    SendFileDialog.this.m_descrTxt.setText(string.trim());
                    SendFileDialog.this.m_descrTxt.setCaretPosition(string.length());
                    if (SendFileDialog.this.m_isTabFromTA) {
                        SendFileDialog.this.m_descrTxt.nextFocus();
                        SendFileDialog.this.m_isTabFromTA = false;
                    } else {
                        keyEvent.consume();
                        SendFileDialog.this.m_isTabFromTA = true;
                    }
                }
            }
        });
        this.m_descrTxt.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SendFileDialog.this.m_isTabFromTA = true;
            }
        });
        panel3.add((Component)label3, "North");
        panel3.add((Component)this.m_descrTxt, "Center");
        String[] stringArray = new String[]{this.m_resourceFile.getString("SEND_DLG_BTN_SEND"), this.m_resourceFile.getString("SEND_DLG_BTN_CANCEL")};
        ButtonsPanel buttonsPanel = new ButtonsPanel(stringArray, buttonEventHandler, 2);
        Button button2 = buttonsPanel.getButton(this.m_resourceFile.getString("SEND_DLG_BTN_SEND"));
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "North");
        this.add((Component)panel3, "Center");
        this.add((Component)buttonsPanel, "South");
        Dimension dimension = this.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
        button2.requestFocus();
        this.m_fileNameFld.getCursor();
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 5, insets.left + 5, insets.bottom + 5, insets.right + 5);
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(10){

            public void executeKeyMethod() {
                Component component;
                if (StaticProps.m_JavaPlugIn && (component = SendFileDialog.this.getFocusOwner()) != null && component instanceof Button) {
                    SendFileDialog.this.handleButtonPressed((Button)component);
                }
            }
        });
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                SendFileDialog.this.dispose();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_BROWSE"))){

            public void executeKeyMethod() {
                SendFileDialog.this.browsePressed();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_SEND"))){

            public void executeKeyMethod() {
                SendFileDialog.this.sendPressed();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_TEXT_FILE_TO_SEND"))){

            public void executeKeyMethod() {
                SendFileDialog.this.m_fileNameFld.requestFocus();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_TEXT_TYPE_DESCCRIPTION"))){

            public void executeKeyMethod() {
                SendFileDialog.this.m_descrTxt.requestFocus();
            }
        });
        return new KeyHandler(vector);
    }

    private void browsePressed() {
        String string = (String)this.m_session.getSessionProperty("defaultSendDir");
        FileDialog fileDialog = new FileDialog(this.m_parent, this.m_resourceFile.getString("FILE_TO_SEND_TITLE"), 0);
        fileDialog.setDirectory(string);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            this.m_fileNameFld.setText(fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    private void sendPressed() {
        try {
            if (this.m_fileNameFld.getText().equals("")) {
                this.m_fileNameFld.selectAll();
                this.m_fileNameFld.requestFocus();
                this.m_FTUIService.showErrorMessage("PLEASE_ENTER_FILE_TITLE", "PLEASE_ENTER_FILE_TEXT", "PLEASE_ENTER_FILE_BTN_OK", true, false);
                return;
            }
            String string = this.m_fileNameFld.getText();
            int n = Math.max(string.lastIndexOf("\\"), string.lastIndexOf("/"));
            String string2 = string.substring(++n, string.length());
            if (n == 0) {
                this.m_fileNameFld.requestFocus();
                this.m_fileNameFld.selectAll();
                this.m_FTUIService.showErrorMessage("PLEASE_ENTER_FULL_PATH_TITLE", "PLEASE_ENTER_FULL_PATH_TEXT", "PLEASE_ENTER_FULL_PATH_BTN_OK", true, false);
            } else {
                String string3 = string.substring(0, --n);
                this.m_session.setSessionProperty("defaultSendDir", string3);
                File file = new File(string);
                if (file.exists()) {
                    int n2 = (Integer)this.m_session.getSessionProperty("fileTransferMaxFileSize");
                    int n3 = (int)file.length() / 1000;
                    if (n2 == -1 || n3 <= n2) {
                        FileTransferService fileTransferService = (FileTransferService)this.m_session.getCompApi("com.lotus.sametime.filetransfer.FileTransferComp");
                        FileTransfer fileTransfer = fileTransferService.createFileTransfer(this.m_receiver, new FileInputStream(string), string2, this.m_descrTxt.getText());
                        FileTransferStatusDialog fileTransferStatusDialog = new FileTransferStatusDialog(this.m_parent, this.m_session, fileTransfer, true);
                        fileTransferStatusDialog.setModal(false);
                        fileTransferStatusDialog.showDialog();
                        fileTransfer.start();
                        this.dispose();
                    } else {
                        this.m_fileNameFld.requestFocus();
                        this.m_fileNameFld.selectAll();
                        String[] stringArray = FileTransferUIComp.fileSizeToString(n3, this.m_resourceFile);
                        String[] stringArray2 = FileTransferUIComp.fileSizeToString(n2, this.m_resourceFile);
                        Object[] objectArray = new String[]{stringArray[0], stringArray[1], stringArray2[0], stringArray2[1]};
                        UbqDialog ubqDialog = new UbqDialog(this.m_parent, this.m_resourceFile.getString("FILE_TOO_LARGE_TITLE"), this.m_resourceFile.formatStringArray("FILE_TOO_LARGE_TEXT", objectArray), this.m_resourceFile.formatStringArray("FILE_TOO_LARGE_BTN_OK"));
                        ubqDialog.setModal(false);
                        ubqDialog.setVisible(true);
                    }
                } else {
                    this.m_fileNameFld.requestFocus();
                    this.m_fileNameFld.selectAll();
                    this.m_FTUIService.showErrorMessage("FILE_NOT_FOUND_TITLE", "FILE_NOT_FOUND_TEXT", "FILE_NOT_FOUND_BTN_OK", true, false);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_fileNameFld.requestFocus();
            this.m_fileNameFld.selectAll();
            fileNotFoundException.printStackTrace();
            this.m_FTUIService.showErrorMessage("FILE_NOT_FOUND_TITLE", "FILE_NOT_FOUND_TEXT", "FILE_NOT_FOUND_BTN_OK", true, false);
        }
    }

    private void handleButtonPressed(Button button) {
        Debug.stAssert(button instanceof Button);
        String string = button.getLabel();
        Debug.stAssert(string != null);
        if (string.equals(this.m_resourceFile.getString("SEND_DLG_BTN_BROWSE"))) {
            this.browsePressed();
        } else if (string.equals(this.m_resourceFile.getString("SEND_DLG_BTN_SEND"))) {
            this.sendPressed();
        } else if (string.equals(this.m_resourceFile.getString("SEND_DLG_BTN_CANCEL"))) {
            this.dispose();
        }
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            SendFileDialog.this.dispose();
        }
    }

    class ButtonEventHandler
    implements ActionListener {
        ButtonEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof Button) {
                SendFileDialog.this.handleButtonPressed((Button)object);
            }
        }
    }
}

