/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.filetransferui;

import com.lotus.sametime.chatui.ChatUI;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.filetransfer.FileTransfer;
import com.lotus.sametime.filetransfer.FileTransferEvent;
import com.lotus.sametime.filetransfer.FileTransferListener;
import com.lotus.sametime.filetransferui.FileTransferStatusDialog;
import com.lotus.sametime.filetransferui.FileTransferUIComp;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.STTextField;
import com.lotus.sametime.guiutils.misc.UbqDialog;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReceiveFileDialog
extends Frame {
    private static String BUNDLE_FILE_NAME = "properties/filetransferui";
    private static final short PADDING = 5;
    private STSession m_session;
    private FileTransfer m_fileTransfer;
    private FileTransferUIComp m_FTUIService;
    private ChatUI m_chatui;
    private Frame m_parent;
    private STBundle m_resourceFile;
    private STTextField m_fullPathFileNameTxt;
    private FileTransferEventHandler m_fTEventHandler;
    private Button m_browseBtn;
    private Button m_acceptBtn;
    private Button m_declineBtn;
    private STTextField m_fileNameFld;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.filetransferui");

    public ReceiveFileDialog(Frame frame, STSession sTSession, FileTransfer fileTransfer) {
        this.m_parent = frame;
        this.m_session = sTSession;
        this.m_fileTransfer = fileTransfer;
        this.addWindowListener(new WindowEventHandler());
        this.m_fTEventHandler = new FileTransferEventHandler();
        this.m_fileTransfer.addFileTransferListener(this.m_fTEventHandler);
        this.m_FTUIService = (FileTransferUIComp)this.m_session.getCompApi("com.lotus.sametime.filetransferui.FileTransferUIComp");
        this.m_chatui = (ChatUI)this.m_session.getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        ResourceLoaderService resourceLoaderService = (ResourceLoaderService)((Object)this.m_session.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_resourceFile = resourceLoaderService.getBundle(BUNDLE_FILE_NAME);
        this.showDialog();
        Toolkit.getDefaultToolkit().beep();
    }

    private void showDialog() {
        Object[] objectArray = new String[]{this.m_fileTransfer.getPartner().getDisplayName()};
        this.setTitle(this.m_resourceFile.formatString("RECEIVE_DLG_TITLE", objectArray));
        this.setFont(Font.decode(Toolkit.getDefaultToolkit().getFontList()[0]));
        this.setBackground(SystemColor.control);
        this.setLayout(new BorderLayout(0, 6));
        ButtonEventHandler buttonEventHandler = new ButtonEventHandler();
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new BorderLayout());
        Label label = new Label(this.m_resourceFile.getString("RECEIVE_DLG_LBL_DESCR"));
        TextArea textArea = new TextArea(this.m_fileTransfer.getFileDesc(), 3, 30);
        textArea.setEditable(false);
        textArea.setEnabled(true);
        textArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    ReceiveFileDialog.this.m_fileNameFld.requestFocus();
                }
            }
        });
        panel2.add((Component)label, "North");
        panel2.add((Component)textArea, "Center");
        panel.add((Component)panel2, "North");
        Panel panel3 = new Panel(new BorderLayout());
        Label label2 = new Label(this.m_resourceFile.getString("RECEIVE_DLG_LBL_FILE"));
        String[] stringArray = FileTransferUIComp.fileSizeToString(this.m_fileTransfer.getFileSize() / 1000, this.m_resourceFile);
        String string = this.m_fileTransfer.getFileName() + " (" + stringArray[0] + " " + stringArray[1] + ")";
        this.m_fileNameFld = new STTextField(string);
        this.m_fileNameFld.setEditable(false);
        panel3.add((Component)label2, "North");
        panel3.add((Component)this.m_fileNameFld, "Center");
        panel.add((Component)panel3, "Center");
        Panel panel4 = new Panel(new BorderLayout(0, 6));
        Label label3 = new Label(this.m_resourceFile.getString("RECEIVE_DLG_LBL_SAVE_AS"));
        panel4.add((Component)label3, "North");
        Panel panel5 = new Panel(new BorderLayout(5, 6));
        this.m_fullPathFileNameTxt = new STTextField(30);
        this.m_fullPathFileNameTxt.setText((String)this.m_session.getSessionProperty("defaultSaveDir") + System.getProperty("file.separator") + this.m_fileTransfer.getFileName());
        this.m_browseBtn = new Button(this.m_resourceFile.getString("RECEIVE_DLG_BTN_BROWSE"));
        this.m_browseBtn.addActionListener(buttonEventHandler);
        panel5.add((Component)this.m_fullPathFileNameTxt, "Center");
        panel5.add((Component)this.m_browseBtn, "East");
        panel4.add((Component)label3, "Center");
        panel4.add((Component)panel5, "South");
        String[] stringArray2 = new String[]{this.m_resourceFile.getString("RECEIVE_DLG_BTN_ACCEPT"), this.m_resourceFile.getString("RECEIVE_DLG_BTN_DECLINE")};
        ButtonsPanel buttonsPanel = new ButtonsPanel(stringArray2, buttonEventHandler, 2);
        this.m_acceptBtn = buttonsPanel.getButton(this.m_resourceFile.getString("RECEIVE_DLG_BTN_ACCEPT"));
        this.m_declineBtn = buttonsPanel.getButton(this.m_resourceFile.getString("RECEIVE_DLG_BTN_DECLINE"));
        this.add((Component)panel, "North");
        this.add((Component)panel4, "Center");
        this.add((Component)buttonsPanel, "South");
        Dimension dimension = this.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
        super.toFront();
        this.requestFocus();
        this.show();
        textArea.requestFocus();
    }

    private void browsePressed() {
        String string = (String)this.m_session.getSessionProperty("defaultSaveDir");
        FileDialog fileDialog = new FileDialog(this.m_parent, this.m_resourceFile.getString("SAVE_FILE_AS"), 1);
        fileDialog.setDirectory(string);
        fileDialog.setFile(this.m_fileTransfer.getFileName());
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            this.m_fullPathFileNameTxt.setText(fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    private void acceptPressed() {
        if (this.m_fullPathFileNameTxt.getText().equals("")) {
            this.m_FTUIService.showErrorMessage("PLEASE_ENTER_FILE_TITLE", "PLEASE_ENTER_FILE_TEXT", "PLEASE_ENTER_FILE_BTN_OK", true, false);
            return;
        }
        if (!new File(this.m_fullPathFileNameTxt.getText()).isAbsolute()) {
            this.m_FTUIService.showErrorMessage("PLEASE_ENTER_FULL_PATH_TITLE", "PLEASE_ENTER_FULL_PATH_TEXT", "PLEASE_ENTER_FULL_PATH_BTN_OK", true, false);
            return;
        }
        try {
            String string = this.m_fullPathFileNameTxt.getText();
            int n = Math.max(string.lastIndexOf("\\"), string.lastIndexOf("/"));
            String string2 = string.substring(++n, string.length());
            String string3 = string.substring(0, --n);
            this.m_session.setSessionProperty("defaultSaveDir", string3);
            File file = new File(string3);
            if (!file.exists()) {
                file.mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.m_fileTransfer.removeFileTransferListener(this.m_fTEventHandler);
            FileTransferStatusDialog fileTransferStatusDialog = new FileTransferStatusDialog(this.m_parent, this.m_session, this.m_fileTransfer, false, string);
            fileTransferStatusDialog.setModal(false);
            fileTransferStatusDialog.showDialog();
            this.m_fileTransfer.accept(fileOutputStream);
            this.dispose();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Object[] objectArray = new String[]{this.m_fullPathFileNameTxt.getText()};
            UbqDialog ubqDialog = new UbqDialog(this.m_parent, this.m_resourceFile.getString("CAN_NOT_WRITE_TO_FILE_TITLE"), this.m_resourceFile.formatStringArray("CAN_NOT_WRITE_TO_FILE_TEXT", objectArray), this.m_resourceFile.formatStringArray("CAN_NOT_WRITE_TO_FILE_BTN_OK"));
            ubqDialog.setModal(false);
            ubqDialog.setVisible(true);
        }
    }

    private void declinePressed() {
        this.m_fileTransfer.decline();
        this.m_fileTransfer.removeFileTransferListener(this.m_fTEventHandler);
        this.dispose();
    }

    private void disableDialog() {
        this.m_browseBtn.setEnabled(false);
        this.m_acceptBtn.setEnabled(false);
        this.m_declineBtn.setEnabled(false);
        this.m_fullPathFileNameTxt.setEnabled(false);
        this.setTitle(this.m_resourceFile.getString("FT_STATUS_TITLE_CANCELED"));
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 5, insets.left + 5, insets.bottom + 5, insets.right + 5);
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(10){

            public void executeKeyMethod() {
                ReceiveFileDialog.this.acceptPressed();
            }
        });
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                ReceiveFileDialog.this.declinePressed();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_BROWSE"))){

            public void executeKeyMethod() {
                ReceiveFileDialog.this.browsePressed();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_ACCEPT"))){

            public void executeKeyMethod() {
                ReceiveFileDialog.this.acceptPressed();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_DECLINE"))){

            public void executeKeyMethod() {
                ReceiveFileDialog.this.declinePressed();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_TEXT_SAVE_AS"))){

            public void executeKeyMethod() {
                ReceiveFileDialog.this.m_fullPathFileNameTxt.requestFocus();
            }
        });
        return new KeyHandler(vector);
    }

    public void toFront() {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        super.toFront();
        this.requestFocus();
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ReceiveFileDialog.this.declinePressed();
        }
    }

    class FileTransferEventHandler
    implements FileTransferListener {
        FileTransferEventHandler() {
        }

        public void fileTransferStopped(FileTransferEvent fileTransferEvent) {
            if (ReceiveFileDialog.this.m_logger.isLoggable(Level.FINER)) {
                ReceiveFileDialog.this.m_logger.logp(Level.FINER, this.getClass().getName(), "fileTransferStopped", "fileTransferStopped " + fileTransferEvent.toString());
            }
            ReceiveFileDialog.this.disableDialog();
        }

        public void fileTransferStarted(FileTransferEvent fileTransferEvent) {
            if (ReceiveFileDialog.this.m_logger.isLoggable(Level.FINER)) {
                ReceiveFileDialog.this.m_logger.logp(Level.FINER, this.getClass().getName(), "fileTransferStarted", "fileTransferStarted " + fileTransferEvent.toString());
            }
        }

        public void fileTransferCompleted(FileTransferEvent fileTransferEvent) {
            if (ReceiveFileDialog.this.m_logger.isLoggable(Level.FINER)) {
                ReceiveFileDialog.this.m_logger.logp(Level.FINER, this.getClass().getName(), "fileTransferCompleted", "fileTransferCompleted " + fileTransferEvent.toString());
            }
        }

        public void fileTransferDeclined(FileTransferEvent fileTransferEvent) {
            if (ReceiveFileDialog.this.m_logger.isLoggable(Level.FINER)) {
                ReceiveFileDialog.this.m_logger.logp(Level.FINER, this.getClass().getName(), "fileTransferDeclined", "fileTransferDeclined " + fileTransferEvent.toString());
            }
            ReceiveFileDialog.this.disableDialog();
        }

        public void bytesTransferredUpdate(FileTransferEvent fileTransferEvent) {
            if (ReceiveFileDialog.this.m_logger.isLoggable(Level.FINER)) {
                ReceiveFileDialog.this.m_logger.logp(Level.FINER, this.getClass().getName(), "bytesTransferredUpdate", "bytesTransferredUpdate " + fileTransferEvent.toString());
            }
        }
    }

    private class ButtonEventHandler
    implements ActionListener {
        private ButtonEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((Button)actionEvent.getSource()).getLabel();
            if (string == ReceiveFileDialog.this.m_resourceFile.getString("RECEIVE_DLG_BTN_BROWSE")) {
                ReceiveFileDialog.this.browsePressed();
            } else if (string == ReceiveFileDialog.this.m_resourceFile.getString("RECEIVE_DLG_BTN_ACCEPT")) {
                ReceiveFileDialog.this.acceptPressed();
            } else if (string == ReceiveFileDialog.this.m_resourceFile.getString("RECEIVE_DLG_BTN_DECLINE")) {
                ReceiveFileDialog.this.declinePressed();
            }
        }
    }
}

