/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.filetransferui;

import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.filetransfer.FileTransfer;
import com.lotus.sametime.filetransfer.FileTransferEvent;
import com.lotus.sametime.filetransfer.FileTransferListener;
import com.lotus.sametime.filetransferui.FileTransferUIComp;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.ProgressBarPanel;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileTransferStatusDialog
extends Dialog {
    private static final short PADDING = 5;
    private static String BUNDLE_FILE_NAME = "properties/filetransferui";
    private Frame m_parent;
    private STSession m_session;
    private FileTransfer m_fileTransfer;
    private STBundle m_resourceFile;
    private boolean m_isSender;
    private String m_fullFileNameToSave;
    private Button m_openBtn;
    private boolean m_showOpenButton;
    private Button m_cancelBtn;
    private Label m_transferringLbl;
    private Label m_percentLbl;
    private Checkbox m_closeWhenCompleted;
    private ProgressBarPanel m_progressBar;
    private FileTransferEventHandler m_FTEventHandler;
    private FileTransferUIComp m_FTUIService;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.filetransferui");

    public FileTransferStatusDialog(Frame frame, STSession sTSession, FileTransfer fileTransfer, boolean bl) {
        this(frame, sTSession, fileTransfer, bl, null);
    }

    public FileTransferStatusDialog(Frame frame, STSession sTSession, FileTransfer fileTransfer, boolean bl, String string) {
        super(frame);
        this.m_parent = frame;
        this.m_session = sTSession;
        this.m_fileTransfer = fileTransfer;
        this.m_isSender = bl;
        this.m_fullFileNameToSave = string;
        this.addWindowListener(new WindowEventHandler());
        this.m_FTUIService = (FileTransferUIComp)this.m_session.getCompApi("com.lotus.sametime.filetransferui.FileTransferUIComp");
        ResourceLoaderService resourceLoaderService = (ResourceLoaderService)((Object)this.m_session.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_resourceFile = resourceLoaderService.getBundle(BUNDLE_FILE_NAME);
        this.m_FTEventHandler = new FileTransferEventHandler();
        this.m_fileTransfer.addFileTransferListener(this.m_FTEventHandler);
    }

    public void showDialog() {
        String[] stringArray;
        Object object;
        this.setTitle(this.m_resourceFile.getString("FT_STATUS_TITLE"));
        this.setFont(Font.decode(Toolkit.getDefaultToolkit().getFontList()[0]));
        Panel panel = new Panel(new BorderLayout());
        if (this.m_isSender) {
            this.m_transferringLbl = new Label(this.m_resourceFile.formatString("FT_STATUS_WAITING", this.m_fileTransfer.getPartner().getName()));
        } else {
            object = new String[]{this.m_fileTransfer.getFileName(), this.m_fileTransfer.getPartner().getName()};
            this.m_transferringLbl = new Label(this.m_resourceFile.formatString("FT_STATUS_TRANSFERRING_FROM", (Object[])object));
        }
        this.m_progressBar = new ProgressBarPanel();
        panel.add((Component)this.m_transferringLbl, "North");
        panel.add((Component)this.m_progressBar, "South");
        object = new Panel(new BorderLayout());
        this.m_percentLbl = new Label();
        this.updatePercentLabel(0, 0L, this.m_fileTransfer.getFileSize());
        if (!this.m_isSender) {
            stringArray = new Label(this.m_resourceFile.formatString("FT_STATUS_DOWNLOAD_TO", this.m_fullFileNameToSave));
            ((Container)object).add((Component)stringArray, "Center");
        }
        this.m_closeWhenCompleted = new Checkbox(this.m_resourceFile.getString("FT_STATUS_CLOSE_WHEN_COMPLETED"), false);
        ((Container)object).add((Component)this.m_percentLbl, "North");
        ((Container)object).add((Component)this.m_closeWhenCompleted, "South");
        this.m_showOpenButton = true;
        if (this.m_isSender || StaticProps.m_bNSVendor) {
            this.m_showOpenButton = false;
        }
        if (!this.m_showOpenButton) {
            int n = 1;
            stringArray = new String[n];
            stringArray[0] = this.m_resourceFile.getString("FT_STATUS_BTN_CANCEL");
        } else {
            int n = 2;
            stringArray = new String[n];
            stringArray[0] = this.m_resourceFile.getString("FT_STATUS_BTN_CANCEL");
            stringArray[1] = this.m_resourceFile.getString("FT_STATUS_BTN_OPEN");
        }
        ButtonsPanel buttonsPanel = new ButtonsPanel(stringArray, new ButtonEventHandler(), 2);
        this.m_cancelBtn = buttonsPanel.getButton(this.m_resourceFile.getString("FT_STATUS_BTN_CANCEL"));
        if (this.m_showOpenButton) {
            this.m_openBtn = buttonsPanel.getButton(this.m_resourceFile.getString("FT_STATUS_BTN_OPEN"));
            this.m_openBtn.setEnabled(false);
        }
        this.add((Component)panel, "North");
        this.add((Component)object, "Center");
        this.add((Component)buttonsPanel, "South");
        Dimension dimension = this.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    private void updatePercentLabel(int n, long l, long l2) {
        String[] stringArray = FileTransferUIComp.fileSizeToString((int)l / 1000, this.m_resourceFile);
        String[] stringArray2 = FileTransferUIComp.fileSizeToString((int)l2 / 1000, this.m_resourceFile);
        Object[] objectArray = new String[]{new Integer(n).toString(), stringArray[0], stringArray[1], stringArray2[0], stringArray2[1]};
        this.m_percentLbl.setText(this.m_resourceFile.formatString("FT_STATUS_PERCENT", objectArray));
        Object[] objectArray2 = new String[]{new Integer(n).toString(), this.m_fileTransfer.getFileName()};
        this.setTitle(this.m_resourceFile.formatString("FT_STATUS_TITLE", objectArray2));
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 5, insets.left + 5, insets.bottom + 5, insets.right + 5);
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(10){

            public void executeKeyMethod() {
                FileTransferStatusDialog.this.closeDialog();
            }
        });
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                FileTransferStatusDialog.this.closeDialog();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_OPEN"))){

            public void executeKeyMethod() {
                FileTransferStatusDialog.this.openPressed();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_CHCKBOX_CLOSE_COMPLETE"))){

            public void executeKeyMethod() {
                FileTransferStatusDialog.this.m_closeWhenCompleted.requestFocus();
            }
        });
        return new KeyHandler(vector);
    }

    private void closeDialog() {
        if (this.m_cancelBtn.getLabel() == this.m_resourceFile.getString("FT_STATUS_BTN_CANCEL")) {
            this.m_fileTransfer.stop();
        }
        this.m_fileTransfer.removeFileTransferListener(this.m_FTEventHandler);
        this.dispose();
    }

    private void openPressed() {
        try {
            if (StaticProps.m_bWindowsOS) {
                String[] stringArray = new String[]{"rundll32", "url.dll,FileProtocolHandler", this.m_fullFileNameToSave};
                Runtime.getRuntime().exec(stringArray);
            } else {
                Runtime.getRuntime().exec('\"' + this.m_fullFileNameToSave + '\"');
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.m_FTUIService.showErrorMessage("CAN_NOT_OPEN_FILE_TITLE", "CAN_NOT_OPEN_FILE_TEXT", "CAN_NOT_OPEN_FILE_BTN_OK", true, false);
        }
    }

    private STUser getSender() {
        if (this.m_isSender) {
            return this.getMySTUser();
        }
        return this.m_fileTransfer.getPartner();
    }

    private STUser getReceiver() {
        if (!this.m_isSender) {
            return this.getMySTUser();
        }
        return this.m_fileTransfer.getPartner();
    }

    private STUser getMySTUser() {
        CommunityService communityService = (CommunityService)this.m_session.getCompApi("com.lotus.sametime.community.STBase");
        return communityService.getLogin().getMyUserInstance();
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            FileTransferStatusDialog.this.closeDialog();
        }
    }

    class ButtonEventHandler
    implements ActionListener {
        ButtonEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == FileTransferStatusDialog.this.m_resourceFile.getString("FT_STATUS_BTN_CANCEL") || actionEvent.getActionCommand() == FileTransferStatusDialog.this.m_resourceFile.getString("FT_STATUS_BTN_CLOSE")) {
                FileTransferStatusDialog.this.closeDialog();
            } else if (actionEvent.getActionCommand() == FileTransferStatusDialog.this.m_resourceFile.getString("FT_STATUS_BTN_OPEN")) {
                FileTransferStatusDialog.this.openPressed();
            }
        }
    }

    class FileTransferEventHandler
    implements FileTransferListener {
        FileTransferEventHandler() {
        }

        public void fileTransferStarted(FileTransferEvent fileTransferEvent) {
            if (FileTransferStatusDialog.this.m_logger.isLoggable(Level.FINER)) {
                FileTransferStatusDialog.this.m_logger.logp(Level.FINER, this.getClass().getName(), "fileTransferStarted", "fileTransferStarted " + fileTransferEvent.toString());
            }
            if (FileTransferStatusDialog.this.m_isSender) {
                Object[] objectArray = new String[]{FileTransferStatusDialog.this.m_fileTransfer.getFileName(), FileTransferStatusDialog.this.m_fileTransfer.getPartner().getName()};
                FileTransferStatusDialog.this.m_transferringLbl.setText(FileTransferStatusDialog.this.m_resourceFile.formatString("FT_STATUS_TRANSFERRING_TO", objectArray));
            }
        }

        public void fileTransferCompleted(FileTransferEvent fileTransferEvent) {
            if (FileTransferStatusDialog.this.m_logger.isLoggable(Level.FINER)) {
                FileTransferStatusDialog.this.m_logger.logp(Level.FINER, this.getClass().getName(), "fileTransferCompleted", "fileTransferCompleted " + fileTransferEvent.toString());
            }
            FileTransferStatusDialog.this.m_FTUIService.transferCompleted(FileTransferStatusDialog.this.m_fileTransfer, FileTransferStatusDialog.this.getSender(), FileTransferStatusDialog.this.getReceiver());
            FileTransferStatusDialog.this.m_progressBar.setPercentage(100);
            FileTransferStatusDialog.this.updatePercentLabel(100, FileTransferStatusDialog.this.m_fileTransfer.getFileSize(), FileTransferStatusDialog.this.m_fileTransfer.getFileSize());
            String string = FileTransferStatusDialog.this.m_fileTransfer.getFileName();
            FileTransferStatusDialog.this.m_transferringLbl.setText(FileTransferStatusDialog.this.m_resourceFile.formatString("FT_STATUS_COMPLETED", string));
            FileTransferStatusDialog.this.m_cancelBtn.setLabel(FileTransferStatusDialog.this.m_resourceFile.getString("FT_STATUS_BTN_CLOSE"));
            if (FileTransferStatusDialog.this.m_showOpenButton) {
                boolean bl = false;
                String string2 = string.substring(string.lastIndexOf(".") + 1);
                if (string2.equalsIgnoreCase("html") || string2.equalsIgnoreCase("htm")) {
                    bl = true;
                }
                if (!bl) {
                    FileTransferStatusDialog.this.m_openBtn.setEnabled(true);
                }
            }
            if (FileTransferStatusDialog.this.m_closeWhenCompleted.getState()) {
                FileTransferStatusDialog.this.closeDialog();
            }
        }

        public void fileTransferDeclined(FileTransferEvent fileTransferEvent) {
            int n;
            if (FileTransferStatusDialog.this.m_logger.isLoggable(Level.FINER)) {
                FileTransferStatusDialog.this.m_logger.logp(Level.FINER, this.getClass().getName(), "fileTransferDeclined", "fileTransferDeclined " + fileTransferEvent.toString());
            }
            FileTransferStatusDialog.this.m_cancelBtn.setLabel(FileTransferStatusDialog.this.m_resourceFile.getString("FT_STATUS_BTN_CLOSE"));
            int n2 = fileTransferEvent.getReason();
            if (n2 == 0x8000606) {
                FileTransferStatusDialog.this.setTitle(FileTransferStatusDialog.this.m_resourceFile.getString("FT_STATUS_TITLE_DECLINED"));
                Object[] objectArray = new String[]{FileTransferStatusDialog.this.m_fileTransfer.getPartner().getDisplayName()};
                FileTransferStatusDialog.this.m_transferringLbl.setText(FileTransferStatusDialog.this.m_resourceFile.formatString("FT_STATUS_DECLINED", objectArray));
                n = 1;
            } else if (n2 == -2147483642) {
                FileTransferStatusDialog.this.setTitle(FileTransferStatusDialog.this.m_resourceFile.getString("FT_STATUS_TITLE_CANCELED"));
                Object[] objectArray = new String[]{FileTransferStatusDialog.this.m_fileTransfer.getPartner().getDisplayName()};
                FileTransferStatusDialog.this.m_transferringLbl.setText(FileTransferStatusDialog.this.m_resourceFile.formatString("FT_STATUS_CANCELED", objectArray));
                n = 3;
            } else if (n2 == -2147483510) {
                FileTransferStatusDialog.this.setTitle(FileTransferStatusDialog.this.m_resourceFile.getString("FT_STATUS_TITLE_CANCELED"));
                Object[] objectArray = new String[]{FileTransferStatusDialog.this.m_fileTransfer.getPartner().getDisplayName()};
                FileTransferStatusDialog.this.m_transferringLbl.setText(FileTransferStatusDialog.this.m_resourceFile.formatString("FT_STATUS_CANCELED", objectArray));
                FileTransferStatusDialog.this.m_FTUIService.showErrorMessage("FILE_TRANSFER_NOT_ALLOWED_TITLE", "FILE_TRANSFER_NOT_ALLOWED_TEXT", "FILE_TRANSFER_NOT_ALLOWED_BTN_OK", true, false);
                n = 5;
            } else {
                FileTransferStatusDialog.this.setTitle(FileTransferStatusDialog.this.m_resourceFile.getString("FT_STATUS_TITLE_CANCELED"));
                Object[] objectArray = new String[]{FileTransferStatusDialog.this.m_fileTransfer.getPartner().getDisplayName()};
                FileTransferStatusDialog.this.m_transferringLbl.setText(FileTransferStatusDialog.this.m_resourceFile.formatString("FT_STATUS_CANCELED", objectArray));
                n = 4;
            }
            FileTransferStatusDialog.this.m_FTUIService.transferFailed(FileTransferStatusDialog.this.m_fileTransfer, FileTransferStatusDialog.this.getSender(), FileTransferStatusDialog.this.getReceiver(), n);
        }

        public void fileTransferStopped(FileTransferEvent fileTransferEvent) {
            if (FileTransferStatusDialog.this.m_logger.isLoggable(Level.FINER)) {
                FileTransferStatusDialog.this.m_logger.logp(Level.FINER, this.getClass().getName(), "fileTransferStopped", "fileTransferStopped " + fileTransferEvent.toString());
            }
            FileTransferStatusDialog.this.m_cancelBtn.setLabel(FileTransferStatusDialog.this.m_resourceFile.getString("FT_STATUS_BTN_CLOSE"));
            FileTransferStatusDialog.this.setTitle(FileTransferStatusDialog.this.m_resourceFile.getString("FT_STATUS_TITLE_CANCELED"));
            Object[] objectArray = new String[]{FileTransferStatusDialog.this.m_fileTransfer.getPartner().getDisplayName()};
            FileTransferStatusDialog.this.m_transferringLbl.setText(FileTransferStatusDialog.this.m_resourceFile.formatString("FT_STATUS_CANCELED", objectArray));
            FileTransferStatusDialog.this.m_FTUIService.transferFailed(FileTransferStatusDialog.this.m_fileTransfer, FileTransferStatusDialog.this.getSender(), FileTransferStatusDialog.this.getReceiver(), 2);
        }

        public void bytesTransferredUpdate(FileTransferEvent fileTransferEvent) {
            if (FileTransferStatusDialog.this.m_logger.isLoggable(Level.FINER)) {
                FileTransferStatusDialog.this.m_logger.logp(Level.FINER, this.getClass().getName(), "bytesTransferredUpdate", "bytesTransferredUpdate " + fileTransferEvent.toString());
            }
            int n = (int)(100L * FileTransferStatusDialog.this.m_fileTransfer.getNumOfByteTransferred() / (long)FileTransferStatusDialog.this.m_fileTransfer.getFileSize());
            FileTransferStatusDialog.this.m_progressBar.setPercentage(n);
            FileTransferStatusDialog.this.updatePercentLabel(n, FileTransferStatusDialog.this.m_fileTransfer.getNumOfByteTransferred(), FileTransferStatusDialog.this.m_fileTransfer.getFileSize());
        }
    }
}

