/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.filetransfer;

import com.lotus.sametime.community.Channel;
import com.lotus.sametime.community.ChannelEvent;
import com.lotus.sametime.community.ChannelService;
import com.lotus.sametime.community.ChannelServiceListener;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.filetransfer.FileTransfer;
import com.lotus.sametime.filetransfer.FileTransferEvent;
import com.lotus.sametime.filetransfer.FileTransferService;
import com.lotus.sametime.filetransfer.FileTransferServiceListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileTransferComp
extends STComp
implements FileTransferService {
    private Vector m_listeners = new Vector();
    private ChannelService m_channelService;
    private ChannelServiceListener m_chServiceListener;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.filetransfer");

    public FileTransferComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.filetransfer.FileTransferComp", sTSession);
        sTSession.registerComponent(this.getName(), this);
        this.m_chServiceListener = new ChannelServiceListener(){

            public void channelReceived(ChannelEvent channelEvent) {
                FileTransferComp.this.channelReceived(channelEvent);
            }
        };
        this.m_channelService = (ChannelService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        if (null != this.m_channelService) {
            this.m_channelService.addChannelServiceListener(this.m_chServiceListener);
        }
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
    }

    protected void componentLoaded(STCompApi sTCompApi) {
        if (null == this.m_channelService && sTCompApi instanceof ChannelService) {
            this.m_channelService = (ChannelService)sTCompApi;
            this.m_channelService.addChannelServiceListener(this.m_chServiceListener);
        }
    }

    public synchronized void addFileTransferServiceListener(FileTransferServiceListener fileTransferServiceListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.addElement(fileTransferServiceListener);
        this.m_listeners = vector;
    }

    public synchronized void removeFileTransferServiceListener(FileTransferServiceListener fileTransferServiceListener) {
        Vector vector = (Vector)this.m_listeners.clone();
        vector.removeElement(fileTransferServiceListener);
        this.m_listeners = vector;
    }

    public FileTransfer createFileTransfer(STUser sTUser, FileInputStream fileInputStream, String string, String string2) {
        FileTransfer fileTransfer = null;
        try {
            fileTransfer = this.createFileTransfer(sTUser, fileInputStream, string, string2, "binary/unknown", FileTransfer.ST_TRANSFER_ID_UNKNOWN);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return fileTransfer;
    }

    public FileTransfer createFileTransfer(STUser sTUser, FileInputStream fileInputStream, String string, String string2, String string3, Integer n) throws IOException {
        FileTransfer fileTransfer = null;
        fileTransfer = new FileTransfer(this.getSession(), sTUser, fileInputStream, string, string2, string3, n);
        return fileTransfer;
    }

    private void channelReceived(ChannelEvent channelEvent) {
        Channel channel = channelEvent.getChannel();
        if (channel.getServiceType() != 56 || this.m_listeners.size() == 0) {
            return;
        }
        channel.pend();
        try {
            FileTransfer fileTransfer = new FileTransfer(channel);
            this.dispatchFTInitiatedEvent(fileTransfer);
        }
        catch (Exception exception) {
            channel.close(Integer.MIN_VALUE, null);
            exception.printStackTrace();
        }
    }

    private void dispatchFTInitiatedEvent(FileTransfer fileTransfer) {
        FileTransferEvent fileTransferEvent = new FileTransferEvent(this, 1, fileTransfer);
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((FileTransferServiceListener)enumeration.nextElement()).FileTransferInitiated(fileTransferEvent);
        }
    }
}

