/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UtilLibrary {
    private static Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util");

    public static String[] uniqify(String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashtable.put(stringArray[i], stringArray[i]);
        }
        String[] stringArray2 = new String[hashtable.size()];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (hashtable.remove(stringArray[i]) == null) continue;
            stringArray2[n++] = stringArray[i];
        }
        return stringArray2;
    }

    public static int bsearch(Integer n, Integer[] integerArray, int n2, int n3) {
        if (n2 >= n3) {
            if (n.equals(integerArray[n2])) {
                return n2;
            }
            return -1;
        }
        int n4 = (n2 + n3) / 2;
        if (n4 == n2) {
            if (n.equals(integerArray[n2])) {
                return n2;
            }
            if (n.equals(integerArray[n3])) {
                return n3;
            }
            return -1;
        }
        if (n.equals(integerArray[n4])) {
            return n4;
        }
        if (n < integerArray[n4]) {
            return UtilLibrary.bsearch(n, integerArray, n2, n4);
        }
        return UtilLibrary.bsearch(n, integerArray, n4, n3);
    }

    public static byte[] byteArrayFromString(String string) {
        Object object;
        byte[] byArray = null;
        try {
            object = new NdrOutputStream();
            ((DataOutputStream)object).writeUTF(string);
            byArray = ((NdrOutputStream)object).toByteArray();
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
        object = new byte[byArray.length - 2];
        System.arraycopy(byArray, 2, object, 0, ((Object)object).length);
        return object;
    }

    public static byte[] byteArrayFromShort(short s) {
        byte[] byArray = new byte[]{(byte)(s >> 8), (byte)(s & 0xFF)};
        return byArray;
    }

    public static int intFromByteArray(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n = n << 8 | byArray[i];
        }
        return n;
    }

    public static long longFromByteArray(byte[] byArray) {
        long l = 0L;
        try {
            NdrInputStream ndrInputStream = new NdrInputStream(byArray);
            l = ndrInputStream.readLong();
        }
        catch (IOException iOException) {
            Debug.stAssert(false);
        }
        return l;
    }

    public static void runWithPermissions(String[] stringArray, Runnable runnable) {
        block2: {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                if (!m_logger.isLoggable(Level.FINER)) break block2;
                m_logger.logp(Level.FINER, UtilLibrary.class.getName(), "runWithPermissions", "runWithPermissions: exception in runnable", throwable);
            }
        }
    }

    public static void runWithPermissions(String string, Runnable runnable) {
        String[] stringArray = new String[]{string};
        UtilLibrary.runWithPermissions(stringArray, runnable);
    }

    public static Hashtable joinTables(Hashtable hashtable, Hashtable hashtable2) {
        Hashtable hashtable3 = (Hashtable)hashtable.clone();
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            hashtable3.put(k, hashtable2.get(k));
        }
        return hashtable3;
    }

    public static Hashtable subtractTables(Hashtable hashtable, Hashtable hashtable2) {
        Hashtable hashtable3 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (hashtable2.containsKey(k)) continue;
            hashtable3.put(k, hashtable.get(k));
        }
        return hashtable3;
    }

    public static Hashtable existInBothTables(Hashtable hashtable, Hashtable hashtable2) {
        Hashtable hashtable3 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!hashtable2.containsKey(k)) continue;
            hashtable3.put(k, hashtable.get(k));
        }
        return hashtable3;
    }
}

