/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.comparch;

import com.lotus.sametime.core.comparch.ComponentInstantiationException;
import com.lotus.sametime.core.comparch.ComponentListener;
import com.lotus.sametime.core.comparch.DispatchingThreadPool;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.Invoker;
import com.lotus.sametime.core.comparch.MessageDispatcher;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STCompEvent;
import com.lotus.sametime.core.comparch.SessionTable;
import com.lotus.sametime.core.comparch.ToolkitInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class STSession {
    private MessageDispatcher m_dispatcher;
    private Invoker m_invoker;
    private Hashtable m_components = new Hashtable(25);
    private String m_name = null;
    private boolean m_isActive = false;
    private Vector m_componentListeners = new Vector(50);
    private static final String[] m_semanticCompNames = new String[]{"com.lotus.sametime.community.STBase", "com.lotus.sametime.conf.ConfComp", "com.lotus.sametime.im.ImComp", "com.lotus.sametime.places.PlacesComp", "com.lotus.sametime.post.PostComp", "com.lotus.sametime.storage.StorageComp", "com.lotus.sametime.wih.WihComp", "com.lotus.sametime.awareness.AwarenessComp", "com.lotus.sametime.directory.DirectoryComp", "com.lotus.sametime.lookup.LookupComp", "com.lotus.sametime.token.TokenComp", "com.lotus.sametime.names.NamesComp", "com.lotus.sametime.filetransfer.FileTransferComp", "com.lotus.sametime.announcement.AnnouncementComp", "com.lotus.sametime.policy.PolicyComp", "com.lotus.sametime.buddylist.BLComp", "com.lotus.sametime.location.LocationComp", "com.lotus.sametime.selectivestatus.SelectiveStatusComp", "com.lotus.sametime.loginattribute.LoginAttributeComp", "com.lotus.sametime.capability.CapabilityComp"};
    private static final String[] m_uiCompNames = new String[]{"com.lotus.sametime.resourceloader.ResourceLoaderComp", "com.lotus.sametime.commui.CommUIComp", "com.lotus.sametime.chatui.ChatUIComp", "com.lotus.sametime.filetransferui.FileTransferUIComp", "com.lotus.sametime.announcementui.AnnouncementUIComp"};
    private Hashtable m_sessionProperties = new Hashtable();
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.comparch");
    private static long c_sessionCount = 0L;

    public STSession() throws DuplicateObjectException {
        this("_STSession" + c_sessionCount++, null);
    }

    public STSession(String string) throws DuplicateObjectException {
        this(string, null);
    }

    public STSession(String string, boolean bl) throws DuplicateObjectException {
        this(string, null);
        this.m_dispatcher.setSwingThreadingEnabled(bl);
    }

    public STSession(String string, DispatchingThreadPool dispatchingThreadPool) throws DuplicateObjectException {
        this.m_name = string;
        this.m_dispatcher = new MessageDispatcher(dispatchingThreadPool);
        this.m_invoker = new Invoker(this.m_dispatcher);
        SessionTable sessionTable = SessionTable.getSessionTable();
        sessionTable.registerSession(string, this);
        this.setupLoggingConfig();
        if (this.m_logger.isLoggable(Level.FINE)) {
            this.m_logger.logp(Level.FINE, this.getClass().getName(), "<init>", "Toolkit Version: " + ToolkitInfo.getVersion());
        }
    }

    public synchronized void addComponentListener(ComponentListener componentListener) {
        Vector vector = (Vector)this.m_componentListeners.clone();
        vector.addElement(componentListener);
        this.m_componentListeners = vector;
    }

    public synchronized void removeComponentListener(ComponentListener componentListener) {
        Vector vector = (Vector)this.m_componentListeners.clone();
        vector.removeElement(componentListener);
        this.m_componentListeners = vector;
    }

    public MessageDispatcher getDispatcher() {
        return this.m_dispatcher;
    }

    public Invoker getInvoker() {
        return this.m_invoker;
    }

    public void registerComponent(String string, STCompApi sTCompApi) throws DuplicateObjectException {
        if (this.m_logger.isLoggable(Level.FINE)) {
            this.m_logger.logp(Level.FINE, this.getClass().getName(), "registerComponent", "STSession: Registering component " + string);
        }
        if (this.m_components.get(string) != null) {
            throw new DuplicateObjectException("Session " + this + "Already contains component " + string);
        }
        this.m_components.put(string, sTCompApi);
        this.notifyComponentLoaded(sTCompApi);
    }

    public STCompApi getCompApi(String string) {
        return (STCompApi)this.m_components.get(string);
    }

    public synchronized void start() {
        if (this.m_isActive) {
            return;
        }
        this.m_isActive = true;
        this.m_dispatcher.start();
        this.m_dispatcher.sendEvent(new STCompEvent(this, 0));
    }

    public synchronized void stop() {
        this.m_dispatcher.sendEvent(new STCompEvent(this, 1));
        this.m_dispatcher.stop();
        this.m_isActive = false;
    }

    public void unloadSession() {
        if (this.m_isActive) {
            this.stop();
        }
        this.m_components.clear();
        this.m_sessionProperties.clear();
        SessionTable sessionTable = SessionTable.getSessionTable();
        sessionTable.unregisterSession(this.m_name);
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    public String toString() {
        return "STSession {" + this.m_name + "}";
    }

    public void loadComponents(String[] stringArray) {
        Class clazz;
        if (this.m_logger.isLoggable(Level.FINE)) {
            this.m_logger.logp(Level.FINE, this.getClass().getName(), "loadComponents", "loadComponents called");
        }
        Object[] objectArray = new Object[]{this};
        Class clazz2 = clazz = STSession.class;
        if (this.m_logger.isLoggable(Level.FINE)) {
            this.m_logger.logp(Level.FINE, this.getClass().getName(), "loadComponents", "Session class = " + clazz);
        }
        Class[] classArray = new Class[]{clazz};
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (this.getCompApi(stringArray[i]) != null) continue;
            try {
                Class<?> clazz3 = Class.forName(stringArray[i]);
                object = clazz3.getConstructor(classArray);
                ((Constructor)object).newInstance(objectArray);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!this.m_logger.isLoggable(Level.FINE)) continue;
                this.m_logger.logp(Level.FINE, this.getClass().getName(), "loadComponents", "Failed to load component Class not found: " + stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                object = "Exception during component '" + stringArray[i] + "' instantiation";
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.logp(Level.FINE, this.getClass().getName(), "loadComponents", (String)object + ": " + exception, exception);
                }
                throw new ComponentInstantiationException((String)object);
            }
        }
    }

    public void loadSemanticComponents() {
        this.loadComponents(m_semanticCompNames);
    }

    public void loadAllComponents() {
        this.loadComponents(m_semanticCompNames);
        this.loadComponents(m_uiCompNames);
    }

    public Object getSessionProperty(String string) {
        return this.m_sessionProperties.get(string);
    }

    public void setSessionProperty(String string, Object object) {
        if (object == null) {
            this.m_sessionProperties.remove(string);
        } else {
            this.m_sessionProperties.put(string, object);
        }
    }

    protected void notifyComponentLoaded(STCompApi sTCompApi) {
        Vector vector = this.m_componentListeners;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ComponentListener componentListener = (ComponentListener)enumeration.nextElement();
            componentListener.componentLoaded(sTCompApi);
        }
    }

    private void setupLoggingConfig() {
        String string = System.getProperty("java.util.logging.config.class");
        String string2 = LogManager.getLogManager().getClass().getName();
        boolean bl = string == null || string.equals(string2);
        String string3 = System.getProperty("user.home") + System.getProperty("file.separator") + "stjavatk.properties";
        File file = new File(string3);
        if (file.exists() && bl) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                LogManager.getLogManager().readConfiguration(bufferedInputStream);
            }
            catch (IOException iOException) {
                System.out.println("Error loading stjavatk.properties: " + iOException.getMessage());
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                System.out.println("Error loading stjavatk.properties: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }
}

