/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.commui;

import com.lotus.sametime.commui.AddDialog;
import com.lotus.sametime.commui.GroupContentDialog;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.directoryui.DirectoryListViewEvent;
import com.lotus.sametime.directoryui.DirectoryListViewListener;
import com.lotus.sametime.directoryui.DirectoryPanel;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.statusbar.Statusbar;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;

public class DirectoryDialog
extends Dialog
implements DirectoryListViewListener,
ActionListener {
    public int m_insets;
    private int m_prefWidth;
    private int m_prefHeight;
    private static String BUNDLE_FILE_NAME = "properties/commui";
    DirectoryPanel m_dirPanel;
    private ButtonsPanel m_btnPanel;
    private AddDialog m_addDialog;
    private STSession m_session;
    private Frame m_parentFrame;
    private Button m_btnProps;
    private Button m_btnClose;
    private Button m_btnAdd;
    private STGroup m_selectedGroup;
    private Statusbar m_statusBar;
    private STBundle m_bundle;

    public DirectoryDialog(Frame frame, STSession sTSession, AddDialog addDialog) {
        super(frame);
        this.m_addDialog = addDialog;
        this.m_parentFrame = frame;
        this.m_session = sTSession;
        ResourceLoaderService resourceLoaderService = (ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_bundle = resourceLoaderService.getBundle(BUNDLE_FILE_NAME);
        this.setTitle(this.m_bundle.getString("DIRECTORY_DIALOG_TITLE"));
        this.setResizable(true);
        this.m_insets = this.m_bundle.getInt("DIRECTORY_INSETS_UNIT");
        this.m_prefHeight = this.m_bundle.getInt("DIRECTORY_PREF_HEIGHT");
        this.m_prefWidth = this.m_bundle.getInt("DIRECTORY_PREF_WIDTH");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DirectoryDialog.this.setVisible(false);
                DirectoryDialog.this.dispose();
            }
        });
        String[] stringArray = new String[]{this.m_bundle.getString("BTN_LBL_ADD"), this.m_bundle.getString("BTN_LBL_PROPS"), this.m_bundle.getString("BTN_LBL_CLOSE")};
        this.m_btnPanel = new ButtonsPanel(stringArray, this, 2);
        this.m_btnAdd = this.m_btnPanel.getButton(this.m_bundle.getString("BTN_LBL_ADD"));
        this.m_btnClose = this.m_btnPanel.getButton(this.m_bundle.getString("BTN_LBL_CLOSE"));
        this.m_btnProps = this.m_btnPanel.getButton(this.m_bundle.getString("BTN_LBL_PROPS"));
        this.m_btnProps.setEnabled(false);
        this.m_btnAdd.setEnabled(false);
        Font font = this.m_bundle.getFont("FONT_PLAIN_NAME", "FONT_PLAIN_STYLE", "FONT_PLAIN_SIZE");
        int n = this.m_bundle.getInt("STATUS_BAR_HEIGHT");
        this.m_statusBar = new Statusbar("", font, n);
        this.m_dirPanel = new DirectoryPanel(sTSession);
        this.m_dirPanel.addDirectoryListViewListener(this);
        this.initLayout();
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
    }

    private void initLayout() {
        this.setLayout(new BorderLayout(5, 6));
        Panel panel = new Panel(new BorderLayout());
        panel.add("Center", this.m_dirPanel);
        panel.add("South", this.m_btnPanel);
        this.add("Center", panel);
        this.add("South", this.m_statusBar);
        this.pack();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.max(dimension.width, this.m_prefWidth);
        dimension.height = Math.max(dimension.height, this.m_prefHeight);
        return dimension;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + this.m_insets, this.m_insets, insets.bottom + this.m_insets, this.m_insets);
    }

    private void launchGroupContentDialog() {
        GroupContentDialog groupContentDialog = new GroupContentDialog(this.m_parentFrame, this.m_session, this.m_selectedGroup);
        groupContentDialog.setVisible(true);
    }

    private void addClicked() {
        Vector vector = this.m_dirPanel.getSelectedEntries();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            STObject sTObject = (STObject)enumeration.nextElement();
            this.m_addDialog.stObjectSelected(null, sTObject);
        }
        this.m_statusBar.setStatus(this.m_bundle.getString("STATUS_MSG_DIR_ADDED"));
    }

    private void closeClicked() {
        this.m_addDialog.dispose();
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_btnProps) {
            this.launchGroupContentDialog();
        } else if (actionEvent.getSource() == this.m_btnAdd) {
            this.addClicked();
        } else if (actionEvent.getSource() == this.m_btnClose) {
            this.closeClicked();
        }
    }

    public void selectionChanged(DirectoryListViewEvent directoryListViewEvent) {
        Vector vector = directoryListViewEvent.getSelectedNodes();
        boolean bl = false;
        STGroup sTGroup = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            STObject sTObject = (STObject)enumeration.nextElement();
            if (!(sTObject instanceof STGroup)) continue;
            if (bl) {
                bl = false;
                break;
            }
            bl = true;
            sTGroup = (STGroup)sTObject;
        }
        this.m_btnProps.setEnabled(bl);
        if (bl) {
            this.m_selectedGroup = sTGroup;
        }
        boolean bl2 = vector != null && vector.size() != 0;
        this.m_btnAdd.setEnabled(bl2);
        if (bl2) {
            this.m_statusBar.resetStatus();
        }
    }

    public void nodeDoubleClicked(DirectoryListViewEvent directoryListViewEvent) {
        STObject sTObject = directoryListViewEvent.getDoubleClickedNode();
        this.m_addDialog.stObjectSelected(null, sTObject);
        this.m_statusBar.setStatus(this.m_bundle.getString("STATUS_MSG_DIR_ADDED"));
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(10){

            public void executeKeyMethod() {
                DirectoryDialog.this.addClicked();
            }
        });
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                DirectoryDialog.this.closeClicked();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_bundle.getString("MN_BTN_ADD"))){

            public void executeKeyMethod() {
                DirectoryDialog.this.addClicked();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_bundle.getString("MN_BTN_CONTENTS"))){

            public void executeKeyMethod() {
                DirectoryDialog.this.launchGroupContentDialog();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_bundle.getString("MN_BTN_CLOSE"))){

            public void executeKeyMethod() {
                DirectoryDialog.this.closeClicked();
            }
        });
        Enumeration enumeration = this.m_dirPanel.getActionKeys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((KeyAction)enumeration.nextElement());
        }
        return new KeyHandler(vector);
    }

    public void dispose() {
        this.m_dirPanel.removeServiceListeners();
        super.dispose();
    }
}

