/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awarenessui;

import com.lotus.sametime.announcementui.AnnouncementUI;
import com.lotus.sametime.awareness.AttributeAdapter;
import com.lotus.sametime.awareness.AttributeEvent;
import com.lotus.sametime.awareness.AwarenessService;
import com.lotus.sametime.awareness.STWatchedUser;
import com.lotus.sametime.awareness.WatchList;
import com.lotus.sametime.awarenessui.AwarenessModel;
import com.lotus.sametime.awarenessui.AwarenessNode;
import com.lotus.sametime.awarenessui.AwarenessViewController;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.constants.EncLevel;
import com.lotus.sametime.core.types.STBoolean;
import com.lotus.sametime.core.types.STExtendedAttribute;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STServer;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserStatus;
import com.lotus.sametime.core.util.ImageResources;
import com.lotus.sametime.filetransferui.FileTransferUI;
import com.lotus.sametime.guiutils.misc.UbqDialog;
import com.lotus.sametime.guiutils.tree.TreeNode;
import com.lotus.sametime.im.Im;
import com.lotus.sametime.im.ImAdapter;
import com.lotus.sametime.im.ImEvent;
import com.lotus.sametime.im.InstantMessagingService;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.Image;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChatController
extends AwarenessViewController {
    private CommunityService m_community;
    private WatchList m_watchList;
    private STSession m_session;
    protected STUser m_phoneServiceId = null;
    private InstantMessagingService m_imSVC;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.awarenessui");

    public ChatController(AwarenessModel awarenessModel) {
        super(awarenessModel);
        this.m_session = awarenessModel.getSession();
        this.m_community = (CommunityService)this.m_session.getCompApi("com.lotus.sametime.community.STBase");
        AwarenessService awarenessService = (AwarenessService)awarenessModel.getSession().getCompApi("com.lotus.sametime.awareness.AwarenessComp");
        int[] nArray = new int[]{9014, 9009, 9060};
        awarenessService.addToAttrFilter(nArray);
        this.m_watchList = awarenessService.createWatchList();
        this.m_watchList.addAttrListener(new AttributeAdapter(){

            public void attrRemoved(AttributeEvent attributeEvent) {
                ChatController.this.attrRemoved(attributeEvent);
            }

            public void attrChanged(AttributeEvent attributeEvent) {
                ChatController.this.attrChanged(attributeEvent);
            }
        });
        this.m_imSVC = (InstantMessagingService)awarenessModel.getSession().getCompApi("com.lotus.sametime.im.ImComp");
        if (this.m_community.isLoggedIn()) {
            this.m_watchList.addItem(this.m_community.getLogin().getServer());
        }
    }

    protected void removeSelectedNodes(Vector vector) {
        STUser[] sTUserArray = this.m_model.getUsersFromNodes(vector);
        this.m_model.removeUsers(sTUserArray);
    }

    protected void createMessage(Vector vector) {
        Vector vector2 = this.getOnlineUsers(vector);
        if (vector2 == null || vector2.size() == 0) {
            ResourceLoaderService resourceLoaderService = (ResourceLoaderService)((Object)this.m_model.getSession().getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
            STBundle sTBundle = resourceLoaderService.getBundle("properties/chatui");
            Image image = ImageResources.getInstance().getImage("images/alert.gif");
            UbqDialog ubqDialog = new UbqDialog(this.getMainFrame(), sTBundle.getString("ALERT_TITLE"), sTBundle.formatStringArray("USER_NOT_ONLINE"), sTBundle.formatStringArray("BTN_LBL_OK"));
            ubqDialog.setImage(image);
            ubqDialog.setVisible(true);
            return;
        }
        if (vector2.size() == 1) {
            AwarenessNode awarenessNode = (AwarenessNode)vector2.firstElement();
            STUser sTUser = (STUser)awarenessNode.getKey();
            this.m_chat.create1On1ChatById(sTUser);
        } else if (vector2.size() > 1) {
            Serializable serializable;
            Object object;
            STBoolean sTBoolean = new STBoolean(false);
            Vector vector3 = this.getOnlineUsers(vector, true, sTBoolean);
            if (vector3.size() == 1) {
                object = (AwarenessNode)vector3.firstElement();
                serializable = (STUser)((TreeNode)object).getKey();
                this.m_chat.create1On1ChatById((STUser)serializable);
            } else if (vector3.size() > 1) {
                this.openConference(vector3);
            }
            if (sTBoolean.getValue()) {
                object = ImageResources.getInstance().getImage("images/alert.gif");
                serializable = new UbqDialog(this.getMainFrame(), this.m_resource.getString("SAMETIME_TITLE"), this.m_resource.formatStringArray("NON_ST_USERS_IN_CHAT"), this.m_resource.formatStringArray("BTN_LBL_OK"));
                ((UbqDialog)serializable).setImage((Image)object);
                ((UbqDialog)serializable).setVisible(true);
            }
        }
    }

    protected void createAnnouncement(Vector vector) {
        Object object;
        STBoolean sTBoolean = new STBoolean(false);
        Vector vector2 = this.getOnlineUsers(vector, true, sTBoolean);
        if (vector2 == null) {
            return;
        }
        Vector<Object> vector3 = new Vector<Object>();
        for (int i = 0; i < vector2.size(); ++i) {
            object = (STUser)((AwarenessNode)vector2.elementAt(i)).getKey();
            AwarenessService awarenessService = (AwarenessService)this.m_model.getSession().getCompApi("com.lotus.sametime.awareness.AwarenessComp");
            STUserStatus sTUserStatus = awarenessService.findUserStatus((STUser)object);
            if (sTUserStatus.isStatus((short)128) || vector3.contains(vector2.elementAt(i))) continue;
            vector3.addElement(object);
        }
        Object[] objectArray = new STObject[vector3.size()];
        vector3.copyInto(objectArray);
        object = (AnnouncementUI)this.m_model.getSession().getCompApi("com.lotus.sametime.announcementui.AnnouncementUIComp");
        object.sendAnnouncement((STObject[])objectArray);
    }

    protected void createFileTransfer(Vector vector) {
        STBoolean sTBoolean = new STBoolean(false);
        Vector vector2 = this.getOnlineUsers(vector, true, sTBoolean);
        if (vector2.size() == 1) {
            STUser sTUser = (STUser)((AwarenessNode)vector2.firstElement()).getKey();
            FileTransferUI fileTransferUI = (FileTransferUI)this.m_model.getSession().getCompApi("com.lotus.sametime.filetransferui.FileTransferUIComp");
            fileTransferUI.sendFile(sTUser);
        }
    }

    protected void enablePopupItems(Vector vector) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.m_popup.removeAll();
        this.m_popup.add(this.m_message);
        if (this.m_phoneServiceId != null) {
            this.m_popup.add(this.m_startPhoneCall);
            this.m_startPhoneCall.setEnabled(vector.size() > 0);
        }
        if (this.m_announcementEnabled) {
            this.m_popup.add(this.m_announcement);
        }
        if (this.m_fileTransferEnabled) {
            this.m_popup.addSeparator();
            this.m_popup.add(this.m_fileTransfer);
        }
        if (this.m_deleteEnabled) {
            this.m_popup.add(this.m_separator);
            this.m_popup.add(this.m_remove);
        }
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            AwarenessNode awarenessNode = (AwarenessNode)object.nextElement();
            if (!awarenessNode.isOnline()) continue;
            bl = true;
            if (((STUser)awarenessNode.getKey()).isExternalUser()) continue;
            bl2 = true;
            break;
        }
        this.m_message.setEnabled(bl && this.m_messageEnabled);
        this.m_announcement.setEnabled(bl && this.m_announcementEnabled);
        if (vector.size() == 1 && ((AwarenessNode)(object = (AwarenessNode)vector.elementAt(0))).isOnline() && !((STUser)((TreeNode)object).getKey()).isExternalUser()) {
            bl3 = true;
        }
        this.m_fileTransfer.setEnabled(bl3);
    }

    protected void handleNodeExpanded(TreeNode treeNode) {
    }

    protected void handleNodeCollapsed(TreeNode treeNode) {
    }

    protected void openConference(Vector vector) {
        String string = this.m_commService.getLogin().getMyUserInstance().getName();
        String string2 = this.m_resource.getString("PLEASE_JOIN_THIS_CHAT");
        String string3 = this.m_resource.formatString("'S_CONFERENCE", string);
        STBoolean sTBoolean = new STBoolean(false);
        STUser[] sTUserArray = this.m_model.getUsersFromNodes(vector, true, sTBoolean);
        this.m_chat.createConferenceChat(string3, string2, true, sTUserArray);
        if (sTBoolean.getValue()) {
            Image image = ImageResources.getInstance().getImage("images/alert.gif");
            UbqDialog ubqDialog = new UbqDialog(this.getMainFrame(), this.m_resource.getString("SAMETIME_TITLE"), this.m_resource.formatStringArray("NON_ST_USERS_IN_CHAT"), this.m_resource.formatStringArray("BTN_LBL_OK"));
            ubqDialog.setImage(image);
            ubqDialog.setVisible(true);
        }
    }

    protected void attrChanged(AttributeEvent attributeEvent) {
        STExtendedAttribute[] sTExtendedAttributeArray = attributeEvent.getAttributeList();
        for (int i = 0; i < sTExtendedAttributeArray.length; ++i) {
            if (sTExtendedAttributeArray[i].getKey() == 9014) {
                this.m_announcementEnabled = true;
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() == 9009) {
                FileTransferUI fileTransferUI = (FileTransferUI)this.m_session.getCompApi("com.lotus.sametime.filetransferui.FileTransferUIComp");
                if (fileTransferUI == null) continue;
                this.m_fileTransferEnabled = true;
                continue;
            }
            if (sTExtendedAttributeArray[i].getKey() != 9060) continue;
            this.m_phoneServiceId = new STUser(new STId(sTExtendedAttributeArray[i].getString(), ""), "", "");
        }
    }

    protected void attrRemoved(AttributeEvent attributeEvent) {
        if (attributeEvent.getAttributeKey() == 9014) {
            this.m_announcementEnabled = false;
        } else if (attributeEvent.getAttributeKey() == 9009) {
            this.m_fileTransferEnabled = false;
        } else if (attributeEvent.getAttributeKey() == 9060) {
            this.m_phoneServiceId = null;
        }
    }

    protected void loggedIn(LoginEvent loginEvent) {
        STServer sTServer = this.m_community.getLogin().getServer();
        this.m_watchList.addItem(sTServer);
        super.loggedIn(loginEvent);
    }

    protected void loggedOut(LoginEvent loginEvent) {
        this.m_watchList.reset();
        this.m_phoneServiceId = null;
        super.loggedOut(loginEvent);
    }

    protected void startPhoneCall(Vector vector) {
        final String string = this.createPhoneCallXML(vector);
        Im im = this.m_imSVC.createIm(this.m_phoneServiceId, EncLevel.ENC_LEVEL_ALL, 9060);
        im.addImListener(new ImAdapter(){

            public void imOpened(ImEvent imEvent) {
                if (ChatController.this.m_logger.isLoggable(Level.FINER)) {
                    ChatController.this.m_logger.logp(Level.FINER, this.getClass().getName(), "imOpened", "Sending Start A phone Call: " + string);
                }
                imEvent.getIm().sendText(true, string);
            }

            public void openImFailed(ImEvent imEvent) {
                if (ChatController.this.m_logger.isLoggable(Level.FINER)) {
                    ChatController.this.m_logger.logp(Level.FINER, this.getClass().getName(), "openImFailed", "Failed to open Im to Start A phone Call service, Reason: " + Integer.toHexString(imEvent.getReason()));
                }
            }
        });
        im.open();
    }

    private String createPhoneCallXML(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getAllUsers(vector).elements();
        stringBuffer.append("<call_request_info>\n");
        while (enumeration.hasMoreElements()) {
            STUser sTUser = (STUser)enumeration.nextElement();
            stringBuffer.append("<user>\n");
            stringBuffer.append("<user_id>");
            stringBuffer.append(sTUser.getId().getId());
            stringBuffer.append("</user_id>\n");
            stringBuffer.append("<user_on_mobile_device>");
            if (sTUser instanceof STWatchedUser) {
                short s = ((STWatchedUser)sTUser).getStatus().getStatusType();
                boolean bl = (s & 0x200) > 0;
                stringBuffer.append(bl ? "1" : "0");
            } else {
                stringBuffer.append("0");
            }
            stringBuffer.append("</user_on_mobile_device>\n");
            stringBuffer.append("<external_user>");
            stringBuffer.append(sTUser.isExternalUser() ? "1" : "0");
            stringBuffer.append("</external_user>\n");
            stringBuffer.append("</user>\n");
        }
        stringBuffer.append("</call_request_info>\n");
        return stringBuffer.toString();
    }
}

