/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awareness;

import com.lotus.sametime.awareness.AwarenessImpl;
import com.lotus.sametime.awareness.STWatchedObject;
import com.lotus.sametime.awareness.STWatchedUser;
import com.lotus.sametime.awareness.Session;
import com.lotus.sametime.awareness.WatchedObjectsFactory;
import com.lotus.sametime.awareness.WioGroup;
import com.lotus.sametime.awareness.WioObject;
import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STObjectImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class WioEntityTable {
    private Hashtable m_objTable = new Hashtable();
    private Hashtable m_groupsTable = new Hashtable();
    private Hashtable m_sessionTable = new Hashtable();
    private AwarenessImpl m_wioImpl;

    protected WioEntityTable(AwarenessImpl awarenessImpl) {
        this.m_wioImpl = awarenessImpl;
    }

    public WioObject addObjWatch(STWatchedObject sTWatchedObject, short s, Integer n) {
        WioObject wioObject = (WioObject)this.m_objTable.get(sTWatchedObject.getId());
        if (wioObject == null) {
            wioObject = new WioObject(sTWatchedObject, s);
            this.m_objTable.put(sTWatchedObject.getId(), wioObject);
        }
        wioObject.addWatch(n);
        return wioObject;
    }

    public WioGroup addGroupWatch(STGroup sTGroup, Integer n) {
        WioGroup wioGroup = (WioGroup)this.m_groupsTable.get(sTGroup.getId());
        if (wioGroup == null) {
            wioGroup = new WioGroup(sTGroup);
            this.m_groupsTable.put(sTGroup.getId(), wioGroup);
        }
        wioGroup.addWatch(n);
        return wioGroup;
    }

    public WioObject removeObjWatch(STObject sTObject, Integer n) {
        WioObject wioObject = (WioObject)this.m_objTable.get(sTObject.getId());
        if (wioObject != null) {
            wioObject.removeWatch(n);
            if (!wioObject.isWatched()) {
                this.m_objTable.remove(sTObject.getId());
            }
        }
        return wioObject;
    }

    public WioGroup removeGroupWatch(STGroup sTGroup, Integer n) {
        WioGroup wioGroup = (WioGroup)this.m_groupsTable.get(sTGroup.getId());
        if (wioGroup != null) {
            wioGroup.removeWatch(n);
            if (!wioGroup.isWatched()) {
                this.clearGroupContent(sTGroup);
                this.m_groupsTable.remove(sTGroup.getId());
            }
        }
        return wioGroup;
    }

    public Enumeration getUsers() {
        return this.m_objTable.elements();
    }

    public Enumeration getGroups() {
        return this.m_groupsTable.elements();
    }

    public Enumeration getObjWatchingSessions(STId sTId) {
        Enumeration enumeration = null;
        WioObject wioObject = (WioObject)this.m_objTable.get(sTId);
        if (wioObject != null) {
            enumeration = wioObject.getWatchingSessions();
        }
        return enumeration;
    }

    public Enumeration getGroupWatchingSessions(STId sTId) {
        WioGroup wioGroup = (WioGroup)this.m_groupsTable.get(sTId);
        if (wioGroup == null) {
            return null;
        }
        return wioGroup.getWatchingSessions();
    }

    public WioObject setUserStatus(STId sTId, STId sTId2, String string, short s, String string2, String string3) {
        STObjectImpl sTObjectImpl;
        WioObject wioObject = (WioObject)this.m_objTable.get(sTId);
        if (wioObject == null) {
            WatchedObjectsFactory cfr_ignored_0 = this.m_wioImpl.m_objectFactory;
            sTObjectImpl = (STWatchedUser)this.m_wioImpl.m_objectFactory.getWatchedObject(2, sTId, string, string2);
            WatchedObjectsFactory cfr_ignored_1 = this.m_wioImpl.m_objectFactory;
            wioObject = new WioObject((STWatchedObject)((Object)sTObjectImpl), 2);
            this.m_objTable.put(sTId, wioObject);
        }
        if (!sTId2.getId().equals("")) {
            sTObjectImpl = this.getGroup(sTId2).getSTGroup();
            wioObject.addWatch((STGroup)sTObjectImpl);
            if (null != string && string.trim().length() > 0) {
                wioObject.setName(string);
            }
        }
        wioObject.setStatus(s, string2);
        wioObject.setIconUrl(string3);
        return wioObject;
    }

    public void reset() {
        this.m_objTable.clear();
        this.m_groupsTable.clear();
        this.m_sessionTable.clear();
    }

    boolean isEmpty() {
        return this.m_objTable.isEmpty() && this.m_groupsTable.isEmpty();
    }

    WioObject getObj(STId sTId) {
        return (WioObject)this.m_objTable.get(sTId);
    }

    WioGroup getGroup(STId sTId) {
        return (WioGroup)this.m_groupsTable.get(sTId);
    }

    public void clearGroupContent(STGroup sTGroup) {
        WioGroup wioGroup = (WioGroup)this.m_groupsTable.get(sTGroup.getId());
        if (wioGroup == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)this.m_objTable.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            WioObject wioObject = (WioObject)enumeration.nextElement();
            wioObject.removeWatch(sTGroup);
            if (wioObject.isWatched()) continue;
            this.m_objTable.remove(wioObject.getWatchedObject());
        }
    }

    public WioObject[] getUsersInGroups(STGroup sTGroup) {
        Object[] objectArray = null;
        Vector<WioObject> vector = new Vector<WioObject>();
        Enumeration enumeration = this.m_objTable.elements();
        while (enumeration.hasMoreElements()) {
            WioObject wioObject = (WioObject)enumeration.nextElement();
            if (!wioObject.isWatched(sTGroup)) continue;
            vector.addElement(wioObject);
        }
        if (vector.size() > 0) {
            objectArray = new WioObject[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public Vector sessionUsers(Integer n) {
        Vector<STWatchedObject> vector = new Vector<STWatchedObject>();
        Enumeration enumeration = this.getUsers();
        while (enumeration.hasMoreElements()) {
            WioObject wioObject = (WioObject)enumeration.nextElement();
            if (!wioObject.isWatched(n)) continue;
            vector.addElement(wioObject.getWatchedObject());
        }
        return vector;
    }

    public Vector sessionGroups(Integer n) {
        Vector<STGroup> vector = new Vector<STGroup>();
        Enumeration enumeration = this.getGroups();
        while (enumeration.hasMoreElements()) {
            WioGroup wioGroup = (WioGroup)enumeration.nextElement();
            if (!wioGroup.isWatched(n)) continue;
            vector.addElement(wioGroup.getSTGroup());
        }
        return vector;
    }

    public Vector getAllWatchedEntities() {
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.m_groupsTable.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.m_objTable.elements();
        while (enumeration.hasMoreElements()) {
            WioObject wioObject = (WioObject)enumeration.nextElement();
            if (!wioObject.isWatchedBySession()) continue;
            vector.addElement(wioObject);
        }
        return vector;
    }

    public Session getSession(Integer n) {
        return (Session)this.m_sessionTable.get(n);
    }

    public void addSession(Session session) {
        this.m_sessionTable.put(session.getId(), session);
    }

    public void removeSession(Integer n) {
        this.m_sessionTable.remove(n);
    }

    public boolean isSessionExists(Integer n) {
        boolean bl = false;
        if (this.getSession(n) != null) {
            bl = true;
        }
        return bl;
    }
}

