/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.announcementui;

import com.lotus.sametime.announcement.AnnouncementService;
import com.lotus.sametime.announcementui.AnnouncementNode;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.STTextArea;
import com.lotus.sametime.guiutils.statusbar.Statusbar;
import com.lotus.sametime.guiutils.tree.TreeModel;
import com.lotus.sametime.guiutils.tree.TreeView;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;

public class SendAnnouncementDialog
extends Dialog {
    private static final short PADDING = 5;
    private static final int DEFAULT_WIDTH = 350;
    private static final int DEFAULT_HEIGHT = 300;
    private static final int MAX_TEXT_SIZE = 512;
    private static String BUNDLE_FILE_NAME = "properties/announcementui";
    private STSession m_session;
    private Frame m_parent;
    private AnnouncementService m_announcementSvc;
    private ResourceLoaderService m_loader;
    private STBundle m_resourceFile;
    private STObject[] m_recipients;
    private STTextArea m_messageArea;
    private Checkbox m_allowCheckbox;
    private Button m_sendButton;
    private Panel m_listPanel;
    private TreeView m_treeView;
    private boolean m_isTabFromTA = true;
    private boolean m_shiftPressed = false;

    public SendAnnouncementDialog(Frame frame, STSession sTSession, STObject[] sTObjectArray) {
        super(frame);
        this.m_parent = frame;
        this.m_session = sTSession;
        this.m_recipients = sTObjectArray;
        this.addWindowListener(new WindowEventHandler());
        this.m_loader = (ResourceLoaderService)((Object)this.m_session.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_resourceFile = this.m_loader.getBundle(BUNDLE_FILE_NAME);
        this.m_announcementSvc = (AnnouncementService)this.m_session.getCompApi("com.lotus.sametime.announcement.AnnouncementComp");
        this.showDialog();
    }

    private void showDialog() {
        this.setTitle(this.m_resourceFile.getString("SEND_DLG_TITLE"));
        this.setFont(Font.decode(Toolkit.getDefaultToolkit().getFontList()[0]));
        this.setSize(350, 300);
        this.setLayout(new BorderLayout(0, 6));
        ButtonEventHandler buttonEventHandler = new ButtonEventHandler();
        Panel panel = new Panel(new BorderLayout());
        Label label = new Label(this.m_resourceFile.getString("SEND_DLG_INSTRUCTIONS"));
        Label label2 = new Label(this.m_resourceFile.getString("SEND_DLG_TIP"));
        this.m_messageArea = new STTextArea("", 3, 30, 1);
        this.m_messageArea.setEditable(true);
        this.m_messageArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c == '\t') {
                    String string = SendAnnouncementDialog.this.m_messageArea.getText();
                    SendAnnouncementDialog.this.m_messageArea.setText(string.trim());
                    SendAnnouncementDialog.this.m_messageArea.setCaretPosition(string.length());
                    if (SendAnnouncementDialog.this.m_isTabFromTA) {
                        SendAnnouncementDialog.this.m_messageArea.nextFocus();
                        SendAnnouncementDialog.this.m_isTabFromTA = false;
                    } else {
                        keyEvent.consume();
                        SendAnnouncementDialog.this.m_isTabFromTA = true;
                    }
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && (keyEvent.getModifiers() & 1) == 0) {
                    if ((keyEvent.getModifiers() & 2) != 0) {
                        String string = SendAnnouncementDialog.this.m_messageArea.getText() + "\n";
                        SendAnnouncementDialog.this.m_messageArea.setText(string);
                        SendAnnouncementDialog.this.m_messageArea.setCaretPosition(SendAnnouncementDialog.this.m_messageArea.getText().length());
                    } else {
                        SendAnnouncementDialog.this.sendPressed();
                    }
                }
            }
        });
        this.m_messageArea.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent textEvent) {
                if (SendAnnouncementDialog.this.m_messageArea.getText().length() > 512) {
                    Toolkit.getDefaultToolkit().beep();
                    SendAnnouncementDialog.this.m_messageArea.setText(SendAnnouncementDialog.this.m_messageArea.getText().substring(0, 512));
                    SendAnnouncementDialog.this.m_messageArea.setCaretPosition(513);
                }
                if (SendAnnouncementDialog.this.m_messageArea.getText().length() == 0) {
                    SendAnnouncementDialog.this.m_sendButton.setEnabled(false);
                } else {
                    SendAnnouncementDialog.this.m_sendButton.setEnabled(true);
                }
            }
        });
        panel.add((Component)label, "North");
        panel.add((Component)label2, "Center");
        panel.add((Component)this.m_messageArea, "South");
        Panel panel2 = new Panel(new BorderLayout(0, 6));
        Label label3 = new Label(this.m_resourceFile.getString("SEND_DLG_RECIPIENTS"));
        this.m_listPanel = this.createListPanel();
        this.add((Component)this.m_listPanel, "Center");
        this.m_allowCheckbox = new Checkbox(this.m_resourceFile.getString("SEND_DLG_ALLOW_RESPOND"), false);
        panel2.add((Component)label3, "North");
        panel2.add((Component)this.m_listPanel, "Center");
        panel2.add((Component)this.m_allowCheckbox, "South");
        Panel panel3 = new Panel(new BorderLayout());
        String[] stringArray = new String[]{this.m_resourceFile.getString("SEND_DLG_BTN_SEND"), this.m_resourceFile.getString("SEND_DLG_BTN_CANCEL")};
        ButtonsPanel buttonsPanel = new ButtonsPanel(stringArray, buttonEventHandler, 2);
        this.m_sendButton = buttonsPanel.getButton(stringArray[0]);
        Statusbar statusbar = new Statusbar(this.m_resourceFile.getString("SEND_DLG_NOT_SECURED"), this.m_resourceFile.getFont("FONT_PLAIN_NAME", "FONT_PLAIN_STYLE", "FONT_PLAIN_SIZE"), this.m_resourceFile.getInt("STATUSBAR_HEIGHT"), this.m_loader.getImage("images/no_encrypt_key.gif"));
        panel3.add((Component)buttonsPanel, "North");
        panel3.add((Component)statusbar, "South");
        this.add((Component)panel, "North");
        this.add((Component)panel2, "Center");
        this.add((Component)panel3, "South");
        Dimension dimension = this.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
        this.m_sendButton.setEnabled(false);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    private Panel createListPanel() {
        TreeModel treeModel = new TreeModel();
        treeModel.sortOnOff(true);
        this.m_treeView = new TreeView(treeModel, 1, true);
        treeModel.addTreeModelListener(this.m_treeView);
        Image image = this.m_loader.getImage("images/shortcut.gif");
        Image image2 = this.m_loader.getImage("images/user.gif");
        Vector<AnnouncementNode> vector = new Vector<AnnouncementNode>();
        for (int i = 0; i < this.m_recipients.length; ++i) {
            if (this.m_recipients[i] instanceof STGroup) {
                vector.addElement(new AnnouncementNode((STGroup)this.m_recipients[i], this.m_recipients[i].getName(), image, 1));
                continue;
            }
            vector.addElement(new AnnouncementNode((STUser)this.m_recipients[i], ((STUser)this.m_recipients[i]).getDisplayName(), image2, 0));
        }
        treeModel.insertNodes(vector);
        Panel panel = new Panel(new BorderLayout(){

            public void requestFocus() {
                SendAnnouncementDialog.this.m_treeView.requestFocus();
            }
        });
        panel.add((Component)this.m_treeView, "Center");
        return panel;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 5, insets.left + 5, insets.bottom + 5, insets.right + 5);
    }

    private void sendPressed() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_messageArea.getText(), "\n");
        String string = "";
        while (stringTokenizer.hasMoreElements()) {
            string = string + stringTokenizer.nextElement() + "\r\n";
        }
        this.m_announcementSvc.sendAnnouncement(this.m_recipients, this.m_allowCheckbox.getState(), string);
        this.dispose();
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
                SendAnnouncementDialog.this.dispose();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_BTN_SEND"))){

            public void executeKeyMethod() {
                SendAnnouncementDialog.this.sendPressed();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_LIST_RECIPIENTS"))){

            public void executeKeyMethod() {
                SendAnnouncementDialog.this.m_listPanel.requestFocus();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resourceFile.getString("MN_CHCKBOX_ALLOW_RESPOND"))){

            public void executeKeyMethod() {
                SendAnnouncementDialog.this.m_allowCheckbox.requestFocus();
            }
        });
        return new KeyHandler(vector);
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            SendAnnouncementDialog.this.dispose();
        }
    }

    private class ButtonEventHandler
    implements ActionListener {
        private ButtonEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((Button)actionEvent.getSource()).getLabel();
            if (string == SendAnnouncementDialog.this.m_resourceFile.getString("SEND_DLG_BTN_SEND")) {
                SendAnnouncementDialog.this.sendPressed();
            }
            if (string == SendAnnouncementDialog.this.m_resourceFile.getString("SEND_DLG_BTN_CANCEL")) {
                SendAnnouncementDialog.this.dispose();
            }
        }
    }
}

