/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.LinkedHashMapWriter;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.MapWriterMap;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SpecProvider;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.util.ByteUtils;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrJSONWriter;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.noggit.CharArr;
import org.noggit.JSONParser;
import org.noggit.JSONWriter;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Random RANDOM;
    public static final Function<JSONParser, ObjectBuilder> STANDARDOBJBUILDER;
    public static final Function<JSONParser, ObjectBuilder> MAPWRITEROBJBUILDER;
    public static final Function<JSONParser, ObjectBuilder> MAPOBJBUILDER;
    public static final Function<Object, String> OBJECT_TO_STRING;
    public static final Pattern ARRAY_ELEMENT_INDEX;
    public static final InputStreamConsumer<?> JAVABINCONSUMER;
    public static final InputStreamConsumer<?> JSONCONSUMER;
    public static final String CATCH_ALL_PROPERTIES_METHOD_NAME = "unknownProperties";
    private static final Map<Class<?>, List<FieldWriter>> storedReflectData;

    public static Map getDeepCopy(Map<?, ?> map, int maxDepth) {
        return Utils.getDeepCopy(map, maxDepth, true, false);
    }

    public static Map getDeepCopy(Map<?, ?> map, int maxDepth, boolean mutable) {
        return Utils.getDeepCopy(map, maxDepth, mutable, false);
    }

    public static Map getDeepCopy(Map<?, ?> map, int maxDepth, boolean mutable, boolean sorted) {
        if (map == null) {
            return null;
        }
        if (maxDepth < 1) {
            return map;
        }
        AbstractMap copy = sorted ? new TreeMap() : (map instanceof LinkedHashMap ? CollectionUtil.newLinkedHashMap(map.size()) : CollectionUtil.newHashMap(map.size()));
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> o;
            Map.Entry<?, ?> e = o = iterator.next();
            copy.put(e.getKey(), Utils.makeDeepCopy(e.getValue(), maxDepth, mutable, sorted));
        }
        return mutable ? copy : Collections.unmodifiableMap(copy);
    }

    public static void forEachMapEntry(Object o, String path, BiConsumer fun) {
        Object val = Utils.getObjectByPath(o, false, path);
        Utils.forEachMapEntry(val, fun);
    }

    public static void forEachMapEntry(Object o, List<String> path, BiConsumer fun) {
        Object val = Utils.getObjectByPath(o, false, path);
        Utils.forEachMapEntry(val, fun);
    }

    public static void forEachMapEntry(Object o, final BiConsumer fun) {
        if (o instanceof MapWriter) {
            MapWriter m = (MapWriter)o;
            try {
                m.writeMap(new MapWriter.EntryWriter(){

                    @Override
                    public MapWriter.EntryWriter put(CharSequence k, Object v) {
                        fun.accept(k, v);
                        return this;
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (o instanceof Map) {
            ((Map)o).forEach((k, v) -> fun.accept(k, v));
        }
    }

    private static Object makeDeepCopy(Object v, int maxDepth, boolean mutable, boolean sorted) {
        if (v instanceof MapWriter && maxDepth > 1) {
            v = ((MapWriter)((Object)v)).toMap(new LinkedHashMap<String, Object>());
        } else if (v instanceof IteratorWriter && maxDepth > 1) {
            List<Object> l = ((IteratorWriter)((Object)v)).toList(new ArrayList<Object>());
            if (sorted) {
                l.sort(null);
            }
            v = l;
        }
        if (v instanceof Map) {
            v = Utils.getDeepCopy((Map)((Object)v), maxDepth - 1, mutable, sorted);
        } else if (v instanceof Collection) {
            v = Utils.getDeepCopy(v, maxDepth - 1, mutable, sorted);
        }
        return v;
    }

    public static InputStream toJavabin(Object o) throws IOException {
        try (JavaBinCodec jbc = new JavaBinCodec();){
            BAOS baos = new BAOS();
            jbc.marshal(o, baos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.getbuf(), 0, baos.size());
            return byteArrayInputStream;
        }
    }

    public static Object fromJavabin(byte[] bytes) throws IOException {
        try (JavaBinCodec jbc = new JavaBinCodec();){
            Object object = jbc.unmarshal(bytes);
            return object;
        }
    }

    public static Collection<?> getDeepCopy(Collection<?> c, int maxDepth, boolean mutable) {
        return Utils.getDeepCopy(c, maxDepth, mutable, false);
    }

    public static Collection<?> getDeepCopy(Collection<?> c, int maxDepth, boolean mutable, boolean sorted) {
        if (c == null || maxDepth < 1) {
            return c;
        }
        AbstractCollection result = c instanceof Set ? (sorted ? new TreeSet() : new HashSet()) : new ArrayList();
        for (Object o : c) {
            result.add(Utils.makeDeepCopy(o, maxDepth, mutable, sorted));
        }
        if (sorted && result instanceof List) {
            ((List)((Object)result)).sort(null);
        }
        return mutable ? result : Collections.unmodifiableCollection(result);
    }

    public static void writeJson(Object o, OutputStream os, boolean indent) throws IOException {
        Utils.writeJson(o, new OutputStreamWriter(os, StandardCharsets.UTF_8), indent).flush();
    }

    public static Writer writeJson(Object o, Writer writer, boolean indent) throws IOException {
        try (SolrJSONWriter jsonWriter = new SolrJSONWriter(writer);){
            jsonWriter.setIndent(indent).writeObj(o);
        }
        return writer;
    }

    public static byte[] toJSON(Object o) {
        if (o == null) {
            return new byte[0];
        }
        CharArr out = new CharArr();
        new JSONWriter(out, 2).write(o);
        return Utils.toUTF8(out);
    }

    public static byte[] toJSON(Object o, int indentSize) {
        if (o == null) {
            return new byte[0];
        }
        CharArr out = new CharArr();
        new JSONWriter(out, indentSize).write(o);
        return Utils.toUTF8(out);
    }

    public static String toJSONString(Object o, int indentSize) {
        return new String(Utils.toJSON(o, indentSize), StandardCharsets.UTF_8);
    }

    public static String toJSONString(Object o) {
        return new String(Utils.toJSON(o), StandardCharsets.UTF_8);
    }

    public static byte[] toUTF8(CharArr out) {
        byte[] arr = new byte[out.size() * 3];
        int nBytes = ByteUtils.UTF16toUTF8(out, 0, out.size(), arr, 0);
        return Arrays.copyOf(arr, nBytes);
    }

    public static Object fromJSON(byte[] utf8) {
        if (utf8 == null || utf8.length == 0) {
            return Collections.emptyMap();
        }
        return Utils.fromJSON(utf8, 0, utf8.length);
    }

    public static Object fromJSON(byte[] utf8, int offset, int length) {
        return Utils.fromJSON(utf8, offset, length, STANDARDOBJBUILDER);
    }

    public static Object fromJSON(byte[] utf8, int offset, int length, Function<JSONParser, ObjectBuilder> fun) {
        if (utf8 == null || utf8.length == 0 || length == 0) {
            return Collections.emptyMap();
        }
        CharArr chars = new CharArr();
        ByteUtils.UTF8toUTF16(utf8, offset, length, chars);
        JSONParser parser = new JSONParser(chars.getArray(), chars.getStart(), chars.length());
        parser.setFlags(parser.getFlags() | 0x40 | 0x80);
        try {
            return fun.apply(parser).getValStrict();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> Map<String, V> makeMap(String k1, V v1, String k2, V v2) {
        LinkedHashMap<String, V> map = new LinkedHashMap<String, V>(2, 1.0f);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static Map<String, Object> makeMap(Object ... keyVals) {
        return Utils._makeMap(keyVals);
    }

    public static Map<String, String> makeMap(String ... keyVals) {
        return Utils._makeMap(keyVals);
    }

    private static <T> Map<String, T> _makeMap(T[] keyVals) {
        if ((keyVals.length & 1) != 0) {
            throw new IllegalArgumentException("arguments should be key,value");
        }
        LinkedHashMap<String, T> propMap = new LinkedHashMap<String, T>();
        for (int i = 0; i < keyVals.length; i += 2) {
            propMap.put(String.valueOf(keyVals[i]), keyVals[i + 1]);
        }
        return propMap;
    }

    public static Object fromJSON(InputStream is) {
        return Utils.fromJSON(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static Object fromJSON(Reader is) {
        try {
            return STANDARDOBJBUILDER.apply(Utils.getJSONParser(is)).getValStrict();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Parse error", (Throwable)e);
        }
    }

    public static Object fromJSON(InputStream is, Function<JSONParser, ObjectBuilder> objBuilderProvider) {
        try {
            return objBuilderProvider.apply(Utils.getJSONParser(new InputStreamReader(is, StandardCharsets.UTF_8))).getValStrict();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Parse error", (Throwable)e);
        }
    }

    public static Object fromJSONResource(ClassLoader loader, String resourceName) {
        Object object;
        block9: {
            URL resource = loader.getResource(resourceName);
            if (null == resource) {
                throw new IllegalArgumentException("invalid resource name: " + resourceName);
            }
            InputStream stream = resource.openStream();
            try {
                object = Utils.fromJSON(stream);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Resource error: " + e.getMessage(), (Throwable)e);
                }
            }
            stream.close();
        }
        return object;
    }

    public static JSONParser getJSONParser(Reader reader) {
        JSONParser parser = new JSONParser(reader);
        parser.setFlags(parser.getFlags() | 0x40 | 0x80);
        return parser;
    }

    public static Object fromJSONString(String json) {
        try {
            return STANDARDOBJBUILDER.apply(Utils.getJSONParser(new StringReader(json))).getValStrict();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Parse error : " + json, (Throwable)e);
        }
    }

    public static Object getObjectByPath(Object root, boolean onlyPrimitive, String hierarchy) {
        if (hierarchy == null) {
            return Utils.getObjectByPath(root, onlyPrimitive, Collections.singletonList(null));
        }
        List<String> parts = StrUtils.splitSmart(hierarchy, '/', true);
        return Utils.getObjectByPath(root, onlyPrimitive, parts);
    }

    public static boolean setObjectByPath(Object root, String hierarchy, Object value) {
        List<String> parts = StrUtils.splitSmart(hierarchy, '/', true);
        return Utils.setObjectByPath(root, parts, value);
    }

    public static boolean setObjectByPath(Object root, List<String> hierarchy, Object value) {
        if (root == null) {
            return false;
        }
        if (!Utils.isMapLike(root)) {
            throw new RuntimeException("must be a Map or NamedList");
        }
        Object obj = root;
        for (int i = 0; i < hierarchy.size(); ++i) {
            Object o;
            Matcher matcher;
            int idx = -2;
            String s = hierarchy.get(i);
            if (s.endsWith("]") && (matcher = ARRAY_ELEMENT_INDEX.matcher(s)).find()) {
                s = matcher.group(1);
                idx = Integer.parseInt(matcher.group(2));
            }
            if (i < hierarchy.size() - 1) {
                o = Utils.getVal(obj, s, -1);
                if (o == null) {
                    return false;
                }
                if (idx > -1) {
                    List l = (List)o;
                    Object object = o = idx < l.size() ? (Object)l.get(idx) : null;
                }
                if (!Utils.isMapLike(o)) {
                    return false;
                }
            } else {
                if (idx == -2) {
                    if (obj instanceof NamedList) {
                        NamedList namedList = (NamedList)obj;
                        int location = namedList.indexOf(s, 0);
                        if (location == -1) {
                            namedList.add(s, value);
                        } else {
                            namedList.setVal(location, value);
                        }
                    } else if (obj instanceof Map) {
                        Map map = (Map)obj;
                        map.put(s, value);
                    }
                    return true;
                }
                Object v = Utils.getVal(obj, s, -1);
                if (v instanceof List) {
                    List list = (List)v;
                    if (idx == -1) {
                        list.add(value);
                    } else if (idx < list.size()) {
                        list.set(idx, value);
                    } else {
                        return false;
                    }
                    return true;
                }
                return false;
            }
            obj = o;
        }
        return false;
    }

    public static Object getObjectByPath(Object root, boolean onlyPrimitive, List<String> hierarchy) {
        if (root == null) {
            return null;
        }
        if (!Utils.isMapLike(root)) {
            return null;
        }
        Object obj = root;
        for (int i = 0; i < hierarchy.size(); ++i) {
            List l;
            Object o;
            Matcher matcher;
            int idx = -1;
            String s = hierarchy.get(i);
            if (s != null && s.endsWith("]") && (matcher = ARRAY_ELEMENT_INDEX.matcher(s)).find()) {
                s = matcher.group(1);
                idx = Integer.parseInt(matcher.group(2));
            }
            if (i < hierarchy.size() - 1) {
                o = Utils.getVal(obj, s, -1);
                if (o == null) {
                    return null;
                }
                if (idx > -1) {
                    if (o instanceof List) {
                        l = (List)o;
                        o = idx < l.size() ? l.get(idx) : null;
                    } else if (o instanceof IteratorWriter) {
                        o = Utils.getValueAt((IteratorWriter)o, idx);
                    } else if (o instanceof MapWriter) {
                        o = Utils.getVal(o, null, idx);
                    } else if (o instanceof Map) {
                        Map map = (Map)o;
                        o = Utils.getVal(new MapWriterMap(map), null, idx);
                    } else {
                        return null;
                    }
                }
                if (!Utils.isMapLike(o)) {
                    return null;
                }
            } else {
                Object val = Utils.getVal(obj, s, -1);
                if (val == null) {
                    return null;
                }
                if (idx > -1) {
                    if (val instanceof IteratorWriter) {
                        val = Utils.getValueAt((IteratorWriter)val, idx);
                    } else {
                        l = (List)val;
                        Object object = val = idx < l.size() ? (Object)l.get(idx) : null;
                    }
                }
                if (onlyPrimitive && Utils.isMapLike(val)) {
                    return null;
                }
                return val;
            }
            obj = o;
        }
        return false;
    }

    private static Object getValueAt(IteratorWriter iteratorWriter, final int idx) {
        final Object[] result = new Object[1];
        try {
            iteratorWriter.writeIter(new IteratorWriter.ItemWriter(){
                int i = -1;

                @Override
                public IteratorWriter.ItemWriter add(Object o) {
                    ++this.i;
                    if (this.i > idx) {
                        return this;
                    }
                    if (this.i == idx) {
                        result[0] = o;
                    }
                    return this;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result[0];
    }

    private static boolean isMapLike(Object o) {
        return o instanceof Map || o instanceof NamedList || o instanceof MapWriter;
    }

    private static Object getVal(Object obj, final String key, final int idx) {
        if (obj instanceof MapWriter) {
            final Object[] result = new Object[1];
            try {
                ((MapWriter)obj).writeMap(new MapWriter.EntryWriter(){
                    int count = -1;

                    @Override
                    public MapWriter.EntryWriter put(CharSequence k, Object v) {
                        if (result[0] != null) {
                            return this;
                        }
                        if (idx < 0) {
                            if (key.contentEquals(k)) {
                                result[0] = v;
                            }
                        } else if (++this.count == idx) {
                            result[0] = new MapWriterEntry<Object>(k, v);
                        }
                        return this;
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return result[0];
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(key);
        }
        throw new RuntimeException("must be a NamedList or Map");
    }

    public static void consumeFully(HttpEntity entity) {
        if (entity != null) {
            try {
                Utils.readFully(entity.getContent());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (IOException iOException) {
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
        }
    }

    public static void readFully(InputStream is) throws IOException {
        is.skip(is.available());
        while (is.read() != -1) {
        }
    }

    public static SpecProvider getSpec(String name) {
        return () -> ValidatingJsonMap.parse("apispec/" + name + ".json", "apispec/");
    }

    public static String parseMetricsReplicaName(String collectionName, String coreName) {
        if (collectionName == null || !coreName.startsWith(collectionName)) {
            return null;
        }
        if (coreName.length() > collectionName.length()) {
            String str = coreName.substring(collectionName.length() + 1);
            int pos = str.lastIndexOf("_replica");
            if (pos == -1) {
                return str;
            }
            return str.substring(pos + 1);
        }
        return null;
    }

    public static boolean mergeJson(Map<String, Object> sink, Map<String, Object> input) {
        boolean isModified = false;
        for (Map.Entry<String, Object> e : input.entrySet()) {
            if (sink.get(e.getKey()) != null) {
                Object sinkVal = sink.get(e.getKey());
                if (e.getValue() == null) {
                    sink.remove(e.getKey());
                    isModified = true;
                    continue;
                }
                if (e.getValue() instanceof Map) {
                    Map mapInputVal = (Map)e.getValue();
                    if (sinkVal instanceof Map) {
                        if (!Utils.mergeJson((Map)sinkVal, mapInputVal)) continue;
                        isModified = true;
                        continue;
                    }
                    sink.put(e.getKey(), mapInputVal);
                    isModified = true;
                    continue;
                }
                sink.put(e.getKey(), e.getValue());
                isModified = true;
                continue;
            }
            if (e.getValue() == null) continue;
            sink.put(e.getKey(), e.getValue());
            isModified = true;
        }
        return isModified;
    }

    public static String applyUrlScheme(String url, String urlScheme) {
        Objects.requireNonNull(url, "URL must not be null!");
        int at = url.indexOf("://");
        return at == -1 ? urlScheme + "://" + url : urlScheme + url.substring(at);
    }

    public static String getBaseUrlForNodeName(String nodeName, String urlScheme) {
        return Utils.getBaseUrlForNodeName(nodeName, urlScheme, false);
    }

    public static String getBaseUrlForNodeName(String nodeName, String urlScheme, boolean isV2) {
        int colonAt = nodeName.indexOf(58);
        if (colonAt == -1) {
            throw new IllegalArgumentException("nodeName does not contain expected ':' separator: " + nodeName);
        }
        int _offset = nodeName.indexOf(95, colonAt);
        if (_offset < 0) {
            throw new IllegalArgumentException("nodeName does not contain expected '_' separator: " + nodeName);
        }
        String hostAndPort = nodeName.substring(0, _offset);
        String path = URLDecoder.decode(nodeName.substring(1 + _offset), StandardCharsets.UTF_8);
        return urlScheme + "://" + hostAndPort + (String)(path.isEmpty() ? "" : "/" + (isV2 ? "api" : path));
    }

    public static long time(TimeSource timeSource, TimeUnit unit) {
        return unit.convert(timeSource.getTimeNs(), TimeUnit.NANOSECONDS);
    }

    public static long timeElapsed(TimeSource timeSource, long start, TimeUnit unit) {
        return unit.convert(timeSource.getTimeNs() - TimeUnit.NANOSECONDS.convert(start, unit), TimeUnit.NANOSECONDS);
    }

    public static <T> T handleExp(Logger logger, T def, Callable<T> c) {
        try {
            return c.call();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return def;
        }
    }

    public static InputStreamConsumer<ByteBuffer> newBytesConsumer(int maxSize) {
        return is -> {
            ByteBuffer byteBuffer;
            BAOS bos = new BAOS();
            try {
                long sz = 0L;
                int next = is.read();
                while (next > -1) {
                    if (++sz > (long)maxSize) {
                        throw new BufferOverflowException();
                    }
                    bos.write(next);
                    next = is.read();
                }
                bos.flush();
                byteBuffer = ByteBuffer.wrap(bos.getbuf(), 0, bos.size());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            bos.close();
            return byteBuffer;
        };
    }

    public static <T> T executeGET(HttpClient client, String url, InputStreamConsumer<T> consumer) throws SolrException {
        return Utils.executeHttpMethod(client, url, consumer, (HttpRequestBase)new HttpGet(url));
    }

    public static <T> T executeHttpMethod(HttpClient client, String url, InputStreamConsumer<T> consumer, HttpRequestBase httpMethod) {
        T result = null;
        HttpResponse rsp = null;
        try {
            rsp = client.execute((HttpUriRequest)httpMethod);
        }
        catch (IOException e) {
            log.error("Error in request to url : {}", (Object)url, (Object)e);
            throw new SolrException(SolrException.ErrorCode.UNKNOWN, "Error sending request");
        }
        int statusCode = rsp.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            try {
                log.error("Failed a request to: {}, status: {}, body: {}", new Object[]{url, rsp.getStatusLine(), EntityUtils.toString((HttpEntity)rsp.getEntity(), (Charset)StandardCharsets.UTF_8)});
            }
            catch (IOException e) {
                log.error("could not print error", (Throwable)e);
            }
            throw new SolrException(SolrException.ErrorCode.getErrorCode(statusCode), "Unknown error");
        }
        HttpEntity entity = rsp.getEntity();
        try {
            InputStream is = entity.getContent();
            if (consumer != null) {
                result = consumer.accept(is);
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.UNKNOWN, (Throwable)e);
        }
        finally {
            Utils.consumeFully(entity);
        }
        return result;
    }

    public static void reflectWrite(MapWriter.EntryWriter ew, Object o) {
        Utils.reflectWrite(ew, o, field -> field.getAnnotation(JsonProperty.class) != null, null, field -> {
            JsonProperty prop = field.getAnnotation(JsonProperty.class);
            return prop.value().isEmpty() ? field.getName() : prop.value();
        });
    }

    public static Object getReflectWriter(Object o) {
        List<FieldWriter> fieldWriters = null;
        try {
            fieldWriters = Utils.getReflectData(o.getClass(), field -> field.getAnnotation(com.fasterxml.jackson.annotation.JsonProperty.class) != null, JsonAnyGetter.class, field -> {
                com.fasterxml.jackson.annotation.JsonProperty prop = field.getAnnotation(com.fasterxml.jackson.annotation.JsonProperty.class);
                return prop.value().isEmpty() ? field.getName() : prop.value();
            });
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (!fieldWriters.isEmpty()) {
            return new DelegateReflectWriter(o, fieldWriters);
        }
        return o.getClass().getName() + ":" + o;
    }

    public static void reflectWrite(MapWriter.EntryWriter ew, Object o, Predicate<Field> fieldFilterer, Class<? extends Annotation> catchAllAnnotation, Function<Field, String> fieldNamer) {
        List<FieldWriter> fieldWriters = null;
        try {
            fieldWriters = Utils.getReflectData(o.getClass(), fieldFilterer, catchAllAnnotation, fieldNamer);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        Utils.reflectWrite(ew, o, fieldWriters);
    }

    private static List<FieldWriter> getReflectData(Class<?> c, Predicate<Field> fieldFilterer, Class<? extends Annotation> catchAllAnnotation, Function<Field, String> fieldNamer) throws IllegalAccessException {
        boolean sameClassLoader = c.getClassLoader() == Utils.class.getClassLoader();
        List<FieldWriter> cachedReflectData = sameClassLoader ? storedReflectData.get(c) : null;
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        if (cachedReflectData == null) {
            cachedReflectData = Utils.addTraditionalFieldWriters(c, lookup, fieldFilterer, fieldNamer);
            if (sameClassLoader) {
                storedReflectData.put(c, Collections.unmodifiableList(new ArrayList<FieldWriter>(cachedReflectData)));
            }
        }
        ArrayList<FieldWriter> mutableFieldWriters = new ArrayList<FieldWriter>(cachedReflectData);
        Utils.addCatchAllFieldWriter(mutableFieldWriters, catchAllAnnotation, lookup, c);
        return Collections.unmodifiableList(mutableFieldWriters);
    }

    private static void reflectWrite(MapWriter.EntryWriter ew, Object o, List<FieldWriter> fieldWriters) {
        for (FieldWriter fieldWriter : fieldWriters) {
            try {
                fieldWriter.write(ew, o);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static List<FieldWriter> addTraditionalFieldWriters(Class<?> c, MethodHandles.Lookup lookup, Predicate<Field> fieldFilterer, Function<Field, String> fieldNamer) throws IllegalAccessException {
        ArrayList<FieldWriter> fieldWriters = new ArrayList<FieldWriter>();
        for (Field field : lookup.accessClass(c).getFields()) {
            int modifiers;
            if (!fieldFilterer.test(field) || !Modifier.isPublic(modifiers = field.getModifiers()) || Modifier.isStatic(modifiers)) continue;
            String fname = fieldNamer.apply(field);
            try {
                MethodHandle mh;
                if (field.getType() == Integer.TYPE) {
                    mh = lookup.findGetter(c, field.getName(), Integer.TYPE);
                    fieldWriters.add((ew, inst) -> ew.put((CharSequence)fname, mh.invoke(inst)));
                    continue;
                }
                if (field.getType() == Long.TYPE) {
                    mh = lookup.findGetter(c, field.getName(), Long.TYPE);
                    fieldWriters.add((ew, inst) -> ew.put((CharSequence)fname, mh.invoke(inst)));
                    continue;
                }
                if (field.getType() == Boolean.TYPE) {
                    mh = lookup.findGetter(c, field.getName(), Boolean.TYPE);
                    fieldWriters.add((ew, inst) -> ew.put((CharSequence)fname, mh.invoke(inst)));
                    continue;
                }
                if (field.getType() == Double.TYPE) {
                    mh = lookup.findGetter(c, field.getName(), Double.TYPE);
                    fieldWriters.add((ew, inst) -> ew.put((CharSequence)fname, mh.invoke(inst)));
                    continue;
                }
                if (field.getType() == Float.TYPE) {
                    mh = lookup.findGetter(c, field.getName(), Float.TYPE);
                    fieldWriters.add((ew, inst) -> ew.put((CharSequence)fname, mh.invoke(inst)));
                    continue;
                }
                mh = lookup.findGetter(c, field.getName(), field.getType());
                fieldWriters.add((ew, inst) -> ew.putIfNotNull((CharSequence)fname, mh.invoke(inst)));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        return fieldWriters;
    }

    private static void addCatchAllFieldWriter(List<FieldWriter> fieldWriters, Class<? extends Annotation> catchAllAnnotation, MethodHandles.Lookup lookup, Class<?> c) throws IllegalAccessException {
        if (catchAllAnnotation != null) {
            try {
                Method catchAllMethod = lookup.accessClass(c).getDeclaredMethod(CATCH_ALL_PROPERTIES_METHOD_NAME, new Class[0]);
                if (catchAllMethod.getAnnotation(catchAllAnnotation) != null) {
                    MethodType catchAllMethodType = MethodType.methodType(Map.class);
                    MethodHandle catchAllHandle = lookup.findVirtual(c, CATCH_ALL_PROPERTIES_METHOD_NAME, catchAllMethodType);
                    fieldWriters.add((ew, inst) -> {
                        Map unknownProperties = catchAllHandle.invoke(inst);
                        for (Map.Entry entry : unknownProperties.entrySet()) {
                            ew.put((CharSequence)entry.getKey(), entry.getValue());
                        }
                    });
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public static Map<String, Object> reflectToMap(Object toReflect) {
        return ((DelegateReflectWriter)Utils.getReflectWriter(toReflect)).toMap(new HashMap<String, Object>());
    }

    public static Map<String, Object> convertToMap(MapWriter m, final Map<String, Object> map) {
        try {
            m.writeMap(new MapWriter.EntryWriter(){

                @Override
                public MapWriter.EntryWriter put(CharSequence k, Object v) {
                    return this.writeEntry(k, v);
                }

                /*
                 * WARNING - void declaration
                 */
                private MapWriter.EntryWriter writeEntry(CharSequence k, Object v) {
                    if (v instanceof MapWriter) {
                        v = ((MapWriter)v).toMap(new LinkedHashMap<String, Object>());
                    }
                    if (v instanceof IteratorWriter) {
                        v = ((IteratorWriter)v).toList(new ArrayList<Object>());
                    }
                    if (v instanceof Iterable) {
                        ArrayList<Object> lst = new ArrayList<Object>();
                        for (Object t : (Iterable)v) {
                            void var5_5;
                            void var5_8;
                            if (t instanceof MapWriter) {
                                Map<String, Object> map2 = ((MapWriter)t).toMap(new LinkedHashMap<String, Object>());
                            }
                            if (var5_8 instanceof IteratorWriter) {
                                List<Object> list = ((IteratorWriter)var5_8).toList(new ArrayList<Object>());
                            }
                            lst.add(var5_5);
                        }
                        v = lst;
                    }
                    if (v instanceof Map) {
                        LinkedHashMap map3 = new LinkedHashMap();
                        for (Map.Entry entry : ((Map)v).entrySet()) {
                            Object vv = entry.getValue();
                            if (vv instanceof MapWriter) {
                                vv = ((MapWriter)vv).toMap(new LinkedHashMap<String, Object>());
                            }
                            if (vv instanceof IteratorWriter) {
                                vv = ((IteratorWriter)vv).toList(new ArrayList<Object>());
                            }
                            map3.put(entry.getKey(), vv);
                        }
                        v = map3;
                    }
                    map.put(k == null ? null : k.toString(), v);
                    return this;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public static ByteBuffer toByteArray(InputStream is) throws IOException {
        return Utils.toByteArray(is, Integer.MAX_VALUE);
    }

    public static ByteBuffer toByteArray(InputStream is, long maxSize) throws IOException {
        try (BAOS bos = new BAOS();){
            long sz = 0L;
            int next = is.read();
            while (next > -1) {
                if (++sz > maxSize) {
                    throw new BufferOverflowException();
                }
                bos.write(next);
                next = is.read();
            }
            bos.flush();
            ByteBuffer byteBuffer = bos.getByteBuffer();
            return byteBuffer;
        }
    }

    static {
        String seed = System.getProperty("tests.seed");
        RANDOM = seed == null ? new Random() : new Random(seed.hashCode());
        STANDARDOBJBUILDER = jsonParser -> {
            try {
                return new ObjectBuilder((JSONParser)jsonParser);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        MAPWRITEROBJBUILDER = jsonParser -> {
            try {
                return new ObjectBuilder((JSONParser)jsonParser){

                    @Override
                    public Object newObject() {
                        return new LinkedHashMapWriter();
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        MAPOBJBUILDER = jsonParser -> {
            try {
                return new ObjectBuilder((JSONParser)jsonParser){

                    @Override
                    public Object newObject() {
                        return new HashMap();
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        OBJECT_TO_STRING = obj -> obj instanceof Date ? Objects.toString(((Date)obj).toInstant()) : Objects.toString(obj);
        ARRAY_ELEMENT_INDEX = Pattern.compile("(\\S*?)\\[([-]?\\d+)\\]");
        JAVABINCONSUMER = is -> new JavaBinCodec().unmarshal(is);
        JSONCONSUMER = Utils::fromJSON;
        storedReflectData = new ConcurrentHashMap();
    }

    public static class BAOS
    extends ByteArrayOutputStream {
        public ByteBuffer getByteBuffer() {
            return ByteBuffer.wrap(this.buf, 0, this.count);
        }

        public byte[] getbuf() {
            return this.buf;
        }
    }

    public static interface InputStreamConsumer<T> {
        public T accept(InputStream var1) throws IOException;
    }

    public static class DelegateReflectWriter
    implements MapWriter {
        private final Object object;
        private final List<FieldWriter> fieldWriters;

        DelegateReflectWriter(Object object, List<FieldWriter> fieldWriters) {
            this.object = object;
            this.fieldWriters = fieldWriters;
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            Utils.reflectWrite(ew, this.object, this.fieldWriters);
        }
    }

    static interface FieldWriter {
        public void write(MapWriter.EntryWriter var1, Object var2) throws Throwable;
    }

    static class MapWriterEntry<V>
    extends AbstractMap.SimpleEntry<CharSequence, V>
    implements MapWriter,
    Map.Entry<CharSequence, V> {
        MapWriterEntry(CharSequence key, V value) {
            super(key, value);
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.put((CharSequence)"key", (CharSequence)this.getKey());
            ew.put((CharSequence)"value", this.getValue());
        }
    }
}

