/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.request.IsUpdateRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.slf4j.MDC;

public abstract class LBSolrClient
extends SolrClient {
    protected static final Set<Integer> RETRY_CODES = new HashSet<Integer>(Arrays.asList(404, 403, 503, 500));
    private static final int NONSTANDARD_PING_LIMIT = 5;
    private final Map<String, ServerWrapper> aliveServers = new LinkedHashMap<String, ServerWrapper>();
    protected final Map<String, ServerWrapper> zombieServers = new ConcurrentHashMap<String, ServerWrapper>();
    private volatile ServerWrapper[] aliveServerList = new ServerWrapper[0];
    private volatile ScheduledExecutorService aliveCheckExecutor;
    protected long aliveCheckIntervalMillis = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private final AtomicInteger counter = new AtomicInteger(-1);
    private static final SolrQuery solrQuery = new SolrQuery("*:*");
    protected volatile ResponseParser parser;
    protected volatile RequestWriter requestWriter;

    public LBSolrClient(List<String> baseSolrUrls) {
        if (!baseSolrUrls.isEmpty()) {
            for (String s : baseSolrUrls) {
                ServerWrapper wrapper = this.createServerWrapper(s);
                this.aliveServers.put(wrapper.getBaseUrl(), wrapper);
            }
            this.updateAliveList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAliveList() {
        Map<String, ServerWrapper> map = this.aliveServers;
        synchronized (map) {
            this.aliveServerList = this.aliveServers.values().toArray(new ServerWrapper[0]);
        }
    }

    protected ServerWrapper createServerWrapper(String baseUrl) {
        return new ServerWrapper(baseUrl);
    }

    public static String normalize(String server) {
        if (server.endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rsp request(Req req) throws SolrServerException, IOException {
        String serverStr;
        Rsp rsp = new Rsp();
        Exception ex = null;
        boolean isNonRetryable = req.request instanceof IsUpdateRequest || CommonParams.ADMIN_PATHS.contains(req.request.getPath());
        ServerIterator serverIterator = new ServerIterator(req, this.zombieServers);
        while ((serverStr = serverIterator.nextOrError(ex)) != null) {
            try {
                MDC.put((String)"LBSolrClient.url", (String)serverStr);
                ex = this.doRequest(serverStr, req, rsp, isNonRetryable, serverIterator.isServingZombieServer());
                if (ex != null) continue;
                Rsp rsp2 = rsp;
                return rsp2;
            }
            finally {
                MDC.remove((String)"LBSolrClient.url");
            }
        }
        throw new SolrServerException("No live SolrServers available to handle this request. (Tracking " + this.zombieServers.size() + " not live)", ex);
    }

    private static long getTimeAllowedInNanos(SolrRequest<?> req) {
        SolrParams reqParams = req.getParams();
        return reqParams == null ? -1L : TimeUnit.NANOSECONDS.convert(reqParams.getInt("timeAllowed", -1), TimeUnit.MILLISECONDS);
    }

    private static boolean isTimeExceeded(long timeAllowedNano, long timeOutTime) {
        return timeAllowedNano > 0L && System.nanoTime() > timeOutTime;
    }

    protected Exception doRequest(String baseUrl, Req req, Rsp rsp, boolean isNonRetryable, boolean isZombie) throws SolrServerException, IOException {
        Exception ex = null;
        try {
            rsp.server = baseUrl;
            req.getRequest().setBasePath(baseUrl);
            rsp.rsp = this.getClient(baseUrl).request(req.getRequest(), null);
            if (isZombie) {
                this.zombieServers.remove(baseUrl);
            }
        }
        catch (BaseHttpSolrClient.RemoteExecutionException e) {
            throw e;
        }
        catch (SolrException e) {
            if (!isNonRetryable && RETRY_CODES.contains(e.code())) {
                ex = !isZombie ? this.addZombie(baseUrl, e) : e;
            }
            if (isZombie) {
                this.zombieServers.remove(baseUrl);
            }
            throw e;
        }
        catch (SocketException e) {
            if (!isNonRetryable || e instanceof ConnectException) {
                ex = !isZombie ? this.addZombie(baseUrl, e) : e;
            }
            throw e;
        }
        catch (SocketTimeoutException e) {
            if (!isNonRetryable) {
                ex = !isZombie ? this.addZombie(baseUrl, e) : e;
            }
            throw e;
        }
        catch (SolrServerException e) {
            Throwable rootCause = e.getRootCause();
            if (!isNonRetryable && rootCause instanceof IOException) {
                ex = !isZombie ? this.addZombie(baseUrl, e) : e;
            }
            if (isNonRetryable && rootCause instanceof ConnectException) {
                ex = !isZombie ? this.addZombie(baseUrl, e) : e;
            }
            throw e;
        }
        catch (Exception e) {
            throw new SolrServerException(e);
        }
        return ex;
    }

    protected abstract SolrClient getClient(String var1);

    protected abstract SolrClient getClient(Endpoint var1);

    protected Exception addZombie(String serverStr, Exception e) {
        ServerWrapper wrapper = this.createServerWrapper(serverStr);
        wrapper.standard = false;
        this.zombieServers.put(serverStr, wrapper);
        this.startAliveCheckExecutor();
        return e;
    }

    @Deprecated
    public void setAliveCheckInterval(int aliveCheckIntervalMillis) {
        if (aliveCheckIntervalMillis <= 0) {
            throw new IllegalArgumentException("Alive check interval must be positive, specified value = " + aliveCheckIntervalMillis);
        }
        this.aliveCheckIntervalMillis = aliveCheckIntervalMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAliveCheckExecutor() {
        if (this.aliveCheckExecutor == null) {
            LBSolrClient lBSolrClient = this;
            synchronized (lBSolrClient) {
                if (this.aliveCheckExecutor == null) {
                    this.aliveCheckExecutor = Executors.newSingleThreadScheduledExecutor(new SolrNamedThreadFactory("aliveCheckExecutor"));
                    this.aliveCheckExecutor.scheduleAtFixedRate(LBSolrClient.getAliveCheckRunner(new WeakReference<LBSolrClient>(this)), this.aliveCheckIntervalMillis, this.aliveCheckIntervalMillis, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private static Runnable getAliveCheckRunner(WeakReference<LBSolrClient> lbRef) {
        return () -> {
            LBSolrClient lb = (LBSolrClient)lbRef.get();
            if (lb != null && lb.zombieServers != null) {
                for (ServerWrapper zombieServer : lb.zombieServers.values()) {
                    lb.checkAZombieServer(zombieServer);
                }
            }
        };
    }

    public ResponseParser getParser() {
        return this.parser;
    }

    @Deprecated
    public void setParser(ResponseParser parser) {
        this.parser = parser;
    }

    @Deprecated
    public void setRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
    }

    public RequestWriter getRequestWriter() {
        return this.requestWriter;
    }

    private void checkAZombieServer(ServerWrapper zombieServer) {
        block4: {
            try {
                ServerWrapper wrapper;
                QueryRequest queryRequest = new QueryRequest(solrQuery);
                queryRequest.setBasePath(zombieServer.baseUrl);
                QueryResponse resp = (QueryResponse)queryRequest.process(this.getClient(zombieServer.getBaseUrl()));
                if (resp.getStatus() == 0 && (wrapper = this.zombieServers.remove(zombieServer.getBaseUrl())) != null) {
                    wrapper.failedPings = 0;
                    if (wrapper.standard) {
                        this.addToAlive(wrapper);
                    }
                }
            }
            catch (Exception e) {
                ++zombieServer.failedPings;
                if (zombieServer.standard || zombieServer.failedPings < 5) break block4;
                this.zombieServers.remove(zombieServer.getBaseUrl());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerWrapper removeFromAlive(String key) {
        Map<String, ServerWrapper> map = this.aliveServers;
        synchronized (map) {
            ServerWrapper wrapper = this.aliveServers.remove(key);
            if (wrapper != null) {
                this.updateAliveList();
            }
            return wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToAlive(ServerWrapper wrapper) {
        Map<String, ServerWrapper> map = this.aliveServers;
        synchronized (map) {
            ServerWrapper prev = this.aliveServers.put(wrapper.getBaseUrl(), wrapper);
            this.updateAliveList();
        }
    }

    @Deprecated
    public void addSolrServer(String server) throws MalformedURLException {
        this.addToAlive(this.createServerWrapper(server));
    }

    public void addSolrServer(Endpoint server) throws MalformedURLException {
        this.addSolrServer(server.getUrl());
    }

    @Deprecated
    public String removeSolrServer(String server) {
        try {
            server = new URL(server).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (server.endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        this.removeFromAlive(server);
        this.zombieServers.remove(server);
        return null;
    }

    public String removeSolrEndpoint(Endpoint endpoint) {
        return this.removeSolrServer(endpoint.getUrl());
    }

    @Override
    public NamedList<Object> request(SolrRequest<?> request, String collection) throws SolrServerException, IOException {
        return this.request(request, collection, null);
    }

    public NamedList<Object> request(SolrRequest<?> request, String collection, Integer numServersToTry) throws SolrServerException, IOException {
        SolrServerException ex = null;
        ServerWrapper[] serverList = this.aliveServerList;
        int maxTries = numServersToTry == null ? serverList.length : numServersToTry;
        int numServersTried = 0;
        HashMap<String, ServerWrapper> justFailed = null;
        if (ClientUtils.shouldApplyDefaultCollection(collection, request)) {
            collection = this.defaultCollection;
        }
        boolean timeAllowedExceeded = false;
        long timeAllowedNano = LBSolrClient.getTimeAllowedInNanos(request);
        long timeOutTime = System.nanoTime() + timeAllowedNano;
        for (int attempts = 0; attempts < maxTries && !(timeAllowedExceeded = LBSolrClient.isTimeExceeded(timeAllowedNano, timeOutTime)); ++attempts) {
            ServerWrapper wrapper = this.pickServer(serverList, request);
            try {
                ++numServersTried;
                request.setBasePath(wrapper.baseUrl);
                return this.getClient(wrapper.getBaseUrl()).request(request, collection);
            }
            catch (SolrException e) {
                throw e;
            }
            catch (SolrServerException e) {
                if (e.getRootCause() instanceof IOException) {
                    ex = e;
                    this.moveAliveToDead(wrapper);
                    if (justFailed == null) {
                        justFailed = new HashMap<String, ServerWrapper>();
                    }
                    justFailed.put(wrapper.getBaseUrl(), wrapper);
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                throw new SolrServerException(e);
            }
        }
        for (ServerWrapper wrapper : this.zombieServers.values()) {
            timeAllowedExceeded = LBSolrClient.isTimeExceeded(timeAllowedNano, timeOutTime);
            if (timeAllowedExceeded) break;
            if (!wrapper.standard || justFailed != null && justFailed.containsKey(wrapper.getBaseUrl())) continue;
            try {
                ++numServersTried;
                request.setBasePath(wrapper.baseUrl);
                NamedList<Object> rsp = this.getClient(wrapper.baseUrl).request(request, collection);
                this.zombieServers.remove(wrapper.getBaseUrl());
                this.addToAlive(wrapper);
                return rsp;
            }
            catch (SolrException e) {
                throw e;
            }
            catch (SolrServerException e) {
                if (e.getRootCause() instanceof IOException) {
                    ex = e;
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                throw new SolrServerException(e);
            }
        }
        Object solrServerExceptionMessage = timeAllowedExceeded ? "Time allowed to handle this request exceeded" : (numServersToTry != null && numServersTried > numServersToTry ? "No live SolrServers available to handle this request: numServersTried=" + numServersTried + " numServersToTry=" + numServersToTry : "No live SolrServers available to handle this request");
        if (ex == null) {
            throw new SolrServerException((String)solrServerExceptionMessage);
        }
        throw new SolrServerException((String)solrServerExceptionMessage, ex);
    }

    protected ServerWrapper pickServer(ServerWrapper[] aliveServerList, SolrRequest<?> request) {
        int count = this.counter.incrementAndGet() & Integer.MAX_VALUE;
        return aliveServerList[count % aliveServerList.length];
    }

    private void moveAliveToDead(ServerWrapper wrapper) {
        if ((wrapper = this.removeFromAlive(wrapper.getBaseUrl())) == null) {
            return;
        }
        this.zombieServers.put(wrapper.getBaseUrl(), wrapper);
        this.startAliveCheckExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LBSolrClient lBSolrClient = this;
        synchronized (lBSolrClient) {
            if (this.aliveCheckExecutor != null) {
                this.aliveCheckExecutor.shutdownNow();
                ExecutorUtil.shutdownAndAwaitTermination(this.aliveCheckExecutor);
            }
        }
    }

    static {
        solrQuery.setRows(0);
        solrQuery.setSort("_docid_", SolrQuery.ORDER.asc);
        solrQuery.setDistrib(false);
    }

    protected static class ServerWrapper {
        final String baseUrl;
        boolean standard = true;
        int failedPings = 0;

        ServerWrapper(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String toString() {
            return this.baseUrl;
        }

        public int hashCode() {
            return this.baseUrl.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ServerWrapper)) {
                return false;
            }
            return this.baseUrl.equals(((ServerWrapper)obj).baseUrl);
        }
    }

    public static class Rsp {
        protected String server;
        protected NamedList<Object> rsp;

        public NamedList<Object> getResponse() {
            return this.rsp;
        }

        public String getServer() {
            return this.server;
        }
    }

    public static class Req {
        protected SolrRequest<?> request;
        protected List<String> servers;
        protected int numDeadServersToTry;
        private final Integer numServersToTry;

        @Deprecated
        public Req(SolrRequest<?> request, List<String> servers) {
            this(request, servers, (Integer)null);
        }

        public Req(SolrRequest<?> request, Collection<Endpoint> servers) {
            this(request, servers.stream().map(endpoint -> endpoint.getUrl()).collect(Collectors.toList()));
        }

        @Deprecated
        public Req(SolrRequest<?> request, List<String> servers, Integer numServersToTry) {
            this.request = request;
            this.servers = servers;
            this.numDeadServersToTry = servers.size();
            this.numServersToTry = numServersToTry;
        }

        public Req(SolrRequest<?> request, Collection<Endpoint> servers, Integer numServersToTry) {
            this(request, servers.stream().map(endpoint -> endpoint.getUrl()).collect(Collectors.toList()), numServersToTry);
        }

        public SolrRequest<?> getRequest() {
            return this.request;
        }

        @Deprecated
        public List<String> getServers() {
            return this.servers;
        }

        public int getNumDeadServersToTry() {
            return this.numDeadServersToTry;
        }

        public void setNumDeadServersToTry(int numDeadServersToTry) {
            this.numDeadServersToTry = numDeadServersToTry;
        }

        public Integer getNumServersToTry() {
            return this.numServersToTry;
        }
    }

    protected static class ServerIterator {
        String serverStr;
        List<String> skipped;
        int numServersTried;
        Iterator<String> it;
        Iterator<String> skippedIt;
        String exceptionMessage;
        long timeAllowedNano;
        long timeOutTime;
        final Map<String, ServerWrapper> zombieServers;
        final Req req;

        public ServerIterator(Req req, Map<String, ServerWrapper> zombieServers) {
            this.it = req.getServers().iterator();
            this.req = req;
            this.zombieServers = zombieServers;
            this.timeAllowedNano = LBSolrClient.getTimeAllowedInNanos(req.getRequest());
            this.timeOutTime = System.nanoTime() + this.timeAllowedNano;
            this.fetchNext();
        }

        public synchronized boolean hasNext() {
            return this.serverStr != null;
        }

        private void fetchNext() {
            this.serverStr = null;
            if (this.req.numServersToTry != null && this.numServersTried > this.req.numServersToTry) {
                this.exceptionMessage = "Time allowed to handle this request exceeded";
                return;
            }
            while (this.it.hasNext()) {
                this.serverStr = this.it.next();
                this.serverStr = LBSolrClient.normalize(this.serverStr);
                ServerWrapper wrapper = this.zombieServers.get(this.serverStr);
                if (wrapper == null) break;
                int numDeadServersToTry = this.req.getNumDeadServersToTry();
                if (numDeadServersToTry <= 0) continue;
                if (this.skipped == null) {
                    this.skipped = new ArrayList<String>(numDeadServersToTry);
                    this.skipped.add(wrapper.getBaseUrl());
                    continue;
                }
                if (this.skipped.size() >= numDeadServersToTry) continue;
                this.skipped.add(wrapper.getBaseUrl());
            }
            if (this.serverStr == null && this.skipped != null) {
                if (this.skippedIt == null) {
                    this.skippedIt = this.skipped.iterator();
                }
                if (this.skippedIt.hasNext()) {
                    this.serverStr = this.skippedIt.next();
                }
            }
        }

        boolean isServingZombieServer() {
            return this.skippedIt != null;
        }

        public synchronized String nextOrError() throws SolrServerException {
            return this.nextOrError(null);
        }

        public synchronized String nextOrError(Exception previousEx) throws SolrServerException {
            Object suffix = "";
            if (previousEx == null) {
                suffix = ":" + this.zombieServers.keySet();
            }
            if (this.numServersTried > 0 && LBSolrClient.isTimeExceeded(this.timeAllowedNano, this.timeOutTime)) {
                throw new SolrServerException("Time allowed to handle this request exceeded" + (String)suffix, previousEx);
            }
            if (this.serverStr == null) {
                throw new SolrServerException("No live SolrServers available to handle this request" + (String)suffix, previousEx);
            }
            ++this.numServersTried;
            if (this.req.getNumServersToTry() != null && this.numServersTried > this.req.getNumServersToTry()) {
                throw new SolrServerException("No live SolrServers available to handle this request: numServersTried=" + this.numServersTried + " numServersToTry=" + this.req.getNumServersToTry() + (String)suffix, previousEx);
            }
            String rs = this.serverStr;
            this.fetchNext();
            return rs;
        }
    }

    public static class Endpoint {
        private final String baseUrl;
        private final String core;

        public Endpoint(String baseUrl) {
            this(baseUrl, null);
        }

        public Endpoint(String baseUrl, String core) {
            this.baseUrl = LBSolrClient.normalize(baseUrl);
            this.core = core;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String getCore() {
            return this.core;
        }

        public String getUrl() {
            if (this.core == null) {
                return this.baseUrl;
            }
            return this.baseUrl + "/" + this.core;
        }

        public String toString() {
            return this.getUrl();
        }

        public int hashCode() {
            return Objects.hash(this.baseUrl, this.core);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Endpoint)) {
                return false;
            }
            Endpoint rhs = (Endpoint)obj;
            return Objects.equals(this.baseUrl, rhs.baseUrl) && Objects.equals(this.core, rhs.core);
        }
    }
}

