/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DMutationEvent;
import ice.pilots.html4.DNode;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DAttr
extends DynamicObject
implements Attr,
Cloneable {
    protected int nameId;
    volatile DAttr next;
    volatile DNode masterNode;
    private Object value;
    private static final int Field_attributes = 1;
    private static final int Field_childNodes = 2;
    private static final int Field_firstChild = 3;
    private static final int Field_lastChild = 4;
    private static final int Field_localName = 5;
    private static final int Field_name = 6;
    private static final int Field_namespaceURI = 7;
    private static final int Field_nextSibling = 8;
    private static final int Field_nodeName = 9;
    private static final int Field_nodeValue = 10;
    private static final int Field_nodeType = 11;
    private static final int Field_ownerDocument = 12;
    private static final int Field_ownerElement = 13;
    private static final int Field_parentNode = 14;
    private static final int Field_prefix = 15;
    private static final int Field_previousSibling = 16;
    private static final int Field_specified = 17;
    private static final int Field_value = 18;
    private static final int Method_appendChild = -1;
    private static final int Method_cloneNode = -2;
    private static final int Method_hasAttributes = -3;
    private static final int Method_hasChildNodes = -4;
    private static final int Method_insertBefore = -5;
    private static final int Method_isSupported = -6;
    private static final int Method_replaceChild = -7;
    private static final int Method_removeChild = -8;
    private static final int Method_normalize = -9;

    final int getNameId() {
        return this.nameId;
    }

    static DAttr cloneList(DAttr list_head, DNode new_master, boolean deep) {
        DAttr cursor = list_head;
        DAttr cloned_head = null;
        DAttr cloned_prev = null;
        while (cursor != null) {
            DAttr cloned = (DAttr)cursor.clone(deep);
            cloned.masterNode = new_master;
            if (cloned_prev == null) {
                cloned_head = cloned;
            } else {
                cloned_prev.next = cloned;
            }
            cloned_prev = cloned;
            cursor = cursor.next;
        }
        return cloned_head;
    }

    protected DAttr(int nId) {
        this.nameId = nId;
    }

    final void initMasterAndLink(DNode masterNode, DAttr next) {
        this.masterNode = masterNode;
        this.next = next;
    }

    final void detachFromAttrList(boolean remove_notify) {
        DNode master = this.masterNode;
        this.next = null;
        String name = this.getName();
        this.masterNode = null;
        String oldVal = this.getValue();
        this.afterDelete(master);
        this.value = null;
        DMutationEvent evt = (DMutationEvent)master.doc.createDOMEvent(28);
        evt.setMutationData(null, oldVal, null, name, (short)3);
        master.dispatchEvent(evt);
    }

    protected final DNode getMasterNode() {
        return this.masterNode;
    }

    final boolean setMasterNode(DNode node) {
        if (this.masterNode == null && node != null) {
            this.masterNode = node;
            return this.masterNode == node;
        }
        return false;
    }

    protected void afterClone(boolean deep) {
        this.unlinkAllSlots();
        this.next = null;
        this.masterNode = null;
    }

    protected void afterDelete(DNode old_master) {
        if (this.nameId == 105 && old_master instanceof DElement) {
            DElement elem = (DElement)old_master;
            elem.getStyle().setCssText(null);
        }
    }

    protected void afterAddingToNode() {
        this.setObjectValue(this.value, false);
    }

    public Object clone(boolean deep) {
        try {
            DAttr cloned = (DAttr)super.clone();
            cloned.afterClone(deep);
            return cloned;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public Object clone() {
        return this.clone(false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        DNode master = this.masterNode;
        if (master != null) {
            sb.append("[<");
            sb.append(master.getNodeName());
            sb.append("> attribute] ");
        } else {
            sb.append("[free attribute] ");
        }
        sb.append(this.getName());
        sb.append("=");
        sb.append(this.getObjectValue());
        return sb.toString();
    }

    public final Object getObjectValue() {
        DNode master;
        if (this.nameId == 105 && (master = this.masterNode) instanceof DElement) {
            DElement elem = (DElement)master;
            return elem.getStyle().getCssText();
        }
        return this.value;
    }

    public final String getValue() {
        DNode master;
        if (this.nameId == 105 && (master = this.masterNode) instanceof DElement) {
            DElement elem = (DElement)master;
            return elem.getStyle().getCssText();
        }
        Object value = this.value;
        if (value instanceof String || value == null) {
            return (String)value;
        }
        return value.toString();
    }

    private final Object script_getValue() {
        return this.getObjectValue();
    }

    public final void setValue(String new_value) {
        String oldVal = this.getValue();
        this.setObjectValue(new_value, true);
        short detail = 1;
        if (oldVal == null) {
            detail = 2;
        }
        DMutationEvent evt = (DMutationEvent)this.masterNode.doc.createDOMEvent(28);
        evt.setMutationData(null, oldVal, this.getValue(), this.getName(), detail);
        this.masterNode.dispatchEvent(evt);
    }

    private final void script_setValue(Object new_value) {
        String oldVal = this.getValue();
        this.setObjectValue(new_value, true);
        short detail = 1;
        if (oldVal == null) {
            detail = 2;
        }
        DMutationEvent evt = (DMutationEvent)this.masterNode.doc.createDOMEvent(28);
        evt.setMutationData(null, oldVal, this.getValue(), this.getName(), detail);
        this.masterNode.dispatchEvent(evt);
    }

    protected void setObjectValue(Object new_value, boolean change_notify) {
        DNode master = this.masterNode;
        if (master == null) {
            this.value = new_value;
        } else if (this.nameId == 105) {
            if (master instanceof DElement) {
                DElement elem = (DElement)master;
                elem.getStyle().setCssText(new_value == null ? null : new_value.toString());
            }
            this.value = new_value;
        } else if (!change_notify) {
            this.value = new_value;
        } else {
            Object old = this.value;
            if (new_value != old) {
                this.value = new_value;
            }
        }
    }

    public String getName() {
        return this.masterNode.doc.names.getAttrName(this.nameId);
    }

    public boolean getSpecified() {
        return false;
    }

    public Element getOwnerElement() {
        DNode node = this.masterNode;
        if (node instanceof Element) {
            return (Element)((Object)node);
        }
        return null;
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getNodeValue() {
        return this.getValue();
    }

    private Object script_getNodeValue() {
        return this.script_getValue();
    }

    public void setNodeValue(String nodeValue) {
        this.setValue(nodeValue);
    }

    private void script_setNodeValue(Object nodeValue) {
        this.script_setValue(nodeValue);
    }

    public short getNodeType() {
        return 2;
    }

    public Node getParentNode() {
        return null;
    }

    public NodeList getChildNodes() {
        return null;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return this.getOwnerDDocument();
    }

    protected DDocument getOwnerDDocument() {
        DNode node = this.masterNode;
        if (node != null) {
            return node.getOwnerDDocument();
        }
        return null;
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return null;
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        return null;
    }

    public Node removeChild(Node oldChild) {
        return null;
    }

    public Node appendChild(Node newChild) {
        return null;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node cloneNode(boolean deep) {
        return (Node)this.clone(deep);
    }

    public void normalize() {
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public String getNamespaceURI() {
        if (this.getPrefix() == null) {
            return null;
        }
        String namespace = this.masterNode.doc.names.getAttrNamespaceURI(this.nameId);
        return "".equals(namespace) ? null : namespace;
    }

    public String getPrefix() {
        int i;
        String t = this.getName();
        if (t != null && (i = t.indexOf(":")) > 0) {
            return t.substring(0, i);
        }
        return null;
    }

    public void setPrefix(String prefix) {
    }

    public String getLocalName() {
        int i;
        String t = this.getName();
        if (t != null && (i = t.indexOf(":")) > 0) {
            t = t.substring(i + 1);
        }
        return t;
    }

    public boolean hasAttributes() {
        return false;
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DAttr.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DAttr.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DAttr.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return this.getAttributes();
            }
            case 2: {
                return this.getChildNodes();
            }
            case 3: {
                return this.getFirstChild();
            }
            case 4: {
                return this.getLastChild();
            }
            case 5: {
                return this.getLocalName();
            }
            case 6: {
                return this.getName();
            }
            case 7: {
                return this.getNamespaceURI();
            }
            case 8: {
                return this.getNextSibling();
            }
            case 9: {
                return this.getNodeName();
            }
            case 10: {
                return this.script_getNodeValue();
            }
            case 11: {
                return env.wrapInt(this.getNodeType());
            }
            case 12: {
                return this.getOwnerDocument();
            }
            case 13: {
                return this.getOwnerElement();
            }
            case 14: {
                return this.getParentNode();
            }
            case 15: {
                return this.getPrefix();
            }
            case 16: {
                return this.getPreviousSibling();
            }
            case 17: {
                return env.wrapBoolean(this.getSpecified());
            }
            case 18: {
                return this.script_getValue();
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        switch (key_id) {
            case 10: {
                this.script_setNodeValue(value);
                return 1;
            }
            case 15: {
                this.setPrefix(env.toStr(value));
                return 1;
            }
            case 18: {
                this.script_setValue(value);
                return 1;
            }
        }
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                Node new_child = (Node)env.toNative(args, 0);
                return this.appendChild(new_child);
            }
            case -2: {
                return this.cloneNode(env.toBoolean(args, 0));
            }
            case -3: {
                return env.wrapBoolean(this.hasAttributes());
            }
            case -4: {
                return env.wrapBoolean(this.hasChildNodes());
            }
            case -5: {
                Node new_child = (Node)env.toNative(args, 0);
                Node ref_child = (Node)env.toNative(args, 1);
                return this.insertBefore(new_child, ref_child);
            }
            case -6: {
                String feature = env.toStr(args, 0);
                String version = env.toStr(args, 1);
                return env.wrapBoolean(this.isSupported(feature, version));
            }
            case -7: {
                Node new_child = (Node)env.toNative(args, 0);
                Node old_child = (Node)env.toNative(args, 1);
                return this.replaceChild(new_child, old_child);
            }
            case -8: {
                Node old_child = (Node)env.toNative(args, 0);
                return this.removeChild(old_child);
            }
            case -9: {
                this.normalize();
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        block0 : switch (s.length()) {
            case 4: {
                guess = "name";
                id = 6;
                break;
            }
            case 5: {
                guess = "value";
                id = 18;
                break;
            }
            case 6: {
                guess = "prefix";
                id = 15;
                break;
            }
            case 8: {
                char c = s.charAt(4);
                if (c == 'N') {
                    guess = "nodeName";
                    id = 9;
                    break;
                }
                if (c != 'T') break;
                guess = "nodeType";
                id = 11;
                break;
            }
            case 9: {
                switch (s.charAt(2)) {
                    case 'c': {
                        guess = "localName";
                        id = 5;
                        break block0;
                    }
                    case 'd': {
                        guess = "nodeValue";
                        id = 10;
                        break block0;
                    }
                    case 'e': {
                        guess = "specified";
                        id = 17;
                        break block0;
                    }
                    case 'o': {
                        guess = "cloneNode";
                        id = -2;
                        break block0;
                    }
                    case 'r': {
                        guess = "normalize";
                        id = -9;
                        break block0;
                    }
                    case 's': {
                        guess = "lastChild";
                        id = 4;
                        break block0;
                    }
                }
                break;
            }
            case 10: {
                switch (s.charAt(0)) {
                    case 'a': {
                        guess = "attributes";
                        id = 1;
                        break block0;
                    }
                    case 'c': {
                        guess = "childNodes";
                        id = 2;
                        break block0;
                    }
                    case 'f': {
                        guess = "firstChild";
                        id = 3;
                        break block0;
                    }
                    case 'p': {
                        guess = "parentNode";
                        id = 14;
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                switch (s.charAt(0)) {
                    case 'a': {
                        guess = "appendChild";
                        id = -1;
                        break block0;
                    }
                    case 'i': {
                        guess = "isSupported";
                        id = -6;
                        break block0;
                    }
                    case 'n': {
                        guess = "nextSibling";
                        id = 8;
                        break block0;
                    }
                    case 'r': {
                        guess = "removeChild";
                        id = -8;
                        break block0;
                    }
                }
                break;
            }
            case 12: {
                switch (s.charAt(0)) {
                    case 'i': {
                        guess = "insertBefore";
                        id = -5;
                        break block0;
                    }
                    case 'n': {
                        guess = "namespaceURI";
                        id = 7;
                        break block0;
                    }
                    case 'o': {
                        guess = "ownerElement";
                        id = 13;
                        break block0;
                    }
                    case 'r': {
                        guess = "replaceChild";
                        id = -7;
                        break block0;
                    }
                }
                break;
            }
            case 13: {
                char c = s.charAt(3);
                if (c == 'A') {
                    guess = "hasAttributes";
                    id = -3;
                    break;
                }
                if (c == 'C') {
                    guess = "hasChildNodes";
                    id = -4;
                    break;
                }
                if (c != 'e') break;
                guess = "ownerDocument";
                id = 12;
                break;
            }
            case 15: {
                guess = "previousSibling";
                id = 16;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

