/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.AccessPosition;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.HighlightListener;
import ice.pilots.html4.LineBox;
import ice.pilots.html4.ThePilot;
import ice.util.Defs;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

abstract class CSSBox
implements ImageObserver,
HighlightListener {
    static final int BOX_INLINE = 0;
    static final int BOX_BLOCK = 1;
    static final int BOX_FLOAT_PLACEHOLDER = 2;
    static final int BOX_DEFAULT = 3;
    protected static int idCounter;
    protected int boxId;
    protected CSSLayout cssLayout;
    protected CSSBox parentBox;
    protected CSSBox next;
    protected DElement element;
    static int debugFlag;
    private static final int tileOptMaxSize = 64;
    private static int tileOptThreshold;
    private static boolean useTransparentTiling;
    private static boolean useITextBackgrounds;
    public static final int STATIC_LEVEL = 0;
    public static final int ABSOLUTE_LEVEL = 1;
    public static final int RELATIVE_LEVEL = 2;
    public static final int FIXED_LEVEL = 3;
    protected static boolean doCompleteZIndexTest;
    CSSAttribs css;
    byte dynamic = 0;
    int numBreaks;
    int totalWidth;
    protected int _startingCharOffset;
    protected int _startingWordOffset;
    protected int _startingSentenceOffset;
    int minWidth;
    int maxWidth;
    int ox;
    int oy;
    int width;
    int height;
    static Point cachedPoint;

    protected CSSBox(DElement dElement, CSSAttribs cSSAttribs, CSSLayout cSSLayout) {
        this.element = dElement;
        this.css = cSSAttribs;
        this.cssLayout = cSSLayout;
        this.boxId = ++idCounter;
    }

    protected CSSBox(CSSLayout cSSLayout) {
        this(null, null, cSSLayout);
    }

    void dispose() {
        this.parentBox = null;
        this.cssLayout = null;
        this.next = null;
    }

    protected final boolean setVisibility(short s) {
        CSSAttribs[] cSSAttribsArray;
        if (this.dynamic > 0 && (cSSAttribsArray = (CSSAttribs[])this.cssLayout.dynamicStyles.get(this.getDomNode())) != null) {
            for (int i = 0; i < cSSAttribsArray.length; ++i) {
                CSSAttribs cSSAttribs = cSSAttribsArray[i];
                if (cSSAttribs == null || (cSSAttribs.misc & 0x20) == 0) continue;
                cSSAttribs.misc = (short)(cSSAttribs.misc & 0xFFFFFFFE);
                cSSAttribs.misc = (short)(cSSAttribs.misc | s & 1);
            }
        }
        if ((this.css.misc & 0x20) == 0) {
            return false;
        }
        this.css.misc = (short)(this.css.misc & 0xFFFFFFFE);
        this.css.misc = (short)(this.css.misc | s & 1);
        return true;
    }

    public CSSAttribs getCSSAttribs() {
        return this.css;
    }

    void propagateVisibility(short s, boolean bl) {
        if (bl) {
            this.setVisibility(s);
        }
    }

    void notifyChildrenGenerated() {
    }

    CSSBox getLast() {
        return null;
    }

    void setParentBox(CSSBox cSSBox) {
        this.parentBox = cSSBox;
    }

    final CSSBox getParentBox() {
        return this.parentBox;
    }

    CSSBox getFirstChild() {
        return null;
    }

    @Override
    public void highlightArea(int n, int n2) {
    }

    @Override
    public void clearHighlights() {
    }

    int getType() {
        return 3;
    }

    void invalidate() {
        CSSBox cSSBox = this;
        while (cSSBox != null) {
            cSSBox.minWidth = 0;
            cSSBox = cSSBox.parentBox;
        }
    }

    CSSBox getBoxAt(int n, int n2, Point point) {
        point.x = n;
        point.y = n2;
        return this;
    }

    void applyDynamicStyle(int n) {
        CSSBox cSSBox = this.parentBox;
        if (cSSBox != null) {
            cSSBox.applyDynamicStyle(n);
        }
    }

    void findAbsolutePosition(Point point) {
        point.x += this.ox;
        point.y += this.oy;
        if (this.parentBox != null) {
            this.parentBox.findAbsolutePosition(point);
        }
    }

    protected void findAbsPos(Point point) {
        this.findAbsolutePosition(point);
    }

    void findAbsolutePosition_int(Point point) {
        this.findAbsolutePosition(point);
    }

    void findBoundingBoxForPrinting(Point point) {
        point.x += this.ox;
        point.y += this.oy;
        if (this.parentBox != null) {
            this.parentBox.findBoundingBoxForPrinting(point);
        }
    }

    void findBoundingBox(Rectangle rectangle) {
    }

    DNode getDomNode() {
        return null;
    }

    int calcBreaks() {
        return 0;
    }

    int getBreaks(int[] nArray, int n) {
        return 0;
    }

    long getChunkDescentAscent(int n, int n2, LineBox lineBox) {
        return 0L;
    }

    void paintChunk(Graphics graphics, int n, int n2, LineBox lineBox, int n3) {
    }

    int getCount(int n, Point point) {
        return 0;
    }

    String getText(int n, int n2, AccessPosition accessPosition) {
        return null;
    }

    CSSBox findChildByIndex_r(int n, int n2, Point point) {
        return null;
    }

    int getStartingCharacterOffset() {
        return -1;
    }

    void calcMinMaxWidths() {
    }

    void layout(int n, int n2, FloatManager floatManager) {
    }

    void paint(Graphics graphics) {
    }

    CSSBox addChild(CSSBox cSSBox) {
        return this;
    }

    void reqReflow() {
        this.cssLayout.refresh();
    }

    void reqRepaint() {
        if (this.cssLayout != null && this.cssLayout.docPane != null) {
            this.cssLayout.docPane.reqRepaint();
        }
    }

    public String toString() {
        DNode dNode = this.getDomNode();
        String string = "NoNode";
        if (dNode != null) {
            string = dNode.toString();
        }
        return super.toString() + "[" + string + "]";
    }

    protected void paintBackground(Graphics graphics, Rectangle rectangle, int n, int n2, int n3, int n4, int n5) {
        int n6;
        boolean bl = false;
        Color color = this.css.background_color;
        Image image = null;
        if (this.css.background_image instanceof Image) {
            image = (Image)this.css.background_image;
        }
        if (this.cssLayout.topBox == this && color == null) {
            CSSBox cSSBox = this.getFirstChild();
            if (cSSBox != null) {
                Object object;
                if (image == null && (object = cSSBox.css.background_image) instanceof Image) {
                    image = (Image)object;
                    cSSBox.css.background_image = null;
                    this.css.background_params = cSSBox.css.background_params;
                    ThePilot.prepareImage(image, this);
                    this.css.background_image = image;
                }
                color = cSSBox.css.background_color;
                cSSBox.css.background_color = null;
            }
            if (color == null) {
                bl = true;
                color = Color.white;
            }
            this.css.background_color = color;
        }
        if (image == null && color == null) {
            return;
        }
        int n7 = n3;
        int n8 = n4;
        int n9 = rectangle.x - n;
        if (n9 > 0) {
            n = rectangle.x;
            if (rectangle.width < (n3 -= n9)) {
                n3 = rectangle.width;
            }
        } else if (rectangle.width + n9 < n3) {
            n3 = rectangle.width + n9;
        }
        if ((n6 = rectangle.y - n2) > 0) {
            n2 = rectangle.y;
            if (rectangle.height < (n4 -= n6)) {
                n4 = rectangle.height;
            }
        } else if (rectangle.height + n6 < n4) {
            n4 = rectangle.height + n6;
        }
        if (n3 > 0 && n4 > 0) {
            if (color != null) {
                graphics.setColor(color);
                if (useITextBackgrounds) {
                    graphics.fillRect(n - 1, n2 - 1, n3, n4);
                } else if (!bl) {
                    graphics.fillRect(n, n2, n3, n4);
                }
            }
            if (image != null) {
                this.setImageForBackground(graphics, image);
                this.paintBackgroundImage(graphics, image, n7, n8, n, n2, n3, n4, n5);
            }
        }
    }

    private void paintBackgroundImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        boolean bl;
        boolean bl2 = image.getAccelerationPriority() == 0.99f;
        int n10 = image.getWidth(this);
        int n11 = image.getHeight(this);
        if (n10 < 1 || n11 < 1) {
            return;
        }
        boolean bl3 = 0 == (this.css.background_params & 1);
        boolean bl4 = bl = 0 == (this.css.background_params & 2);
        if ((n10 < tileOptThreshold || n11 < tileOptThreshold) && this.css.background_params == 0) {
            return;
        }
        if (n10 == 1 && n11 == 1 && bl3 && bl) {
            graphics.drawImage(image, 0, 0, 1, 1, n3, n4, n5, n6, this);
            return;
        }
        int n12 = n10;
        int n13 = n11;
        int n14 = this.cssLayout.getLayoutZoom();
        n12 = n12 * n14 >> 8;
        n13 = n13 * n14 >> 8;
        if (n12 == 0) {
            n12 = 1;
        }
        if (n13 == 0) {
            n13 = 1;
        }
        int n15 = n;
        int n16 = n2;
        if ((this.css.background_params & 4) != 0 & this.cssLayout.docPane != null) {
            n15 = this.cssLayout.docPane.getPaneWidth();
            n16 = this.cssLayout.docPane.getPaneHeight();
        }
        int n17 = 0;
        int n18 = 0;
        if ((this.css.background_params & 0x1F0) > 0) {
            n17 = n15 / 2 - n12 / 2;
            n18 = n16 / 2 - n13 / 2;
            if ((this.css.background_params & 0x100) > 0) {
                n17 = 0;
            }
            if ((this.css.background_params & 0x10) > 0) {
                n17 = n15 - n12;
            }
            if ((this.css.background_params & 0x40) > 0) {
                n18 = 0;
            }
            if ((this.css.background_params & 0x80) > 0) {
                n18 = n16 - n13;
            }
        } else {
            if ((this.css.background_params & 0x200) > 0) {
                n17 = (this.css.percentage_flag & 1) > 0 ? (n15 - n12) * this.css.background_position_x / 100 : (int)this.css.background_position_x;
            }
            if ((this.css.background_params & 0x400) > 0) {
                n18 = (this.css.percentage_flag & 2) > 0 ? (n16 - n13) * this.css.background_position_y / 100 : (int)this.css.background_position_y;
            }
        }
        Rectangle rectangle = null;
        rectangle = !this.cssLayout.inPrintMode ? new Rectangle(this.cssLayout.docPane.getScrollX(), this.cssLayout.docPane.getScrollY(), this.cssLayout.docPane.getPaneWidth(), this.cssLayout.docPane.getPaneHeight()) : this.cssLayout.imageablePrintArea;
        int n19 = 0;
        int n20 = 0;
        if ((this.css.background_params & 4) != 0) {
            n9 = 0;
            n8 = 0;
            if (this.cssLayout != null && this.cssLayout.docPane != null) {
                n9 = this.cssLayout.docPane.getScrollX();
                n8 = this.cssLayout.docPane.getScrollY();
            }
            CSSBox.cachedPoint.x = -n9;
            CSSBox.cachedPoint.y = -n8 - n7;
            this.findAbsolutePosition(cachedPoint);
            n17 -= CSSBox.cachedPoint.x;
            n18 -= CSSBox.cachedPoint.y;
            if (this.cssLayout.docPane != null) {
                n19 = this.cssLayout.docPane.getDocWidth();
                n20 = this.cssLayout.docPane.getDocHeight();
            } else if (this.cssLayout.docPane == null && this.cssLayout.inPrintMode) {
                n19 = this.cssLayout.imageablePrintArea.width;
                n20 = this.cssLayout.imageablePrintArea.height;
            }
        } else {
            n19 = n;
            n20 = n2;
        }
        n9 = n18;
        n8 = n17;
        if (bl3) {
            n8 = n17 % n12 - n12;
        }
        if (bl) {
            n9 = n18 % n13 - n13;
        }
        Rectangle rectangle2 = graphics.getClip().getBounds();
        Graphics graphics2 = graphics.create(0, 0, n, n2);
        Rectangle rectangle3 = graphics2.getClip().getBounds();
        graphics2.dispose();
        graphics.setClip(rectangle3);
        while (n9 < n20) {
            for (int i = n8; i < n19; i += n12) {
                if (bl2) {
                    this.setImageForBackground(graphics, image);
                }
                if (useITextBackgrounds && (bl3 || bl) && this.cssLayout.inPrintMode) {
                    Rectangle rectangle4 = new Rectangle(i, n9, n12, n13);
                    if (!rectangle4.intersects(rectangle)) continue;
                    if (n14 != 256) {
                        graphics.drawImage(image, i, n9, n12, n13, this);
                        continue;
                    }
                    graphics.drawImage(image, i, n9, this);
                    continue;
                }
                if (n14 != 256) {
                    graphics.drawImage(image, i, n9, n12, n13, this);
                    continue;
                }
                graphics.drawImage(image, i, n9, this);
                if (bl3) continue;
            }
            n9 += n13;
            if (bl) continue;
            break;
        }
        graphics.setClip(rectangle2);
    }

    private void setImageForBackground(Graphics graphics, Image image) {
        if ("coldfusion.presentation.PPGraphics2D".equalsIgnoreCase(graphics.getClass().getName()) || "org.apache.poi.hslf.model.PPGraphics2D".equalsIgnoreCase(graphics.getClass().getName())) {
            image.setAccelerationPriority(0.99f);
        }
    }

    void loadBackgroundImage(DDocument dDocument) {
        boolean bl;
        String string = this.css.background_image_url;
        if (string == null) {
            string = this.css.background_image instanceof String ? (String)this.css.background_image : "";
        }
        String string2 = dDocument.resolveUrl(string);
        Image image = dDocument.getPilot().objectPool.loadImage(string2);
        this.css.background_image = image;
        if (image != null && (bl = ThePilot.prepareImage(image, this))) {
            this.imageUpdate(image, 32, 0, 0, -1, -1);
        }
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        if (this.cssLayout == null) {
            return false;
        }
        if (this.cssLayout.docPane == null && !this.cssLayout.inPrintMode) {
            return false;
        }
        if ((n & 0xC0) != 0 || this.css.background_image != image) {
            if (this.css != null) {
                this.css.background_image = null;
                this.reqRepaint();
            }
            return false;
        }
        boolean bl2 = (n & 0x20) != 0;
        boolean bl3 = bl = (n & 0x10) != 0;
        if (bl2 || bl) {
            boolean bl4 = false;
            if (this.css != null) {
                bl4 = this.pretileImage(image, this.css.background_image_url);
            }
            if (!bl4) {
                this.reqRepaint();
            }
            return bl && this.cssLayout.doImageAnimation && !bl4 && this.css.background_image != null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean pretileImage(Image var1_1, String var2_2) {
        var3_3 = var1_1.getWidth(null);
        var4_4 = var1_1.getHeight(null);
        if (var3_3 <= 0 || var4_4 <= 0) {
            return false;
        }
        if (var3_3 == 1 && var4_4 == 1) {
            return false;
        }
        if (var3_3 >= CSSBox.tileOptThreshold && var4_4 >= CSSBox.tileOptThreshold) {
            return false;
        }
        if (var3_3 >= 64) ** GOTO lbl-1000
        if ((this.css.background_params & 1) == 0) {
            var5_5 = (64 + var3_3 - 1) / var3_3;
        } else lbl-1000:
        // 2 sources

        {
            var5_5 = 1;
        }
        if (var4_4 >= 64) ** GOTO lbl-1000
        if ((this.css.background_params & 2) == 0) {
            var6_6 = (64 + var4_4 - 1) / var4_4;
        } else lbl-1000:
        // 2 sources

        {
            var6_6 = 1;
        }
        if (var5_5 == 1 && var6_6 == 1) {
            return false;
        }
        var7_7 = null;
        var8_8 = null;
        var8_8 = var2_2 + "_" + var5_5 + "_" + var6_6;
        var7_7 = this.cssLayout.doc.getPilot().objectPool.getTiledImage(var8_8);
        var9_9 = var8_8;
        if (var7_7 != null) {
            this.css.background_image = var7_7;
            this.css.background_params = (short)(this.css.background_params | 8);
        } else {
            if (CSSBox.useTransparentTiling) {
                var10_10 = new PixelGrabber(var1_1, 0, 0, var3_3, var4_4, false){

                    @Override
                    public void abortGrabbing() {
                        super.abortGrabbing();
                        CSSBox.this.transparentTilingImpl(null, null, var3_3, var4_4, var5_5, var6_6);
                    }

                    @Override
                    public void imageComplete(int n) {
                        super.imageComplete(n);
                        if (n == 1 || n == 4) {
                            CSSBox.this.transparentTilingImpl(null, null, var3_3, var4_4, var5_5, var6_6);
                        } else {
                            CSSBox.this.transparentTilingImpl(this.getPixels(), this.getColorModel(), var3_3, var4_4, var5_5, var6_6);
                        }
                        if (CSSBox.this.cssLayout != null && !CSSBox.this.cssLayout.inPrintMode) {
                            CSSBox.this.cssLayout.doc.getPilot().objectPool.addTiledImageToCache(var9_9, (Image)CSSBox.this.css.background_image);
                        }
                    }
                };
                var10_10.startGrabbing();
                return true;
            }
            var10_11 = var5_5 * var3_3;
            var11_12 = var6_6 * var4_4;
            var12_13 = this.cssLayout.docPane.createImage(var10_11, var11_12);
            var13_14 = var12_13.getGraphics();
            try {
                for (var14_15 = 0; var14_15 < var6_6; ++var14_15) {
                    for (var15_16 = 0; var15_16 < var5_5; ++var15_16) {
                        var13_14.drawImage(var1_1, var15_16 * var3_3, var14_15 * var4_4, null);
                    }
                }
            }
            finally {
                var13_14.dispose();
            }
            this.css.background_params = (short)(this.css.background_params | 8);
            this.css.background_image = var12_13;
        }
        this.reqRepaint();
        return true;
    }

    void transparentTilingImpl(Object object, ColorModel colorModel, int n, int n2, int n3, int n4) {
        if (object == null || colorModel == null) {
            this.css.background_image = null;
            this.reqRepaint();
            return;
        }
        int n5 = n * n3;
        int n6 = n2 * n4;
        int n7 = n5 * n6;
        Object[] objectArray = object instanceof byte[] ? new byte[n7] : (Object[])new int[n7];
        for (int i = 0; i != n2; ++i) {
            System.arraycopy(object, i * n, objectArray, i * n5, n);
            CSSBox.tileBlock(objectArray, i * n5, n, n3);
        }
        CSSBox.tileBlock(objectArray, 0, n2 * n5, n4);
        MemoryImageSource memoryImageSource = object instanceof byte[] ? new MemoryImageSource(n5, n6, colorModel, (byte[])objectArray, 0, n5) : new MemoryImageSource(n5, n6, colorModel, (int[])objectArray, 0, n5);
        Image image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
        this.css.background_params = (short)(this.css.background_params | 8);
        this.css.background_image = image;
        this.reqRepaint();
    }

    private static void tileBlock(Object object, int n, int n2, int n3) {
        int n4 = 1;
        while (n4 * 2 <= n3) {
            System.arraycopy(object, n, object, n + n4 * n2, n4 * n2);
            n4 *= 2;
        }
        System.arraycopy(object, n, object, n + n4 * n2, (n3 - n4) * n2);
    }

    protected void paintBorders(Graphics graphics, Rectangle rectangle, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        CSSBox cSSBox;
        Color color;
        if (bl && n2 + this.css.border_top_width > rectangle.y && n2 < rectangle.y + rectangle.height) {
            color = this.css.border_top_color;
            if (color == null && (this.css.border_top_style == 154 || this.css.border_top_style == 155)) {
                cSSBox = this;
                while (cSSBox != null && color == null) {
                    color = cSSBox.css.background_color;
                    cSSBox = cSSBox.parentBox;
                }
            }
            if (color == null) {
                color = this.css.color;
            }
            this.css.border_top_color = color;
            if (color != CSSAttribs.COLOR_TRANSPARENT) {
                if (this.css.border_top_style == 148 || this.css.border_top_style == 149) {
                    graphics.setColor(color);
                    CSSUtil.drawStyledLine(graphics, n, n2, n + n3 - 1, n2, this.css.border_top_style, this.css.border_top_width);
                } else {
                    if (this.css.border_top_style == 154) {
                        color = this.makeDark(color);
                    } else if (this.css.border_top_style == 155) {
                        color = this.makeBright(color);
                    }
                    graphics.setColor(color);
                    for (int i = 0; i < this.css.border_top_width; ++i) {
                        graphics.drawLine(n, n2 + i, n + n3 - 1, n2 + i);
                    }
                }
            }
        }
        if (bl2 && n2 + n4 > rectangle.y && n2 + n4 - this.css.border_bottom_width < rectangle.y + rectangle.height) {
            color = this.css.border_bottom_color;
            if (color == null && (this.css.border_bottom_style == 154 || this.css.border_bottom_style == 155)) {
                cSSBox = this;
                while (cSSBox != null && color == null) {
                    color = cSSBox.css.background_color;
                    cSSBox = cSSBox.parentBox;
                }
            }
            if (color == null) {
                color = this.css.color;
            }
            this.css.border_bottom_color = color;
            if (color != CSSAttribs.COLOR_TRANSPARENT) {
                if (this.css.border_bottom_style == 148 || this.css.border_bottom_style == 149) {
                    graphics.setColor(color);
                    int n12 = n2 + n4 - this.css.border_bottom_width;
                    CSSUtil.drawStyledLine(graphics, n, n12, n + n3 - 1, n12, this.css.border_bottom_style, this.css.border_bottom_width);
                } else {
                    if (this.css.border_bottom_style == 154) {
                        color = this.makeBright(color);
                    } else if (this.css.border_bottom_style == 155) {
                        color = this.makeDark(color);
                    }
                    graphics.setColor(color);
                    for (int i = this.css.border_bottom_width; i > 0; --i) {
                        graphics.drawLine(n, n2 + n4 - i, n + n3 - 1, n2 + n4 - i);
                    }
                }
            }
        }
        if (bl3) {
            color = this.css.border_left_color;
            if (color == null && (this.css.border_left_style == 154 || this.css.border_left_style == 155)) {
                CSSBox cSSBox2 = this;
                while (cSSBox2 != null && color == null) {
                    color = cSSBox2.css.background_color;
                    cSSBox2 = cSSBox2.parentBox;
                }
            }
            if (color == null) {
                color = this.css.color;
            }
            this.css.border_left_color = color;
            if (color != CSSAttribs.COLOR_TRANSPARENT) {
                if (this.css.border_left_style == 148 || this.css.border_left_style == 149) {
                    graphics.setColor(color);
                    CSSUtil.drawStyledLine(graphics, n, n2, n, n2 + n4 - 1, this.css.border_left_style, this.css.border_left_width);
                } else {
                    if (this.css.border_left_style == 154) {
                        color = this.makeDark(color);
                    } else if (this.css.border_left_style == 155) {
                        color = this.makeBright(color);
                    }
                    graphics.setColor(color);
                    int n13 = this.css.border_left_width;
                    n11 = n2;
                    n10 = n2 + n4;
                    if (n11 < rectangle.y - n13) {
                        n11 = rectangle.y - n13;
                    }
                    if (n10 > rectangle.y + rectangle.height + n13) {
                        n10 = rectangle.y + rectangle.height + n13;
                    }
                    n9 = 0;
                    n8 = 0;
                    n7 = 0;
                    n6 = 0;
                    if (bl) {
                        n7 = (this.css.border_top_width << 16) / n13;
                    }
                    if (bl2) {
                        n6 = (this.css.border_bottom_width << 16) / n13;
                    }
                    n5 = 0;
                    while (n5 < n13) {
                        graphics.drawLine(n + n5, n11 + (n9 >> 16), n + n5, n10 - (n8 >> 16) - 1);
                        ++n5;
                        n9 += n7;
                        n8 += n6;
                    }
                }
            }
        }
        if (bl4) {
            color = this.css.border_right_color;
            if (color == null && (this.css.border_right_style == 154 || this.css.border_right_style == 155)) {
                CSSBox cSSBox3 = this;
                while (cSSBox3 != null && color == null) {
                    color = cSSBox3.css.background_color;
                    cSSBox3 = cSSBox3.parentBox;
                }
            }
            if (color == null) {
                color = this.css.color;
            }
            this.css.border_right_color = color;
            if (color != CSSAttribs.COLOR_TRANSPARENT) {
                if (this.css.border_right_style == 148 || this.css.border_right_style == 149) {
                    graphics.setColor(color);
                    int n14 = n + n3 - this.css.border_right_width;
                    CSSUtil.drawStyledLine(graphics, n14, n2, n14, n2 + n4 - 1, this.css.border_right_style, this.css.border_right_width);
                } else {
                    if (this.css.border_right_style == 154) {
                        color = this.makeBright(color);
                    } else if (this.css.border_right_style == 155) {
                        color = this.makeDark(color);
                    }
                    graphics.setColor(color);
                    int n15 = this.css.border_right_width;
                    n11 = n2;
                    n10 = n2 + n4;
                    if (n11 < rectangle.y - n15) {
                        n11 = rectangle.y - n15;
                    }
                    if (n10 > rectangle.y + rectangle.height + n15) {
                        n10 = rectangle.y + rectangle.height + n15;
                    }
                    n9 = 0;
                    n8 = 0;
                    n7 = 0;
                    n6 = 0;
                    if (bl) {
                        n7 = (this.css.border_top_width << 16) / n15;
                    }
                    if (bl2) {
                        n6 = (this.css.border_bottom_width << 16) / n15;
                    }
                    n5 = 0;
                    while (n5 < n15) {
                        graphics.drawLine(n + n3 - n5 - 1, n11 + (n9 >> 16), n + n3 - n5 - 1, n10 - (n8 >> 16) - 1);
                        ++n5;
                        n9 += n7;
                        n8 += n6;
                    }
                }
            }
        }
    }

    private final Color makeDark(Color color) {
        if (color.equals(Color.black)) {
            return Color.gray;
        }
        if (color.equals(Color.white)) {
            return Color.gray;
        }
        return color.darker();
    }

    private final Color makeBright(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        if (n == 0 && n2 == 0 && n3 == 0) {
            return Color.lightGray;
        }
        if (n == 255 && n2 == 255 && n3 == 255) {
            return Color.lightGray;
        }
        int n4 = (n << 1) + n >> 1;
        int n5 = (n2 << 1) + n2 >> 1;
        int n6 = (n3 << 1) + n3 >> 1;
        if (n4 > 255) {
            n4 = 255;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        if (n6 > 255) {
            n6 = 255;
        }
        if (n4 == n && n5 == n2 && n6 == n3) {
            if (n6 == 0) {
                n6 += 128;
                if (n4 == 255 && n5 == 255) {
                    n6 += 127;
                }
            }
            if (n4 == 0) {
                n4 += 128;
            }
            if (n5 == 0) {
                n5 += 128;
            }
        }
        return new Color(n4, n5, n6);
    }

    static long wrapDescentAscent(int n, int n2, int n3) {
        return (long)(n3 & 0xFFFF) << 32 | (long)(n & 0xFFFF) << 16 | (long)n2 & 0xFFFFL;
    }

    static int unwrapDescent(long l) {
        int n = 0xFFFF & (int)l >> 16;
        n <<= 16;
        return n >>= 16;
    }

    static int unwrapAscent(long l) {
        int n = 0xFFFF & (int)l;
        n <<= 16;
        return n >>= 16;
    }

    static int unwrapLineHeight(long l) {
        int n = 0xFFFF & (int)(l >> 32);
        n <<= 16;
        return n >>= 16;
    }

    static int getValueOrPercentage(int n, int n2, int n3, int n4) {
        if (n3 == -123456) {
            return n3;
        }
        if ((n & n2) > 0) {
            return n3 * n4 / 100;
        }
        return n3;
    }

    public boolean checkIfVisible() {
        boolean bl = true;
        if (doCompleteZIndexTest) {
            bl = this.isZOrderVisible();
        }
        return bl;
    }

    public void calculateBreaks(int n) {
    }

    private boolean isZOrderVisible() {
        boolean bl = true;
        if (this.cssLayout != null) {
            CSSBox cSSBox = this.cssLayout.topBox;
            if ((cSSBox = cSSBox.getFirstChild()) != null && cSSBox.element != null && cSSBox.element.getNameId() == 13 && this.css != null && cSSBox.css != null && this.css.z_index < cSSBox.css.z_index) {
                bl = false;
            }
        }
        return bl;
    }

    static {
        useTransparentTiling = true;
        useITextBackgrounds = false;
        String string = "ice.pilots.html4.tileOptThreshold";
        tileOptThreshold = Defs.intProperty(string, 32);
        if (tileOptThreshold < 0) {
            tileOptThreshold = 0;
        } else if (tileOptThreshold > 32) {
            tileOptThreshold = 32;
        }
        useITextBackgrounds = Defs.booleanProperty("ice.pilots.html4.printBackgrounds.iTextMode", false);
        doCompleteZIndexTest = Defs.booleanProperty("ice.pilots.html4.doZIndexTest", false);
        cachedPoint = new Point();
    }
}

