/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.session;

import coldfusion.runtime.session.CFNode;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

public class NodeDiscoveryManager {
    private static final String NODE_STOPPED = "X";
    private static final String HEART_BEAT = "P";
    private static final String MASTER_NODE = "M";
    private static final String NODE_DISCOVEERY_CACHE = "cf_nodes";
    private static final int IDLE_NODE_EVECTION_TIME = 30;
    private static final int INITIAL_HEARTBEAT_DELAY = 5;
    private static final String DEFAULT_DISCOVERY_HOST = System.getProperty("coldfusion.session.redis.discovery_host", "231.0.0.1");
    private static final int DEFAULT_DISCOVERY_PORT = Integer.getInteger("coldfusion.session.redis.discovery_port", 4446);
    private InetAddress group;
    private MulticastSocket socket;
    private int port;
    private CFNode node;
    private volatile boolean shutdown;
    private ExecutorService receiver;
    private ScheduledExecutorService heartBeat;
    private TreeSet<String> allNodes = new TreeSet();
    private SortedSet<String> liveNodes = new TreeSet<String>();
    private Cache nodeCache;
    private TreeSet<String> nodesToCleanUp = new TreeSet();

    public NodeDiscoveryManager() throws IOException {
        CacheManager mgr = CacheManager.newInstance();
        mgr.addCache(NODE_DISCOVEERY_CACHE);
        this.nodeCache = mgr.getCache(NODE_DISCOVEERY_CACHE);
        this.nodeCache.getCacheConfiguration().setTimeToLiveSeconds(30L);
        this.nodeCache.getCacheConfiguration().setTimeToIdleSeconds(30L);
        this.nodeCache.getCacheEventNotificationService().registerListener((CacheEventListener)new NodeCacheEventListener());
        this.node = new CFNode();
        this.addNewNode(this.node.getName(), false);
        this.group = InetAddress.getByName(DEFAULT_DISCOVERY_HOST);
        this.socket = new MulticastSocket(DEFAULT_DISCOVERY_PORT);
        this.socket.joinGroup(this.group);
        this.heartBeat = Executors.newScheduledThreadPool(1);
        this.receiver = Executors.newSingleThreadExecutor();
    }

    public void startReceivingMessages() throws IOException {
        this.receiver.execute(new MessageReciever());
    }

    public void startHeartBeat() {
        this.heartBeat.scheduleAtFixedRate(new HeartBeat(), 5L, 1L, TimeUnit.SECONDS);
    }

    public void broadcastNodeStopped(CFNode node) {
        try {
            String s = "X," + node.getName();
            this.socket.send(this.createDatagramMessage(s));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.heartBeat.shutdownNow();
        this.receiver.shutdownNow();
        this.broadcastNodeStopped(this.node);
        this.socket.close();
    }

    private void processMessage(String message) {
        if (message.startsWith(HEART_BEAT)) {
            if ((message = message.substring(2)).startsWith(MASTER_NODE)) {
                int index = message.indexOf("$");
                String nodeName = message.substring(2, index);
                if (!nodeName.equals(this.node.getName())) {
                    this.processNode(nodeName);
                    StringTokenizer tokenizer = new StringTokenizer(message.substring(index + 1), ",");
                    while (tokenizer.hasMoreTokens()) {
                        this.addNodeToMainList(tokenizer.nextToken());
                    }
                }
            } else {
                this.processNode(message);
            }
        } else if (message.startsWith(NODE_STOPPED)) {
            String nodeName = message.substring(2);
            if (this.node != null && !nodeName.equals(this.node.getName())) {
                this.removeNode(nodeName);
            }
        }
    }

    private void addNodeToMainList(String nextToken) {
        this.allNodes.add(nextToken);
    }

    private void processNode(String nodeName) {
        Element nodeElement;
        if (!(this.node != null && nodeName.equals(this.node.getName()) || (nodeElement = this.nodeCache.get((Serializable)((Object)nodeName))) != null)) {
            this.addNewNode(nodeName, true);
        }
    }

    private void removeNode(String nodeName) {
        this.liveNodes.remove(nodeName);
        this.nodeCache.remove((Serializable)((Object)nodeName));
    }

    private DatagramPacket createDatagramMessage(String message) {
        return new DatagramPacket(message.getBytes(), message.length(), this.group, DEFAULT_DISCOVERY_PORT);
    }

    private void addNewNode(String nodeName, boolean addToCache) {
        this.allNodes.add(nodeName);
        this.liveNodes.add(nodeName);
        if (addToCache) {
            Element nodeElement = new Element((Serializable)((Object)nodeName), (Serializable)((Object)nodeName));
            this.nodeCache.put(nodeElement);
        }
    }

    public Iterator<String> getNodesForSessionCleanup() {
        try {
            if (this.liveNodes.size() > 0) {
                TreeSet temp = null;
                if (this.node.isMaster()) {
                    temp = (TreeSet)this.allNodes.clone();
                    temp.removeAll(this.liveNodes);
                    temp.add(this.node.getName());
                    this.nodesToCleanUp = temp;
                } else {
                    this.nodesToCleanUp.clear();
                    this.nodesToCleanUp.add(this.node.getName());
                }
                return this.nodesToCleanUp.iterator();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public CFNode getNode() {
        return this.node;
    }

    private class NodeCacheEventListener
    implements CacheEventListener {
        private NodeCacheEventListener() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public void dispose() {
        }

        public void notifyElementEvicted(Ehcache arg0, Element arg1) {
            NodeDiscoveryManager.this.liveNodes.remove(arg1.getObjectValue());
        }

        public void notifyElementExpired(Ehcache arg0, Element arg1) {
            NodeDiscoveryManager.this.liveNodes.remove(arg1.getObjectValue());
        }

        public void notifyElementPut(Ehcache arg0, Element arg1) throws CacheException {
        }

        public void notifyElementRemoved(Ehcache arg0, Element arg1) throws CacheException {
        }

        public void notifyElementUpdated(Ehcache arg0, Element arg1) throws CacheException {
        }

        public void notifyRemoveAll(Ehcache arg0) {
        }
    }

    private class MessageReciever
    implements Runnable {
        @Override
        public void run() {
            byte[] buffer = new byte[65509];
            DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
            String message = null;
            while (!NodeDiscoveryManager.this.shutdown) {
                try {
                    NodeDiscoveryManager.this.socket.receive(dp);
                    message = new String(dp.getData(), 0, dp.getLength());
                    NodeDiscoveryManager.this.processMessage(message);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class HeartBeat
    implements Runnable {
        private HeartBeat() {
        }

        @Override
        public void run() {
            if (!NodeDiscoveryManager.this.shutdown && NodeDiscoveryManager.this.node != null) {
                try {
                    if (NodeDiscoveryManager.this.liveNodes.first().equals(NodeDiscoveryManager.this.node.getName())) {
                        NodeDiscoveryManager.this.node.setMaster(true);
                        StringBuilder heartBeat = new StringBuilder(NodeDiscoveryManager.HEART_BEAT);
                        heartBeat.append(",");
                        heartBeat.append(NodeDiscoveryManager.MASTER_NODE);
                        heartBeat.append(",");
                        heartBeat.append(NodeDiscoveryManager.this.node.getName());
                        heartBeat.append("$");
                        if (NodeDiscoveryManager.this.nodesToCleanUp != null && NodeDiscoveryManager.this.nodesToCleanUp.size() > 0) {
                            Iterator<String> itr = NodeDiscoveryManager.this.nodesToCleanUp.iterator();
                            while (itr.hasNext()) {
                                heartBeat.append(itr.next());
                                if (!itr.hasNext()) continue;
                                heartBeat.append(",");
                            }
                        }
                        NodeDiscoveryManager.this.socket.send(NodeDiscoveryManager.this.createDatagramMessage(heartBeat.toString()));
                    } else {
                        NodeDiscoveryManager.this.node.setMaster(false);
                        String s = "P," + NodeDiscoveryManager.this.node.getName();
                        NodeDiscoveryManager.this.socket.send(NodeDiscoveryManager.this.createDatagramMessage(s));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

